/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.ArrayTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesOfSingleton;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class ArraySuperTypeSet
extends ArrayTypeSet {
    private EnumeratedTypeSet fEnumCache = null;

    public ArraySuperTypeSet(TypeSet typeSet) {
        super(typeSet.getTypeSetEnvironment());
        this.fElemTypeSet = typeSet instanceof SuperTypesOfSingleton || typeSet instanceof SuperTypesSet ? typeSet.lowerBound() : typeSet;
    }

    public TType anyMember() {
        return this.getJavaLangObject();
    }

    public boolean contains(TType tType) {
        if (tType.equals(this.getJavaLangObject())) {
            return true;
        }
        if (!(tType instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)tType;
        TType tType2 = arrayType.getComponentType();
        if (this.fElemTypeSet.contains(tType2)) {
            return true;
        }
        Iterator iterator = this.fElemTypeSet.iterator();
        while (iterator.hasNext()) {
            TType tType3 = (TType)iterator.next();
            if (!TTypes.canAssignTo(tType3, tType2)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(TypeSet typeSet) {
        if (typeSet instanceof ArraySuperTypeSet) {
            ArraySuperTypeSet arraySuperTypeSet = (ArraySuperTypeSet)typeSet;
            return this.fElemTypeSet.containsAll(arraySuperTypeSet.fElemTypeSet);
        }
        if (typeSet instanceof ArrayTypeSet) {
            ArrayTypeSet arrayTypeSet = (ArrayTypeSet)typeSet;
            return this.fElemTypeSet.containsAll(arrayTypeSet.fElemTypeSet);
        }
        return this.enumerate().containsAll(typeSet);
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet typeSet) {
        if (typeSet instanceof ArraySuperTypeSet) {
            ArraySuperTypeSet arraySuperTypeSet = (ArraySuperTypeSet)typeSet;
            if (arraySuperTypeSet.fElemTypeSet.isUniverse()) {
                return new ArraySuperTypeSet(this.fElemTypeSet);
            }
        } else if (typeSet instanceof ArrayTypeSet) {
            ArrayTypeSet arrayTypeSet = (ArrayTypeSet)typeSet;
            if (arrayTypeSet.fElemTypeSet.isUniverse()) {
                return new ArrayTypeSet(this.fElemTypeSet);
            }
        }
        return super.specialCasesIntersectedWith(typeSet);
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            this.fEnumCache = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            TypeSet typeSet = this.fElemTypeSet.superTypes();
            Iterator iterator = typeSet.iterator();
            while (iterator.hasNext()) {
                TType tType = (TType)iterator.next();
                this.fEnumCache.add(TTypes.createArrayType(tType, 1));
            }
            this.fEnumCache.add(this.getJavaLangObject());
            this.fEnumCache.initComplete();
        }
        return this.fEnumCache;
    }

    public boolean hasUniqueUpperBound() {
        return true;
    }

    public boolean isSingleton() {
        return false;
    }

    public boolean isUniverse() {
        return false;
    }

    public Iterator iterator() {
        return this.enumerate().iterator();
    }

    public TypeSet makeClone() {
        return new ArraySuperTypeSet(this.fElemTypeSet);
    }

    public TypeSet superTypes() {
        return this.makeClone();
    }

    public TType uniqueUpperBound() {
        return this.getJavaLangObject();
    }

    public TypeSet upperBound() {
        return new SingletonTypeSet(this.getJavaLangObject(), this.getTypeSetEnvironment());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ArraySuperTypeSet) {
            ArraySuperTypeSet arraySuperTypeSet = (ArraySuperTypeSet)object;
            return this.fElemTypeSet.equals(arraySuperTypeSet.fElemTypeSet);
        }
        return false;
    }

    public TypeSet subTypes() {
        return this.getTypeSetEnvironment().getUniverseTypeSet();
    }

    public String toString() {
        return "{" + this.fID + ": array-super(" + this.fElemTypeSet + ")}";
    }
}

