/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.AbstractTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.HierarchyType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeVariable;

public class TTypes {
    private TTypes() {
    }

    public static TType createArrayType(TType tType, int n) {
        return tType.getEnvironment().createArrayType(tType, n);
    }

    public static Iterator getAllSubTypesIterator(TType tType) {
        return new AllSubtypesIterator(tType);
    }

    public static Iterator getAllSuperTypesIterator(TType tType) {
        return new AllSupertypesIterator(tType);
    }

    public static boolean canAssignTo(TType tType, TType tType2) {
        if (tType.isHierarchyType() && tType2.isHierarchyType()) {
            HierarchyType hierarchyType = (HierarchyType)tType.getTypeDeclaration();
            HierarchyType hierarchyType2 = (HierarchyType)tType2.getTypeDeclaration();
            return tType2.isJavaLangObject() || hierarchyType.equals(hierarchyType2) || hierarchyType.isSubType(hierarchyType2);
        }
        if (tType.isTypeVariable()) {
            if (tType.canAssignTo(tType2)) {
                return true;
            }
            TType[] tTypeArray = ((TypeVariable)tType).getBounds();
            int n = 0;
            while (n < tTypeArray.length) {
                if (TTypes.canAssignTo(tTypeArray[n], tType2)) {
                    return true;
                }
                ++n;
            }
            return tType2.isJavaLangObject();
        }
        return tType.canAssignTo(tType2);
    }

    private static class AllSubtypesIterator
    implements Iterator {
        private final Stack fWorklist = new Stack();

        public AllSubtypesIterator(TType tType) {
            this.fWorklist.push(tType.getTypeDeclaration());
        }

        public boolean hasNext() {
            return !this.fWorklist.empty();
        }

        public Object next() {
            TType tType = (TType)this.fWorklist.pop();
            TType[] tTypeArray = tType.getSubTypes();
            int n = 0;
            while (n < tTypeArray.length) {
                this.fWorklist.push(tTypeArray[n].getTypeDeclaration());
                ++n;
            }
            return tType;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class AllSupertypesIterator
    implements Iterator {
        private final Stack fWorklist = new Stack();

        public AllSupertypesIterator(TType tType) {
            this.pushSupertypes(tType);
        }

        public boolean hasNext() {
            return !this.fWorklist.empty();
        }

        public Object next() {
            TType tType = (TType)this.fWorklist.pop();
            this.pushSupertypes(tType);
            return tType;
        }

        private void pushSupertypes(TType tType) {
            if (tType.isJavaLangObject()) {
                return;
            }
            if (tType.isTypeVariable() || tType.isCaptureType()) {
                TType[] tTypeArray = ((AbstractTypeVariable)tType).getBounds();
                int n = 0;
                while (n < tTypeArray.length) {
                    this.fWorklist.push(tTypeArray[n].getTypeDeclaration());
                    ++n;
                }
            } else {
                TType tType2 = tType.getSuperclass();
                if (tType2 == null) {
                    if (tType.isInterface()) {
                        this.fWorklist.push(tType.getEnvironment().getJavaLangObject());
                    }
                } else {
                    this.fWorklist.push(tType2.getTypeDeclaration());
                }
                TType[] tTypeArray = tType.getInterfaces();
                int n = 0;
                while (n < tTypeArray.length) {
                    this.fWorklist.push(tTypeArray[n].getTypeDeclaration());
                    ++n;
                }
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

