/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.ltk.core.refactoring.TextEditBasedChange;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;

public class TextEditBasedChangeManager {
    private Map fMap = new HashMap(10);
    private final boolean fKeepExecutedTextEdits;

    public TextEditBasedChangeManager() {
        this(false);
    }

    public TextEditBasedChangeManager(boolean bl) {
        this.fKeepExecutedTextEdits = bl;
    }

    public void manage(ICompilationUnit iCompilationUnit, TextEditBasedChange textEditBasedChange) {
        this.fMap.put(iCompilationUnit, textEditBasedChange);
    }

    public TextEditBasedChange get(ICompilationUnit iCompilationUnit) {
        Object object = (TextEditBasedChange)this.fMap.get(iCompilationUnit);
        if (object == null) {
            object = new CompilationUnitChange(iCompilationUnit.getElementName(), iCompilationUnit);
            object.setKeepPreviewEdits(this.fKeepExecutedTextEdits);
            this.fMap.put(iCompilationUnit, object);
        }
        return object;
    }

    public TextEditBasedChange remove(ICompilationUnit iCompilationUnit) {
        return (TextEditBasedChange)this.fMap.remove(iCompilationUnit);
    }

    public TextEditBasedChange[] getAllChanges() {
        Set set = this.fMap.keySet();
        ICompilationUnit[] iCompilationUnitArray = set.toArray(new ICompilationUnit[set.size()]);
        Arrays.sort(iCompilationUnitArray, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = ((ICompilationUnit)object).getElementName();
                String string2 = ((ICompilationUnit)object2).getElementName();
                return string.compareTo(string2);
            }
        });
        TextEditBasedChange[] textEditBasedChangeArray = new TextEditBasedChange[iCompilationUnitArray.length];
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            textEditBasedChangeArray[n] = (TextEditBasedChange)this.fMap.get(iCompilationUnitArray[n]);
            ++n;
        }
        return textEditBasedChangeArray;
    }

    public ICompilationUnit[] getAllCompilationUnits() {
        return this.fMap.keySet().toArray(new ICompilationUnit[this.fMap.keySet().size()]);
    }

    public void clear() {
        this.fMap.clear();
    }

    public boolean containsChangesIn(ICompilationUnit iCompilationUnit) {
        return this.fMap.containsKey(iCompilationUnit);
    }
}

