/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.template.java.CodeTemplateContextType;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class CodeTemplateContext
extends TemplateContext {
    private String fLineDelimiter;
    private IJavaProject fProject;

    public CodeTemplateContext(String string, IJavaProject iJavaProject, String string2) {
        super(JavaPlugin.getDefault().getCodeTemplateContextRegistry().getContextType(string));
        this.fLineDelimiter = string2;
        this.fProject = iJavaProject;
    }

    public IJavaProject getJavaProject() {
        return this.fProject;
    }

    public TemplateBuffer evaluate(Template template) throws BadLocationException, TemplateException {
        Object object;
        Iterator iterator = this.getContextType().resolvers();
        while (iterator.hasNext()) {
            object = (TemplateVariableResolver)iterator.next();
            if (!(object instanceof CodeTemplateContextType.CodeTemplateVariableResolver)) continue;
            Assert.isNotNull((Object)this.getVariable(object.getType()), (String)("Variable " + object.getType() + "not defined"));
        }
        if (!this.canEvaluate(template)) {
            return null;
        }
        object = CodeTemplateContext.changeLineDelimiter(template.getPattern(), this.fLineDelimiter);
        TemplateTranslator templateTranslator = new TemplateTranslator();
        TemplateBuffer templateBuffer = templateTranslator.translate((String)object);
        this.getContextType().resolve(templateBuffer, (TemplateContext)this);
        return templateBuffer;
    }

    private static String changeLineDelimiter(String string, String string2) {
        try {
            DefaultLineTracker defaultLineTracker = new DefaultLineTracker();
            defaultLineTracker.set(string);
            int n = defaultLineTracker.getNumberOfLines();
            if (n == 1) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                if (n2 != 0) {
                    stringBuffer.append(string2);
                }
                IRegion iRegion = defaultLineTracker.getLineInformation(n2);
                String string3 = string.substring(iRegion.getOffset(), iRegion.getOffset() + iRegion.getLength());
                stringBuffer.append(string3);
                ++n2;
            }
            return stringBuffer.toString();
        }
        catch (BadLocationException badLocationException) {
            return string;
        }
    }

    public boolean canEvaluate(Template template) {
        return true;
    }

    public void setCompilationUnitVariables(ICompilationUnit iCompilationUnit) {
        this.setVariable("file_name", iCompilationUnit.getElementName());
        this.setVariable("package_name", iCompilationUnit.getParent().getElementName());
        this.setVariable("project_name", iCompilationUnit.getJavaProject().getElementName());
    }
}

