/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.util.StringTokenizer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class TypeFilter
implements IPropertyChangeListener {
    private StringMatcher[] fStringMatchers = null;

    public static TypeFilter getDefault() {
        return JavaPlugin.getDefault().getTypeFilter();
    }

    public static boolean isFiltered(String string) {
        return TypeFilter.getDefault().filter(string);
    }

    public static boolean isFiltered(char[] cArray) {
        return TypeFilter.getDefault().filter(new String(cArray));
    }

    public static boolean isFiltered(char[] cArray, char[] cArray2) {
        return TypeFilter.getDefault().filter(JavaModelUtil.concatenateName(cArray, cArray2));
    }

    public static boolean isFiltered(IType iType) {
        TypeFilter typeFilter = TypeFilter.getDefault();
        if (typeFilter.hasFilters()) {
            return typeFilter.filter(JavaModelUtil.getFullyQualifiedName(iType));
        }
        return false;
    }

    public static boolean isFiltered(TypeNameMatch typeNameMatch) {
        return TypeFilter.getDefault().filter(typeNameMatch.getFullyQualifiedName());
    }

    public TypeFilter() {
        PreferenceConstants.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private synchronized StringMatcher[] getStringMatchers() {
        if (this.fStringMatchers == null) {
            String string = PreferenceConstants.getPreferenceStore().getString("org.eclipse.wst.jsdt.ui.typefilter.enabled");
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            int n = stringTokenizer.countTokens();
            this.fStringMatchers = new StringMatcher[n];
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringTokenizer.nextToken();
                if (string2.length() > 0) {
                    this.fStringMatchers[n2] = new StringMatcher(string2, false, false);
                }
                ++n2;
            }
        }
        return this.fStringMatchers;
    }

    public void dispose() {
        PreferenceConstants.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStringMatchers = null;
    }

    public boolean hasFilters() {
        return this.getStringMatchers().length > 0;
    }

    public boolean filter(String string) {
        StringMatcher[] stringMatcherArray = this.getStringMatchers();
        int n = 0;
        while (n < stringMatcherArray.length) {
            StringMatcher stringMatcher = stringMatcherArray[n];
            if (stringMatcher.match(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("org.eclipse.wst.jsdt.ui.typefilter.enabled".equals(propertyChangeEvent.getProperty())) {
            this.fStringMatchers = null;
        }
    }
}

