/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.corext.util.TypeInfoRequestorAdapter;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;
import org.eclipse.wst.jsdt.ui.dialogs.ITypeInfoFilterExtension;

public class TypeInfoFilter {
    private String fText;
    private IJavaSearchScope fSearchScope;
    private boolean fIsWorkspaceScope;
    private int fElementKind;
    private ITypeInfoFilterExtension fFilterExtension;
    private TypeInfoRequestorAdapter fAdapter = new TypeInfoRequestorAdapter();
    private PatternMatcher fPackageMatcher;
    private PatternMatcher fNameMatcher;
    private static final int TYPE_MODIFIERS = 25088;

    public TypeInfoFilter(String string, IJavaSearchScope iJavaSearchScope, int n, ITypeInfoFilterExtension iTypeInfoFilterExtension) {
        this.fText = string;
        this.fSearchScope = iJavaSearchScope;
        this.fIsWorkspaceScope = this.fSearchScope.equals(SearchEngine.createWorkspaceScope());
        this.fElementKind = n;
        this.fFilterExtension = iTypeInfoFilterExtension;
        int n2 = string.lastIndexOf(".");
        if (n2 == -1) {
            this.fNameMatcher = new PatternMatcher(string, true);
        } else {
            this.fPackageMatcher = new PatternMatcher(this.evaluatePackagePattern(string.substring(0, n2)), true);
            String string2 = string.substring(n2 + 1);
            if (string2.length() == 0) {
                string2 = "*";
            }
            this.fNameMatcher = new PatternMatcher(string2, true);
        }
    }

    private String evaluatePackagePattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '.') {
                if (!bl) {
                    stringBuffer.append('*');
                }
                bl = false;
            } else if (c == '*' || c == '?') {
                bl = true;
            }
            stringBuffer.append(c);
            ++n;
        }
        if (!bl) {
            stringBuffer.append('*');
        }
        return stringBuffer.toString();
    }

    public String getText() {
        return this.fText;
    }

    public boolean isSubFilter(String string) {
        if (!this.fText.startsWith(string)) {
            return false;
        }
        return this.fText.indexOf(46, string.length()) == -1;
    }

    public boolean isCamelCasePattern() {
        return this.fNameMatcher.getMatchKind() == 128;
    }

    public String getPackagePattern() {
        if (this.fPackageMatcher == null) {
            return null;
        }
        return this.fPackageMatcher.getPattern();
    }

    public String getNamePattern() {
        return this.fNameMatcher.getPattern();
    }

    public int getSearchFlags() {
        return this.fNameMatcher.getMatchKind();
    }

    public int getPackageFlags() {
        if (this.fPackageMatcher == null) {
            return 0;
        }
        return this.fPackageMatcher.getMatchKind();
    }

    public boolean matchesRawNamePattern(TypeNameMatch typeNameMatch) {
        return Strings.startsWithIgnoreCase(typeNameMatch.getSimpleTypeName(), this.fNameMatcher.getPattern());
    }

    public boolean matchesCachedResult(TypeNameMatch typeNameMatch) {
        if (!this.matchesPackage(typeNameMatch) || !this.matchesFilterExtension(typeNameMatch)) {
            return false;
        }
        return this.matchesName(typeNameMatch);
    }

    public boolean matchesHistoryElement(TypeNameMatch typeNameMatch) {
        if (!(this.matchesPackage(typeNameMatch) && this.matchesModifiers(typeNameMatch) && this.matchesScope(typeNameMatch) && this.matchesFilterExtension(typeNameMatch))) {
            return false;
        }
        return this.matchesName(typeNameMatch);
    }

    public boolean matchesFilterExtension(TypeNameMatch typeNameMatch) {
        if (this.fFilterExtension == null) {
            return true;
        }
        this.fAdapter.setMatch(typeNameMatch);
        return this.fFilterExtension.select(this.fAdapter);
    }

    private boolean matchesName(TypeNameMatch typeNameMatch) {
        return this.fNameMatcher.matches(typeNameMatch.getSimpleTypeName());
    }

    private boolean matchesPackage(TypeNameMatch typeNameMatch) {
        if (this.fPackageMatcher == null) {
            return true;
        }
        return this.fPackageMatcher.matches(typeNameMatch.getTypeContainerName());
    }

    private boolean matchesScope(TypeNameMatch typeNameMatch) {
        if (this.fIsWorkspaceScope) {
            return true;
        }
        return this.fSearchScope.encloses((IJavaElement)typeNameMatch.getType());
    }

    private boolean matchesModifiers(TypeNameMatch typeNameMatch) {
        if (this.fElementKind == 0) {
            return true;
        }
        int n = typeNameMatch.getModifiers() & 0x6200;
        switch (this.fElementKind) {
            case 5: {
                return n == 0;
            }
            case 8: {
                return Flags.isAnnotation((int)n);
            }
            case 6: {
                return Flags.isInterface((int)n);
            }
            case 7: {
                return Flags.isEnum((int)n);
            }
            case 10: {
                return n == 0 || Flags.isInterface((int)n);
            }
            case 9: {
                return n == 0 || Flags.isEnum((int)n);
            }
        }
        return false;
    }

    private static class PatternMatcher {
        private String fPattern;
        private int fMatchKind;
        private StringMatcher fStringMatcher;
        private static final char END_SYMBOL = '<';
        private static final char ANY_STRING = '*';
        private static final char BLANK = ' ';

        public PatternMatcher(String string, boolean bl) {
            this(string, 131);
        }

        public PatternMatcher(String string, int n) {
            this.initializePatternAndMatchKind(string);
            this.fMatchKind &= n;
            if (this.fMatchKind == 2) {
                this.fStringMatcher = new StringMatcher(this.fPattern, true, false);
            }
        }

        public String getPattern() {
            return this.fPattern;
        }

        public int getMatchKind() {
            return this.fMatchKind;
        }

        public boolean matches(String string) {
            switch (this.fMatchKind) {
                case 2: {
                    return this.fStringMatcher.match(string);
                }
                case 0: {
                    return this.fPattern.equalsIgnoreCase(string);
                }
                case 128: {
                    if (!SearchPattern.camelCaseMatch((String)this.fPattern, (String)string)) break;
                    return true;
                }
            }
            return Strings.startsWithIgnoreCase(string, this.fPattern);
        }

        private void initializePatternAndMatchKind(String string) {
            int n = string.length();
            if (n == 0) {
                this.fMatchKind = 0;
                this.fPattern = string;
                return;
            }
            char c = string.charAt(n - 1);
            if (string.indexOf(42) != -1 || string.indexOf(63) != -1) {
                this.fMatchKind = 2;
                switch (c) {
                    case '<': {
                        this.fPattern = string.substring(0, n - 1);
                        break;
                    }
                    case ' ': {
                        this.fPattern = string.trim();
                        break;
                    }
                    case '*': {
                        this.fPattern = string;
                        break;
                    }
                    default: {
                        this.fPattern = String.valueOf(string) + '*';
                    }
                }
                return;
            }
            if (c == '<') {
                this.fMatchKind = 0;
                this.fPattern = string.substring(0, n - 1);
                return;
            }
            if (c == ' ') {
                this.fMatchKind = 0;
                this.fPattern = string.trim();
                return;
            }
            if (SearchUtils.isCamelCasePattern(string)) {
                this.fMatchKind = 128;
                this.fPattern = string;
                return;
            }
            this.fMatchKind = 1;
            this.fPattern = string;
        }
    }
}

