/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.wizards.BuildPathDialogAccess;

public class ConfigureContainerAction
implements IObjectActionDelegate {
    private ISelection fCurrentSelection;
    private IWorkbenchPart fPart;

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.fPart = iWorkbenchPart;
    }

    public void run(IAction iAction) {
        if (this.fCurrentSelection instanceof IStructuredSelection) {
            ClassPathContainer classPathContainer = (ClassPathContainer)((IStructuredSelection)this.fCurrentSelection).getFirstElement();
            this.openWizard(classPathContainer.getClasspathEntry(), classPathContainer.getLabel(), classPathContainer.getJavaProject());
        }
    }

    private void openWizard(IClasspathEntry iClasspathEntry, String string, final IJavaProject iJavaProject) {
        Shell shell = this.fPart.getSite().getShell();
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            IClasspathEntry iClasspathEntry2 = BuildPathDialogAccess.configureContainerEntry(shell, iClasspathEntry, iJavaProject, iClasspathEntryArray);
            if (iClasspathEntry2 == null || iClasspathEntry2.equals(iClasspathEntry)) {
                return;
            }
            int n = ConfigureContainerAction.indexInClasspath(iClasspathEntryArray, iClasspathEntry);
            if (n == -1) {
                return;
            }
            final IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length];
            System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, iClasspathEntryArray.length);
            iClasspathEntryArray2[n] = iClasspathEntry2;
            IWorkbenchWindow iWorkbenchWindow = this.fPart.getSite().getWorkbenchWindow();
            if (iWorkbenchWindow == null) {
                iWorkbenchWindow = PlatformUI.getWorkbench().getProgressService();
            }
            iWorkbenchWindow.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    try {
                        iJavaProject.setRawClasspath(iClasspathEntryArray2, iJavaProject.getOutputLocation(), iProgressMonitor);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
            });
        }
        catch (JavaModelException javaModelException) {
            String string2 = ActionMessages.ConfigureContainerAction_error_title;
            String string3 = ActionMessages.ConfigureContainerAction_error_creationfailed_message;
            ExceptionHandler.handle((CoreException)((Object)javaModelException), shell, string2, string3);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string4 = ActionMessages.ConfigureContainerAction_error_title;
            String string5 = ActionMessages.ConfigureContainerAction_error_applyingfailed_message;
            ExceptionHandler.handle(invocationTargetException, shell, string4, string5);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected static int indexInClasspath(IClasspathEntry[] iClasspathEntryArray, IClasspathEntry iClasspathEntry) {
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            if (iClasspathEntryArray[n] == iClasspathEntry) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.fCurrentSelection = iSelection;
    }
}

