/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.actions;

import java.io.CharConversionException;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ExtractSuperClassAction
extends SelectionDispatchAction {
    public static final String EXTRACT_SUPERTYPE = "org.eclipse.wst.jsdt.ui.edit.text.java.extract.superclass";
    public static final String EXTRACT_SUPERTYPES = "org.eclipse.wst.jsdt.ui.actions.ExtractSuperclass";
    private JavaEditor fEditor;

    private static IMember[] getSelectedMembers(IStructuredSelection iStructuredSelection) {
        Object object;
        if (iStructuredSelection.isEmpty()) {
            return null;
        }
        if (iStructuredSelection.size() == 1) {
            try {
                object = RefactoringAvailabilityTester.getSingleSelectedType(iStructuredSelection);
                if (object != null) {
                    return new IType[]{object};
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
        }
        object = iStructuredSelection.iterator();
        while (object.hasNext()) {
            if (object.next() instanceof IMember) continue;
            return null;
        }
        object = new HashSet();
        object.addAll(Arrays.asList(iStructuredSelection.toArray()));
        return object.toArray(new IMember[object.size()]);
    }

    public ExtractSuperClassAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public ExtractSuperClassAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.ExtractSuperTypeAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.extract_supertype_action");
    }

    private IMember getSelectedMemberFromEditor() throws JavaModelException {
        IJavaElement iJavaElement = SelectionConverter.resolveEnclosingElement(this.fEditor, (ITextSelection)this.fEditor.getSelectionProvider().getSelection());
        if (iJavaElement == null || !(iJavaElement instanceof IMember)) {
            return null;
        }
        return (IMember)iJavaElement;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            IMember[] iMemberArray = ExtractSuperClassAction.getSelectedMembers(iStructuredSelection);
            if (RefactoringAvailabilityTester.isExtractSupertypeAvailable(iMemberArray) && ActionUtil.isEditable(this.getShell(), (IJavaElement)iMemberArray[0])) {
                RefactoringExecutionStarter.startExtractSupertypeRefactoring(iMemberArray, this.getShell());
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(ITextSelection iTextSelection) {
        try {
            if (!ActionUtil.isEditable(this.fEditor)) {
                return;
            }
            IMember iMember = this.getSelectedMemberFromEditor();
            IMember[] iMemberArray = new IMember[]{iMember};
            if (iMember != null && RefactoringAvailabilityTester.isExtractSupertypeAvailable(iMemberArray)) {
                RefactoringExecutionStarter.startExtractSupertypeRefactoring(iMemberArray, this.getShell());
            } else {
                MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.OpenRefactoringWizardAction_unavailable, (String)RefactoringMessages.ExtractSuperTypeAction_unavailable);
            }
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isExtractSupertypeAvailable(iStructuredSelection));
        }
        catch (JavaModelException javaModelException) {
            if (!(javaModelException.getException() instanceof CharConversionException) && JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isExtractSupertypeAvailable(javaTextSelection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }
}

