/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.IWorkingCopy;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;

class JavaBrowsingContentProvider
extends StandardJavaElementContentProvider
implements IElementChangedListener {
    private StructuredViewer fViewer;
    private Object fInput;
    private JavaBrowsingPart fBrowsingPart;
    private int fReadsInDisplayThread;

    public JavaBrowsingContentProvider(boolean bl, JavaBrowsingPart javaBrowsingPart) {
        super(bl);
        this.fBrowsingPart = javaBrowsingPart;
        this.fViewer = this.fBrowsingPart.getViewer();
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public boolean hasChildren(Object object) {
        this.startReadInDisplayThread();
        try {
            boolean bl = super.hasChildren(object);
            Object var2_3 = null;
            this.finishedReadInDisplayThread();
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.finishedReadInDisplayThread();
            throw throwable;
        }
    }

    public Object[] getChildren(Object object) {
        block17: {
            block16: {
                block15: {
                    block14: {
                        block12: {
                            block13: {
                                if (!this.exists(object)) {
                                    return NO_CHILDREN;
                                }
                                this.startReadInDisplayThread();
                                if (!(object instanceof Collection)) break block12;
                                Collection collection = (Collection)object;
                                if (!collection.isEmpty()) break block13;
                                Object[] objectArray = NO_CHILDREN;
                                Object var6_11 = null;
                                this.finishedReadInDisplayThread();
                                return objectArray;
                            }
                            Object[] objectArray = new Object[]{};
                            Iterator iterator = ((Collection)object).iterator();
                            while (iterator.hasNext()) {
                                Object[] objectArray2 = this.getChildren(iterator.next());
                                if (objectArray2 == NO_CHILDREN) continue;
                                objectArray = JavaBrowsingContentProvider.concatenate(objectArray, objectArray2);
                            }
                            Object[] objectArray3 = objectArray;
                            Object var6_12 = null;
                            this.finishedReadInDisplayThread();
                            return objectArray3;
                        }
                        if (!(object instanceof IPackageFragment)) break block14;
                        Object[] objectArray = this.getPackageContents((IPackageFragment)object);
                        Object var6_13 = null;
                        this.finishedReadInDisplayThread();
                        return objectArray;
                    }
                    if (!this.fProvideMembers || !(object instanceof IType)) break block15;
                    Object[] objectArray = this.getChildren((IType)object);
                    Object var6_14 = null;
                    this.finishedReadInDisplayThread();
                    return objectArray;
                }
                if (!this.fProvideMembers || !(object instanceof ISourceReference) || !(object instanceof IParent)) break block16;
                Object[] objectArray = this.removeImportAndPackageDeclarations(super.getChildren(object));
                Object var6_15 = null;
                this.finishedReadInDisplayThread();
                return objectArray;
            }
            if (!(object instanceof IJavaProject)) break block17;
            Object[] objectArray = this.getPackageFragmentRoots((IJavaProject)object);
            Object var6_16 = null;
            this.finishedReadInDisplayThread();
            return objectArray;
        }
        try {
            Object[] objectArray = super.getChildren(object);
            Object var6_17 = null;
            this.finishedReadInDisplayThread();
            return objectArray;
        }
        catch (JavaModelException javaModelException) {
            try {
                Object[] objectArray = NO_CHILDREN;
                Object var6_18 = null;
                this.finishedReadInDisplayThread();
                return objectArray;
            }
            catch (Throwable throwable) {
                Object var6_19 = null;
                this.finishedReadInDisplayThread();
                throw throwable;
            }
        }
    }

    private Object[] getPackageContents(IPackageFragment iPackageFragment) throws JavaModelException {
        Object[] objectArray;
        ICompilationUnit[] iCompilationUnitArray;
        if (iPackageFragment.getKind() == 1) {
            iCompilationUnitArray = iPackageFragment.getCompilationUnits();
        } else {
            objectArray = iPackageFragment.getClassFiles();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            int n = 0;
            while (n < objectArray.length) {
                IType iType = objectArray[n].getType();
                if (iType != null && iType.getDeclaringType() == null && !iType.isAnonymous() && !iType.isLocal()) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            iCompilationUnitArray = arrayList.toArray(new ISourceReference[arrayList.size()]);
        }
        objectArray = new Object[]{};
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            objectArray = JavaBrowsingContentProvider.concatenate(objectArray, this.removeImportAndPackageDeclarations(this.getChildren(iCompilationUnitArray[n])));
            ++n;
        }
        return JavaBrowsingContentProvider.concatenate(objectArray, iPackageFragment.getNonJavaResources());
    }

    private Object[] removeImportAndPackageDeclarations(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        int n = 0;
        while (n < objectArray.length) {
            if (!(objectArray[n] instanceof IImportContainer) && !(objectArray[n] instanceof IPackageDeclaration)) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        return arrayList.toArray();
    }

    private Object[] getChildren(IType iType) throws JavaModelException {
        Object object = iType.isBinary() ? iType.getClassFile() : iType.getCompilationUnit();
        if (iType.getDeclaringType() != null) {
            return iType.getChildren();
        }
        IJavaElement[] iJavaElementArray = object.getChildren();
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>(iJavaElementArray.length);
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (iJavaElementArray[n] instanceof IImportContainer) {
                arrayList.add(iJavaElementArray[n]);
            }
            ++n;
        }
        arrayList.addAll(Arrays.asList(iType.getChildren()));
        return arrayList.toArray();
    }

    protected Object[] getPackageFragmentRoots(IJavaProject iJavaProject) throws JavaModelException {
        if (!iJavaProject.getProject().isOpen()) {
            return NO_CHILDREN;
        }
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        ArrayList<Object> arrayList = new ArrayList<Object>(iPackageFragmentRootArray.length);
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n];
            if (!iPackageFragmentRoot.isExternal()) {
                IJavaElement[] iJavaElementArray = iPackageFragmentRoot.getChildren();
                int n2 = 0;
                while (n2 < iJavaElementArray.length) {
                    arrayList.add(iJavaElementArray[n2]);
                    ++n2;
                }
            } else if (this.hasChildren(iPackageFragmentRoot)) {
                arrayList.add(iPackageFragmentRoot);
            }
            ++n;
        }
        return JavaBrowsingContentProvider.concatenate(arrayList.toArray(), iJavaProject.getNonJavaResources());
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        super.inputChanged(viewer, object, object2);
        if (object2 instanceof Collection) {
            Collection collection = (Collection)object2;
            object2 = !collection.isEmpty() ? collection.iterator().next() : null;
        }
        this.fInput = object2;
    }

    public void dispose() {
        super.dispose();
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent elementChangedEvent) {
        try {
            this.processDelta(elementChangedEvent.getDelta());
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException.getStatus());
        }
    }

    protected void processDelta(IJavaElementDelta iJavaElementDelta) throws JavaModelException {
        IJavaElement iJavaElement;
        IPackageFragmentRoot iPackageFragmentRoot;
        int n = iJavaElementDelta.getKind();
        int n2 = iJavaElementDelta.getFlags();
        IJavaElement iJavaElement2 = iJavaElementDelta.getElement();
        boolean bl = this.fBrowsingPart.isValidElement(iJavaElement2);
        if (!this.getProvideWorkingCopy() && iJavaElement2 instanceof IWorkingCopy && ((IWorkingCopy)iJavaElement2).isWorkingCopy()) {
            return;
        }
        if (iJavaElement2 != null && iJavaElement2.getElementType() == 5 && !this.isOnClassPath((ICompilationUnit)iJavaElement2)) {
            return;
        }
        if ((n2 & 0x400) != 0 || (n2 & 0x200) != 0) {
            this.postRefresh(null);
            return;
        }
        if (n == 2) {
            Object object = this.internalGetParent(iJavaElement2);
            if (bl) {
                if (iJavaElement2 instanceof IClassFile) {
                    this.postRemove(((IClassFile)iJavaElement2).getType());
                } else if (iJavaElement2 instanceof ICompilationUnit && !((ICompilationUnit)iJavaElement2).isWorkingCopy()) {
                    this.postRefresh(null);
                } else if (iJavaElement2 instanceof ICompilationUnit && ((ICompilationUnit)iJavaElement2).isWorkingCopy()) {
                    if (this.getProvideWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (object instanceof ICompilationUnit && this.getProvideWorkingCopy() && !((ICompilationUnit)object).isWorkingCopy()) {
                    if (iJavaElement2 instanceof IWorkingCopy && ((IWorkingCopy)iJavaElement2).isWorkingCopy()) {
                        this.postRefresh(null);
                    }
                } else if (iJavaElement2 instanceof IWorkingCopy && ((IWorkingCopy)iJavaElement2).isWorkingCopy() && object != null && object.equals(this.fInput)) {
                    this.postRefresh(null);
                } else {
                    this.postRemove(iJavaElement2);
                }
            }
            if (this.fBrowsingPart.isAncestorOf(iJavaElement2, this.fInput)) {
                if (iJavaElement2 instanceof IWorkingCopy && ((IWorkingCopy)iJavaElement2).isWorkingCopy()) {
                    this.postAdjustInputAndSetSelection(((IJavaElement)this.fInput).getPrimaryElement());
                } else {
                    this.postAdjustInputAndSetSelection(null);
                }
            }
            if (this.fInput != null && this.fInput.equals(iJavaElement2)) {
                this.postRefresh(null);
            }
            if (object instanceof IPackageFragment && this.fBrowsingPart.isValidElement(object) && this.isPackageFragmentEmpty((IJavaElement)((IPackageFragment)object)) && this.fViewer.testFindItem(object) != null) {
                this.postRefresh(null);
            }
            return;
        }
        if (n == 1 && iJavaElementDelta.getMovedFromElement() != null && iJavaElement2 instanceof ICompilationUnit) {
            return;
        }
        if (n == 1) {
            if (bl) {
                Object object = this.internalGetParent(iJavaElement2);
                if (iJavaElement2 instanceof IClassFile) {
                    this.postAdd(object, ((IClassFile)iJavaElement2).getType());
                } else if (iJavaElement2 instanceof ICompilationUnit && !((ICompilationUnit)iJavaElement2).isWorkingCopy()) {
                    this.postAdd(object, ((ICompilationUnit)iJavaElement2).getTypes());
                } else if (!(object instanceof ICompilationUnit) || !this.getProvideWorkingCopy() || ((ICompilationUnit)object).isWorkingCopy()) {
                    if (iJavaElement2 instanceof IWorkingCopy && ((IWorkingCopy)iJavaElement2).isWorkingCopy()) {
                        this.postRefresh(null);
                    } else {
                        this.postAdd(object, iJavaElement2);
                    }
                }
            } else if (this.fInput == null) {
                IJavaElement iJavaElement3 = this.fBrowsingPart.findInputForJavaElement(iJavaElement2);
                if (iJavaElement3 != null) {
                    this.postAdjustInputAndSetSelection(iJavaElement2);
                }
            } else if (iJavaElement2 instanceof IType && this.fBrowsingPart.isValidInput(iJavaElement2)) {
                IJavaElement iJavaElement4 = iJavaElement2.getAncestor(5);
                IJavaElement iJavaElement5 = ((IJavaElement)this.fInput).getAncestor(5);
                if (iJavaElement4 != null && iJavaElement5 != null && iJavaElement4.equals(iJavaElement5)) {
                    this.postAdjustInputAndSetSelection(iJavaElement2);
                }
            }
            return;
        }
        if (n == 4) {
            if (this.fInput != null && this.fInput.equals(iJavaElement2) && (n2 & 8) != 0 && (n2 & 0x4000) != 0) {
                this.postRefresh(null, true);
                return;
            }
            if (bl && (n2 & 2) != 0) {
                this.postUpdateIcon(iJavaElement2);
            }
        }
        if (this.isClassPathChange(iJavaElementDelta)) {
            this.postRefresh(null);
        }
        if ((n2 & 0x8000) != 0 && this.fInput instanceof IJavaElement && (iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement2).equals(iJavaElement = ((IJavaElement)this.fInput).getAncestor(3))) {
            this.postRefresh(null);
        }
        if (iJavaElement2 instanceof IPackageFragmentRoot && ((n2 & 0x1000) != 0 || (n2 & 0x2000) != 0)) {
            this.postUpdateIcon(iJavaElement2);
        }
        if (((IPackageFragmentRoot)(iPackageFragmentRoot = iJavaElementDelta.getAffectedChildren())).length > 1) {
            if (iJavaElement2 instanceof IPackageFragment) {
                iJavaElement = (IJavaElement)this.internalGetParent(iJavaElement2);
                if (iJavaElement2.equals(this.fInput)) {
                    this.postRefresh(iJavaElement2);
                } else {
                    this.postRefresh(iJavaElement);
                }
            }
            if (iJavaElement2 instanceof IPackageFragmentRoot && bl) {
                this.postRefresh(this.skipProjectPackageFragmentRoot((IPackageFragmentRoot)iJavaElement2));
                return;
            }
        }
        int n3 = 0;
        while (n3 < ((IPackageFragmentRoot)iPackageFragmentRoot).length) {
            this.processDelta((IJavaElementDelta)iPackageFragmentRoot[n3]);
            ++n3;
        }
    }

    private boolean isOnClassPath(ICompilationUnit iCompilationUnit) throws JavaModelException {
        IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
        if (iJavaProject == null || !iJavaProject.exists()) {
            return false;
        }
        return iJavaProject.isOnClasspath((IJavaElement)iCompilationUnit);
    }

    private void postUpdateIcon(final IJavaElement iJavaElement) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    JavaBrowsingContentProvider.this.fViewer.update((Object)iJavaElement, new String[]{"org.eclipse.jface.image"});
                }
            }
        });
    }

    private void postRefresh(final Object object, final boolean bl) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    JavaBrowsingContentProvider.this.fViewer.refresh(object, bl);
                }
            }
        });
    }

    private void postRefresh(Object object) {
        this.postRefresh(object, false);
    }

    private void postAdd(Object object, Object object2) {
        this.postAdd(object, new Object[]{object2});
    }

    private void postAdd(final Object object, final Object[] objectArray) {
        if (objectArray == null || objectArray.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    Object[] objectArray2 = JavaBrowsingContentProvider.this.getNewElements(objectArray);
                    if (JavaBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        if (JavaBrowsingContentProvider.this.fViewer.testFindItem(object) == null) {
                            Object object2 = ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).getInput();
                            if (object2 != null) {
                                ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).add(object2, objectArray2);
                            }
                        } else {
                            ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).add(object, objectArray2);
                        }
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)JavaBrowsingContentProvider.this.fViewer).add(objectArray2);
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)JavaBrowsingContentProvider.this.fViewer).add(objectArray2);
                    }
                    if (JavaBrowsingContentProvider.this.fViewer.testFindItem(objectArray[0]) != null) {
                        JavaBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(objectArray[0]);
                    }
                }
            }
        });
    }

    private Object[] getNewElements(Object[] objectArray) {
        int n = objectArray.length;
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (this.fViewer.testFindItem(object) == null) {
                arrayList.add(object);
            }
            ++n2;
        }
        return arrayList.toArray();
    }

    private void postRemove(Object object) {
        this.postRemove(new Object[]{object});
    }

    private void postRemove(final Object[] objectArray) {
        if (objectArray.length <= 0) {
            return;
        }
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    if (JavaBrowsingContentProvider.this.fViewer instanceof AbstractTreeViewer) {
                        ((AbstractTreeViewer)JavaBrowsingContentProvider.this.fViewer).remove(objectArray);
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof ListViewer) {
                        ((ListViewer)JavaBrowsingContentProvider.this.fViewer).remove(objectArray);
                    } else if (JavaBrowsingContentProvider.this.fViewer instanceof TableViewer) {
                        ((TableViewer)JavaBrowsingContentProvider.this.fViewer).remove(objectArray);
                    }
                }
            }
        });
    }

    private void postAdjustInputAndSetSelection(final Object object) {
        this.postRunnable(new Runnable(){

            public void run() {
                Control control = JavaBrowsingContentProvider.this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.setRedraw(false);
                    JavaBrowsingContentProvider.this.fBrowsingPart.adjustInputAndSetSelection(object);
                    control.setRedraw(true);
                }
            }
        });
    }

    protected void startReadInDisplayThread() {
        if (this.isDisplayThread()) {
            ++this.fReadsInDisplayThread;
        }
    }

    protected void finishedReadInDisplayThread() {
        if (this.isDisplayThread()) {
            --this.fReadsInDisplayThread;
        }
    }

    private boolean isDisplayThread() {
        Control control = this.fViewer.getControl();
        if (control == null) {
            return false;
        }
        Display display = Display.getCurrent();
        return display != null && display.equals(control.getDisplay());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void postRunnable(Runnable runnable) {
        Control control = this.fViewer.getControl();
        if (control == null) return;
        if (control.isDisposed()) return;
        this.fBrowsingPart.setProcessSelectionEvents(false);
        try {
            if (this.isDisplayThread() && this.fReadsInDisplayThread == 0) {
                control.getDisplay().syncExec(runnable);
            } else {
                control.getDisplay().asyncExec(runnable);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fBrowsingPart.setProcessSelectionEvents(true);
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.fBrowsingPart.setProcessSelectionEvents(true);
            return;
        }
    }

    protected Object internalGetParent(Object object) {
        if (object instanceof IJavaProject) {
            return ((IJavaProject)object).getJavaModel();
        }
        if (object instanceof IResource) {
            IContainer iContainer = ((IResource)object).getParent();
            IJavaElement iJavaElement = JavaCore.create((IResource)iContainer);
            if (iJavaElement != null) {
                return iJavaElement;
            }
            return iContainer;
        }
        if (object instanceof IPackageFragment) {
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)((IPackageFragment)object).getParent();
            return this.skipProjectPackageFragmentRoot(iPackageFragmentRoot);
        }
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getParent();
        }
        return null;
    }
}

