/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.browsing;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.CategoryFilterActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.LexicalSortingAction;
import org.eclipse.wst.jsdt.internal.ui.browsing.JavaBrowsingPart;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaUILabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.MemberFilterActionGroup;

public class MembersView
extends JavaBrowsingPart
implements IPropertyChangeListener {
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private CategoryFilterActionGroup fCategoryFilterActionGroup;
    static /* synthetic */ Class class$0;

    public MembersView() {
        this.setHasWorkingSetFilter(false);
        this.setHasCustomSetFilter(true);
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.wst.jsdt.ui.PackageExplorer"};
                }
            };
        }
        return super.getAdapter(clazz);
    }

    protected JavaUILabelProvider createLabelProvider() {
        return new AppearanceAwareLabelProvider(0x210000204029L | JavaElementLabels.ALL_CATEGORY, 1);
    }

    protected String getHelpContextId() {
        return "org.eclipse.wst.jsdt.ui.members_view_context";
    }

    protected String getLinkToEditorKey() {
        return "org.eclipse.wst.jsdt.ui.browsing.memberstoeditor";
    }

    protected StructuredViewer createViewer(Composite composite) {
        ProblemTreeViewer problemTreeViewer = new ProblemTreeViewer(composite, 2);
        ColoredViewersManager.install((StructuredViewer)problemTreeViewer);
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)problemTreeViewer, JavaUI.ID_MEMBERS_VIEW);
        return problemTreeViewer;
    }

    protected void fillToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)new LexicalSortingAction(this.getViewer(), JavaUI.ID_MEMBERS_VIEW));
        this.fMemberFilterActionGroup.contributeToToolBar(iToolBarManager);
        super.fillToolBar(iToolBarManager);
    }

    protected void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.fCategoryFilterActionGroup = new CategoryFilterActionGroup(this.getViewer(), this.getViewSite().getId(), this.getCategoryFilterActionGroupInput());
        this.fCategoryFilterActionGroup.contributeToViewMenu(iActionBars.getMenuManager());
    }

    protected void setInput(Object object) {
        super.setInput(object);
        if (this.fCategoryFilterActionGroup != null) {
            this.fCategoryFilterActionGroup.setInput(this.getCategoryFilterActionGroupInput());
        }
    }

    private IJavaElement[] getCategoryFilterActionGroupInput() {
        Object object = this.getInput();
        if (object instanceof IJavaElement) {
            return new IJavaElement[]{(IJavaElement)object};
        }
        return new IJavaElement[0];
    }

    protected boolean isValidInput(Object object) {
        if (object instanceof IType) {
            IType iType = (IType)object;
            return iType.isBinary() || iType.getDeclaringType() == null;
        }
        return false;
    }

    protected boolean isValidElement(Object object) {
        Object object2;
        if (object instanceof IMember) {
            return super.isValidElement(((IMember)object).getDeclaringType());
        }
        if (object instanceof IImportDeclaration) {
            return this.isValidElement(((IJavaElement)object).getParent());
        }
        if (object instanceof IImportContainer && (object2 = this.getViewer().getInput()) instanceof IJavaElement) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)((IJavaElement)object2).getAncestor(5);
            if (iCompilationUnit != null) {
                ICompilationUnit iCompilationUnit2 = (ICompilationUnit)((IJavaElement)object).getAncestor(5);
                return iCompilationUnit.equals(iCompilationUnit2);
            }
            IClassFile iClassFile = (IClassFile)((IJavaElement)object2).getAncestor(6);
            IClassFile iClassFile2 = (IClassFile)((IJavaElement)object).getAncestor(6);
            return iClassFile != null && iClassFile.equals(iClassFile2);
        }
        return false;
    }

    protected IJavaElement findElementToSelect(IJavaElement iJavaElement) {
        if (iJavaElement == null) {
            return null;
        }
        switch (iJavaElement.getElementType()) {
            case 7: {
                if (((IType)iJavaElement).getDeclaringType() == null) {
                    return null;
                }
                return iJavaElement;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return iJavaElement;
            }
            case 13: {
                ICompilationUnit iCompilationUnit = (ICompilationUnit)iJavaElement.getParent().getParent();
                try {
                    Object object;
                    if (iCompilationUnit.getImports()[0].equals(iJavaElement) && (object = this.getSingleElementFromSelection(this.getViewer().getSelection())) instanceof IImportContainer) {
                        return (IImportContainer)object;
                    }
                }
                catch (JavaModelException javaModelException) {}
                return iJavaElement;
            }
        }
        return null;
    }

    protected IJavaElement findInputForJavaElement(IJavaElement iJavaElement) {
        if (iJavaElement == null || !iJavaElement.exists() || iJavaElement.getJavaProject() != null && !iJavaElement.getJavaProject().isOnClasspath(iJavaElement)) {
            return null;
        }
        switch (iJavaElement.getElementType()) {
            case 7: {
                IType iType = ((IType)iJavaElement).getDeclaringType();
                if (iType == null) {
                    return iJavaElement;
                }
                return this.findInputForJavaElement((IJavaElement)iType);
            }
            case 5: {
                return this.getTypeForCU((ICompilationUnit)iJavaElement);
            }
            case 6: {
                return this.findInputForJavaElement((IJavaElement)((IClassFile)iJavaElement).getType());
            }
            case 13: {
                return this.findInputForJavaElement(iJavaElement.getParent());
            }
            case 11: 
            case 12: {
                IJavaElement iJavaElement2 = iJavaElement.getParent();
                if (iJavaElement2 instanceof ICompilationUnit) {
                    return this.getTypeForCU((ICompilationUnit)iJavaElement2);
                }
                if (iJavaElement2 instanceof IClassFile) {
                    return this.findInputForJavaElement(iJavaElement2);
                }
                return null;
            }
        }
        if (iJavaElement instanceof IMember) {
            return this.findInputForJavaElement((IJavaElement)((IMember)iJavaElement).getDeclaringType());
        }
        return null;
    }

    public void saveState(IMemento iMemento) {
        super.saveState(iMemento);
        this.fMemberFilterActionGroup.saveState(iMemento);
    }

    protected void restoreState(IMemento iMemento) {
        super.restoreState(iMemento);
        this.fMemberFilterActionGroup.restoreState(iMemento);
        this.getViewer().getControl().setRedraw(false);
        this.getViewer().refresh();
        this.getViewer().getControl().setRedraw(true);
    }

    protected void hookViewerListeners() {
        super.hookViewerListeners();
        this.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                Object object;
                TreeViewer treeViewer = (TreeViewer)MembersView.this.getViewer();
                if (treeViewer.isExpandable(object = ((IStructuredSelection)doubleClickEvent.getSelection()).getFirstElement())) {
                    treeViewer.setExpandedState(object, !treeViewer.getExpandedState(object));
                }
            }
        });
    }

    boolean isInputAWorkingCopy() {
        ICompilationUnit iCompilationUnit;
        Object object = this.getViewer().getInput();
        if (object instanceof IJavaElement && (iCompilationUnit = (ICompilationUnit)((IJavaElement)object).getAncestor(5)) != null) {
            return iCompilationUnit.isWorkingCopy();
        }
        return false;
    }

    protected void restoreSelection() {
        IEditorPart iEditorPart = this.getViewSite().getPage().getActiveEditor();
        if (iEditorPart != null) {
            this.setSelectionFromEditor((IWorkbenchPart)iEditorPart);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (MembersOrderPreferenceCache.isMemberOrderProperty(propertyChangeEvent.getProperty())) {
            this.getViewer().refresh();
        }
    }

    public void dispose() {
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fCategoryFilterActionGroup != null) {
            this.fCategoryFilterActionGroup.dispose();
            this.fCategoryFilterActionGroup = null;
        }
        super.dispose();
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }
}

