/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyViewPart;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;

public class HistoryListAction
extends Action {
    private CallHierarchyViewPart fView;

    public HistoryListAction(CallHierarchyViewPart callHierarchyViewPart) {
        this.fView = callHierarchyViewPart;
        this.setText(CallHierarchyMessages.HistoryListAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.history_list_action");
    }

    public void run() {
        IMethod[] iMethodArray = this.fView.getHistoryEntries();
        HistoryListDialog historyListDialog = new HistoryListDialog(JavaPlugin.getActiveWorkbenchShell(), iMethodArray);
        if (historyListDialog.open() == 0) {
            this.fView.setHistoryEntries(historyListDialog.getRemaining());
            this.fView.setMethod(historyListDialog.getResult());
        }
    }

    private class HistoryListDialog
    extends StatusDialog {
        private ListDialogField fHistoryList;
        private IStatus fHistoryStatus;
        private IMethod fResult;

        private HistoryListDialog(Shell shell, IMethod[] iMethodArray) {
            super(shell);
            this.setTitle(CallHierarchyMessages.HistoryListDialog_title);
            String[] stringArray = new String[]{CallHierarchyMessages.HistoryListDialog_remove_button};
            IListAdapter iListAdapter = new IListAdapter(this){
                final /* synthetic */ HistoryListDialog this$1;
                {
                    this.this$1 = historyListDialog;
                }

                public void customButtonPressed(ListDialogField listDialogField, int n) {
                    HistoryListDialog.access$0(this.this$1);
                }

                public void selectionChanged(ListDialogField listDialogField) {
                    HistoryListDialog.access$1(this.this$1);
                }

                public void doubleClicked(ListDialogField listDialogField) {
                    HistoryListDialog.access$2(this.this$1);
                }
            };
            JavaElementLabelProvider javaElementLabelProvider = new JavaElementLabelProvider(1088);
            this.fHistoryList = new ListDialogField(iListAdapter, stringArray, (ILabelProvider)javaElementLabelProvider);
            this.fHistoryList.setLabelText(CallHierarchyMessages.HistoryListDialog_label);
            this.fHistoryList.setElements(Arrays.asList(iMethodArray));
            StructuredSelection structuredSelection = iMethodArray.length > 0 ? new StructuredSelection((Object)iMethodArray[0]) : new StructuredSelection();
            this.fHistoryList.selectElements((ISelection)structuredSelection);
        }

        protected Control createDialogArea(Composite composite) {
            this.initializeDialogUnits((Control)composite);
            Composite composite2 = (Composite)super.createDialogArea(composite);
            Composite composite3 = new Composite(composite2, 0);
            composite3.setLayoutData((Object)new GridData(1808));
            composite3.setFont(composite2.getFont());
            LayoutUtil.doDefaultLayout(composite3, new DialogField[]{this.fHistoryList}, true, 0, 0);
            LayoutUtil.setHeightHint(this.fHistoryList.getListControl(null), this.convertHeightInCharsToPixels(12));
            LayoutUtil.setHorizontalGrabbing(this.fHistoryList.getListControl(null));
            HistoryListDialog.applyDialogFont((Control)composite2);
            return composite2;
        }

        private void doCustomButtonPressed() {
            this.fHistoryList.removeElements(this.fHistoryList.getSelectedElements());
        }

        private void doDoubleClicked() {
            if (this.fHistoryStatus.isOK()) {
                this.okPressed();
            }
        }

        private void doSelectionChanged() {
            StatusInfo statusInfo = new StatusInfo();
            List list = this.fHistoryList.getSelectedElements();
            if (list.size() != 1) {
                statusInfo.setError("");
                this.fResult = null;
            } else {
                this.fResult = (IMethod)list.get(0);
            }
            this.fHistoryList.enableButton(0, this.fHistoryList.getSize() > list.size() && list.size() != 0);
            this.fHistoryStatus = statusInfo;
            this.updateStatus(statusInfo);
        }

        public IMethod getResult() {
            return this.fResult;
        }

        public IMethod[] getRemaining() {
            List list = this.fHistoryList.getElements();
            return list.toArray(new IMethod[list.size()]);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.history_list_dialog_context");
        }

        public void create() {
            this.setShellStyle(this.getShellStyle() | 0x10);
            super.create();
        }

        static /* synthetic */ void access$0(HistoryListDialog historyListDialog) {
            historyListDialog.doCustomButtonPressed();
        }

        static /* synthetic */ void access$1(HistoryListDialog historyListDialog) {
            historyListDialog.doSelectionChanged();
        }

        static /* synthetic */ void access$2(HistoryListDialog historyListDialog) {
            historyListDialog.doDoubleClicked();
        }
    }
}

