/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.core.search.TypeNameRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.History;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.OpenTypeHistory;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TypeSelectionComponent;
import org.eclipse.wst.jsdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.dialogs.TypeSelectionExtension;

public class TypeSelectionDialog2
extends SelectionStatusDialog {
    private String fTitle;
    private boolean fMultipleSelection;
    private IRunnableContext fRunnableContext;
    private IJavaSearchScope fScope;
    private int fElementKind;
    private String fInitialFilter;
    private int fSelectionMode;
    private ISelectionStatusValidator fValidator;
    private TypeSelectionComponent fContent;
    private TypeSelectionExtension fExtension;
    public static final int NONE = 0;
    public static final int CARET_BEGINNING = 1;
    public static final int FULL_SELECTION = 2;
    private static boolean fgFirstTime = true;

    public TypeSelectionDialog2(Shell shell, boolean bl, IRunnableContext iRunnableContext, IJavaSearchScope iJavaSearchScope, int n) {
        this(shell, bl, iRunnableContext, iJavaSearchScope, n, null);
    }

    public TypeSelectionDialog2(Shell shell, boolean bl, IRunnableContext iRunnableContext, IJavaSearchScope iJavaSearchScope, int n, TypeSelectionExtension typeSelectionExtension) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMultipleSelection = bl;
        this.fRunnableContext = iRunnableContext;
        this.fScope = iJavaSearchScope;
        this.fElementKind = n;
        this.fSelectionMode = 0;
        this.fExtension = typeSelectionExtension;
        if (this.fExtension != null) {
            this.fValidator = this.fExtension.getSelectionValidator();
        }
    }

    public void setFilter(String string) {
        this.setFilter(string, 2);
    }

    public void setFilter(String string, int n) {
        this.fInitialFilter = string;
        this.fSelectionMode = n;
    }

    public void setValidator(ISelectionStatusValidator iSelectionStatusValidator) {
        this.fValidator = iSelectionStatusValidator;
    }

    protected TypeNameMatch[] getSelectedTypes() {
        if (this.fContent == null || this.fContent.isDisposed()) {
            return null;
        }
        return this.fContent.getSelection();
    }

    public void create() {
        super.create();
        this.fContent.populate(this.fSelectionMode);
        this.getOkButton().setEnabled(this.fContent.getSelection().length > 0);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.type_selection_dialog2_context");
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.fContent = new TypeSelectionComponent(composite2, 0, this.getMessage(), this.fMultipleSelection, this.fScope, this.fElementKind, this.fInitialFilter, new TitleLabel(), this.fExtension);
        GridData gridData = new GridData(1808);
        this.fContent.setLayoutData(gridData);
        this.fContent.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                TypeSelectionDialog2.this.handleDefaultSelected(TypeSelectionDialog2.this.fContent.getSelection());
            }

            public void widgetSelected(SelectionEvent selectionEvent) {
                TypeSelectionDialog2.this.handleWidgetSelected(TypeSelectionDialog2.this.fContent.getSelection());
            }
        });
        return composite2;
    }

    protected void handleDefaultSelected(TypeNameMatch[] typeNameMatchArray) {
        if (typeNameMatchArray.length == 0) {
            return;
        }
        this.okPressed();
    }

    protected void handleWidgetSelected(TypeNameMatch[] typeNameMatchArray) {
        Status status = null;
        if (typeNameMatchArray.length == 0) {
            status = new Status(4, JavaPlugin.getPluginId(), 4, "", null);
        } else if (this.fValidator != null) {
            ArrayList<IType> arrayList = new ArrayList<IType>();
            int n = 0;
            while (n < typeNameMatchArray.length) {
                IType iType = typeNameMatchArray[n].getType();
                if (iType == null) {
                    status = new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(JavaUIMessages.TypeSelectionDialog_error_type_doesnot_exist, typeNameMatchArray[n].getFullyQualifiedName()), null);
                    break;
                }
                arrayList.add(iType);
                ++n;
            }
            if (status == null) {
                status = this.fValidator.validate(arrayList.toArray());
            }
        } else {
            status = new Status(0, JavaPlugin.getPluginId(), 0, "", null);
        }
        this.updateStatus((IStatus)status);
    }

    public int open() {
        String string;
        ISelection iSelection;
        IWorkbenchWindow iWorkbenchWindow;
        try {
            this.ensureConsistency();
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, JavaUIMessages.TypeSelectionDialog_error3Title, JavaUIMessages.TypeSelectionDialog_error3Message);
            return 1;
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        if (this.fInitialFilter == null && (iWorkbenchWindow = JavaPlugin.getActiveWorkbenchWindow()) != null && (iSelection = iWorkbenchWindow.getSelectionService().getSelection()) instanceof ITextSelection && (string = ((ITextSelection)iSelection).getText()) != null && (string = string.trim()).length() > 0 && JavaConventions.validateJavaTypeName((String)string, (String)"1.3", (String)"1.3").isOK()) {
            this.fInitialFilter = string;
            this.fSelectionMode = 2;
        }
        return super.open();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean close() {
        try {
            if (this.getReturnCode() == 0) {
                OpenTypeHistory.getInstance().save();
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            boolean bl = super.close();
            throw throwable;
        }
        {
            Object var2_3 = null;
        }
        return super.close();
    }

    public void setTitle(String string) {
        super.setTitle(string);
        this.fTitle = string;
    }

    protected void computeResult() {
        TypeNameMatch[] typeNameMatchArray = this.fContent.getSelection();
        if (typeNameMatchArray == null || typeNameMatchArray.length == 0) {
            this.setResult(null);
            return;
        }
        if (this.fScope == null) {
            this.fScope = this.fContent.getScope();
        }
        OpenTypeHistory openTypeHistory = OpenTypeHistory.getInstance();
        ArrayList<IType> arrayList = new ArrayList<IType>(typeNameMatchArray.length);
        int n = 0;
        while (n < typeNameMatchArray.length) {
            TypeNameMatch typeNameMatch = typeNameMatchArray[n];
            IType iType = typeNameMatch.getType();
            if (!iType.exists()) {
                String string = JavaUIMessages.TypeSelectionDialog_errorTitle;
                IPackageFragmentRoot iPackageFragmentRoot = typeNameMatch.getPackageFragmentRoot();
                String string2 = JavaElementLabels.getElementLabel((IJavaElement)iPackageFragmentRoot, 0x20000000000L);
                String string3 = Messages.format(JavaUIMessages.TypeSelectionDialog_dialogMessage, new String[]{typeNameMatch.getFullyQualifiedName(), string2});
                MessageDialog.openError((Shell)this.getShell(), (String)string, (String)string3);
                openTypeHistory.remove(typeNameMatch);
                this.setResult(null);
            } else {
                openTypeHistory.accessed(typeNameMatch);
                arrayList.add(iType);
            }
            ++n;
        }
        this.setResult(arrayList);
    }

    private void ensureConsistency() throws InvocationTargetException, InterruptedException {
        class ConsistencyRunnable
        implements IRunnableWithProgress {
            final /* synthetic */ TypeSelectionDialog2 this$0;

            ConsistencyRunnable(TypeSelectionDialog2 typeSelectionDialog2) {
                this.this$0 = typeSelectionDialog2;
            }

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                Object object;
                if (TypeSelectionDialog2.access$2()) {
                    object = Job.getJobManager();
                    object.join((Object)"org.eclipse.wst.jsdt.ui", iProgressMonitor);
                }
                object = OpenTypeHistory.getInstance();
                if (TypeSelectionDialog2.access$2() || ((History)object).isEmpty()) {
                    iProgressMonitor.beginTask(JavaUIMessages.TypeSelectionDialog_progress_consistency, 100);
                    if (((OpenTypeHistory)object).needConsistencyCheck()) {
                        this.refreshSearchIndices((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 90));
                        ((OpenTypeHistory)object).checkConsistency((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 10));
                    } else {
                        this.refreshSearchIndices(iProgressMonitor);
                    }
                    iProgressMonitor.done();
                    TypeSelectionDialog2.access$3(false);
                } else {
                    ((OpenTypeHistory)object).checkConsistency(iProgressMonitor);
                }
            }

            public boolean needsExecution() {
                OpenTypeHistory openTypeHistory = OpenTypeHistory.getInstance();
                return TypeSelectionDialog2.access$2() || openTypeHistory.isEmpty() || openTypeHistory.needConsistencyCheck();
            }

            private void refreshSearchIndices(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    new SearchEngine().searchAllTypeNames(null, 0, "_______________".toCharArray(), 8, 7, SearchEngine.createWorkspaceScope(), new TypeNameRequestor(this){
                        final /* synthetic */ ConsistencyRunnable this$1;
                        {
                            this.this$1 = consistencyRunnable;
                        }
                    }, 3, iProgressMonitor);
                }
                catch (JavaModelException javaModelException) {
                    throw new InvocationTargetException(javaModelException);
                }
            }
        }
        ConsistencyRunnable consistencyRunnable = new ConsistencyRunnable(this);
        if (!consistencyRunnable.needsExecution()) {
            return;
        }
        IRunnableContext iRunnableContext = this.fRunnableContext != null ? this.fRunnableContext : PlatformUI.getWorkbench().getProgressService();
        iRunnableContext.run(true, true, (IRunnableWithProgress)consistencyRunnable);
    }

    static /* synthetic */ boolean access$2() {
        return fgFirstTime;
    }

    static /* synthetic */ void access$3(boolean bl) {
        fgFirstTime = bl;
    }

    private class TitleLabel
    implements TypeSelectionComponent.ITitleLabel {
        private TitleLabel() {
        }

        public void setText(String string) {
            if (string == null || string.length() == 0) {
                TypeSelectionDialog2.this.getShell().setText(TypeSelectionDialog2.this.fTitle);
            } else {
                TypeSelectionDialog2.this.getShell().setText(Messages.format(JavaUIMessages.TypeSelectionDialog2_title_format, new String[]{TypeSelectionDialog2.this.fTitle, string}));
            }
        }
    }
}

