/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.VariableDeclarationFix;
import org.eclipse.wst.jsdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.wst.jsdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class VariableDeclarationCleanUp
extends AbstractCleanUp {
    public VariableDeclarationCleanUp(Map map) {
        super(map);
    }

    public VariableDeclarationCleanUp() {
    }

    public boolean requireAST(ICompilationUnit iCompilationUnit) throws CoreException {
        boolean bl = this.isEnabled("cleanup.make_variable_declarations_final");
        if (!bl) {
            return false;
        }
        return this.isEnabled("cleanup.make_private_fields_final") || this.isEnabled("cleanup.make_parameters_final") || this.isEnabled("cleanup.make_local_variable_final");
    }

    public IFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        boolean bl = this.isEnabled("cleanup.make_variable_declarations_final");
        if (!bl) {
            return null;
        }
        return VariableDeclarationFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.make_private_fields_final"), this.isEnabled("cleanup.make_parameters_final"), this.isEnabled("cleanup.make_local_variable_final"));
    }

    public IFix createFix(CompilationUnit compilationUnit, IProblemLocation[] iProblemLocationArray) throws CoreException {
        return null;
    }

    public Map getRequiredOptions() {
        return null;
    }

    public String[] getDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_private_fields_final")) {
            arrayList.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalField_description);
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_parameters_final")) {
            arrayList.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalParameters_description);
        }
        if (this.isEnabled("cleanup.make_variable_declarations_final") && this.isEnabled("cleanup.make_local_variable_final")) {
            arrayList.add(MultiFixMessages.VariableDeclarationCleanUp_AddFinalLocals_description);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getPreview() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    public boolean canFix(CompilationUnit compilationUnit, IProblemLocation iProblemLocation) throws CoreException {
        return false;
    }

    public int maximalNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }
}

