/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.infoviews;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.infoviews.CopyToClipboardAction;
import org.eclipse.wst.jsdt.internal.ui.infoviews.GotoInputAction;
import org.eclipse.wst.jsdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public abstract class AbstractInfoView
extends ViewPart
implements ISelectionListener,
IMenuListener,
IPropertyChangeListener {
    private final long TITLE_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 4L | 0x200000L | 0x1000000000000L;
    private final long LOCAL_VARIABLE_TITLE_FLAGS = this.TITLE_FLAGS & 0xFFFFFFFFFFFEFFFFL | 0x20000L;
    private static final long TOOLTIP_LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference.getId().equals(AbstractInfoView.this.getSite().getId())) {
                IWorkbenchPart iWorkbenchPart = iWorkbenchPartReference.getPage().getActivePart();
                if (iWorkbenchPart != null) {
                    AbstractInfoView.this.selectionChanged(iWorkbenchPart, iWorkbenchPartReference.getPage().getSelection());
                }
                AbstractInfoView.this.startListeningForSelectionChanges();
            }
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.stopListeningForSelectionChanges();
            }
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            if (!iWorkbenchPartReference.getId().equals(AbstractInfoView.this.getSite().getId())) {
                AbstractInfoView.this.computeAndSetInput(iWorkbenchPartReference.getPart(false));
            }
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }
    };
    protected IJavaElement fCurrentViewInput;
    private SelectionDispatchAction fCopyToClipboardAction;
    private GotoInputAction fGotoInputAction;
    private volatile int fComputeCount;
    private Color fBackgroundColor;
    private RGB fBackgroundColorRGB;
    static /* synthetic */ Class class$0;

    protected abstract void setInput(Object var1);

    protected abstract Object computeInput(Object var1);

    protected abstract void internalCreatePartControl(Composite var1);

    protected abstract void setForeground(Color var1);

    protected abstract void setBackground(Color var1);

    abstract Control getControl();

    protected abstract String getHelpContextId();

    public final void createPartControl(Composite composite) {
        this.internalCreatePartControl(composite);
        this.inititalizeColors();
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.fPartListener);
        this.createContextMenu();
        this.createActions();
        this.fillActionBars(this.getViewSite().getActionBars());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
    }

    protected void createActions() {
        this.fGotoInputAction = new GotoInputAction(this);
        this.fGotoInputAction.setEnabled(false);
        this.fCopyToClipboardAction = new CopyToClipboardAction((IWorkbenchSite)this.getViewSite());
        ISelectionProvider iSelectionProvider = this.getSelectionProvider();
        if (iSelectionProvider != null) {
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
    }

    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        Menu menu = menuManager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuManager, this.getSelectionProvider());
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("group.open"));
        iMenuManager.add((IContributionItem)new Separator("group.edit"));
        iMenuManager.add((IContributionItem)new Separator("additions"));
        IAction iAction = this.getCopyToClipboardAction();
        if (iAction != null) {
            iMenuManager.appendToGroup("group.edit", iAction);
        }
        if ((iAction = this.getSelectAllAction()) != null) {
            iMenuManager.appendToGroup("group.edit", iAction);
        }
        iMenuManager.appendToGroup("group.open", (IAction)this.fGotoInputAction);
    }

    protected IAction getSelectAllAction() {
        return null;
    }

    protected IAction getCopyToClipboardAction() {
        return this.fCopyToClipboardAction;
    }

    protected IJavaElement getInput() {
        return this.fCurrentViewInput;
    }

    ISelectionProvider getSelectionProvider() {
        return this.getViewSite().getSelectionProvider();
    }

    protected void fillActionBars(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        this.fillToolBar(iToolBarManager);
        IAction iAction = this.getCopyToClipboardAction();
        if (iAction != null) {
            iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), iAction);
        }
        if ((iAction = this.getSelectAllAction()) != null) {
            iActionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), iAction);
        }
    }

    protected void fillToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.fGotoInputAction);
    }

    private void inititalizeColors() {
        Color color;
        if (this.getSite().getShell().isDisposed()) {
            return;
        }
        Display display = this.getSite().getShell().getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        this.setForeground(display.getSystemColor(28));
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        colorRegistry.addListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = colorRegistry.getRGB(this.getBackgroundColorKey());
        if (this.fBackgroundColorRGB == null) {
            color = display.getSystemColor(29);
            this.fBackgroundColorRGB = color.getRGB();
        } else {
            this.fBackgroundColor = color = new Color((Device)display, this.fBackgroundColorRGB);
        }
        this.setBackground(color);
    }

    protected abstract String getBackgroundColorKey();

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.getBackgroundColorKey().equals(propertyChangeEvent.getProperty())) {
            this.inititalizeColors();
        }
    }

    protected void startListeningForSelectionChanges() {
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    protected void stopListeningForSelectionChanges() {
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        if (iWorkbenchPart.equals((Object)this)) {
            return;
        }
        this.computeAndSetInput(iWorkbenchPart);
    }

    protected boolean isIgnoringNewInput(IJavaElement iJavaElement, IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        return this.fCurrentViewInput != null && this.fCurrentViewInput.equals(iJavaElement) && iJavaElement != null;
    }

    protected IJavaElement findSelectedJavaElement(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        Object object;
        block6: {
            block5: {
                try {
                    if (!(iWorkbenchPart instanceof JavaEditor) || !(iSelection instanceof ITextSelection)) break block5;
                    IJavaElement[] iJavaElementArray = TextSelectionConverter.codeResolve((JavaEditor)iWorkbenchPart, (ITextSelection)iSelection);
                    if (iJavaElementArray != null && iJavaElementArray.length > 0) {
                        return iJavaElementArray[0];
                    }
                    return null;
                }
                catch (JavaModelException javaModelException) {
                    return null;
                }
            }
            if (iSelection instanceof IStructuredSelection) {
                object = SelectionUtil.getSingleElement(iSelection);
                break block6;
            }
            return null;
        }
        return this.findJavaElement(object);
    }

    private IJavaElement findJavaElement(Object object) {
        if (object == null) {
            return null;
        }
        IJavaElement iJavaElement = null;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz);
        }
        return iJavaElement;
    }

    protected IType getTypeForCU(ICompilationUnit iCompilationUnit) {
        if (iCompilationUnit == null || !iCompilationUnit.exists()) {
            return null;
        }
        IType iType = iCompilationUnit.findPrimaryType();
        if (iType != null) {
            return iType;
        }
        try {
            IType[] iTypeArray = iCompilationUnit.getTypes();
            if (iTypeArray.length > 0) {
                return iTypeArray[0];
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    public final void dispose() {
        ++this.fComputeCount;
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.fPartListener);
        ISelectionProvider iSelectionProvider = this.getSelectionProvider();
        if (iSelectionProvider != null) {
            iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fCopyToClipboardAction);
        }
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        this.fBackgroundColorRGB = null;
        if (this.fBackgroundColor != null) {
            this.fBackgroundColor.dispose();
            this.fBackgroundColor = null;
        }
        this.internalDispose();
    }

    protected abstract void internalDispose();

    private void computeAndSetInput(final IWorkbenchPart iWorkbenchPart) {
        final int n = ++this.fComputeCount;
        ISelectionProvider iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider();
        if (iSelectionProvider == null) {
            return;
        }
        final ISelection iSelection = iSelectionProvider.getSelection();
        if (iSelection == null || iSelection.isEmpty()) {
            return;
        }
        Thread thread = new Thread("Info view input computer"){

            public void run() {
                if (n != AbstractInfoView.this.fComputeCount) {
                    return;
                }
                IJavaElement iJavaElement = AbstractInfoView.this.findSelectedJavaElement(iWorkbenchPart, iSelection);
                if (AbstractInfoView.this.isIgnoringNewInput(iJavaElement, iWorkbenchPart, iSelection)) {
                    return;
                }
                Object object = AbstractInfoView.this.computeInput(iJavaElement);
                if (object == null) {
                    return;
                }
                Shell shell = AbstractInfoView.this.getSite().getShell();
                if (shell.isDisposed()) {
                    return;
                }
                Display display = shell.getDisplay();
                if (display.isDisposed()) {
                    return;
                }
                display.asyncExec(new Runnable(this, n, iJavaElement, object){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ int val$currentCount;
                    private final /* synthetic */ IJavaElement val$je;
                    private final /* synthetic */ Object val$input;
                    {
                        this.this$1 = var1_1;
                        this.val$currentCount = n;
                        this.val$je = iJavaElement;
                        this.val$input = object;
                    }

                    public void run() {
                        if (AbstractInfoView.access$1(2.access$0(this.this$1)) != this.val$currentCount || 2.access$0(this.this$1).getViewSite().getShell().isDisposed()) {
                            return;
                        }
                        2.access$0(this.this$1).fCurrentViewInput = this.val$je;
                        AbstractInfoView.access$2(2.access$0(this.this$1), this.val$input);
                    }
                });
            }

            static /* synthetic */ AbstractInfoView access$0(2 var0) {
                return var0.AbstractInfoView.this;
            }
        };
        thread.setDaemon(true);
        thread.setPriority(1);
        thread.start();
    }

    private void doSetInput(Object object) {
        this.setInput(object);
        this.fGotoInputAction.setEnabled(true);
        IJavaElement iJavaElement = this.getInput();
        long l = iJavaElement instanceof ILocalVariable ? this.LOCAL_VARIABLE_TITLE_FLAGS : this.TITLE_FLAGS;
        this.setContentDescription(JavaElementLabels.getElementLabel(iJavaElement, l));
        this.setTitleToolTip(JavaElementLabels.getElementLabel(iJavaElement, TOOLTIP_LABEL_FLAGS));
    }

    static /* synthetic */ void access$2(AbstractInfoView abstractInfoView, Object object) {
        abstractInfoView.doSetInput(object);
    }
}

