/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.infoviews;

import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.wst.jsdt.core.ICodeAssist;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.infoviews.AbstractInfoView;
import org.eclipse.wst.jsdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.text.JavaCodeReader;
import org.eclipse.wst.jsdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.actions.OpenAction;
import org.eclipse.wst.jsdt.ui.text.JavaSourceViewerConfiguration;

public class SourceView
extends AbstractInfoView
implements IMenuListener {
    private static final String SYMBOLIC_FONT_NAME = "org.eclipse.wst.jsdt.ui.editors.textfont";
    private SourceViewer fViewer;
    private JavaSourceViewerConfiguration fViewerConfiguration;
    private IPropertyChangeListener fFontPropertyChangeListener = new FontPropertyChangeListener();
    private IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private OpenAction fOpen;
    private int fCommentLineCount;
    private SelectAllAction fSelectAllAction;
    private IJavaElement fLastOpenedElement;

    protected void internalCreatePartControl(Composite composite) {
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getCombinedPreferenceStore();
        this.fViewer = new JavaSourceViewer(composite, null, null, false, 768, iPreferenceStore);
        this.fViewerConfiguration = new SimpleJavaSourceViewerConfiguration(JavaPlugin.getDefault().getJavaTextTools().getColorManager(), iPreferenceStore, null, "___java_partitioning", false);
        this.fViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fViewer.setEditable(false);
        this.setViewerFont();
        JFaceResources.getFontRegistry().addListener(this.fFontPropertyChangeListener);
        iPreferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction((TextViewer)this.fViewer);
        this.fOpen = new OpenAction((IWorkbenchSite)this.getViewSite()){

            public ISelection getSelection() {
                return SourceView.this.convertToJavaElementSelection(SourceView.this.fViewer.getSelection());
            }

            public void run(IStructuredSelection iStructuredSelection) {
                if (iStructuredSelection.isEmpty()) {
                    this.getShell().getDisplay().beep();
                    return;
                }
                super.run(iStructuredSelection);
            }

            public Object getElementToOpen(Object object) throws JavaModelException {
                if (object instanceof IJavaElement) {
                    SourceView.this.fLastOpenedElement = (IJavaElement)object;
                } else {
                    SourceView.this.fLastOpenedElement = null;
                }
                return super.getElementToOpen(object);
            }

            public void run(Object[] objectArray) {
                SourceView.this.stopListeningForSelectionChanges();
                super.run(objectArray);
                SourceView.this.startListeningForSelectionChanges();
            }
        };
    }

    protected IAction getSelectAllAction() {
        return this.fSelectAllAction;
    }

    protected void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.setGlobalActionHandler("org.eclipse.wst.jsdt.ui.actions.Open", (IAction)this.fOpen);
        this.fOpen.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.open.editor");
    }

    protected Control getControl() {
        return this.fViewer.getControl();
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        super.menuAboutToShow(iMenuManager);
        iMenuManager.appendToGroup("group.open", (IAction)this.fOpen);
    }

    protected void setForeground(Color color) {
        this.fViewer.getTextWidget().setForeground(color);
    }

    protected void setBackground(Color color) {
        this.fViewer.getTextWidget().setBackground(color);
    }

    protected String getBackgroundColorKey() {
        return "org.eclipse.wst.jsdt.ui.DeclarationView.backgroundColor";
    }

    private IStructuredSelection convertToJavaElementSelection(ISelection iSelection) {
        if (!(iSelection instanceof ITextSelection) || !(this.fCurrentViewInput instanceof ISourceReference)) {
            return StructuredSelection.EMPTY;
        }
        ITextSelection iTextSelection = (ITextSelection)iSelection;
        IJavaElement iJavaElement = this.fCurrentViewInput.getAncestor(5);
        if (iJavaElement == null) {
            iJavaElement = this.fCurrentViewInput.getAncestor(6);
        }
        if (iJavaElement instanceof ICodeAssist) {
            IJavaElement[] iJavaElementArray = null;
            try {
                ISourceRange iSourceRange = ((ISourceReference)this.fCurrentViewInput).getSourceRange();
                iJavaElementArray = ((ICodeAssist)iJavaElement).codeSelect(iSourceRange.getOffset() + this.getOffsetInUnclippedDocument(iTextSelection), iTextSelection.getLength());
            }
            catch (JavaModelException javaModelException) {
                return StructuredSelection.EMPTY;
            }
            if (iJavaElementArray != null && iJavaElementArray.length > 0) {
                return new StructuredSelection((Object)iJavaElementArray[0]);
            }
            return StructuredSelection.EMPTY;
        }
        return StructuredSelection.EMPTY;
    }

    private int getOffsetInUnclippedDocument(ITextSelection iTextSelection) {
        Document document = null;
        try {
            document = new Document(((ISourceReference)this.fCurrentViewInput).getSource());
        }
        catch (JavaModelException javaModelException) {
            return -1;
        }
        IDocument iDocument = (IDocument)this.fViewer.getInput();
        try {
            IRegion iRegion = document.getLineInformation(this.fCommentLineCount + iTextSelection.getStartLine());
            IRegion iRegion2 = iDocument.getLineInformation(iTextSelection.getStartLine());
            int n = iRegion.getLength() - iRegion2.getLength();
            int n2 = iTextSelection.getOffset() - iRegion2.getOffset();
            return iRegion.getOffset() + n + n2;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    protected void internalDispose() {
        this.fViewer = null;
        this.fViewerConfiguration = null;
        JFaceResources.getFontRegistry().removeListener(this.fFontPropertyChangeListener);
        JavaPlugin.getDefault().getCombinedPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
    }

    public void setFocus() {
        this.fViewer.getTextWidget().setFocus();
    }

    protected Object computeInput(Object object) {
        boolean bl;
        String string;
        if (this.fViewer == null || !(object instanceof ISourceReference)) {
            return null;
        }
        ISourceReference iSourceReference = (ISourceReference)object;
        if (this.fLastOpenedElement != null && object instanceof IJavaElement && ((IJavaElement)object).getHandleIdentifier().equals(this.fLastOpenedElement.getHandleIdentifier())) {
            this.fLastOpenedElement = null;
            return null;
        }
        this.fLastOpenedElement = null;
        try {
            string = iSourceReference.getSource();
        }
        catch (JavaModelException javaModelException) {
            return "";
        }
        if (string == null) {
            return "";
        }
        string = this.removeLeadingComments(string);
        String string2 = StubUtility.getLineDelimiterUsed((IJavaElement)object);
        String[] stringArray = Strings.convertIntoLines(string);
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        String string3 = stringArray[0];
        boolean bl2 = bl = string3 != null && string3.length() > 0 && !Character.isWhitespace(string3.charAt(0));
        if (bl) {
            stringArray[0] = "";
        }
        IJavaProject iJavaProject = object instanceof IJavaElement ? ((IJavaElement)object).getJavaProject() : null;
        Strings.trimIndentation(stringArray, iJavaProject);
        if (bl) {
            stringArray[0] = string3;
        }
        return Strings.concatenate(stringArray, string2);
    }

    protected void setInput(Object object) {
        if (object instanceof IDocument) {
            this.fViewer.setInput(object);
        } else if (object == null) {
            this.fViewer.setInput((Object)new Document(""));
        } else {
            Document document = new Document(object.toString());
            JavaPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
            this.fViewer.setInput((Object)document);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String removeLeadingComments(String var1_1) {
        var2_2 = new JavaCodeReader();
        var3_3 = new Document(var1_1);
        try {
            try {
                var2_2.configureForwardReader((IDocument)var3_3, 0, var3_3.getLength(), true, false);
                var5_4 = var2_2.read();
                while (true) {
                    if (var5_4 == -1 || var5_4 != 13 && var5_4 != 10 && var5_4 != 9) {
                        var4_5 = var2_2.getOffset();
                        var2_2.close();
                    }
                    var5_4 = var2_2.read();
                }
            }
            catch (IOException v0) {
                var4_5 = 0;
            }
        }
        catch (Throwable var7_6) {
            var6_7 = null;
            try {
                if (var2_2 == null) throw var7_6;
                var2_2.close();
                throw var7_6;
            }
            catch (IOException var8_9) {
                JavaPlugin.log(var8_9);
            }
            throw var7_6;
        }
        {
            var6_8 = null;
        }
        ** try [egrp 2[TRYBLOCK] [3 : 103->114)] { 
lbl29:
        // 1 sources

        if (var2_2 != null) {
            var2_2.close();
        }
        ** GOTO lbl-1000
lbl32:
        // 1 sources

        catch (IOException var8_10) {
            JavaPlugin.log(var8_10);
        }
lbl-1000:
        // 2 sources

        {
            this.fCommentLineCount = var3_3.getLineOfOffset(var4_5);
        }
        if (var4_5 >= 0) return var1_1.substring(var4_5);
        return var1_1;
    }

    private void setViewerFont() {
        Font font = JFaceResources.getFont((String)SYMBOLIC_FONT_NAME);
        if (this.fViewer.getDocument() != null) {
            Point point = this.fViewer.getSelectedRange();
            int n = this.fViewer.getTopIndex();
            StyledText styledText = this.fViewer.getTextWidget();
            Control control = this.fViewer.getControl();
            control.setRedraw(false);
            styledText.setFont(font);
            this.fViewer.setSelectedRange(point.x, point.y);
            this.fViewer.setTopIndex(n);
            if (control instanceof Composite) {
                Composite composite = (Composite)control;
                composite.layout(true);
            }
            control.setRedraw(true);
        } else {
            StyledText styledText = this.fViewer.getTextWidget();
            styledText.setFont(font);
        }
    }

    protected String getHelpContextId() {
        return "org.eclipse.wst.jsdt.ui.source_view_context";
    }

    class FontPropertyChangeListener
    implements IPropertyChangeListener {
        FontPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SourceView.this.fViewer == null) {
                return;
            }
            String string = propertyChangeEvent.getProperty();
            if (SourceView.SYMBOLIC_FONT_NAME.equals(string)) {
                SourceView.this.setViewerFont();
            }
        }
    }

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (SourceView.this.fViewer == null) {
                return;
            }
            if (SourceView.this.fViewerConfiguration.affectsTextPresentation(propertyChangeEvent)) {
                SourceView.this.fViewerConfiguration.handlePropertyChangeEvent(propertyChangeEvent);
                SourceView.this.fViewer.invalidateTextPresentation();
            }
        }
    }

    private static class SelectAllAction
    extends Action {
        private TextViewer fTextViewer;

        public SelectAllAction(TextViewer textViewer) {
            super("selectAll");
            Assert.isNotNull((Object)textViewer);
            this.fTextViewer = textViewer;
            this.setText(InfoViewMessages.SelectAllAction_label);
            this.setToolTipText(InfoViewMessages.SelectAllAction_tooltip);
            this.setDescription(InfoViewMessages.SelectAllAction_description);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        }

        public void run() {
            this.fTextViewer.doOperation(7);
        }
    }
}

