/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackageActionDelegate;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.jarpackager.IJarExportRunnable;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;

public class CreateJarActionDelegate
extends JarPackageActionDelegate {
    public void run(IAction iAction) {
        MultiStatus multiStatus;
        IFile[] iFileArray = this.getDescriptionFiles(this.getSelection());
        int n = iFileArray.length;
        if (n < 1) {
            return;
        }
        String string = n > 1 ? JarPackagerMessages.JarFileExportOperation_creationOfSomeJARsFailed : JarPackagerMessages.JarFileExportOperation_jarCreationFailed;
        MultiStatus multiStatus2 = new MultiStatus(JavaPlugin.getPluginId(), 0, string, null);
        JarPackageData[] jarPackageDataArray = this.readJarPackages(iFileArray, multiStatus2);
        if (jarPackageDataArray.length > 0) {
            IStatus iStatus = this.export(jarPackageDataArray);
            if (iStatus == null) {
                return;
            }
            string = multiStatus2.getSeverity() == 4 ? multiStatus2.getMessage() : iStatus.getMessage();
            multiStatus = new MultiStatus(JavaPlugin.getPluginId(), iStatus.getCode(), multiStatus2.getChildren(), string, null);
            multiStatus.merge(iStatus);
        } else {
            multiStatus = multiStatus2;
        }
        if (!multiStatus.isOK()) {
            ErrorDialog.openError((Shell)this.getShell(), (String)JarPackagerMessages.CreateJarActionDelegate_jarExport_title, null, (IStatus)multiStatus);
        }
    }

    private JarPackageData[] readJarPackages(IFile[] iFileArray, MultiStatus multiStatus) {
        ArrayList<JarPackageData> arrayList = new ArrayList<JarPackageData>(iFileArray.length);
        int n = 0;
        while (n < iFileArray.length) {
            JarPackageData jarPackageData = this.readJarPackage(iFileArray[n], multiStatus);
            if (jarPackageData != null) {
                arrayList.add(jarPackageData);
            }
            ++n;
        }
        return arrayList.toArray(new JarPackageData[arrayList.size()]);
    }

    private IStatus export(JarPackageData[] jarPackageDataArray) {
        Shell shell = this.getShell();
        IJarExportRunnable iJarExportRunnable = jarPackageDataArray[0].createJarExportRunnable(jarPackageDataArray, shell);
        try {
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().run(false, true, (IRunnableWithProgress)iJarExportRunnable);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() != null) {
                ExceptionHandler.handle(invocationTargetException, shell, JarPackagerMessages.CreateJarActionDelegate_jarExportError_title, JarPackagerMessages.CreateJarActionDelegate_jarExportError_message);
                return null;
            }
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return iJarExportRunnable.getStatus();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JarPackageData readJarPackage(IFile var1_1, MultiStatus var2_2) {
        block11: {
            Assert.isLegal((boolean)var1_1.isAccessible());
            Assert.isNotNull((Object)var1_1.getFileExtension());
            Assert.isLegal((boolean)var1_1.getFileExtension().equals("jardesc"));
            var3_3 = new JarPackageData();
            var4_4 = null;
            try {
                try {
                    var4_4 = var3_3.createJarDescriptionReader(var1_1.getContents());
                    var4_4.read(var3_3);
                    var3_3.setSaveManifest(false);
                    var3_3.setSaveDescription(false);
                }
                catch (CoreException var5_5) {
                    var6_6 = Messages.format(JarPackagerMessages.JarFileExportOperation_errorReadingFile, new Object[]{var1_1.getFullPath(), var5_5.getStatus().getMessage()});
                    this.addToStatus(var2_2, var3_3, var6_6, var5_5);
                    var7_7 = null;
                    if (var4_4 != null) {
                        var2_2.addAll(var4_4.getStatus());
                    }
                    try {
                        if (var4_4 == null) return null;
                        var4_4.close();
                        return null;
                    }
                    catch (CoreException var9_10) {
                        var10_13 = Messages.format(JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, var1_1.getFullPath());
                        this.addToStatus(var2_2, var3_3, var10_13, var9_10);
                    }
                    return null;
                }
            }
            catch (Throwable var8_16) {
                var7_8 = null;
                if (var4_4 != null) {
                    var2_2.addAll(var4_4.getStatus());
                }
                ** try [egrp 2[TRYBLOCK] [3 : 155->170)] { 
lbl36:
                // 1 sources

                if (var4_4 == null) throw var8_16;
                var4_4.close();
                throw var8_16;
lbl39:
                // 1 sources

                catch (CoreException var9_11) {
                    var10_14 = Messages.format(JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, var1_1.getFullPath());
                    this.addToStatus(var2_2, var3_3, var10_14, var9_11);
                }
                throw var8_16;
            }
            {
                var7_9 = null;
                if (var4_4 == null) break block11;
            }
            var2_2.addAll(var4_4.getStatus());
        }
        try {}
        catch (CoreException var9_12) {
            var10_15 = Messages.format(JarPackagerMessages.JarFileExportOperation_errorClosingJarPackageDescriptionReader, var1_1.getFullPath());
            this.addToStatus(var2_2, var3_3, var10_15, var9_12);
            return var3_3;
        }
        if (var4_4 == null) return var3_3;
        var4_4.close();
        return var3_3;
    }

    protected void addToStatus(MultiStatus multiStatus, JarPackageData jarPackageData, String string, CoreException coreException) {
        IStatus iStatus = coreException.getStatus();
        String string2 = coreException.getLocalizedMessage();
        if (string2 == null || string2.length() < 1) {
            iStatus = new Status(iStatus.getSeverity(), iStatus.getPlugin(), iStatus.getCode(), string, (Throwable)coreException);
        }
        multiStatus.add(iStatus);
    }
}

