/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.jarpackager;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.IRefactoringHistoryService;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.jarpackager.JarPackagerMessages;
import org.eclipse.wst.jsdt.ui.jarpackager.IJarDescriptionWriter;
import org.eclipse.wst.jsdt.ui.jarpackager.JarPackageData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JarPackageWriter
implements IJarDescriptionWriter {
    private final OutputStream fOutputStream;
    private final String fEncoding;

    public JarPackageWriter(OutputStream outputStream, String string) {
        Assert.isNotNull((Object)outputStream);
        this.fOutputStream = new BufferedOutputStream(outputStream);
        this.fEncoding = string;
    }

    public void write(JarPackageData jarPackageData) throws CoreException {
        try {
            this.writeXML(jarPackageData);
        }
        catch (IOException iOException) {
            String string = iOException.getLocalizedMessage() != null ? iOException.getLocalizedMessage() : "";
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, string, (Throwable)iOException));
        }
    }

    public void writeXML(JarPackageData jarPackageData) throws IOException {
        Assert.isNotNull((Object)jarPackageData);
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IOException(JarPackagerMessages.JarWriter_error_couldNotGetXmlBuilder);
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("jardesc");
        document.appendChild(element);
        this.xmlWriteJarLocation(jarPackageData, document, element);
        this.xmlWriteOptions(jarPackageData, document, element);
        this.xmlWriteRefactoring(jarPackageData, document, element);
        this.xmlWriteSelectedProjects(jarPackageData, document, element);
        if (jarPackageData.areGeneratedFilesExported()) {
            this.xmlWriteManifest(jarPackageData, document, element);
        }
        this.xmlWriteSelectedElements(jarPackageData, document, element);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", this.fEncoding);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(this.fOutputStream);
            transformer.transform(dOMSource, streamResult);
        }
        catch (TransformerException transformerException) {
            throw new IOException(JarPackagerMessages.JarWriter_error_couldNotTransformToXML);
        }
    }

    private void xmlWriteJarLocation(JarPackageData jarPackageData, Document document, Element element) throws DOMException {
        Element element2 = document.createElement("jar");
        element.appendChild(element2);
        element2.setAttribute("path", jarPackageData.getJarLocation().toPortableString());
    }

    private void xmlWriteOptions(JarPackageData jarPackageData, Document document, Element element) throws DOMException {
        Element element2 = document.createElement("options");
        element.appendChild(element2);
        element2.setAttribute("overwrite", "" + jarPackageData.allowOverwrite());
        element2.setAttribute("compress", "" + jarPackageData.isCompressed());
        element2.setAttribute("exportErrors", "" + jarPackageData.areErrorsExported());
        element2.setAttribute("exportWarnings", "" + jarPackageData.exportWarnings());
        element2.setAttribute("saveDescription", "" + jarPackageData.isDescriptionSaved());
        element2.setAttribute("descriptionLocation", jarPackageData.getDescriptionLocation().toPortableString());
        element2.setAttribute("useSourceFolders", "" + jarPackageData.useSourceFolderHierarchy());
        element2.setAttribute("buildIfNeeded", "" + jarPackageData.isBuildingIfNeeded());
        element2.setAttribute("includeDirectoryEntries", "" + jarPackageData.areDirectoryEntriesIncluded());
        element2.setAttribute("storeRefactorings", "" + jarPackageData.isRefactoringAware());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void xmlWriteRefactoring(JarPackageData jarPackageData, Document document, Element element) throws DOMException {
        RefactoringDescriptorProxy[] refactoringDescriptorProxyArray;
        Element element2 = document.createElement("storedRefactorings");
        element.appendChild(element2);
        element2.setAttribute("structuralOnly", "" + jarPackageData.isExportStructuralOnly());
        element2.setAttribute("deprecationInfo", "" + jarPackageData.isDeprecationAware());
        IProject[] iProjectArray = jarPackageData.getRefactoringProjects();
        if (iProjectArray != null && iProjectArray.length > 0) {
            int n = 0;
            while (n < iProjectArray.length) {
                element2.setAttribute("project" + (n + 1), iProjectArray[n].getName());
                ++n;
            }
        }
        if ((refactoringDescriptorProxyArray = jarPackageData.getRefactoringDescriptors()) == null) return;
        if (refactoringDescriptorProxyArray.length <= 0) return;
        int n = 1;
        IRefactoringHistoryService iRefactoringHistoryService = RefactoringCore.getHistoryService();
        try {
            iRefactoringHistoryService.connect();
            int n2 = 0;
            while (n2 < refactoringDescriptorProxyArray.length) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    iRefactoringHistoryService.writeRefactoringDescriptors(new RefactoringDescriptorProxy[]{refactoringDescriptorProxyArray[n2]}, (OutputStream)byteArrayOutputStream, 0, true, null);
                    element2.setAttribute("refactoring" + n, byteArrayOutputStream.toString("UTF-8"));
                }
                catch (CoreException coreException) {
                    JavaPlugin.log(coreException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Assert.isTrue((boolean)false);
                }
                ++n2;
                ++n;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            iRefactoringHistoryService.disconnect();
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        iRefactoringHistoryService.disconnect();
    }

    private void xmlWriteManifest(JarPackageData jarPackageData, Document document, Element element) throws DOMException {
        Element element2 = document.createElement("manifest");
        element.appendChild(element2);
        element2.setAttribute("manifestVersion", jarPackageData.getManifestVersion());
        element2.setAttribute("usesManifest", "" + jarPackageData.usesManifest());
        element2.setAttribute("reuseManifest", "" + jarPackageData.isManifestReused());
        element2.setAttribute("saveManifest", "" + jarPackageData.isManifestSaved());
        element2.setAttribute("generateManifest", "" + jarPackageData.isManifestGenerated());
        element2.setAttribute("manifestLocation", jarPackageData.getManifestLocation().toPortableString());
        if (jarPackageData.getManifestMainClass() != null) {
            element2.setAttribute("mainClassHandleIdentifier", jarPackageData.getManifestMainClass().getHandleIdentifier());
        }
        this.xmlWriteSealingInfo(jarPackageData, document, element2);
    }

    private void xmlWriteSealingInfo(JarPackageData jarPackageData, Document document, Element element) throws DOMException {
        Element element2 = document.createElement("sealing");
        element.appendChild(element2);
        element2.setAttribute("sealJar", "" + jarPackageData.isJarSealed());
        Element element3 = document.createElement("packagesToSeal");
        element2.appendChild(element3);
        this.add(jarPackageData.getPackagesToSeal(), element3, document);
        Element element4 = document.createElement("packagesToUnSeal");
        element2.appendChild(element4);
        this.add(jarPackageData.getPackagesToUnseal(), element4, document);
    }

    private void xmlWriteSelectedElements(JarPackageData jarPackageData, Document document, Element element) throws DOMException {
        Element element2 = document.createElement("selectedElements");
        element.appendChild(element2);
        element2.setAttribute("exportClassFiles", "" + jarPackageData.areClassFilesExported());
        element2.setAttribute("exportOutputFolder", "" + jarPackageData.areOutputFoldersExported());
        element2.setAttribute("exportJavaFiles", "" + jarPackageData.areJavaFilesExported());
        Object[] objectArray = jarPackageData.getElements();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof IResource) {
                this.add((IResource)object, element2, document);
            } else if (object instanceof IJavaElement) {
                this.add((IJavaElement)object, element2, document);
            }
            ++n;
        }
    }

    private void xmlWriteSelectedProjects(JarPackageData jarPackageData, Document document, Element element) throws DOMException {
        Element element2 = document.createElement("selectedProjects");
        element.appendChild(element2);
        IProject[] iProjectArray = jarPackageData.getRefactoringProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IProject iProject = iProjectArray[n];
            if (iProject instanceof IResource) {
                this.add((IResource)iProject, element2, document);
            }
            ++n;
        }
    }

    public void close() throws CoreException {
        if (this.fOutputStream != null) {
            try {
                this.fOutputStream.close();
            }
            catch (IOException iOException) {
                String string = iOException.getLocalizedMessage() != null ? iOException.getLocalizedMessage() : "";
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 10001, string, (Throwable)iOException));
            }
        }
    }

    private void add(IResource iResource, Element element, Document document) {
        if (iResource.getType() == 4) {
            Element element2 = document.createElement("project");
            element.appendChild(element2);
            element2.setAttribute("name", iResource.getName());
        } else if (iResource.getType() == 1) {
            Element element3 = document.createElement("file");
            element.appendChild(element3);
            element3.setAttribute("path", iResource.getFullPath().toString());
        } else if (iResource.getType() == 2) {
            Element element4 = document.createElement("folder");
            element.appendChild(element4);
            element4.setAttribute("path", iResource.getFullPath().toString());
        }
    }

    private void add(IJavaElement iJavaElement, Element element, Document document) {
        Element element2 = document.createElement("javaElement");
        element.appendChild(element2);
        element2.setAttribute("handleIdentifier", iJavaElement.getHandleIdentifier());
    }

    private void add(IPackageFragment[] iPackageFragmentArray, Element element, Document document) {
        int n = 0;
        while (n < iPackageFragmentArray.length) {
            Element element2 = document.createElement("package");
            element.appendChild(element2);
            element2.setAttribute("handleIdentifier", iPackageFragmentArray[n].getHandleIdentifier());
            ++n;
        }
    }

    public IStatus getStatus() {
        return new Status(0, JavaPlugin.getPluginId(), 0, "", null);
    }
}

