/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocTreeWizardPage;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocWizardPage;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;

public class JavadocSpecificsWizardPage
extends JavadocWizardPage {
    private Button fAntBrowseButton;
    private Button fCheckbrowser;
    private Text fAntText;
    private Button fOverViewButton;
    private Button fOverViewBrowseButton;
    private Button fAntButton;
    private Combo fSourceCombo;
    private Composite fLowerComposite;
    private Text fOverViewText;
    private Text fExtraOptionsText;
    private Text fVMOptionsText;
    private StatusInfo fOverviewStatus;
    private StatusInfo fAntStatus;
    private JavadocTreeWizardPage fFirstPage;
    private JavadocOptionsManager fStore;
    private final int OVERVIEWSTATUS = 1;
    private final int ANTSTATUS = 2;

    protected JavadocSpecificsWizardPage(String string, JavadocTreeWizardPage javadocTreeWizardPage, JavadocOptionsManager javadocOptionsManager) {
        super(string);
        this.setDescription(JavadocExportMessages.JavadocSpecificsWizardPage_description);
        this.fStore = javadocOptionsManager;
        this.fOverviewStatus = new StatusInfo();
        this.fAntStatus = new StatusInfo();
        this.fFirstPage = javadocTreeWizardPage;
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.fLowerComposite = new Composite(composite, 0);
        this.fLowerComposite.setLayoutData((Object)this.createGridData(1808, 1, 0));
        GridLayout gridLayout = this.createGridLayout(3);
        gridLayout.marginHeight = 0;
        this.fLowerComposite.setLayout((Layout)gridLayout);
        this.createExtraOptionsGroup(this.fLowerComposite);
        this.createAntGroup(this.fLowerComposite);
        this.setControl((Control)this.fLowerComposite);
        Dialog.applyDialogFont((Control)this.fLowerComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fLowerComposite, "org.eclipse.wst.jsdt.ui.javadoc_specifics_page_context");
    }

    private void createExtraOptionsGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.createGridLayout(3));
        composite2.setLayoutData((Object)this.createGridData(768, 3, 0));
        ((GridLayout)composite2.getLayout()).marginWidth = 0;
        this.fOverViewButton = this.createButton(composite2, 32, JavadocExportMessages.JavadocSpecificsWizardPage_overviewbutton_label, this.createGridData(1));
        this.fOverViewText = this.createText(composite2, 2052, null, this.createGridData(768, 1, 0));
        ((GridData)this.fOverViewText.getLayoutData()).widthHint = 200;
        this.fOverViewBrowseButton = this.createButton(composite2, 8, JavadocExportMessages.JavadocSpecificsWizardPage_overviewbrowse_label, this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fOverViewBrowseButton);
        String string = this.fStore.getOverview();
        if (string.length() == 0) {
            this.fOverViewText.setEnabled(false);
            this.fOverViewBrowseButton.setEnabled(false);
        } else {
            this.fOverViewButton.setSelection(true);
            this.fOverViewText.setText(string);
        }
        this.createLabel(composite, 0, JavadocExportMessages.JavadocSpecificsWizardPage_vmoptionsfield_label, this.createGridData(32, 3, 0));
        this.fVMOptionsText = this.createText(composite, 2052, null, this.createGridData(256, 3, 0));
        this.fVMOptionsText.setText(this.fStore.getVMParams());
        this.createLabel(composite, 0, JavadocExportMessages.JavadocSpecificsWizardPage_extraoptionsfield_label, this.createGridData(32, 3, 0));
        this.fExtraOptionsText = this.createText(composite, 2882, null, this.createGridData(1296, 3, 0));
        this.fExtraOptionsText.setText(this.fStore.getAdditionalParams());
        Composite composite3 = new Composite(composite, 0);
        composite3.setLayoutData((Object)new GridData(4, 1, false, false, 3, 1));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        this.createLabel(composite3, 0, JavadocExportMessages.JavadocSpecificsWizardPage_sourcecompatibility_label, this.createGridData(32, 1, 0));
        this.fSourceCombo = this.createCombo(composite3, 0, this.fStore.getSource(), this.createGridData(1));
        String[] stringArray = new String[]{"-", "1.3", "1.4", "1.5"};
        this.fSourceCombo.setItems(stringArray);
        this.fSourceCombo.setText(this.fStore.getSource());
        this.fOverViewButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fOverViewBrowseButton, this.fOverViewText}){

            public void validate() {
                JavadocSpecificsWizardPage.this.doValidation(1);
            }
        });
        this.fOverViewText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavadocSpecificsWizardPage.this.doValidation(1);
            }
        });
        this.fOverViewBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavadocSpecificsWizardPage.this.handleFileBrowseButtonPressed(JavadocSpecificsWizardPage.this.fOverViewText, new String[]{"*.html"}, JavadocExportMessages.JavadocSpecificsWizardPage_overviewbrowsedialog_title);
            }
        });
    }

    private void createAntGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.createGridLayout(3));
        composite2.setLayoutData((Object)this.createGridData(768, 3, 0));
        ((GridLayout)composite2.getLayout()).marginWidth = 0;
        this.fAntButton = this.createButton(composite2, 32, JavadocExportMessages.JavadocSpecificsWizardPage_antscriptbutton_label, this.createGridData(3));
        this.createLabel(composite2, 0, JavadocExportMessages.JavadocSpecificsWizardPage_antscripttext_label, this.createGridData(32, 1, 0));
        this.fAntText = this.createText(composite2, 2052, null, this.createGridData(768, 1, 0));
        ((GridData)this.fAntText.getLayoutData()).widthHint = 200;
        this.fAntText.setText(this.fStore.getAntpath());
        this.fAntBrowseButton = this.createButton(composite2, 8, JavadocExportMessages.JavadocSpecificsWizardPage_antscriptbrowse_label, this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fAntBrowseButton);
        this.fAntText.setEnabled(false);
        this.fAntBrowseButton.setEnabled(false);
        this.fCheckbrowser = this.createButton(composite2, 32, JavadocExportMessages.JavadocSpecificsWizardPage_openbrowserbutton_label, this.createGridData(3));
        this.fCheckbrowser.setSelection(this.fStore.doOpenInBrowser());
        this.fAntButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fAntText, this.fAntBrowseButton}){

            public void validate() {
                JavadocSpecificsWizardPage.this.doValidation(2);
            }
        });
        this.fAntText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavadocSpecificsWizardPage.this.doValidation(2);
            }
        });
        this.fAntBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = JavadocSpecificsWizardPage.this.fAntText.getText();
                IPath iPath = Path.fromOSString((String)string);
                String string2 = iPath.lastSegment();
                if (string2 == null) {
                    string2 = "javadoc.xml";
                }
                iPath = iPath.removeLastSegments(1);
                String string3 = JavadocSpecificsWizardPage.this.handleFolderBrowseButtonPressed(iPath.toOSString(), JavadocExportMessages.JavadocSpecificsWizardPage_antscriptbrowsedialog_title, JavadocExportMessages.JavadocSpecificsWizardPage_antscriptbrowsedialog_label);
                iPath = Path.fromOSString((String)string3).append(string2);
                JavadocSpecificsWizardPage.this.fAntText.setText(iPath.toOSString());
            }
        });
    }

    private void doValidation(int n) {
        switch (n) {
            case 1: {
                this.fOverviewStatus = new StatusInfo();
                if (!this.fOverViewButton.getSelection()) break;
                String string = this.fOverViewText.getText();
                if (string.length() == 0) {
                    this.fOverviewStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_overviewnotfound_error);
                    break;
                }
                File file = new File(string);
                String string2 = string.substring(string.lastIndexOf(46) + 1);
                if (!file.isFile()) {
                    this.fOverviewStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_overviewnotfound_error);
                    break;
                }
                if (string2.equalsIgnoreCase("html")) break;
                this.fOverviewStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_overviewincorrect_error);
                break;
            }
            case 2: {
                this.fAntStatus = new StatusInfo();
                if (!this.fAntButton.getSelection()) break;
                String string = this.fAntText.getText();
                if (string.length() == 0) {
                    this.fOverviewStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_antfileincorrect_error);
                    break;
                }
                File file = new File(string);
                String string3 = string.substring(string.lastIndexOf(46) + 1);
                if (file.isDirectory() || !string3.equalsIgnoreCase("xml")) {
                    this.fAntStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_antfileincorrect_error);
                    break;
                }
                if (!file.exists()) break;
                this.fAntStatus.setWarning(JavadocExportMessages.JavadocSpecificsWizardPage_antfileoverwrite_warning);
            }
        }
        this.updateStatus(this.findMostSevereStatus());
    }

    protected void updateStore() {
        this.fStore.setVMParams(this.fVMOptionsText.getText());
        this.fStore.setAdditionalParams(this.fExtraOptionsText.getText());
        if (this.fOverViewText.getEnabled()) {
            this.fStore.setOverview(this.fOverViewText.getText());
        } else {
            this.fStore.setOverview("");
        }
        if (this.fAntText.getEnabled()) {
            this.fStore.setGeneralAntpath(this.fAntText.getText());
        }
        this.fStore.setOpenInBrowser(this.fCheckbrowser.getSelection());
        this.fStore.setSource(this.fSourceCombo.getText());
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.doValidation(1);
            this.doValidation(2);
            this.fCheckbrowser.setVisible(!this.fFirstPage.getCustom());
        }
    }

    public void init() {
        this.updateStatus(new StatusInfo());
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fAntStatus, this.fOverviewStatus});
    }

    public boolean generateAnt() {
        return this.fAntButton.getSelection();
    }
}

