/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocExportMessages;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocLinkDialogLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocLinkRef;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocOptionsManager;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocTreeWizardPage;
import org.eclipse.wst.jsdt.internal.ui.javadocexport.JavadocWizardPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavadocConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.launching.IRuntimeClasspathEntry;
import org.eclipse.wst.jsdt.launching.JavaRuntime;

public class JavadocStandardWizardPage
extends JavadocWizardPage {
    private final int STYLESHEETSTATUS = 1;
    private final int LINK_REFERENCES = 2;
    private JavadocOptionsManager fStore;
    private Composite fUpperComposite;
    private Group fBasicOptionsGroup;
    private Group fTagsGroup;
    private Button fTitleButton;
    private Text fTitleText;
    private Text fStyleSheetText;
    private FlaggedButton fDeprecatedList;
    private FlaggedButton fDeprecatedCheck;
    private FlaggedButton fIndexCheck;
    private FlaggedButton fSeperatedIndexCheck;
    private Button fStyleSheetBrowseButton;
    private Button fStyleSheetButton;
    private CheckedListDialogField fListDialogField;
    private StatusInfo fStyleSheetStatus;
    private StatusInfo fLinkRefStatus;
    private ArrayList fButtonsList;
    private JavadocTreeWizardPage fFirstPage;

    public JavadocStandardWizardPage(String string, JavadocTreeWizardPage javadocTreeWizardPage, JavadocOptionsManager javadocOptionsManager) {
        super(string);
        this.fFirstPage = javadocTreeWizardPage;
        this.setDescription(JavadocExportMessages.JavadocStandardWizardPage_description);
        this.fStore = javadocOptionsManager;
        this.fButtonsList = new ArrayList();
        this.fStyleSheetStatus = new StatusInfo();
        this.fLinkRefStatus = new StatusInfo();
    }

    public void createControl(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.fUpperComposite = new Composite(composite, 0);
        this.fUpperComposite.setFont(composite.getFont());
        this.fUpperComposite.setLayoutData((Object)this.createGridData(1808, 1, 0));
        GridLayout gridLayout = this.createGridLayout(4);
        gridLayout.marginHeight = 0;
        this.fUpperComposite.setLayout((Layout)gridLayout);
        this.createBasicOptionsGroup(this.fUpperComposite);
        this.createTagOptionsGroup(this.fUpperComposite);
        this.createListDialogField(this.fUpperComposite);
        this.createStyleSheetGroup(this.fUpperComposite);
        this.setControl((Control)this.fUpperComposite);
        Dialog.applyDialogFont((Control)this.fUpperComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fUpperComposite, "org.eclipse.wst.jsdt.ui.javadoc_standard_page_context");
    }

    private void createBasicOptionsGroup(Composite composite) {
        this.fTitleButton = this.createButton(composite, 32, JavadocExportMessages.JavadocStandardWizardPage_titlebutton_label, this.createGridData(1));
        this.fTitleText = this.createText(composite, 2052, null, this.createGridData(768, 3, 0));
        String string = this.fStore.getTitle();
        if (!string.equals("")) {
            this.fTitleText.setText(string);
            this.fTitleButton.setSelection(true);
        } else {
            this.fTitleText.setEnabled(false);
        }
        this.fBasicOptionsGroup = new Group(composite, 16);
        this.fBasicOptionsGroup.setLayout((Layout)this.createGridLayout(1));
        this.fBasicOptionsGroup.setLayoutData((Object)this.createGridData(1808, 2, 0));
        this.fBasicOptionsGroup.setText(JavadocExportMessages.JavadocStandardWizardPage_basicgroup_label);
        new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.JavadocStandardWizardPage_usebutton_label, new GridData(768), this.fStore.USE, true);
        new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.JavadocStandardWizardPage_hierarchybutton_label, new GridData(768), this.fStore.NOTREE, false);
        new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.JavadocStandardWizardPage_navigartorbutton_label, new GridData(768), this.fStore.NONAVBAR, false);
        this.fIndexCheck = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.JavadocStandardWizardPage_indexbutton_label, new GridData(768), this.fStore.NOINDEX, false);
        this.fSeperatedIndexCheck = new FlaggedButton((Composite)this.fBasicOptionsGroup, JavadocExportMessages.JavadocStandardWizardPage_seperateindexbutton_label, this.createGridData(512, 1, this.convertWidthInCharsToPixels(3)), this.fStore.SPLITINDEX, true);
        this.fSeperatedIndexCheck.getButton().setEnabled(this.fIndexCheck.getButton().getSelection());
        this.fIndexCheck.getButton().addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fSeperatedIndexCheck.getButton()}));
        this.fTitleButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fTitleText}));
    }

    private void createTagOptionsGroup(Composite composite) {
        this.fTagsGroup = new Group(composite, 16);
        this.fTagsGroup.setLayout((Layout)this.createGridLayout(1));
        this.fTagsGroup.setLayoutData((Object)this.createGridData(1808, 2, 0));
        this.fTagsGroup.setText(JavadocExportMessages.JavadocStandardWizardPage_tagsgroup_label);
        new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.JavadocStandardWizardPage_authorbutton_label, new GridData(768), this.fStore.AUTHOR, true);
        new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.JavadocStandardWizardPage_versionbutton_label, new GridData(768), this.fStore.VERSION, true);
        this.fDeprecatedCheck = new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.JavadocStandardWizardPage_deprecatedbutton_label, new GridData(768), this.fStore.NODEPRECATED, false);
        this.fDeprecatedList = new FlaggedButton((Composite)this.fTagsGroup, JavadocExportMessages.JavadocStandardWizardPage_deprecatedlistbutton_label, this.createGridData(768, 1, this.convertWidthInCharsToPixels(3)), this.fStore.NODEPRECATEDLIST, false);
        this.fDeprecatedList.getButton().setEnabled(this.fDeprecatedCheck.getButton().getSelection());
        this.fDeprecatedCheck.getButton().addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fDeprecatedList.getButton()}));
    }

    private void createStyleSheetGroup(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)this.createGridLayout(3));
        composite2.setLayoutData((Object)this.createGridData(768, 4, 0));
        ((GridLayout)composite2.getLayout()).marginWidth = 0;
        this.fStyleSheetButton = this.createButton(composite2, 32, JavadocExportMessages.JavadocStandardWizardPage_stylesheettext_label, this.createGridData(1));
        this.fStyleSheetText = this.createText(composite2, 2052, null, this.createGridData(768, 1, 0));
        ((GridData)this.fStyleSheetText.getLayoutData()).widthHint = 200;
        this.fStyleSheetBrowseButton = this.createButton(composite2, 8, JavadocExportMessages.JavadocStandardWizardPage_stylesheetbrowsebutton_label, this.createGridData(128, 1, 0));
        SWTUtil.setButtonDimensionHint(this.fStyleSheetBrowseButton);
        String string = this.fStore.getStyleSheet();
        if (string.equals("")) {
            this.fStyleSheetText.setEnabled(false);
            this.fStyleSheetBrowseButton.setEnabled(false);
        } else {
            this.fStyleSheetButton.setSelection(true);
            this.fStyleSheetText.setText(string);
        }
        this.fStyleSheetButton.addSelectionListener((SelectionListener)new JavadocWizardPage.ToggleSelectionAdapter(new Control[]{this.fStyleSheetText, this.fStyleSheetBrowseButton}){

            public void validate() {
                JavadocStandardWizardPage.this.doValidation(1);
            }
        });
        this.fStyleSheetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                JavadocStandardWizardPage.this.doValidation(1);
            }
        });
        this.fStyleSheetBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                JavadocStandardWizardPage.this.handleFileBrowseButtonPressed(JavadocStandardWizardPage.this.fStyleSheetText, new String[]{"*.css"}, JavadocExportMessages.JavadocSpecificsWizardPage_stylesheetbrowsedialog_title);
            }
        });
    }

    private void createListDialogField(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        composite2.setLayout((Layout)this.createGridLayout(3));
        composite2.setLayoutData((Object)this.createGridData(1808, 4, 0));
        ((GridLayout)composite2.getLayout()).marginWidth = 0;
        String[] stringArray = new String[]{JavadocExportMessages.JavadocStandardWizardPage_selectallbutton_label, JavadocExportMessages.JavadocStandardWizardPage_clearallbutton_label, JavadocExportMessages.JavadocStandardWizardPage_configurebutton_label};
        JavadocLinkDialogLabelProvider javadocLinkDialogLabelProvider = new JavadocLinkDialogLabelProvider();
        ListAdapter listAdapter = new ListAdapter();
        this.fListDialogField = new CheckedListDialogField(listAdapter, stringArray, (ILabelProvider)javadocLinkDialogLabelProvider);
        this.fListDialogField.setDialogFieldListener(listAdapter);
        this.fListDialogField.setCheckAllButtonIndex(0);
        this.fListDialogField.setUncheckAllButtonIndex(1);
        this.fListDialogField.setViewerComparator(new ViewerComparator());
        this.createLabel(composite2, 0, JavadocExportMessages.JavadocStandardWizardPage_referencedclasses_label, this.createGridData(32, 4, 0));
        this.fListDialogField.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalGrabbing(this.fListDialogField.getListControl(null));
        this.fListDialogField.enableButton(2, false);
    }

    private List getCheckedReferences(JavadocLinkRef[] javadocLinkRefArray) {
        ArrayList<JavadocLinkRef> arrayList = new ArrayList<JavadocLinkRef>();
        String[] stringArray = this.fStore.getHRefs();
        if (stringArray.length > 0) {
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            while (n < stringArray.length) {
                hashSet.add(stringArray[n]);
                ++n;
            }
            n = 0;
            while (n < javadocLinkRefArray.length) {
                JavadocLinkRef javadocLinkRef = javadocLinkRefArray[n];
                URL uRL = javadocLinkRef.getURL();
                if (uRL != null && hashSet.contains(uRL.toExternalForm())) {
                    arrayList.add(javadocLinkRef);
                }
                ++n;
            }
        }
        return arrayList;
    }

    private JavadocLinkRef[] getReferencedElements(IJavaProject[] iJavaProjectArray) {
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < iJavaProjectArray.length) {
            IJavaProject iJavaProject = iJavaProjectArray[n];
            try {
                this.collectReferencedElements(iJavaProject, hashSet);
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
            ++n;
        }
        return hashSet.toArray(new JavadocLinkRef[hashSet.size()]);
    }

    private void collectReferencedElements(IJavaProject iJavaProject, HashSet hashSet) throws CoreException {
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = JavaRuntime.computeUnresolvedRuntimeClasspath(iJavaProject);
        int n = 0;
        while (n < iRuntimeClasspathEntryArray.length) {
            IRuntimeClasspathEntry iRuntimeClasspathEntry = iRuntimeClasspathEntryArray[n];
            if (iRuntimeClasspathEntry.getType() == 1) {
                hashSet.add(new JavadocLinkRef(JavaCore.create((IProject)((IProject)iRuntimeClasspathEntry.getResource()))));
            } else {
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray2 = JavaRuntime.resolveRuntimeClasspathEntry(iRuntimeClasspathEntry, iJavaProject);
                int n2 = 0;
                while (n2 < iRuntimeClasspathEntryArray2.length) {
                    IClasspathEntry iClasspathEntry;
                    IRuntimeClasspathEntry iRuntimeClasspathEntry2 = iRuntimeClasspathEntryArray2[n2];
                    if (iRuntimeClasspathEntry2.getType() == 1) {
                        hashSet.add(new JavadocLinkRef(JavaCore.create((IProject)((IProject)iRuntimeClasspathEntry2.getResource()))));
                    } else if (iRuntimeClasspathEntry2.getType() == 2 && (iClasspathEntry = iRuntimeClasspathEntry2.getClasspathEntry()) != null) {
                        IPath iPath = null;
                        if (iRuntimeClasspathEntry.getType() == 4) {
                            iPath = iRuntimeClasspathEntry.getPath();
                        }
                        hashSet.add(new JavadocLinkRef(iPath, iClasspathEntry, iJavaProject));
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    final void doValidation(int n) {
        block0 : switch (n) {
            case 1: {
                this.fStyleSheetStatus = new StatusInfo();
                if (!this.fStyleSheetButton.getSelection()) break;
                String string = this.fStyleSheetText.getText();
                if (string.length() == 0) {
                    this.fStyleSheetStatus.setError(JavadocExportMessages.JavadocSpecificsWizardPage_overviewnotfound_error);
                    break;
                }
                File file = new File(string);
                String string2 = string.substring(string.lastIndexOf(46) + 1);
                if (!file.isFile()) {
                    this.fStyleSheetStatus.setError(JavadocExportMessages.JavadocStandardWizardPage_stylesheetnopath_error);
                    break;
                }
                if (string2.equalsIgnoreCase("css")) break;
                this.fStyleSheetStatus.setError(JavadocExportMessages.JavadocStandardWizardPage_stylesheetnotcss_error);
                break;
            }
            case 2: {
                this.fLinkRefStatus = new StatusInfo();
                List list = this.fListDialogField.getCheckedElements();
                int n2 = 0;
                while (n2 < list.size()) {
                    JavadocLinkRef javadocLinkRef = (JavadocLinkRef)list.get(n2);
                    URL uRL = javadocLinkRef.getURL();
                    if (uRL == null) {
                        this.fLinkRefStatus.setWarning(JavadocExportMessages.JavadocStandardWizardPage_nolinkref_error);
                        break block0;
                    }
                    if ("jar".equals(uRL.getProtocol())) {
                        this.fLinkRefStatus.setWarning(JavadocExportMessages.JavadocStandardWizardPage_nojarlinkref_error);
                        break block0;
                    }
                    ++n2;
                }
                break;
            }
        }
        this.updateStatus(this.findMostSevereStatus());
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fStyleSheetStatus, this.fLinkRefStatus});
    }

    public void updateStore() {
        if (this.fTitleButton.getSelection()) {
            this.fStore.setTitle(this.fTitleText.getText());
        } else {
            this.fStore.setTitle("");
        }
        Object[] objectArray = this.fButtonsList.toArray();
        int n = 0;
        while (n < objectArray.length) {
            FlaggedButton flaggedButton = (FlaggedButton)objectArray[n];
            if (flaggedButton.getButton().getEnabled()) {
                this.fStore.setBoolean(flaggedButton.getFlag(), !(flaggedButton.getButton().getSelection() ^ flaggedButton.show()));
            } else {
                this.fStore.setBoolean(flaggedButton.getFlag(), !flaggedButton.show());
            }
            ++n;
        }
        if (this.fStyleSheetText.getEnabled()) {
            this.fStore.setStyleSheet(this.fStyleSheetText.getText());
        } else {
            this.fStore.setStyleSheet("");
        }
        this.fStore.setHRefs(this.getHRefs());
    }

    private String[] getHRefs() {
        HashSet<String> hashSet = new HashSet<String>();
        List list = this.fListDialogField.getCheckedElements();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JavadocLinkRef javadocLinkRef = (JavadocLinkRef)iterator.next();
            URL uRL = javadocLinkRef.getURL();
            if (uRL == null) continue;
            hashSet.add(uRL.toExternalForm());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.doValidation(1);
            this.updateHRefList(this.fFirstPage.getCheckedProjects());
        } else {
            this.fStore.setHRefs(this.getHRefs());
        }
    }

    private void updateHRefList(IJavaProject[] iJavaProjectArray) {
        JavadocLinkRef[] javadocLinkRefArray = this.getReferencedElements(iJavaProjectArray);
        this.fListDialogField.setElements(Arrays.asList(javadocLinkRefArray));
        List list = this.getCheckedReferences(javadocLinkRefArray);
        this.fListDialogField.setCheckedElements(list);
    }

    public void init() {
        this.updateStatus(new StatusInfo());
    }

    private void doEditButtonPressed() {
        JavadocPropertyDialog javadocPropertyDialog;
        List list = this.fListDialogField.getSelectedElements();
        if (list.isEmpty()) {
            return;
        }
        JavadocLinkRef javadocLinkRef = (JavadocLinkRef)list.get(0);
        if (javadocLinkRef != null && (javadocPropertyDialog = new JavadocPropertyDialog(this.getShell(), javadocLinkRef)).open() == 0) {
            this.fListDialogField.refresh();
        }
    }

    protected class FlaggedButton {
        private Button fButton;
        private String fFlag;
        private boolean fShowFlag;

        public FlaggedButton(Composite composite, String string, GridData gridData, String string2, boolean bl) {
            this.fFlag = string2;
            this.fShowFlag = bl;
            this.fButton = JavadocStandardWizardPage.this.createButton(composite, 32, string, gridData);
            JavadocStandardWizardPage.this.fButtonsList.add(this);
            this.setButtonSettings();
        }

        public Button getButton() {
            return this.fButton;
        }

        public String getFlag() {
            return this.fFlag;
        }

        public boolean show() {
            return this.fShowFlag;
        }

        private void setButtonSettings() {
            this.fButton.setSelection(!(JavadocStandardWizardPage.this.fStore.getBoolean(this.fFlag) ^ this.fShowFlag));
        }
    }

    private class JavadocPropertyDialog
    extends StatusDialog
    implements IStatusChangeListener {
        private JavadocConfigurationBlock fJavadocConfigurationBlock;
        private JavadocLinkRef fElement;

        public JavadocPropertyDialog(Shell shell, JavadocLinkRef javadocLinkRef) {
            super(shell);
            this.setTitle(JavadocExportMessages.JavadocStandardWizardPage_javadocpropertydialog_title);
            this.fElement = javadocLinkRef;
            URL uRL = javadocLinkRef.getURL();
            this.fJavadocConfigurationBlock = new JavadocConfigurationBlock(shell, this, uRL, javadocLinkRef.isProjectRef());
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            Control control = this.fJavadocConfigurationBlock.createContents(composite2);
            control.setLayoutData((Object)new GridData(1808));
            JavadocPropertyDialog.applyDialogFont((Control)composite2);
            return composite2;
        }

        public void statusChanged(IStatus iStatus) {
            this.updateStatus(iStatus);
        }

        protected void okPressed() {
            try {
                IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(this){
                    final /* synthetic */ JavadocPropertyDialog this$1;
                    {
                        this.this$1 = javadocPropertyDialog;
                    }

                    public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                        URL uRL = JavadocPropertyDialog.access$0(this.this$1).getJavadocLocation();
                        JavadocPropertyDialog.access$1(this.this$1).setURL(uRL, iProgressMonitor);
                    }
                };
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(iWorkspaceRunnable));
            }
            catch (InvocationTargetException invocationTargetException) {
                String string = JavadocExportMessages.JavadocStandardWizardPage_configurecontainer_error_title;
                String string2 = JavadocExportMessages.JavadocStandardWizardPage_configurecontainer_error_message;
                ExceptionHandler.handle(invocationTargetException, this.getShell(), string, string2);
            }
            catch (InterruptedException interruptedException) {}
            JavadocStandardWizardPage.this.fListDialogField.refresh();
            JavadocStandardWizardPage.this.doValidation(2);
            super.okPressed();
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.javadoc_property_dialog_context");
        }

        static /* synthetic */ JavadocConfigurationBlock access$0(JavadocPropertyDialog javadocPropertyDialog) {
            return javadocPropertyDialog.fJavadocConfigurationBlock;
        }

        static /* synthetic */ JavadocLinkRef access$1(JavadocPropertyDialog javadocPropertyDialog) {
            return javadocPropertyDialog.fElement;
        }
    }

    private class ListAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ListAdapter() {
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            if (n == 2) {
                JavadocStandardWizardPage.this.doEditButtonPressed();
            }
        }

        public void selectionChanged(ListDialogField listDialogField) {
            List list = JavadocStandardWizardPage.this.fListDialogField.getSelectedElements();
            if (list.size() != 1) {
                JavadocStandardWizardPage.this.fListDialogField.enableButton(2, false);
            } else {
                JavadocStandardWizardPage.this.fListDialogField.enableButton(2, true);
            }
        }

        public void doubleClicked(ListDialogField listDialogField) {
            JavadocStandardWizardPage.this.doEditButtonPressed();
        }

        public void dialogFieldChanged(DialogField dialogField) {
            JavadocStandardWizardPage.this.doValidation(2);
        }
    }
}

