/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javadocexport;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.ui.JavaUI;

public class RecentSettingsStore {
    private final String HREF = "href";
    private final String DESTINATION = "destdir";
    private final String ANTPATH = "antpath";
    private final String SECTION_PROJECTS = "projects";
    private static final char REF_SEPARATOR = ';';
    private Map fPerProjectSettings = new HashMap();

    public RecentSettingsStore(IDialogSettings iDialogSettings) {
        if (iDialogSettings != null) {
            this.load(iDialogSettings);
        }
    }

    private void load(IDialogSettings iDialogSettings) {
        Object object;
        String string;
        IDialogSettings iDialogSettings2;
        int n;
        IDialogSettings[] iDialogSettingsArray;
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IDialogSettings iDialogSettings3 = iDialogSettings.getSection("projects");
        if (iDialogSettings3 != null) {
            iDialogSettingsArray = iDialogSettings3.getSections();
            n = 0;
            while (n < iDialogSettingsArray.length) {
                IJavaProject iJavaProject;
                iDialogSettings2 = iDialogSettingsArray[n];
                string = iDialogSettings2.getName();
                object = iWorkspaceRoot.getProject(string);
                if (object.isAccessible() && !this.fPerProjectSettings.containsKey(iJavaProject = JavaCore.create((IProject)object))) {
                    String string2;
                    String string3;
                    String string4 = iDialogSettings2.get("href");
                    if (string4 == null) {
                        string4 = "";
                    }
                    if ((string3 = iDialogSettings2.get("destdir")) == null || string3.length() == 0) {
                        string3 = this.getDefaultDestination(iJavaProject);
                    }
                    if ((string2 = iDialogSettings2.get("antpath")) == null || string2.length() == 0) {
                        string2 = this.getDefaultAntPath(iJavaProject);
                    }
                    ProjectData projectData = new ProjectData();
                    projectData.setDestination(string3);
                    projectData.setAntpath(string2);
                    projectData.setHRefs(string4);
                    if (!this.fPerProjectSettings.containsValue(iJavaProject)) {
                        this.fPerProjectSettings.put(iJavaProject, projectData);
                    }
                }
                ++n;
            }
        }
        iDialogSettingsArray = iWorkspaceRoot.getProjects();
        n = 0;
        while (n < iDialogSettingsArray.length) {
            iDialogSettings2 = iDialogSettingsArray[n];
            if (iDialogSettings2.isAccessible() && !this.fPerProjectSettings.containsKey(string = JavaCore.create((IProject)iDialogSettings2))) {
                object = new ProjectData();
                ((ProjectData)object).setDestination(this.getDefaultDestination((IJavaProject)string));
                ((ProjectData)object).setAntpath(this.getDefaultAntPath((IJavaProject)string));
                ((ProjectData)object).setHRefs("");
                this.fPerProjectSettings.put(string, object);
            }
            ++n;
        }
    }

    public void store(IDialogSettings iDialogSettings) {
        IDialogSettings iDialogSettings2 = iDialogSettings.addNewSection("projects");
        Set set = this.fPerProjectSettings.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IJavaProject iJavaProject = (IJavaProject)iterator.next();
            IDialogSettings iDialogSettings3 = iDialogSettings2.addNewSection(iJavaProject.getElementName());
            if (!set.contains(iJavaProject)) {
                iDialogSettings3.put("href", "");
                iDialogSettings3.put("destdir", "");
                iDialogSettings3.put("antpath", "");
            } else {
                ProjectData projectData = (ProjectData)this.fPerProjectSettings.get(iJavaProject);
                iDialogSettings3.put("href", projectData.getHRefs());
                iDialogSettings3.put("destdir", projectData.getDestination());
                iDialogSettings3.put("antpath", projectData.getAntPath());
            }
            iDialogSettings2.addSection(iDialogSettings3);
        }
    }

    public void setProjectSettings(IJavaProject iJavaProject, String string, String string2, String[] stringArray) {
        ProjectData projectData = (ProjectData)this.fPerProjectSettings.get(iJavaProject);
        if (projectData == null) {
            projectData = new ProjectData();
        }
        projectData.setDestination(string);
        projectData.setAntpath(string2);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(';');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        projectData.setHRefs(stringBuffer.toString());
    }

    public static String[] getRefTokens(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, String.valueOf(';'));
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public String[] getHRefs(IJavaProject iJavaProject) {
        ProjectData projectData = (ProjectData)this.fPerProjectSettings.get(iJavaProject);
        if (projectData != null) {
            String string = projectData.getHRefs();
            return RecentSettingsStore.getRefTokens(string);
        }
        return new String[0];
    }

    public String getDestination(IJavaProject iJavaProject) {
        ProjectData projectData = (ProjectData)this.fPerProjectSettings.get(iJavaProject);
        if (projectData != null) {
            return projectData.getDestination();
        }
        return this.getDefaultDestination(iJavaProject);
    }

    public String getAntpath(IJavaProject iJavaProject) {
        ProjectData projectData = (ProjectData)this.fPerProjectSettings.get(iJavaProject);
        if (projectData != null) {
            return projectData.getAntPath();
        }
        return this.getDefaultAntPath(iJavaProject);
    }

    private String getDefaultAntPath(IJavaProject iJavaProject) {
        IPath iPath;
        if (iJavaProject != null && (iPath = iJavaProject.getProject().getLocation()) != null) {
            return iPath.append("javadoc.xml").toOSString();
        }
        return "";
    }

    private String getDefaultDestination(IJavaProject iJavaProject) {
        if (iJavaProject != null) {
            URL uRL = JavaUI.getProjectJavadocLocation(iJavaProject);
            if (uRL == null || !uRL.getProtocol().equals("file")) {
                IPath iPath = iJavaProject.getProject().getLocation();
                if (iPath != null) {
                    return iPath.append("doc").toOSString();
                }
            } else {
                return new File(uRL.getFile()).getPath();
            }
        }
        return "";
    }

    private static class ProjectData {
        private String fHrefs;
        private String fDestinationDir;
        private String fAntPath;

        private ProjectData() {
        }

        public void setHRefs(String string) {
            this.fHrefs = string == null ? "" : string;
        }

        public void setDestination(String string) {
            this.fDestinationDir = string == null ? "" : string;
        }

        public void setAntpath(String string) {
            this.fAntPath = string == null ? "" : string;
        }

        public String getHRefs() {
            return this.fHrefs;
        }

        public String getDestination() {
            return this.fDestinationDir;
        }

        public String getAntPath() {
            return this.fAntPath;
        }
    }
}

