/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.AddImportsOperation;
import org.eclipse.wst.jsdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.TypeNameMatchLabelProvider;

public class AddImportOnSelectionAction
extends Action
implements IUpdate {
    private static final AddImportComparator ADD_IMPORT_COMPARATOR = new AddImportComparator();
    private CompilationUnitEditor fEditor;

    public AddImportOnSelectionAction(CompilationUnitEditor compilationUnitEditor) {
        super(JavaEditorMessages.AddImportOnSelection_label);
        this.setToolTipText(JavaEditorMessages.AddImportOnSelection_tooltip);
        this.setDescription(JavaEditorMessages.AddImportOnSelection_description);
        this.fEditor = compilationUnitEditor;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.add_imports_on_selection_action_context");
        this.setEnabled(this.getCompilationUnit() != null);
    }

    public void update() {
        this.setEnabled(this.fEditor != null && this.getCompilationUnit() != null);
    }

    private ICompilationUnit getCompilationUnit() {
        if (this.fEditor == null) {
            return null;
        }
        WorkingCopyManager workingCopyManager = JavaPlugin.getDefault().getWorkingCopyManager();
        return workingCopyManager.getWorkingCopy(this.fEditor.getEditorInput());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
        if (iCompilationUnit == null) return;
        if (this.fEditor == null) {
            return;
        }
        if (!ElementValidator.checkValidateEdit((IJavaElement)iCompilationUnit, this.getShell(), JavaEditorMessages.AddImportOnSelection_error_title)) {
            return;
        }
        if (!ActionUtil.isEditable(this.fEditor)) {
            return;
        }
        ISelection iSelection = this.fEditor.getSelectionProvider().getSelection();
        if (!(iSelection instanceof ITextSelection)) return;
        ITextSelection iTextSelection = (ITextSelection)iSelection;
        SelectTypeQuery selectTypeQuery = new SelectTypeQuery(this.getShell());
        AddImportsOperation addImportsOperation = new AddImportsOperation(iCompilationUnit, iTextSelection.getOffset(), iTextSelection.getLength(), selectTypeQuery, false);
        IEditingSupport iEditingSupport = this.createViewerHelper(iTextSelection, selectTypeQuery);
        try {
            try {
                IStatusLineManager iStatusLineManager;
                this.registerHelper(iEditingSupport);
                IProgressService iProgressService = PlatformUI.getWorkbench().getProgressService();
                iProgressService.runInUI((IRunnableContext)this.fEditor.getSite().getWorkbenchWindow(), (IRunnableWithProgress)new WorkbenchRunnableAdapter(addImportsOperation, addImportsOperation.getScheduleRule()), addImportsOperation.getScheduleRule());
                IStatus iStatus = addImportsOperation.getStatus();
                if (!iStatus.isOK() && (iStatusLineManager = this.getStatusLineManager()) != null) {
                    iStatusLineManager.setMessage(iStatus.getMessage());
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                ExceptionHandler.handle(invocationTargetException, this.getShell(), JavaEditorMessages.AddImportOnSelection_error_title, null);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.deregisterHelper(iEditingSupport);
            throw throwable;
        }
        {
            Object var10_13 = null;
            this.deregisterHelper(iEditingSupport);
            return;
        }
    }

    private IEditingSupport createViewerHelper(final ITextSelection iTextSelection, final SelectTypeQuery selectTypeQuery) {
        return new IEditingSupport(){

            public boolean isOriginator(DocumentEvent documentEvent, IRegion iRegion) {
                return iRegion.getOffset() <= iTextSelection.getOffset() + iTextSelection.getLength() && iTextSelection.getOffset() <= iRegion.getOffset() + iRegion.getLength();
            }

            public boolean ownsFocusShell() {
                return selectTypeQuery.isShowing();
            }
        };
    }

    private void registerHelper(IEditingSupport iEditingSupport) {
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        if (iSourceViewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry iEditingSupportRegistry = (IEditingSupportRegistry)iSourceViewer;
            iEditingSupportRegistry.register(iEditingSupport);
        }
    }

    private void deregisterHelper(IEditingSupport iEditingSupport) {
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        if (iSourceViewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry iEditingSupportRegistry = (IEditingSupportRegistry)iSourceViewer;
            iEditingSupportRegistry.unregister(iEditingSupport);
        }
    }

    private Shell getShell() {
        return this.fEditor.getSite().getShell();
    }

    private IStatusLineManager getStatusLineManager() {
        return this.fEditor.getEditorSite().getActionBars().getStatusLineManager();
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    static /* synthetic */ AddImportComparator access$0() {
        return ADD_IMPORT_COMPARATOR;
    }

    private static final class AddImportComparator
    implements Comparator {
        private AddImportComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            if (((String)object).equals(object2)) {
                return 0;
            }
            QualifiedTypeNameHistory qualifiedTypeNameHistory = QualifiedTypeNameHistory.getDefault();
            int n2 = qualifiedTypeNameHistory.getPosition(object);
            if (n2 == (n = qualifiedTypeNameHistory.getPosition(object2))) {
                return Collator.getInstance().compare(object, object2);
            }
            if (n2 > n) {
                return -1;
            }
            return 1;
        }
    }

    private static class SelectTypeQuery
    implements AddImportsOperation.IChooseImportQuery {
        private final Shell fShell;
        private boolean fIsShowing;

        public SelectTypeQuery(Shell shell) {
            this.fShell = shell;
        }

        public TypeNameMatch chooseImport(TypeNameMatch[] typeNameMatchArray, String string) {
            TypeNameMatch typeNameMatch;
            int n = typeNameMatchArray.length;
            if (n == 0) {
                return null;
            }
            if (n == 1) {
                return typeNameMatchArray[0];
            }
            if (string.length() != 0) {
                int n2 = 0;
                while (n2 < n) {
                    typeNameMatch = typeNameMatchArray[n2];
                    if (string.equals(typeNameMatch.getTypeContainerName())) {
                        return typeNameMatch;
                    }
                    ++n2;
                }
            }
            this.fIsShowing = true;
            ElementListSelectionDialog elementListSelectionDialog = new ElementListSelectionDialog(this, this.fShell, (ILabelProvider)new TypeNameMatchLabelProvider(1)){
                final /* synthetic */ SelectTypeQuery this$1;
                {
                    this.this$1 = selectTypeQuery;
                }

                protected FilteredList createFilteredList(Composite composite) {
                    FilteredList filteredList = super.createFilteredList(composite);
                    filteredList.setComparator((Comparator)AddImportOnSelectionAction.access$0());
                    return filteredList;
                }
            };
            elementListSelectionDialog.setTitle(JavaEditorMessages.AddImportOnSelection_dialog_title);
            elementListSelectionDialog.setMessage(JavaEditorMessages.AddImportOnSelection_dialog_message);
            elementListSelectionDialog.setElements((Object[])typeNameMatchArray);
            if (elementListSelectionDialog.open() == 0) {
                this.fIsShowing = false;
                typeNameMatch = (TypeNameMatch)elementListSelectionDialog.getFirstResult();
                QualifiedTypeNameHistory.remember(typeNameMatch.getFullyQualifiedName());
                return typeNameMatch;
            }
            this.fIsShowing = false;
            return null;
        }

        boolean isShowing() {
            return this.fIsShowing;
        }
    }
}

