/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public final class ClipboardOperationAction
extends TextEditorAction {
    private static final ClipboardTransfer fgTransferInstance = new ClipboardTransfer();
    private int fOperationCode = -1;
    private ITextOperationTarget fOperationTarget;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public ClipboardOperationAction(ResourceBundle resourceBundle, String string, ITextEditor iTextEditor, int n) {
        super(resourceBundle, string, iTextEditor);
        this.fOperationCode = n;
        if (n == 3) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.CUT_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.cut");
        } else if (n == 4) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.COPY_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        } else if (n == 5) {
            this.setHelpContextId(IAbstractTextEditorHelpContextIds.PASTE_ACTION);
            this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        } else {
            Assert.isTrue((boolean)false, (String)"Invalid operation code");
        }
        this.update();
    }

    private boolean isReadOnlyOperation() {
        return this.fOperationCode == 4;
    }

    public void run() {
        if (this.fOperationCode == -1 || this.fOperationTarget == null) {
            return;
        }
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return;
        }
        if (!this.isReadOnlyOperation() && !this.validateEditorInputState()) {
            return;
        }
        BusyIndicator.showWhile((Display)this.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ClipboardOperationAction.this.internalDoOperation();
            }
        });
    }

    private Shell getShell() {
        IWorkbenchPartSite iWorkbenchPartSite;
        Shell shell;
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor != null && (shell = (iWorkbenchPartSite = iTextEditor.getSite()).getShell()) != null && !shell.isDisposed()) {
            return shell;
        }
        return null;
    }

    private Display getDisplay() {
        Shell shell = this.getShell();
        if (shell != null) {
            return shell.getDisplay();
        }
        return null;
    }

    protected final void internalDoOperation() {
        if (PreferenceConstants.getPreferenceStore().getBoolean("importsOnPaste")) {
            if (this.fOperationCode == 5) {
                this.doPasteWithImportsOperation();
            } else {
                this.doCutCopyWithImportsOperation();
            }
        } else {
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }

    public void update() {
        super.update();
        if (!this.isReadOnlyOperation() && !this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor iTextEditor = this.getTextEditor();
        if (this.fOperationTarget == null && iTextEditor != null && this.fOperationCode != -1) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fOperationTarget = (ITextOperationTarget)iTextEditor.getAdapter((Class)clazz);
        }
        boolean bl = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
        this.setEnabled(bl);
    }

    public void setEditor(ITextEditor iTextEditor) {
        super.setEditor(iTextEditor);
        this.fOperationTarget = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doCutCopyWithImportsOperation() {
        ITextSelection iTextSelection;
        block11: {
            block10: {
                ITextEditor iTextEditor = this.getTextEditor();
                IEditorInput iEditorInput = iTextEditor.getEditorInput();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$1 = clazz2;
                }
                IJavaElement iJavaElement = (IJavaElement)iEditorInput.getAdapter((Class)clazz);
                ISelection iSelection = iTextEditor.getSelectionProvider().getSelection();
                ClipboardData clipboardData = null;
                if (iJavaElement != null && iSelection instanceof ITextSelection && !iSelection.isEmpty() && this.isNonTrivialSelection(iTextSelection = (ITextSelection)iSelection)) {
                    clipboardData = this.getClipboardData(iJavaElement, iTextSelection.getOffset(), iTextSelection.getLength());
                }
                this.fOperationTarget.doOperation(this.fOperationCode);
                if (clipboardData == null) return;
                iTextSelection = new Clipboard(this.getDisplay());
                try {
                    Object object = iTextSelection.getContents((Transfer)TextTransfer.getInstance());
                    Object object2 = iTextSelection.getContents((Transfer)RTFTransfer.getInstance());
                    ArrayList<Object> arrayList = new ArrayList<Object>(3);
                    ArrayList<Object> arrayList2 = new ArrayList<Object>(3);
                    if (object != null) {
                        arrayList.add(object);
                        arrayList2.add(TextTransfer.getInstance());
                    }
                    if (object2 != null) {
                        arrayList.add(object2);
                        arrayList2.add(RTFTransfer.getInstance());
                    }
                    if (arrayList.isEmpty()) {
                        Object var12_10 = null;
                        break block10;
                    }
                    arrayList.add(clipboardData);
                    arrayList2.add((Object)fgTransferInstance);
                    Transfer[] transferArray = arrayList2.toArray(new Transfer[arrayList2.size()]);
                    Object[] objectArray = arrayList.toArray();
                    this.setClipboardContents((Clipboard)iTextSelection, objectArray, transferArray);
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var12_11 = null;
                    iTextSelection.dispose();
                    throw throwable;
                }
            }
            iTextSelection.dispose();
            return;
        }
        Object var12_12 = null;
        iTextSelection.dispose();
    }

    private void setClipboardContents(Clipboard clipboard, Object[] objectArray, Transfer[] transferArray) {
        block2: {
            try {
                clipboard.setContents(objectArray, transferArray);
            }
            catch (SWTError sWTError) {
                if (sWTError.code == 2002) break block2;
                throw sWTError;
            }
        }
    }

    private boolean isNonTrivialSelection(ITextSelection iTextSelection) {
        if (iTextSelection.getLength() < 30) {
            String string = iTextSelection.getText();
            if (string != null) {
                int n = 0;
                while (n < string.length()) {
                    if (!Character.isJavaIdentifierPart(string.charAt(n))) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }
        return true;
    }

    private ClipboardData getClipboardData(IJavaElement iJavaElement, int n, int n2) {
        CharSequence charSequence;
        ITypeBinding iTypeBinding;
        Name name;
        CompilationUnit compilationUnit = JavaPlugin.getDefault().getASTProvider().getAST(iJavaElement, ASTProvider.WAIT_ACTIVE_ONLY, null);
        if (compilationUnit == null) {
            return null;
        }
        List list = compilationUnit.imports();
        if (!list.isEmpty() ? n < ((ASTNode)list.get(list.size() - 1)).getStartPosition() : compilationUnit.getPackage() != null && n < compilationUnit.getPackage().getStartPosition()) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ImportReferencesCollector.collect((ASTNode)compilationUnit, iJavaElement.getJavaProject(), new Region(n, n2), arrayList, arrayList2);
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            return null;
        }
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>(arrayList.size());
        int n3 = 0;
        while (n3 < arrayList.size()) {
            Name name2 = (Name)arrayList.get(n3);
            name = name2.resolveBinding();
            if (name != null && name.getKind() == 2) {
                iTypeBinding = (ITypeBinding)name;
                if (iTypeBinding.isArray()) {
                    iTypeBinding = iTypeBinding.getElementType();
                }
                if (!(iTypeBinding.isTypeVariable() || iTypeBinding.isCapture() || iTypeBinding.isWildcardType() || !iTypeBinding.isMember() && !iTypeBinding.isTopLevel() || ((String)(charSequence = Bindings.getRawQualifiedName(iTypeBinding))).length() <= 0)) {
                    hashSet.add(charSequence);
                }
            }
            ++n3;
        }
        HashSet<String> hashSet2 = new HashSet<String>(arrayList2.size());
        int n4 = 0;
        while (n4 < arrayList2.size()) {
            name = (Name)arrayList2.get(n4);
            iTypeBinding = name.resolveBinding();
            if (iTypeBinding != null) {
                charSequence = new StringBuffer(Bindings.getImportName((IBinding)iTypeBinding));
                if (iTypeBinding.getKind() == 4) {
                    ((StringBuffer)charSequence).append("()");
                }
                hashSet2.add(((StringBuffer)charSequence).toString());
            }
            ++n4;
        }
        if (hashSet.isEmpty() && hashSet2.isEmpty()) {
            return null;
        }
        String[] stringArray = hashSet.toArray(new String[hashSet.size()]);
        name = hashSet2.toArray(new String[hashSet2.size()]);
        return new ClipboardData(iJavaElement, stringArray, (String[])name);
    }

    /*
     * Exception decompiling
     */
    private void doPasteWithImportsOperation() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 221->227)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addImports(ICompilationUnit iCompilationUnit, ClipboardData clipboardData) throws CoreException {
        ImportRewrite importRewrite = StubUtility.createImportRewrite(iCompilationUnit, true);
        String[] stringArray = clipboardData.getTypeImports();
        int n = 0;
        while (n < stringArray.length) {
            importRewrite.addImport(stringArray[n]);
            ++n;
        }
        String[] stringArray2 = clipboardData.getStaticImports();
        int n2 = 0;
        while (n2 < stringArray2.length) {
            boolean bl;
            String string = Signature.getSimpleName((String)stringArray2[n2]);
            boolean bl2 = bl = !string.endsWith("()");
            if (!bl) {
                string = string.substring(0, string.length() - 2);
            }
            String string2 = Signature.getQualifier((String)stringArray2[n2]);
            importRewrite.addStaticImport(string2, string, bl);
            ++n2;
        }
        JavaModelUtil.applyEdit(iCompilationUnit, importRewrite.rewriteImports(null), false, null);
    }

    public static class ClipboardData {
        private String fOriginHandle;
        private String[] fTypeImports;
        private String[] fStaticImports;

        public ClipboardData(IJavaElement iJavaElement, String[] stringArray, String[] stringArray2) {
            Assert.isNotNull((Object)iJavaElement);
            Assert.isNotNull((Object)stringArray);
            Assert.isNotNull((Object)stringArray2);
            this.fTypeImports = stringArray;
            this.fStaticImports = stringArray2;
            this.fOriginHandle = iJavaElement.getHandleIdentifier();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ClipboardData(byte[] byArray) throws IOException {
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            try {
                this.fOriginHandle = dataInputStream.readUTF();
                this.fTypeImports = ClipboardData.readArray(dataInputStream);
                this.fStaticImports = ClipboardData.readArray(dataInputStream);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                dataInputStream.close();
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            dataInputStream.close();
        }

        private static String[] readArray(DataInputStream dataInputStream) throws IOException {
            int n = dataInputStream.readInt();
            String[] stringArray = new String[n];
            int n2 = 0;
            while (n2 < n) {
                stringArray[n2] = dataInputStream.readUTF();
                ++n2;
            }
            return stringArray;
        }

        private static void writeArray(DataOutputStream dataOutputStream, String[] stringArray) throws IOException {
            dataOutputStream.writeInt(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                dataOutputStream.writeUTF(stringArray[n]);
                ++n;
            }
        }

        public String[] getTypeImports() {
            return this.fTypeImports;
        }

        public String[] getStaticImports() {
            return this.fStaticImports;
        }

        public boolean isFromSame(IJavaElement iJavaElement) {
            return this.fOriginHandle.equals(iJavaElement.getHandleIdentifier());
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public byte[] serialize() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeUTF(this.fOriginHandle);
                ClipboardData.writeArray(dataOutputStream, this.fTypeImports);
                ClipboardData.writeArray(dataOutputStream, this.fStaticImports);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                dataOutputStream.close();
                byteArrayOutputStream.close();
                throw throwable;
            }
            {
                Object var3_5 = null;
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
    }

    private static class ClipboardTransfer
    extends ByteArrayTransfer {
        private static final String TYPE_NAME = "source-with-imports-transfer-format" + System.currentTimeMillis();
        private static final int TYPEID = ClipboardTransfer.registerType((String)TYPE_NAME);

        private ClipboardTransfer() {
        }

        protected int[] getTypeIds() {
            return new int[]{TYPEID};
        }

        protected String[] getTypeNames() {
            return new String[]{TYPE_NAME};
        }

        protected void javaToNative(Object object, TransferData transferData) {
            if (object instanceof ClipboardData) {
                try {
                    super.javaToNative((Object)((ClipboardData)object).serialize(), transferData);
                }
                catch (IOException iOException) {}
            }
        }

        protected Object nativeToJava(TransferData transferData) {
            byte[] byArray = (byte[])super.nativeToJava(transferData);
            if (byArray != null) {
                try {
                    return new ClipboardData(byArray);
                }
                catch (IOException iOException) {}
            }
            return null;
        }
    }
}

