/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class JavaAnnotationImageProvider
implements IAnnotationImageProvider {
    private static final int NO_IMAGE = 0;
    private static final int GRAY_IMAGE = 1;
    private static final int OVERLAY_IMAGE = 2;
    private static final int QUICKFIX_IMAGE = 3;
    private static final int QUICKFIX_ERROR_IMAGE = 4;
    private static Image fgQuickFixImage;
    private static Image fgQuickFixErrorImage;
    private static ImageRegistry fgImageRegistry;
    private boolean fShowQuickFixIcon = PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.ShowTemporaryProblem");
    private int fCachedImageType;
    private Image fCachedImage;

    public Image getManagedImage(Annotation annotation) {
        if (annotation instanceof IJavaAnnotation) {
            IJavaAnnotation iJavaAnnotation = (IJavaAnnotation)annotation;
            int n = this.getImageType(iJavaAnnotation);
            return this.getImage(iJavaAnnotation, n, Display.getCurrent());
        }
        return null;
    }

    public String getImageDescriptorId(Annotation annotation) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(String string) {
        return null;
    }

    private boolean showQuickFix(IJavaAnnotation iJavaAnnotation) {
        return this.fShowQuickFixIcon && iJavaAnnotation.isProblem() && JavaCorrectionProcessor.hasCorrections((Annotation)iJavaAnnotation);
    }

    private Image getQuickFixImage() {
        if (fgQuickFixImage == null) {
            fgQuickFixImage = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.quickfix_warning_obj.gif");
        }
        return fgQuickFixImage;
    }

    private Image getQuickFixErrorImage() {
        if (fgQuickFixErrorImage == null) {
            fgQuickFixErrorImage = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.quickfix_error_obj.gif");
        }
        return fgQuickFixErrorImage;
    }

    private ImageRegistry getImageRegistry(Display display) {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry(display);
        }
        return fgImageRegistry;
    }

    private int getImageType(IJavaAnnotation iJavaAnnotation) {
        int n = 0;
        if (iJavaAnnotation.hasOverlay()) {
            n = 2;
        } else if (!iJavaAnnotation.isMarkedDeleted()) {
            if (this.showQuickFix(iJavaAnnotation)) {
                n = "org.eclipse.wst.jsdt.ui.error".equals(iJavaAnnotation.getType()) ? 4 : 3;
            }
        } else {
            n = 1;
        }
        return n;
    }

    private Image getImage(IJavaAnnotation iJavaAnnotation, int n, Display display) {
        if ((n == 3 || n == 4) && this.fCachedImageType == n) {
            return this.fCachedImage;
        }
        Image image = null;
        switch (n) {
            case 2: {
                IJavaAnnotation iJavaAnnotation2 = iJavaAnnotation.getOverlay();
                image = this.getManagedImage((Annotation)iJavaAnnotation2);
                this.fCachedImageType = -1;
                break;
            }
            case 3: {
                image = this.getQuickFixImage();
                this.fCachedImageType = n;
                this.fCachedImage = image;
                break;
            }
            case 4: {
                image = this.getQuickFixErrorImage();
                this.fCachedImageType = n;
                this.fCachedImage = image;
                break;
            }
            case 1: {
                ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
                String string = iJavaAnnotation.getType();
                if ("org.eclipse.wst.jsdt.ui.error".equals(string)) {
                    image = iSharedImages.getImage("IMG_OBJS_ERROR_TSK");
                } else if ("org.eclipse.wst.jsdt.ui.warning".equals(string)) {
                    image = iSharedImages.getImage("IMG_OBJS_WARN_TSK");
                } else if ("org.eclipse.wst.jsdt.ui.info".equals(string)) {
                    image = iSharedImages.getImage("IMG_OBJS_INFO_TSK");
                }
                if (image != null) {
                    String string2;
                    ImageRegistry imageRegistry = this.getImageRegistry(display);
                    Image image2 = imageRegistry.get(string2 = Integer.toString(image.hashCode()));
                    if (image2 == null) {
                        image2 = new Image((Device)display, image, 2);
                        imageRegistry.put(string2, image2);
                    }
                    image = image2;
                }
                this.fCachedImageType = -1;
            }
        }
        return image;
    }
}

