/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.wst.jsdt.core.CorrectionEngine;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IJavaAnnotation;

public class JavaMarkerAnnotation
extends MarkerAnnotation
implements IJavaAnnotation {
    public static final String JAVA_MARKER_TYPE_PREFIX = "org.eclipse.wst.jsdt";
    public static final String ERROR_ANNOTATION_TYPE = "org.eclipse.wst.jsdt.ui.error";
    public static final String WARNING_ANNOTATION_TYPE = "org.eclipse.wst.jsdt.ui.warning";
    public static final String INFO_ANNOTATION_TYPE = "org.eclipse.wst.jsdt.ui.info";
    public static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    private IJavaAnnotation fOverlay;

    public JavaMarkerAnnotation(IMarker iMarker) {
        super(iMarker);
    }

    public String[] getArguments() {
        IMarker iMarker = this.getMarker();
        if (iMarker != null && iMarker.exists() && this.isProblem()) {
            return CorrectionEngine.getProblemArguments((IMarker)iMarker);
        }
        return null;
    }

    public int getId() {
        IMarker iMarker = this.getMarker();
        if (iMarker == null || !iMarker.exists()) {
            return -1;
        }
        if (this.isProblem()) {
            return iMarker.getAttribute("id", -1);
        }
        return -1;
    }

    public boolean isProblem() {
        String string = this.getType();
        return WARNING_ANNOTATION_TYPE.equals(string) || ERROR_ANNOTATION_TYPE.equals(string);
    }

    public void setOverlay(IJavaAnnotation iJavaAnnotation) {
        if (this.fOverlay != null) {
            this.fOverlay.removeOverlaid(this);
        }
        this.fOverlay = iJavaAnnotation;
        if (!this.isMarkedDeleted()) {
            this.markDeleted(this.fOverlay != null);
        }
        if (this.fOverlay != null) {
            this.fOverlay.addOverlaid(this);
        }
    }

    public boolean hasOverlay() {
        return this.fOverlay != null;
    }

    public IJavaAnnotation getOverlay() {
        return this.fOverlay;
    }

    public void addOverlaid(IJavaAnnotation iJavaAnnotation) {
    }

    public void removeOverlaid(IJavaAnnotation iJavaAnnotation) {
    }

    public Iterator getOverlaidIterator() {
        return null;
    }

    public ICompilationUnit getCompilationUnit() {
        IJavaElement iJavaElement = JavaCore.create((IResource)this.getMarker().getResource());
        if (iJavaElement instanceof ICompilationUnit) {
            return (ICompilationUnit)iJavaElement;
        }
        return null;
    }

    public String getMarkerType() {
        IMarker iMarker = this.getMarker();
        if (iMarker == null || !iMarker.exists()) {
            return null;
        }
        return MarkerUtilities.getMarkerType((IMarker)this.getMarker());
    }
}

