/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class JavaTextSelection
extends TextSelection {
    private IJavaElement fElement;
    private IJavaElement[] fResolvedElements;
    private boolean fEnclosingElementRequested;
    private IJavaElement fEnclosingElement;
    private boolean fPartialASTRequested;
    private CompilationUnit fPartialAST;
    private boolean fNodesRequested;
    private ASTNode[] fSelectedNodes;
    private ASTNode fCoveringNode;
    private boolean fInMethodBodyRequested;
    private boolean fInMethodBody;
    private boolean fInClassInitializerRequested;
    private boolean fInClassInitializer;
    private boolean fInVariableInitializerRequested;
    private boolean fInVariableInitializer;

    public JavaTextSelection(IJavaElement iJavaElement, IDocument iDocument, int n, int n2) {
        super(iDocument, n, n2);
        this.fElement = iJavaElement;
    }

    public IJavaElement[] resolveElementAtOffset() throws JavaModelException {
        if (this.fResolvedElements != null) {
            return this.fResolvedElements;
        }
        this.fResolvedElements = SelectionConverter.codeResolve(this.fElement, (ITextSelection)this);
        return this.fResolvedElements;
    }

    public IJavaElement resolveEnclosingElement() throws JavaModelException {
        if (this.fEnclosingElementRequested) {
            return this.fEnclosingElement;
        }
        this.fEnclosingElementRequested = true;
        this.fEnclosingElement = SelectionConverter.resolveEnclosingElement(this.fElement, (ITextSelection)this);
        return this.fEnclosingElement;
    }

    public CompilationUnit resolvePartialAstAtOffset() {
        if (this.fPartialASTRequested) {
            return this.fPartialAST;
        }
        this.fPartialASTRequested = true;
        if (!(this.fElement instanceof ICompilationUnit)) {
            return null;
        }
        this.fPartialAST = JavaPlugin.getDefault().getASTProvider().getAST(this.fElement, ASTProvider.WAIT_YES, null);
        return this.fPartialAST;
    }

    public ASTNode[] resolveSelectedNodes() {
        if (this.fNodesRequested) {
            return this.fSelectedNodes;
        }
        this.fNodesRequested = true;
        CompilationUnit compilationUnit = this.resolvePartialAstAtOffset();
        if (compilationUnit == null) {
            return null;
        }
        Selection selection = Selection.createFromStartLength(this.getOffset(), this.getLength());
        SelectionAnalyzer selectionAnalyzer = new SelectionAnalyzer(selection, false);
        compilationUnit.accept((ASTVisitor)selectionAnalyzer);
        this.fSelectedNodes = selectionAnalyzer.getSelectedNodes();
        this.fCoveringNode = selectionAnalyzer.getLastCoveringNode();
        return this.fSelectedNodes;
    }

    public ASTNode resolveCoveringNode() {
        if (this.fNodesRequested) {
            return this.fCoveringNode;
        }
        this.resolveSelectedNodes();
        return this.fCoveringNode;
    }

    /*
     * Unable to fully structure code
     */
    public boolean resolveInMethodBody() {
        block4: {
            if (this.fInMethodBodyRequested) {
                return this.fInMethodBody;
            }
            this.fInMethodBodyRequested = true;
            this.resolveSelectedNodes();
            var1_1 = this.getStartNode();
            if (var1_1 != null) ** GOTO lbl18
            this.fInMethodBody = true;
            break block4;
lbl-1000:
            // 1 sources

            {
                var2_2 = var1_1.getNodeType();
                if (var2_2 == 8 && var1_1.getParent() instanceof BodyDeclaration) {
                    this.fInMethodBody = var1_1.getParent().getNodeType() == 31;
                    break;
                }
                if (var2_2 == 1) {
                    this.fInMethodBody = false;
                    break;
                }
                var1_1 = var1_1.getParent();
lbl18:
                // 2 sources

                ** while (var1_1 != null)
            }
        }
        return this.fInMethodBody;
    }

    /*
     * Unable to fully structure code
     */
    public boolean resolveInClassInitializer() {
        block5: {
            if (this.fInClassInitializerRequested) {
                return this.fInClassInitializer;
            }
            this.fInClassInitializerRequested = true;
            this.resolveSelectedNodes();
            var1_1 = this.getStartNode();
            if (var1_1 != null) ** GOTO lbl21
            this.fInClassInitializer = true;
            break block5;
lbl-1000:
            // 1 sources

            {
                var2_2 = var1_1.getNodeType();
                if (var1_1 instanceof AbstractTypeDeclaration) {
                    this.fInClassInitializer = false;
                    break;
                }
                if (var2_2 == 1) {
                    this.fInClassInitializer = false;
                    break;
                }
                if (var2_2 == 28) {
                    this.fInClassInitializer = true;
                    break;
                }
                var1_1 = var1_1.getParent();
lbl21:
                // 2 sources

                ** while (var1_1 != null)
            }
        }
        return this.fInClassInitializer;
    }

    public boolean resolveInVariableInitializer() {
        if (this.fInVariableInitializerRequested) {
            return this.fInVariableInitializer;
        }
        this.fInVariableInitializerRequested = true;
        this.resolveSelectedNodes();
        ASTNode aSTNode = this.getStartNode();
        ASTNode aSTNode2 = null;
        while (aSTNode != null) {
            int n = aSTNode.getNodeType();
            if (aSTNode instanceof AbstractTypeDeclaration) {
                this.fInVariableInitializer = false;
                break;
            }
            if (n == 1) {
                this.fInVariableInitializer = false;
                break;
            }
            if (n == 59 && ((VariableDeclarationFragment)aSTNode).getInitializer() == aSTNode2) {
                this.fInVariableInitializer = true;
                break;
            }
            if (n == 44 && ((SingleVariableDeclaration)aSTNode).getInitializer() == aSTNode2) {
                this.fInVariableInitializer = true;
                break;
            }
            if (n == 82 && ((AnnotationTypeMemberDeclaration)aSTNode).getDefault() == aSTNode2) {
                this.fInVariableInitializer = true;
                break;
            }
            aSTNode2 = aSTNode;
            aSTNode = aSTNode.getParent();
        }
        return this.fInVariableInitializer;
    }

    private ASTNode getStartNode() {
        if (this.fSelectedNodes != null && this.fSelectedNodes.length > 0) {
            return this.fSelectedNodes[0];
        }
        return this.fCoveringNode;
    }
}

