/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightingManager;
import org.eclipse.wst.jsdt.internal.ui.text.JavaPresentationReconciler;

public class SemanticHighlightingPresenter
implements ITextPresentationListener,
ITextInputListener,
IDocumentListener {
    private IPositionUpdater fPositionUpdater = new HighlightingPositionUpdater(this.getPositionCategory());
    private JavaSourceViewer fSourceViewer;
    private JavaPresentationReconciler fPresentationReconciler;
    private List fPositions = new ArrayList();
    private Object fPositionLock = new Object();
    private boolean fIsCanceled = false;

    public SemanticHighlightingManager.HighlightedPosition createHighlightedPosition(int n, int n2, SemanticHighlightingManager.Highlighting highlighting) {
        return new SemanticHighlightingManager.HighlightedPosition(n, n2, highlighting, this.fPositionUpdater);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllPositions(List list) {
        Object object = this.fPositionLock;
        synchronized (object) {
            list.addAll(this.fPositions);
        }
    }

    public TextPresentation createPresentation(List list, List list2) {
        int n;
        Position position;
        JavaSourceViewer javaSourceViewer = this.fSourceViewer;
        JavaPresentationReconciler javaPresentationReconciler = this.fPresentationReconciler;
        if (javaSourceViewer == null || javaPresentationReconciler == null) {
            return null;
        }
        if (this.isCanceled()) {
            return null;
        }
        IDocument iDocument = javaSourceViewer.getDocument();
        if (iDocument == null) {
            return null;
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        int n5 = list2.size();
        while (n4 < n5) {
            position = (Position)list2.get(n4);
            n = position.getOffset();
            n2 = Math.min(n2, n);
            n3 = Math.max(n3, n + position.getLength());
            ++n4;
        }
        n4 = 0;
        n5 = list.size();
        while (n4 < n5) {
            position = (Position)list.get(n4);
            n = position.getOffset();
            n2 = Math.min(n2, n);
            n3 = Math.max(n3, n + position.getLength());
            ++n4;
        }
        if (n2 < n3) {
            try {
                return javaPresentationReconciler.createRepairDescription((IRegion)new Region(n2, n3 - n2), iDocument);
            }
            catch (RuntimeException runtimeException) {}
        }
        return null;
    }

    public Runnable createUpdateRunnable(final TextPresentation textPresentation, List list, List list2) {
        if (this.fSourceViewer == null || textPresentation == null) {
            return null;
        }
        final SemanticHighlightingManager.HighlightedPosition[] highlightedPositionArray = new SemanticHighlightingManager.HighlightedPosition[list.size()];
        list.toArray(highlightedPositionArray);
        final SemanticHighlightingManager.HighlightedPosition[] highlightedPositionArray2 = new SemanticHighlightingManager.HighlightedPosition[list2.size()];
        list2.toArray(highlightedPositionArray2);
        if (this.isCanceled()) {
            return null;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                SemanticHighlightingPresenter.this.updatePresentation(textPresentation, highlightedPositionArray, highlightedPositionArray2);
            }
        };
        return runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updatePresentation(TextPresentation textPresentation, SemanticHighlightingManager.HighlightedPosition[] highlightedPositionArray, SemanticHighlightingManager.HighlightedPosition[] highlightedPositionArray2) {
        if (this.fSourceViewer == null) {
            return;
        }
        if (this.isCanceled()) {
            return;
        }
        IDocument iDocument = this.fSourceViewer.getDocument();
        if (iDocument == null) {
            return;
        }
        String string = this.getPositionCategory();
        List<SemanticHighlightingManager.HighlightedPosition> list = Arrays.asList(highlightedPositionArray2);
        try {
            Object object = this.fPositionLock;
            synchronized (object) {
                List list2 = this.fPositions;
                int n = Math.max(this.fPositions.size() + highlightedPositionArray.length - highlightedPositionArray2.length, 10);
                ArrayList<Position> arrayList = new ArrayList<Position>(n);
                Position position = null;
                SemanticHighlightingManager.HighlightedPosition highlightedPosition = null;
                int n2 = 0;
                int n3 = 0;
                int n4 = list2.size();
                int n5 = highlightedPositionArray.length;
                block6: while (true) {
                    block17: {
                        block18: {
                            if (n2 >= n4 && position == null && n3 >= n5 && highlightedPosition == null) {
                                this.fPositions = arrayList;
                                break;
                            }
                            while (true) {
                                if (position != null || n2 >= n4) {
                                    if (highlightedPosition == null && n3 < n5) {
                                        highlightedPosition = highlightedPositionArray[n3++];
                                        iDocument.addPosition(string, (Position)highlightedPosition);
                                    }
                                    if (position == null) break block17;
                                    if (highlightedPosition != null) {
                                        if (position.getOffset() > highlightedPosition.getOffset()) break;
                                        arrayList.add(position);
                                        position = null;
                                        continue block6;
                                    }
                                    break block18;
                                }
                                if (!(position = (Position)list2.get(n2++)).isDeleted() && !this.contain(list, position)) continue;
                                iDocument.removePosition(string, position);
                                position = null;
                            }
                            arrayList.add(highlightedPosition);
                            highlightedPosition = null;
                            continue;
                        }
                        arrayList.add(position);
                        position = null;
                        continue;
                    }
                    if (highlightedPosition == null) continue;
                    arrayList.add(highlightedPosition);
                    highlightedPosition = null;
                }
            }
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            JavaPlugin.log(badPositionCategoryException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        if (textPresentation != null) {
            this.fSourceViewer.changeTextPresentation(textPresentation, false);
            return;
        }
        this.fSourceViewer.invalidateTextPresentation();
    }

    private boolean contain(List list, Position position) {
        return this.indexOf(list, position) != -1;
    }

    private int indexOf(List list, Position position) {
        int n = this.computeIndexAtOffset(list, position.getOffset());
        int n2 = list.size();
        while (n < n2) {
            if (list.get(n) == position) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void insertPosition(Position position) {
        int n = this.computeIndexAfterOffset(this.fPositions, position.getOffset());
        this.fPositions.add(n, position);
    }

    private int computeIndexAfterOffset(List list, int n) {
        int n2 = -1;
        int n3 = list.size();
        while (n3 - n2 > 1) {
            int n4 = n2 + n3 >> 1;
            Position position = (Position)list.get(n4);
            if (position.getOffset() > n) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        return n3;
    }

    private int computeIndexAtOffset(List list, int n) {
        int n2 = -1;
        int n3 = list.size();
        while (n3 - n2 > 1) {
            int n4 = n2 + n3 >> 1;
            Position position = (Position)list.get(n4);
            if (position.getOffset() >= n) {
                n3 = n4;
                continue;
            }
            n2 = n4;
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void applyTextPresentation(TextPresentation var1_1) {
        block4: {
            var2_2 = var1_1.getExtent();
            var3_3 = this.computeIndexAtOffset(this.fPositions, var2_2.getOffset());
            var4_4 = this.computeIndexAtOffset(this.fPositions, var2_2.getOffset() + var2_2.getLength());
            if (var4_4 - var3_3 <= 2) ** GOTO lbl21
            var5_5 = new ArrayList<StyleRange>(var4_4 - var3_3);
            while (var3_3 < var4_4) {
                var6_7 /* !! */  = (SemanticHighlightingManager.HighlightedPosition)this.fPositions.get(var3_3);
                if (!var6_7 /* !! */ .isDeleted()) {
                    var5_5.add(var6_7 /* !! */ .createStyleRange());
                }
                ++var3_3;
            }
            var6_7 /* !! */  = new StyleRange[var5_5.size()];
            var6_7 /* !! */  = var5_5.toArray(var6_7 /* !! */ );
            var1_1.replaceStyleRanges(var6_7 /* !! */ );
            break block4;
lbl-1000:
            // 1 sources

            {
                var5_6 = (SemanticHighlightingManager.HighlightedPosition)this.fPositions.get(var3_3);
                if (!var5_6.isDeleted()) {
                    var1_1.replaceStyleRange(var5_6.createStyleRange());
                }
                ++var3_3;
lbl21:
                // 2 sources

                ** while (var3_3 < var4_4)
            }
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument iDocument, IDocument iDocument2) {
        this.setCanceled(true);
        this.releaseDocument(iDocument);
        this.resetState();
    }

    public void inputDocumentChanged(IDocument iDocument, IDocument iDocument2) {
        this.manageDocument(iDocument2);
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
        this.setCanceled(true);
    }

    public void documentChanged(DocumentEvent documentEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCanceled() {
        IDocument iDocument;
        IDocument iDocument2 = iDocument = this.fSourceViewer != null ? this.fSourceViewer.getDocument() : null;
        if (iDocument == null) {
            return this.fIsCanceled;
        }
        Object object = this.getLockObject(iDocument);
        synchronized (object) {
            return this.fIsCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanceled(boolean bl) {
        IDocument iDocument;
        IDocument iDocument2 = iDocument = this.fSourceViewer != null ? this.fSourceViewer.getDocument() : null;
        if (iDocument == null) {
            this.fIsCanceled = bl;
            return;
        }
        Object object = this.getLockObject(iDocument);
        synchronized (object) {
            this.fIsCanceled = bl;
        }
    }

    private Object getLockObject(IDocument iDocument) {
        Object object;
        if (iDocument instanceof ISynchronizable && (object = ((ISynchronizable)iDocument).getLockObject()) != null) {
            return object;
        }
        return iDocument;
    }

    public void install(JavaSourceViewer javaSourceViewer, JavaPresentationReconciler javaPresentationReconciler) {
        this.fSourceViewer = javaSourceViewer;
        this.fPresentationReconciler = javaPresentationReconciler;
        this.fSourceViewer.prependTextPresentationListener(this);
        this.fSourceViewer.addTextInputListener(this);
        this.manageDocument(this.fSourceViewer.getDocument());
    }

    public void uninstall() {
        this.setCanceled(true);
        if (this.fSourceViewer != null) {
            this.fSourceViewer.removeTextPresentationListener(this);
            this.releaseDocument(this.fSourceViewer.getDocument());
            this.invalidateTextPresentation();
            this.resetState();
            this.fSourceViewer.removeTextInputListener(this);
            this.fSourceViewer = null;
        }
    }

    public void highlightingStyleChanged(SemanticHighlightingManager.Highlighting highlighting) {
        int n = 0;
        int n2 = this.fPositions.size();
        while (n < n2) {
            SemanticHighlightingManager.HighlightedPosition highlightedPosition = (SemanticHighlightingManager.HighlightedPosition)((Object)this.fPositions.get(n));
            if (highlightedPosition.getHighlighting() == highlighting) {
                this.fSourceViewer.invalidateTextPresentation(highlightedPosition.getOffset(), highlightedPosition.getLength());
            }
            ++n;
        }
    }

    private void invalidateTextPresentation() {
        int n = 0;
        int n2 = this.fPositions.size();
        while (n < n2) {
            Position position = (Position)this.fPositions.get(n);
            this.fSourceViewer.invalidateTextPresentation(position.getOffset(), position.getLength());
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPositionFromUI(int n, int n2, SemanticHighlightingManager.Highlighting highlighting) {
        SemanticHighlightingManager.HighlightedPosition highlightedPosition = this.createHighlightedPosition(n, n2, highlighting);
        Object object = this.fPositionLock;
        synchronized (object) {
            this.insertPosition(highlightedPosition);
        }
        object = this.fSourceViewer.getDocument();
        if (object == null) {
            return;
        }
        String string = this.getPositionCategory();
        try {
            object.addPosition(string, (Position)highlightedPosition);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            JavaPlugin.log(badPositionCategoryException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetState() {
        Object object = this.fPositionLock;
        synchronized (object) {
            this.fPositions.clear();
        }
    }

    private void manageDocument(IDocument iDocument) {
        if (iDocument != null) {
            iDocument.addPositionCategory(this.getPositionCategory());
            iDocument.addPositionUpdater(this.fPositionUpdater);
            iDocument.addDocumentListener((IDocumentListener)this);
        }
    }

    private void releaseDocument(IDocument iDocument) {
        if (iDocument != null) {
            iDocument.removeDocumentListener((IDocumentListener)this);
            iDocument.removePositionUpdater(this.fPositionUpdater);
            try {
                iDocument.removePositionCategory(this.getPositionCategory());
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                JavaPlugin.log(badPositionCategoryException);
            }
        }
    }

    private String getPositionCategory() {
        return this.toString();
    }

    private class HighlightingPositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public HighlightingPositionUpdater(String string) {
            this.fCategory = string;
        }

        public void update(DocumentEvent documentEvent) {
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            int n3 = n + n2;
            try {
                Position[] positionArray = documentEvent.getDocument().getPositions(this.fCategory);
                int n4 = 0;
                while (n4 != positionArray.length) {
                    SemanticHighlightingManager.HighlightedPosition highlightedPosition = (SemanticHighlightingManager.HighlightedPosition)positionArray[n4];
                    int n5 = highlightedPosition.getOffset();
                    int n6 = highlightedPosition.getLength();
                    int n7 = n5 + n6;
                    if (n5 > n3) {
                        this.updateWithPrecedingEvent(highlightedPosition, documentEvent);
                    } else if (n7 < n) {
                        this.updateWithSucceedingEvent(highlightedPosition, documentEvent);
                    } else if (n5 <= n && n7 >= n3) {
                        this.updateWithIncludedEvent(highlightedPosition, documentEvent);
                    } else if (n5 <= n) {
                        this.updateWithOverEndEvent(highlightedPosition, documentEvent);
                    } else if (n7 >= n3) {
                        this.updateWithOverStartEvent(highlightedPosition, documentEvent);
                    } else {
                        this.updateWithIncludingEvent(highlightedPosition, documentEvent);
                    }
                    ++n4;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        private void updateWithPrecedingEvent(SemanticHighlightingManager.HighlightedPosition highlightedPosition, DocumentEvent documentEvent) {
            String string = documentEvent.getText();
            int n = string != null ? string.length() : 0;
            int n2 = n - documentEvent.getLength();
            highlightedPosition.setOffset(highlightedPosition.getOffset() + n2);
        }

        private void updateWithSucceedingEvent(SemanticHighlightingManager.HighlightedPosition highlightedPosition, DocumentEvent documentEvent) {
        }

        private void updateWithIncludedEvent(SemanticHighlightingManager.HighlightedPosition highlightedPosition, DocumentEvent documentEvent) {
            int n = documentEvent.getOffset();
            String string = documentEvent.getText();
            if (string == null) {
                string = "";
            }
            int n2 = string.length();
            int n3 = n2 - documentEvent.getLength();
            int n4 = highlightedPosition.getOffset();
            int n5 = highlightedPosition.getLength();
            int n6 = n4 + n5;
            int n7 = 0;
            while (n7 < n2 && Character.isJavaIdentifierPart(string.charAt(n7))) {
                ++n7;
            }
            if (n7 == n2) {
                highlightedPosition.setLength(n5 + n3);
            } else {
                int n8 = n - n4 + n7;
                int n9 = n2;
                while (n9 > 0 && Character.isJavaIdentifierPart(string.charAt(n9 - 1))) {
                    --n9;
                }
                int n10 = n + n9;
                int n11 = n6 + n3 - n10;
                if (n11 == 0) {
                    highlightedPosition.setLength(n8);
                } else if (n8 == 0) {
                    highlightedPosition.update(n10, n11);
                } else {
                    highlightedPosition.setLength(n8);
                    SemanticHighlightingPresenter.this.addPositionFromUI(n10, n11, highlightedPosition.getHighlighting());
                }
            }
        }

        private void updateWithOverEndEvent(SemanticHighlightingManager.HighlightedPosition highlightedPosition, DocumentEvent documentEvent) {
            String string = documentEvent.getText();
            if (string == null) {
                string = "";
            }
            int n = string.length();
            int n2 = 0;
            while (n2 < n && Character.isJavaIdentifierPart(string.charAt(n2))) {
                ++n2;
            }
            highlightedPosition.setLength(documentEvent.getOffset() - highlightedPosition.getOffset() + n2);
        }

        private void updateWithOverStartEvent(SemanticHighlightingManager.HighlightedPosition highlightedPosition, DocumentEvent documentEvent) {
            int n;
            int n2 = documentEvent.getOffset();
            int n3 = n2 + documentEvent.getLength();
            String string = documentEvent.getText();
            if (string == null) {
                string = "";
            }
            int n4 = n = string.length();
            while (n4 > 0 && Character.isJavaIdentifierPart(string.charAt(n4 - 1))) {
                --n4;
            }
            int n5 = n3 - highlightedPosition.getOffset();
            int n6 = n - n4;
            highlightedPosition.update(n2 + n4, highlightedPosition.getLength() - n5 + n6);
        }

        private void updateWithIncludingEvent(SemanticHighlightingManager.HighlightedPosition highlightedPosition, DocumentEvent documentEvent) {
            highlightedPosition.delete();
            highlightedPosition.update(documentEvent.getOffset(), 0);
        }
    }
}

