/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.wst.jsdt.ui.IWorkingCopyManager;
import org.eclipse.wst.jsdt.ui.IWorkingCopyManagerExtension;

public class WorkingCopyManager
implements IWorkingCopyManager,
IWorkingCopyManagerExtension {
    private ICompilationUnitDocumentProvider fDocumentProvider;
    private Map fMap;
    private boolean fIsShuttingDown;

    public WorkingCopyManager(ICompilationUnitDocumentProvider iCompilationUnitDocumentProvider) {
        Assert.isNotNull((Object)iCompilationUnitDocumentProvider);
        this.fDocumentProvider = iCompilationUnitDocumentProvider;
    }

    public void connect(IEditorInput iEditorInput) throws CoreException {
        this.fDocumentProvider.connect(iEditorInput);
    }

    public void disconnect(IEditorInput iEditorInput) {
        this.fDocumentProvider.disconnect(iEditorInput);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        if (this.fIsShuttingDown) return;
        this.fIsShuttingDown = true;
        try {
            if (this.fMap != null) {
                this.fMap.clear();
                this.fMap = null;
            }
            this.fDocumentProvider.shutdown();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fIsShuttingDown = false;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.fIsShuttingDown = false;
            return;
        }
    }

    public ICompilationUnit getWorkingCopy(IEditorInput iEditorInput) {
        return this.getWorkingCopy(iEditorInput, true);
    }

    public ICompilationUnit getWorkingCopy(IEditorInput iEditorInput, boolean bl) {
        ICompilationUnit iCompilationUnit;
        ICompilationUnit iCompilationUnit2 = iCompilationUnit = this.fMap == null ? null : (ICompilationUnit)this.fMap.get(iEditorInput);
        if (iCompilationUnit == null) {
            iCompilationUnit = this.fDocumentProvider.getWorkingCopy(iEditorInput);
        }
        if (iCompilationUnit != null && (!bl || JavaModelUtil.isPrimary(iCompilationUnit))) {
            return iCompilationUnit;
        }
        return null;
    }

    public void setWorkingCopy(IEditorInput iEditorInput, ICompilationUnit iCompilationUnit) {
        if (this.fDocumentProvider.getDocument(iEditorInput) != null) {
            if (this.fMap == null) {
                this.fMap = new HashMap();
            }
            this.fMap.put(iEditorInput, iCompilationUnit);
        }
    }

    public void removeWorkingCopy(IEditorInput iEditorInput) {
        this.fMap.remove(iEditorInput);
        if (this.fMap.isEmpty()) {
            this.fMap = null;
        }
    }
}

