/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.navigator;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.IExtensionStateModel;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.JavaModelException;

public abstract class NonEssentialElementsFilter
extends ViewerFilter {
    private static final String JAVA_EXTENSION_ID = "org.eclipse.wst.jsdt.java.ui.javaContent";
    private boolean isStateModelInitialized = false;
    private IExtensionStateModel fStateModel = null;
    private INavigatorContentService fContentService;
    private ViewerFilter fDelegateFilter;

    protected NonEssentialElementsFilter(ViewerFilter viewerFilter) {
        this.fDelegateFilter = viewerFilter;
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        if (!this.isStateModelInitialized) {
            this.initStateModel(viewer);
        }
        if (this.fContentService == null || this.fStateModel == null) {
            return true;
        }
        if (object2 instanceof IPackageFragment && this.isApplicable() && viewer instanceof StructuredViewer) {
            boolean bl = !this.fStateModel.getBooleanProperty("isLayoutFlat");
            try {
                IPackageFragment iPackageFragment = (IPackageFragment)object2;
                if (bl && !iPackageFragment.isDefaultPackage() && iPackageFragment.hasSubpackages()) {
                    return this.hasFilteredChildren((StructuredViewer)viewer, iPackageFragment);
                }
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
        return this.doSelect(viewer, object, object2);
    }

    private boolean hasFilteredChildren(StructuredViewer structuredViewer, IPackageFragment iPackageFragment) {
        Object[] objectArray = this.getRawChildren(structuredViewer, iPackageFragment);
        ViewerFilter[] viewerFilterArray = structuredViewer.getFilters();
        int n = 0;
        while (n < viewerFilterArray.length) {
            if ((objectArray = viewerFilterArray[n].filter((Viewer)structuredViewer, (Object)iPackageFragment, objectArray)).length == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private Object[] getRawChildren(StructuredViewer structuredViewer, IPackageFragment iPackageFragment) {
        IStructuredContentProvider iStructuredContentProvider = (IStructuredContentProvider)structuredViewer.getContentProvider();
        if (iStructuredContentProvider instanceof ITreeContentProvider) {
            return ((ITreeContentProvider)iStructuredContentProvider).getChildren((Object)iPackageFragment);
        }
        return iStructuredContentProvider.getElements((Object)iPackageFragment);
    }

    protected boolean doSelect(Viewer viewer, Object object, Object object2) {
        return this.fDelegateFilter.select(viewer, object, object2);
    }

    private boolean isApplicable() {
        return this.fContentService != null && this.fContentService.isVisible(JAVA_EXTENSION_ID) && this.fContentService.isActive(JAVA_EXTENSION_ID);
    }

    private synchronized void initStateModel(Viewer viewer) {
        if (!this.isStateModelInitialized && viewer instanceof CommonViewer) {
            CommonViewer commonViewer = (CommonViewer)viewer;
            this.fContentService = commonViewer.getNavigatorContentService();
            this.fStateModel = this.fContentService.findStateModel(JAVA_EXTENSION_ID);
            this.isStateModelInitialized = true;
        }
    }
}

