/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

class FileTransferDragAdapter
extends DragSourceAdapter
implements TransferDragSourceListener {
    private ISelectionProvider fProvider;
    static /* synthetic */ Class class$0;

    FileTransferDragAdapter(ISelectionProvider iSelectionProvider) {
        this.fProvider = iSelectionProvider;
        Assert.isNotNull((Object)this.fProvider);
    }

    public Transfer getTransfer() {
        return FileTransfer.getInstance();
    }

    public void dragStart(DragSourceEvent dragSourceEvent) {
        dragSourceEvent.doit = this.isDragable(this.fProvider.getSelection());
    }

    private boolean isDragable(ISelection iSelection) {
        if (!(iSelection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        Object object = iStructuredSelection.iterator();
        while (object.hasNext()) {
            Object e = object.next();
            if (!(e instanceof IJavaElement)) continue;
            IJavaElement iJavaElement = (IJavaElement)e;
            int n = iJavaElement.getElementType();
            if (n != 3 && n != 5 && n != 7) {
                return false;
            }
            IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement.getAncestor(3);
            if (iPackageFragmentRoot == null || !iPackageFragmentRoot.isArchive()) continue;
            return false;
        }
        object = this.convertIntoResources(iStructuredSelection);
        return object.size() == iStructuredSelection.size();
    }

    public void dragSetData(DragSourceEvent dragSourceEvent) {
        List list = this.getResources();
        if (list == null || list.size() == 0) {
            dragSourceEvent.data = null;
            return;
        }
        dragSourceEvent.data = FileTransferDragAdapter.getResourceLocations(list);
    }

    private static String[] getResourceLocations(List list) {
        return Resources.getLocationOSStrings(list.toArray(new IResource[list.size()]));
    }

    public void dragFinished(DragSourceEvent dragSourceEvent) {
        if (!dragSourceEvent.doit) {
            return;
        }
        if (dragSourceEvent.detail != 2 && (dragSourceEvent.detail == 0 || dragSourceEvent.detail == 8)) {
            this.handleRefresh(dragSourceEvent);
        }
    }

    void handleDropMove(DragSourceEvent dragSourceEvent) {
        final List list = this.getResources();
        if (list == null || list.size() == 0) {
            return;
        }
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    iProgressMonitor.beginTask(PackagesMessages.DragAdapter_deleting, list.size());
                    MultiStatus multiStatus = FileTransferDragAdapter.this.createMultiStatus();
                    Iterator iterator = list.iterator();
                    while (true) {
                        Object var6_6;
                        if (!iterator.hasNext()) {
                            if (multiStatus.isOK()) break;
                            throw new CoreException((IStatus)multiStatus);
                        }
                        IResource iResource = (IResource)iterator.next();
                        try {
                            try {
                                iProgressMonitor.subTask(iResource.getFullPath().toOSString());
                                iResource.delete(true, null);
                            }
                            catch (CoreException coreException) {
                                multiStatus.add(coreException.getStatus());
                            }
                        }
                        catch (Throwable throwable) {
                            var6_6 = null;
                            iProgressMonitor.worked(1);
                            throw throwable;
                        }
                        {
                            var6_6 = null;
                        }
                        iProgressMonitor.worked(1);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var8_10 = null;
                }
                iProgressMonitor.done();
            }
        };
        this.runOperation((IRunnableWithProgress)workspaceModifyOperation, true, false);
    }

    private void handleRefresh(DragSourceEvent dragSourceEvent) {
        final Set set = this.collectRoots(this.getResources());
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    iProgressMonitor.beginTask(PackagesMessages.DragAdapter_refreshing, set.size());
                    MultiStatus multiStatus = FileTransferDragAdapter.this.createMultiStatus();
                    Iterator iterator = set.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            if (multiStatus.isOK()) break;
                            throw new CoreException((IStatus)multiStatus);
                        }
                        IResource iResource = (IResource)iterator.next();
                        try {
                            iResource.refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        }
                        catch (CoreException coreException) {
                            multiStatus.add(coreException.getStatus());
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var6_8 = null;
                }
                iProgressMonitor.done();
            }
        };
        this.runOperation((IRunnableWithProgress)workspaceModifyOperation, true, false);
    }

    protected Set collectRoots(List list) {
        HashSet<Object> hashSet = new HashSet<Object>(10);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IResource iResource = (IResource)iterator.next();
            IContainer iContainer = iResource.getParent();
            if (iContainer == null) {
                hashSet.add(iResource);
                continue;
            }
            hashSet.add(iContainer);
        }
        return hashSet;
    }

    private List getResources() {
        ISelection iSelection = this.fProvider.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return null;
        }
        return this.convertIntoResources((IStructuredSelection)iSelection);
    }

    private List convertIntoResources(IStructuredSelection iStructuredSelection) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            IResource iResource = null;
            if (e instanceof IResource) {
                iResource = (IResource)e;
            } else if (e instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
            }
            if (iResource == null || iResource.getLocation() == null) continue;
            arrayList.add(iResource);
        }
        return arrayList;
    }

    private MultiStatus createMultiStatus() {
        return new MultiStatus(JavaPlugin.getPluginId(), 0, PackagesMessages.DragAdapter_problem, null);
    }

    private void runOperation(IRunnableWithProgress iRunnableWithProgress, boolean bl, boolean bl2) {
        try {
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            new ProgressMonitorDialog(shell).run(bl, bl2, iRunnableWithProgress);
        }
        catch (InvocationTargetException invocationTargetException) {
            String string = PackagesMessages.DragAdapter_problem;
            String string2 = PackagesMessages.DragAdapter_problemTitle;
            ExceptionHandler.handle(invocationTargetException, string2, string);
        }
        catch (InterruptedException interruptedException) {}
    }
}

