/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJarEntryResource;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModel;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.filters.OutputFolderFilter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.CustomHashtable;
import org.eclipse.wst.jsdt.internal.ui.packageview.FileTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.FileTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerActionGroup;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageExplorerLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.SelectionTransferDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.packageview.WorkingSetAwareContentProvider;
import org.eclipse.wst.jsdt.internal.ui.packageview.WorkingSetAwareJavaElementSorter;
import org.eclipse.wst.jsdt.internal.ui.packageview.WorkingSetDropAdapter;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.wst.jsdt.internal.ui.util.JavaUIHelp;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ColoredViewersManager;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.DecoratingJavaLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.FilterUpdater;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.IViewPartInputProvider;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.StatusBarUpdater;
import org.eclipse.wst.jsdt.internal.ui.workingsets.ConfigureWorkingSetAction;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetFilterActionGroup;
import org.eclipse.wst.jsdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.wst.jsdt.ui.IPackagesViewPart;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.StandardJavaElementContentProvider;
import org.eclipse.wst.jsdt.ui.actions.CustomFiltersActionGroup;

public class PackageExplorerPart
extends ViewPart
implements ISetSelectionTarget,
IMenuListener,
IShowInTarget,
IPackagesViewPart,
IPropertyChangeListener,
IViewPartInputProvider {
    private static final String PERF_CREATE_PART_CONTROL = "org.eclipse.wst.jsdt.ui/perf/explorer/createPartControl";
    private static final String PERF_MAKE_ACTIONS = "org.eclipse.wst.jsdt.ui/perf/explorer/makeActions";
    private static final int HIERARCHICAL_LAYOUT = 1;
    private static final int FLAT_LAYOUT = 2;
    private static final String VIEW_ID = "org.eclipse.wst.jsdt.ui.PackageExplorer";
    private static final String TAG_LAYOUT = "layout";
    private static final String TAG_GROUP_LIBRARIES = "group_libraries";
    private static final String TAG_ROOT_MODE = "rootMode";
    private static final String TAG_LINK_EDITOR = "linkWithEditor";
    private static final String TAG_MEMENTO = "memento";
    private boolean fIsCurrentLayoutFlat = false;
    private boolean fShowLibrariesNode;
    private boolean fLinkingEnabled;
    private int fRootMode;
    private WorkingSetModel fWorkingSetModel;
    private PackageExplorerLabelProvider fLabelProvider;
    private DecoratingJavaLabelProvider fDecoratingLabelProvider;
    private PackageExplorerContentProvider fContentProvider;
    private FilterUpdater fFilterUpdater;
    private PackageExplorerActionGroup fActionSet;
    private ProblemTreeViewer fViewer;
    private Menu fContextMenu;
    private IMemento fMemento;
    private ISelection fLastOpenSelection;
    private final ISelectionChangedListener fPostSelectionListener;
    private String fWorkingSetLabel;
    private IDialogSettings fDialogSettings;
    private IPartListener2 fLinkWithEditorListener = new IPartListener2(){

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference instanceof IEditorReference) {
                PackageExplorerPart.this.editorActivated(((IEditorReference)iWorkbenchPartReference).getEditor(true));
            }
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            if (iWorkbenchPartReference instanceof IEditorReference) {
                PackageExplorerPart.this.editorActivated(((IEditorReference)iWorkbenchPartReference).getEditor(true));
            }
        }
    };
    private ITreeViewerListener fExpansionListener = new ITreeViewerListener(){

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            Object object = treeExpansionEvent.getElement();
            if (object instanceof ICompilationUnit || object instanceof IClassFile) {
                PackageExplorerPart.this.expandMainType(object);
            }
        }
    };
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public PackageExplorerPart() {
        this.fPostSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                PackageExplorerPart.this.handlePostSelectionChanged(selectionChangedEvent);
            }
        };
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettingsSection(this.getClass().getName());
        this.fShowLibrariesNode = this.fDialogSettings.get(TAG_GROUP_LIBRARIES) == null || this.fDialogSettings.getBoolean(TAG_GROUP_LIBRARIES);
        this.fLinkingEnabled = this.fDialogSettings.getBoolean(TAG_LINK_EDITOR);
        try {
            this.fIsCurrentLayoutFlat = this.fDialogSettings.getInt(TAG_LAYOUT) == 2;
        }
        catch (NumberFormatException numberFormatException) {
            this.fIsCurrentLayoutFlat = false;
        }
        try {
            this.fRootMode = this.fDialogSettings.getInt(TAG_ROOT_MODE);
        }
        catch (NumberFormatException numberFormatException) {
            this.fRootMode = 1;
        }
    }

    public void init(IViewSite iViewSite, IMemento iMemento) throws PartInitException {
        String string;
        super.init(iViewSite, iMemento);
        if (iMemento == null && (string = this.fDialogSettings.get(TAG_MEMENTO)) != null) {
            try {
                iMemento = XMLMemento.createReadRoot((Reader)new StringReader(string));
            }
            catch (WorkbenchException workbenchException) {}
        }
        this.fMemento = iMemento;
        if (iMemento != null) {
            this.restoreLayoutState(iMemento);
            this.restoreLinkingEnabled(iMemento);
            this.restoreRootMode(iMemento);
        }
        if (this.showWorkingSets()) {
            this.createWorkingSetModel();
        }
    }

    private void restoreRootMode(IMemento iMemento) {
        Integer n = iMemento.getInteger(TAG_ROOT_MODE);
        int n2 = this.fRootMode = n == null ? 1 : n;
        if (this.fRootMode != 1 && this.fRootMode != 2) {
            this.fRootMode = 1;
        }
    }

    private void restoreLayoutState(IMemento iMemento) {
        Integer n = iMemento.getInteger(TAG_LAYOUT);
        this.fIsCurrentLayoutFlat = n == null || n == 2;
        Integer n2 = iMemento.getInteger(TAG_GROUP_LIBRARIES);
        this.fShowLibrariesNode = n2 == null || n2 != 0;
    }

    public static PackageExplorerPart getFromActivePerspective() {
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage == null) {
            return null;
        }
        IViewPart iViewPart = iWorkbenchPage.findView(VIEW_ID);
        if (iViewPart instanceof PackageExplorerPart) {
            return (PackageExplorerPart)iViewPart;
        }
        return null;
    }

    public static PackageExplorerPart openInActivePerspective() {
        try {
            return (PackageExplorerPart)JavaPlugin.getActivePage().showView(VIEW_ID);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void dispose() {
        XMLMemento xMLMemento = XMLMemento.createWriteRoot((String)"packageExplorer");
        this.saveState((IMemento)xMLMemento);
        StringWriter stringWriter = new StringWriter();
        try {
            xMLMemento.save((Writer)stringWriter);
            this.fDialogSettings.put(TAG_MEMENTO, stringWriter.getBuffer().toString());
        }
        catch (IOException iOException) {}
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        this.getSite().getPage().removePartListener(this.fLinkWithEditorListener);
        JavaPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        if (this.fViewer != null) {
            this.fViewer.removeTreeListener(this.fExpansionListener);
        }
        if (this.fActionSet != null) {
            this.fActionSet.dispose();
        }
        if (this.fFilterUpdater != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        }
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.dispose();
        }
        super.dispose();
    }

    public void createPartControl(Composite composite) {
        PerformanceStats performanceStats = PerformanceStats.getStats((String)PERF_CREATE_PART_CONTROL, (Object)this);
        performanceStats.startRun();
        this.fViewer = this.createViewer(composite);
        this.fViewer.setUseHashlookup(true);
        this.initDragAndDrop();
        this.setProviders();
        JavaPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fViewer.getTree());
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        iWorkbenchPartSite.registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.fViewer);
        this.makeActions();
        this.restoreFilterAndSorter();
        this.fViewer.setInput(this.findInputElement());
        this.initFrameActions();
        this.initKeyListener();
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                PackageExplorerPart.this.fActionSet.handleDoubleClick(doubleClickEvent);
            }
        });
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent openEvent) {
                PackageExplorerPart.this.fActionSet.handleOpen(openEvent);
                PackageExplorerPart.this.fLastOpenSelection = openEvent.getSelection();
            }
        });
        IStatusLineManager iStatusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(iStatusLineManager));
        this.fViewer.addTreeListener(this.fExpansionListener);
        JavaUIHelp.setHelp((StructuredViewer)this.fViewer, "org.eclipse.wst.jsdt.ui.package_view_context");
        this.fillActionBars();
        this.updateTitle();
        this.fFilterUpdater = new FilterUpdater(this.fViewer);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fFilterUpdater);
        this.setLinkingEnabled(this.isLinkingEnabled());
        performanceStats.endRun();
    }

    private void initFrameActions() {
        this.fActionSet.getUpAction().update();
        this.fActionSet.getBackAction().update();
        this.fActionSet.getForwardAction().update();
    }

    private ProblemTreeViewer createViewer(Composite composite) {
        return new PackageExplorerProblemTreeViewer(composite, 770);
    }

    public boolean isFlatLayout() {
        return this.fIsCurrentLayoutFlat;
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fContentProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fContentProvider.setShowLibrariesNode(this.fShowLibrariesNode);
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setComparer(this.createElementComparer());
        this.fLabelProvider = this.createLabelProvider();
        this.fLabelProvider.setIsFlatLayout(this.fIsCurrentLayoutFlat);
        this.fDecoratingLabelProvider = new DecoratingJavaLabelProvider(this.fLabelProvider, false, this.fIsCurrentLayoutFlat);
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fDecoratingLabelProvider);
    }

    public void setShowLibrariesNode(boolean bl) {
        this.fShowLibrariesNode = bl;
        this.saveDialogSettings();
        this.fContentProvider.setShowLibrariesNode(bl);
        this.fViewer.getControl().setRedraw(false);
        this.fViewer.refresh();
        this.fViewer.getControl().setRedraw(true);
    }

    boolean isLibrariesNodeShown() {
        return this.fShowLibrariesNode;
    }

    public void setFlatLayout(boolean bl) {
        this.fIsCurrentLayoutFlat = bl;
        this.saveDialogSettings();
        if (this.fViewer != null) {
            this.fContentProvider.setIsFlatLayout(this.isFlatLayout());
            this.fLabelProvider.setIsFlatLayout(this.isFlatLayout());
            this.fDecoratingLabelProvider.setFlatPackageMode(this.isFlatLayout());
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.refresh();
            this.fViewer.getControl().setRedraw(true);
        }
    }

    public PackageExplorerContentProvider createContentProvider() {
        IPreferenceStore iPreferenceStore = PreferenceConstants.getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("org.eclipse.wst.jsdt.ui.packages.cuchildren");
        if (this.showProjects()) {
            return new PackageExplorerContentProvider(bl);
        }
        return new WorkingSetAwareContentProvider(bl, this.fWorkingSetModel);
    }

    private PackageExplorerLabelProvider createLabelProvider() {
        return new PackageExplorerLabelProvider(this.fContentProvider);
    }

    private IElementComparer createElementComparer() {
        if (this.showProjects()) {
            return null;
        }
        return WorkingSetModel.COMPARER;
    }

    private void fillActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fActionSet.fillActionBars(iActionBars);
    }

    private Object findInputElement() {
        if (this.showWorkingSets()) {
            return this.fWorkingSetModel;
        }
        IAdaptable iAdaptable = this.getSite().getPage().getInput();
        if (iAdaptable instanceof IWorkspace) {
            return JavaCore.create((IWorkspaceRoot)((IWorkspace)iAdaptable).getRoot());
        }
        if (iAdaptable instanceof IContainer) {
            IJavaElement iJavaElement = JavaCore.create((IResource)((IContainer)iAdaptable));
            if (iJavaElement != null && iJavaElement.exists()) {
                return iJavaElement;
            }
            return iAdaptable;
        }
        return JavaCore.create((IWorkspaceRoot)JavaPlugin.getWorkspace().getRoot());
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.jface.viewers.ISelectionProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(clazz2)) {
            return this.fViewer;
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return this.getShowInSource();
        }
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz4) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.ui.views.ResourceNavigator"};
                }
            };
        }
        Class<?> clazz5 = class$3;
        if (clazz5 == null) {
            try {
                clazz5 = class$3 = Class.forName("org.eclipse.help.IContextProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz5) {
            return JavaUIHelp.getHelpContextProvider((IWorkbenchPart)this, "org.eclipse.wst.jsdt.ui.package_view_context");
        }
        return super.getAdapter(clazz);
    }

    String getToolTipText(Object object) {
        IPath iPath;
        String string = !(object instanceof IResource) ? (object instanceof IJavaModel ? PackagesMessages.PackageExplorerPart_workspace : (object instanceof IJavaElement ? JavaElementLabels.getTextLabel(object, JavaElementLabels.ALL_FULLY_QUALIFIED) : (object instanceof IWorkingSet ? ((IWorkingSet)object).getLabel() : (object instanceof WorkingSetModel ? PackagesMessages.PackageExplorerPart_workingSetModel : this.fLabelProvider.getText(object))))) : ((iPath = ((IResource)object).getFullPath()).isRoot() ? PackagesMessages.PackageExplorer_title : iPath.makeRelative().toString());
        if (this.fRootMode == 1) {
            if (this.fWorkingSetLabel == null) {
                return string;
            }
            if (string.length() == 0) {
                return Messages.format(PackagesMessages.PackageExplorer_toolTip, new String[]{this.fWorkingSetLabel});
            }
            return Messages.format(PackagesMessages.PackageExplorer_toolTip2, new String[]{string, this.fWorkingSetLabel});
        }
        if (object != null && !(object instanceof IWorkingSet) && !(object instanceof WorkingSetModel) && this.fActionSet != null) {
            iPath = this.fActionSet.getFrameList();
            int n = iPath.getCurrentIndex();
            IWorkingSet iWorkingSet = null;
            while (n >= 0) {
                Object object2;
                Frame frame = iPath.getFrame(n);
                if (frame instanceof TreeFrame && (object2 = ((TreeFrame)frame).getInput()) instanceof IWorkingSet) {
                    iWorkingSet = (IWorkingSet)object2;
                    break;
                }
                --n;
            }
            if (iWorkingSet != null) {
                return Messages.format(PackagesMessages.PackageExplorer_toolTip3, new String[]{iWorkingSet.getLabel(), string});
            }
            return string;
        }
        return string;
    }

    public String getTitleToolTip() {
        if (this.fViewer == null) {
            return super.getTitleToolTip();
        }
        return this.getToolTipText(this.fViewer.getInput());
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    private ISelection getSelection() {
        return this.fViewer.getSelection();
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        JavaPlugin.createStandardGroups(iMenuManager);
        this.fActionSet.setContext(new ActionContext(this.getSelection()));
        this.fActionSet.fillContextMenu(iMenuManager);
        this.fActionSet.setContext(null);
    }

    private void makeActions() {
        PerformanceStats performanceStats = PerformanceStats.getStats((String)PERF_MAKE_ACTIONS, (Object)this);
        performanceStats.startRun();
        this.fActionSet = new PackageExplorerActionGroup(this);
        if (this.fWorkingSetModel != null) {
            this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
        }
        performanceStats.endRun();
    }

    private void initDragAndDrop() {
        this.initDrag();
        this.initDrop();
    }

    private void initDrag() {
        int n = 7;
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDragSourceListener[] transferDragSourceListenerArray = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.fViewer), new ResourceTransferDragAdapter((ISelectionProvider)this.fViewer), new FileTransferDragAdapter((ISelectionProvider)this.fViewer)};
        this.fViewer.addDragSupport(n, transferArray, new JdtViewerDragAdapter((StructuredViewer)this.fViewer, transferDragSourceListenerArray));
    }

    private void initDrop() {
        int n = 23;
        Transfer[] transferArray = new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()};
        TransferDropTargetListener[] transferDropTargetListenerArray = new TransferDropTargetListener[]{new SelectionTransferDropAdapter((StructuredViewer)this.fViewer), new FileTransferDropAdapter((AbstractTreeViewer)this.fViewer), new WorkingSetDropAdapter(this)};
        this.fViewer.addDropSupport(n, transferArray, new DelegatingDropAdapter(transferDropTargetListenerArray));
    }

    private void handlePostSelectionChanged(SelectionChangedEvent selectionChangedEvent) {
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (this.isLinkingEnabled() && !iSelection.equals(this.fLastOpenSelection)) {
            this.linkToEditor((IStructuredSelection)iSelection);
        }
        this.fLastOpenSelection = null;
    }

    public void selectReveal(ISelection iSelection) {
        Control control = this.getTreeViewer().getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        this.fContentProvider.runPendingUpdates();
        this.fViewer.setSelection(this.convertSelection(iSelection), true);
    }

    public ISelection convertSelection(ISelection iSelection) {
        if (!(iSelection instanceof IStructuredSelection)) {
            return iSelection;
        }
        Object[] objectArray = ((IStructuredSelection)iSelection).toArray();
        boolean bl = false;
        int n = 0;
        while (n < objectArray.length) {
            Object object = this.convertElement(objectArray[n]);
            bl = bl || object != objectArray[n];
            objectArray[n] = object;
            ++n;
        }
        if (bl) {
            return new StructuredSelection(objectArray);
        }
        return iSelection;
    }

    private Object convertElement(Object object) {
        if (object instanceof IJavaElement) {
            IResource iResource;
            ICompilationUnit iCompilationUnit;
            IJavaProject iJavaProject;
            if (object instanceof ICompilationUnit && (iJavaProject = (iCompilationUnit = (ICompilationUnit)object).getJavaProject()) != null && iJavaProject.exists() && !iJavaProject.isOnClasspath((IJavaElement)iCompilationUnit) && (iResource = iCompilationUnit.getResource()) != null) {
                return iResource;
            }
            return object;
        }
        if (object instanceof IResource) {
            IJavaProject iJavaProject;
            IJavaElement iJavaElement = JavaCore.create((IResource)((IResource)object));
            if (iJavaElement != null && iJavaElement.exists() && (iJavaProject = iJavaElement.getJavaProject()) != null && iJavaProject.exists()) {
                return iJavaElement;
            }
        } else if (object instanceof IAdaptable) {
            IResource iResource;
            IJavaElement iJavaElement;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iJavaElement = (IJavaElement)iAdaptable.getAdapter((Class)clazz)) != null && iJavaElement.exists()) {
                return iJavaElement;
            }
            Class<?> clazz2 = class$5;
            if (clazz2 == null) {
                try {
                    clazz2 = class$5 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz2)) != null) {
                iJavaElement = JavaCore.create((IResource)iResource);
                if (iJavaElement != null && iJavaElement.exists()) {
                    return iJavaElement;
                }
                return iResource;
            }
        }
        return object;
    }

    public void selectAndReveal(Object object) {
        this.selectReveal((ISelection)new StructuredSelection(object));
    }

    public boolean isLinkingEnabled() {
        return this.fLinkingEnabled;
    }

    private void linkToEditor(IStructuredSelection iStructuredSelection) {
        IEditorPart iEditorPart;
        if (!this.isActivePart()) {
            return;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (iStructuredSelection.size() == 1 && (iEditorPart = EditorUtility.isOpenInEditor(object)) != null) {
            IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
            if (object instanceof IJavaElement) {
                EditorUtility.revealInEditor(iEditorPart, (IJavaElement)object);
            }
        }
    }

    private boolean isActivePart() {
        return this == this.getSite().getPage().getActivePart();
    }

    public void saveState(IMemento iMemento) {
        if (this.fViewer == null && this.fMemento != null) {
            iMemento.putMemento(this.fMemento);
            return;
        }
        iMemento.putInteger(TAG_ROOT_MODE, this.fRootMode);
        if (this.fWorkingSetModel != null) {
            this.fWorkingSetModel.saveState(iMemento);
        }
        this.saveLayoutState(iMemento);
        this.saveLinkingEnabled(iMemento);
        if (this.fActionSet != null) {
            this.fActionSet.saveFilterAndSorterState(iMemento);
        }
    }

    private void saveLinkingEnabled(IMemento iMemento) {
        iMemento.putInteger(TAG_LINK_EDITOR, this.fLinkingEnabled ? 1 : 0);
    }

    private void saveLayoutState(IMemento iMemento) {
        if (iMemento != null) {
            iMemento.putInteger(TAG_LAYOUT, this.getLayoutAsInt());
            iMemento.putInteger(TAG_GROUP_LIBRARIES, this.fShowLibrariesNode ? 1 : 0);
        }
    }

    private void saveDialogSettings() {
        this.fDialogSettings.put(TAG_GROUP_LIBRARIES, this.fShowLibrariesNode);
        this.fDialogSettings.put(TAG_LAYOUT, this.getLayoutAsInt());
        this.fDialogSettings.put(TAG_ROOT_MODE, this.fRootMode);
        this.fDialogSettings.put(TAG_LINK_EDITOR, this.fLinkingEnabled);
    }

    private int getLayoutAsInt() {
        if (this.fIsCurrentLayoutFlat) {
            return 2;
        }
        return 1;
    }

    private void restoreFilterAndSorter() {
        this.fViewer.addFilter(new OutputFolderFilter());
        this.setComparator();
        if (this.fMemento != null) {
            this.fActionSet.restoreFilterAndSorterState(this.fMemento);
        }
    }

    private void restoreLinkingEnabled(IMemento iMemento) {
        Integer n = iMemento.getInteger(TAG_LINK_EDITOR);
        this.fLinkingEnabled = n != null && n != 0;
    }

    private void initKeyListener() {
        this.fViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                PackageExplorerPart.this.fActionSet.handleKeyEvent(keyEvent);
            }
        });
    }

    void editorActivated(IEditorPart iEditorPart) {
        IEditorInput iEditorInput = iEditorPart.getEditorInput();
        if (iEditorInput == null) {
            return;
        }
        Object object = this.getInputFromEditor(iEditorInput);
        if (object == null) {
            return;
        }
        if (!this.inputIsSelected(iEditorInput)) {
            this.showInput(object);
        } else {
            this.getTreeViewer().getTree().showSelection();
        }
    }

    private Object getInputFromEditor(IEditorInput iEditorInput) {
        Object object = JavaUI.getEditorInputJavaElement(iEditorInput);
        if (object == null) {
            Class<?> clazz = class$6;
            if (clazz == null) {
                try {
                    clazz = class$6 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object = iEditorInput.getAdapter((Class)clazz);
        }
        if (object == null && iEditorInput instanceof IStorageEditorInput) {
            try {
                object = ((IStorageEditorInput)iEditorInput).getStorage();
            }
            catch (CoreException coreException) {}
        }
        return object;
    }

    private boolean inputIsSelected(IEditorInput iEditorInput) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fViewer.getSelection();
        if (iStructuredSelection.size() != 1) {
            return false;
        }
        IEditorInput iEditorInput2 = null;
        try {
            iEditorInput2 = EditorUtility.getEditorInput(iStructuredSelection.getFirstElement());
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
        return iEditorInput.equals(iEditorInput2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean showInput(Object object) {
        Object object2 = null;
        if (object instanceof IFile && this.isOnClassPath((IFile)object)) {
            object2 = JavaCore.create((IFile)((IFile)object));
        }
        if (object2 == null) {
            object2 = object;
        }
        if (object2 == null) return false;
        StructuredSelection structuredSelection = new StructuredSelection(object2);
        if (this.fViewer.getSelection().equals(structuredSelection)) {
            this.fViewer.reveal(object2);
            return true;
        }
        try {
            this.fViewer.removePostSelectionChangedListener(this.fPostSelectionListener);
            this.fViewer.setSelection((ISelection)structuredSelection, true);
            while (object2 != null && this.fViewer.getSelection().isEmpty()) {
                if ((object2 = this.getParent(object2)) == null) continue;
                structuredSelection = new StructuredSelection(object2);
                this.fViewer.setSelection((ISelection)structuredSelection, true);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.fViewer.addPostSelectionChangedListener(this.fPostSelectionListener);
        return true;
    }

    private boolean isOnClassPath(IFile iFile) {
        IJavaProject iJavaProject = JavaCore.create((IProject)iFile.getProject());
        return iJavaProject.isOnClasspath((IResource)iFile);
    }

    private Object getParent(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getParent();
        }
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        if (object instanceof IJarEntryResource) {
            return ((IJarEntryResource)object).getParent();
        }
        return null;
    }

    void expandMainType(Object object) {
        try {
            Control control;
            ICompilationUnit iCompilationUnit;
            IType iType = null;
            if (object instanceof ICompilationUnit) {
                iCompilationUnit = (ICompilationUnit)object;
                control = iCompilationUnit.getTypes();
                if (((IType[])control).length > 0) {
                    iType = control[0];
                }
            } else if (object instanceof IClassFile) {
                iCompilationUnit = (IClassFile)object;
                iType = iCompilationUnit.getType();
            }
            if (iType != null) {
                iCompilationUnit = iType;
                control = this.fViewer.getControl();
                if (control != null && !control.isDisposed()) {
                    control.getDisplay().asyncExec(new Runnable((IType)iCompilationUnit){
                        private final /* synthetic */ IType val$type2;
                        {
                            this.val$type2 = iType;
                        }

                        public void run() {
                            Control control = PackageExplorerPart.this.fViewer.getControl();
                            if (control != null && !control.isDisposed()) {
                                PackageExplorerPart.this.fViewer.expandToLevel(this.val$type2, 1);
                            }
                        }
                    });
                }
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public TreeViewer getTreeViewer() {
        return this.fViewer;
    }

    boolean isExpandable(Object object) {
        if (this.fViewer == null) {
            return false;
        }
        return this.fViewer.isExpandable(object);
    }

    void setWorkingSetLabel(String string) {
        this.fWorkingSetLabel = string;
        this.setTitleToolTip(this.getTitleToolTip());
    }

    void updateTitle() {
        Object object = this.fViewer.getInput();
        if (object == null || object instanceof IJavaModel) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String string = JavaElementLabels.getTextLabel(object, 36283885813801L);
            this.setContentDescription(string);
            this.setTitleToolTip(this.getToolTipText(object));
        }
    }

    public void setLabelDecorator(ILabelDecorator iLabelDecorator) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.fViewer == null) {
            return;
        }
        boolean bl = false;
        if ("org.eclipse.wst.jsdt.ui.packages.cuchildren".equals(propertyChangeEvent.getProperty())) {
            this.fActionSet.updateActionBars(this.getViewSite().getActionBars());
            boolean bl2 = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.wst.jsdt.ui.packages.cuchildren");
            ((StandardJavaElementContentProvider)this.fViewer.getContentProvider()).setProvideMembers(bl2);
            bl = true;
        } else if (MembersOrderPreferenceCache.isMemberOrderProperty(propertyChangeEvent.getProperty())) {
            bl = true;
        }
        if (bl) {
            this.fViewer.refresh();
        }
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.fViewer.getControl().setRedraw(true);
    }

    public boolean show(ShowInContext showInContext) {
        Object object;
        ISelection iSelection = showInContext.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            object = (IStructuredSelection)iSelection;
            if (object.size() == 1) {
                int n = this.tryToReveal(object.getFirstElement());
                if (n == 0) {
                    return true;
                }
                if (n == 8) {
                    return false;
                }
            } else if (object.size() > 1) {
                this.selectReveal((ISelection)object);
                return true;
            }
        }
        if ((object = showInContext.getInput()) instanceof IEditorInput) {
            Object object2 = this.getInputFromEditor((IEditorInput)object);
            return object2 != null && this.tryToReveal(object2) == 0;
        }
        return false;
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(PackageExplorerPart.this.getTreeViewer().getInput(), PackageExplorerPart.this.getTreeViewer().getSelection());
            }
        };
    }

    public void setLinkingEnabled(boolean bl) {
        this.fLinkingEnabled = bl;
        this.saveDialogSettings();
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        if (bl) {
            iWorkbenchPage.addPartListener(this.fLinkWithEditorListener);
            IEditorPart iEditorPart = iWorkbenchPage.getActiveEditor();
            if (iEditorPart != null) {
                this.editorActivated(iEditorPart);
            }
        } else {
            iWorkbenchPage.removePartListener(this.fLinkWithEditorListener);
        }
    }

    String getFrameName(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getElementName();
        }
        if (object instanceof WorkingSetModel) {
            return "";
        }
        return this.fLabelProvider.getText(object);
    }

    public int tryToReveal(Object object) {
        Object object2;
        Object object3;
        String[] stringArray;
        Object object4;
        if (this.revealElementOrParent(object)) {
            return 0;
        }
        WorkingSetFilterActionGroup workingSetFilterActionGroup = this.fActionSet.getWorkingSetActionGroup().getFilterGroup();
        if (workingSetFilterActionGroup != null) {
            object4 = workingSetFilterActionGroup.getWorkingSet();
            if (workingSetFilterActionGroup.isFiltered(this.getVisibleParent(object), object)) {
                if (object instanceof IJavaElement) {
                    stringArray = JavaElementLabels.getElementLabel((IJavaElement)object, JavaElementLabels.ALL_DEFAULT);
                    object3 = Messages.format(PackagesMessages.PackageExplorerPart_notFoundSepcific, new String[]{stringArray, object4.getLabel()});
                } else {
                    object3 = Messages.format(PackagesMessages.PackageExplorer_notFound, object4.getLabel());
                }
                if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PackagesMessages.PackageExplorer_filteredDialog_title, (String)object3)) {
                    workingSetFilterActionGroup.setWorkingSet(null, true);
                    if (this.revealElementOrParent(object)) {
                        return 0;
                    }
                } else {
                    return 8;
                }
            }
        }
        if (((String[])(object3 = ((CustomFiltersActionGroup)((Object)(object4 = this.fActionSet.getCustomFilterActionGroup()))).internalGetEnabledFilterIds())).length > (stringArray = ((CustomFiltersActionGroup)((Object)object4)).removeFiltersFor(this.getVisibleParent(object), object, this.getTreeViewer().getContentProvider())).length) {
            if (object instanceof IJavaElement) {
                String string = JavaElementLabels.getElementLabel((IJavaElement)object, JavaElementLabels.ALL_DEFAULT);
                object2 = Messages.format(PackagesMessages.PackageExplorerPart_removeFiltersSpecific, string);
            } else {
                object2 = PackagesMessages.PackageExplorer_removeFilters;
            }
            if (MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)PackagesMessages.PackageExplorer_filteredDialog_title, (String)object2)) {
                ((CustomFiltersActionGroup)((Object)object4)).setFilters(stringArray);
                if (this.revealElementOrParent(object)) {
                    return 0;
                }
            } else {
                return 8;
            }
        }
        object2 = this.fActionSet.getUpAction();
        while (object2.getFrameList().getCurrentIndex() > 0) {
            if (object2.getFrameList().getSource().getFrame(3, 0) == null) break;
            object2.run();
            if (!this.revealElementOrParent(object)) continue;
            return 0;
        }
        return 4;
    }

    private boolean revealElementOrParent(Object object) {
        if (this.revealAndVerify(object)) {
            return true;
        }
        if ((object = this.getVisibleParent(object)) != null) {
            IResource iResource;
            if (this.revealAndVerify(object)) {
                return true;
            }
            if (object instanceof IJavaElement && (iResource = ((IJavaElement)object).getResource()) != null && this.revealAndVerify(iResource)) {
                return true;
            }
        }
        return false;
    }

    private Object getVisibleParent(Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof IJavaElement)) {
            return object;
        }
        IJavaElement iJavaElement = (IJavaElement)object;
        switch (iJavaElement.getElementType()) {
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                iJavaElement = (IJavaElement)iJavaElement.getOpenable();
                break;
            }
            case 1: {
                iJavaElement = null;
            }
        }
        return iJavaElement;
    }

    private boolean revealAndVerify(Object object) {
        if (object == null) {
            return false;
        }
        this.selectReveal((ISelection)new StructuredSelection(object));
        return !this.getSite().getSelectionProvider().getSelection().isEmpty();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rootModeChanged(int n) {
        ConfigureWorkingSetAction configureWorkingSetAction;
        this.fRootMode = n;
        this.saveDialogSettings();
        if (this.showWorkingSets() && this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
            if (this.fActionSet != null) {
                this.fActionSet.getWorkingSetActionGroup().setWorkingSetModel(this.fWorkingSetModel);
            }
        }
        StructuredSelection structuredSelection = new StructuredSelection(((IStructuredSelection)this.fViewer.getSelection()).toArray());
        Object object = this.fViewer.getInput();
        boolean bl = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).equals(object) || this.fWorkingSetModel != null && this.fWorkingSetModel.equals(object) || object instanceof IWorkingSet;
        try {
            this.fViewer.getControl().setRedraw(false);
            if (bl) {
                this.fViewer.setInput(null);
            }
            this.setProviders();
            this.setComparator();
            this.fActionSet.getWorkingSetActionGroup().fillFilters((StructuredViewer)this.fViewer);
            if (bl) {
                this.fViewer.setInput(this.findInputElement());
            }
            this.fViewer.setSelection((ISelection)structuredSelection, true);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            configureWorkingSetAction = null;
        }
        this.fViewer.getControl().setRedraw(true);
        if (bl && this.showWorkingSets() && this.fWorkingSetModel.needsConfiguration()) {
            configureWorkingSetAction = new ConfigureWorkingSetAction(this.getSite());
            configureWorkingSetAction.setWorkingSetModel(this.fWorkingSetModel);
            configureWorkingSetAction.run();
            this.fWorkingSetModel.configured();
        }
        this.setTitleToolTip(this.getTitleToolTip());
    }

    private void createWorkingSetModel() {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                PackageExplorerPart.this.fWorkingSetModel = new WorkingSetModel(PackageExplorerPart.this.fMemento);
            }

            public void handleException(Throwable throwable) {
                PackageExplorerPart.this.fWorkingSetModel = new WorkingSetModel(null);
            }
        });
    }

    public IWorkingSet getFilterWorkingSet() {
        if (!this.showProjects()) {
            return null;
        }
        if (this.fActionSet == null) {
            return null;
        }
        return this.fActionSet.getWorkingSetActionGroup().getFilterGroup().getWorkingSet();
    }

    public WorkingSetModel getWorkingSetModel() {
        return this.fWorkingSetModel;
    }

    public int getRootMode() {
        return this.fRootMode;
    }

    boolean showProjects() {
        return this.fRootMode == 1;
    }

    boolean showWorkingSets() {
        return this.fRootMode == 2;
    }

    private void setComparator() {
        if (this.showWorkingSets()) {
            this.fViewer.setComparator(new WorkingSetAwareJavaElementSorter());
        } else {
            this.fViewer.setComparator(new JavaElementComparator());
        }
    }

    public void internalTestShowWorkingSets(IWorkingSet[] iWorkingSetArray) {
        if (this.fWorkingSetModel == null) {
            this.createWorkingSetModel();
        }
        this.fWorkingSetModel.setActiveWorkingSets(iWorkingSetArray);
        this.fWorkingSetModel.configured();
        this.rootModeChanged(2);
    }

    private class PackageExplorerProblemTreeViewer
    extends ProblemTreeViewer {
        private List fPendingRefreshes = Collections.synchronizedList(new ArrayList());
        private boolean fInPreserveSelection;

        public PackageExplorerProblemTreeViewer(Composite composite, int n) {
            super(composite, n);
            ColoredViewersManager.install((StructuredViewer)this);
        }

        public void add(Object object, Object[] objectArray) {
            if (this.fPendingRefreshes.contains(object)) {
                return;
            }
            super.add(object, objectArray);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void internalRefresh(Object object, boolean bl) {
            try {
                this.fPendingRefreshes.add(object);
                super.internalRefresh(object, bl);
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                this.fPendingRefreshes.remove(object);
                throw throwable;
            }
            {
                Object var3_5 = null;
                this.fPendingRefreshes.remove(object);
            }
        }

        protected boolean evaluateExpandableWithFilters(Object object) {
            if (object instanceof IJavaProject || object instanceof ICompilationUnit || object instanceof IClassFile || object instanceof ClassPathContainer) {
                return false;
            }
            return !(object instanceof IPackageFragmentRoot) || !((IPackageFragmentRoot)object).isArchive();
        }

        protected boolean isFiltered(Object object, Object object2, ViewerFilter[] viewerFilterArray) {
            if (object instanceof PackageFragmentRootContainer) {
                return !this.hasFilteredChildren(object);
            }
            boolean bl = super.isFiltered(object, object2, viewerFilterArray);
            if (bl && this.isEssential(object)) {
                return false;
            }
            return bl;
        }

        private boolean isEssential(Object object) {
            try {
                IPackageFragment iPackageFragment;
                if (!PackageExplorerPart.this.isFlatLayout() && object instanceof IPackageFragment && !(iPackageFragment = (IPackageFragment)object).isDefaultPackage() && iPackageFragment.hasSubpackages()) {
                    return this.hasFilteredChildren(iPackageFragment);
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            return false;
        }

        protected void handleInvalidSelection(ISelection iSelection, ISelection iSelection2) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            ArrayList<Object> arrayList = null;
            arrayList = iSelection2 instanceof IStructuredSelection ? new ArrayList(((IStructuredSelection)iSelection2).toList()) : new ArrayList<Object>();
            boolean bl = false;
            Iterator iterator = iStructuredSelection.iterator();
            while (iterator.hasNext()) {
                IProject iProject;
                Object e = iterator.next();
                if (e instanceof IJavaProject) {
                    iProject = ((IJavaProject)e).getProject();
                    if (iProject.isOpen() || !iProject.exists()) continue;
                    arrayList.add(iProject);
                    bl = true;
                    continue;
                }
                if (!(e instanceof IProject) || !(iProject = (IProject)e).isOpen()) continue;
                IJavaProject iJavaProject = JavaCore.create((IProject)iProject);
                if (iJavaProject != null && iJavaProject.exists()) {
                    arrayList.add(iJavaProject);
                }
                bl = true;
            }
            if (bl) {
                iSelection2 = new StructuredSelection(arrayList);
                this.setSelection(iSelection2);
            }
            super.handleInvalidSelection(iSelection, iSelection2);
        }

        protected Object[] addAditionalProblemParents(Object[] objectArray) {
            if (PackageExplorerPart.this.showWorkingSets() && objectArray != null) {
                return PackageExplorerPart.this.fWorkingSetModel.addWorkingSets(objectArray);
            }
            return objectArray;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void preservingSelection(Runnable runnable) {
            try {
                this.fInPreserveSelection = true;
                super.preservingSelection(runnable);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                this.fInPreserveSelection = false;
                throw throwable;
            }
            {
                Object var2_4 = null;
                this.fInPreserveSelection = false;
                return;
            }
        }

        protected void setSelectionToWidget(ISelection iSelection, boolean bl) {
            super.setSelectionToWidget(iSelection, bl);
        }

        private Widget internalFindChild(Widget widget, Object object) {
            Item[] itemArray = this.getChildren(widget);
            int n = 0;
            while (n < itemArray.length) {
                Item item = itemArray[n];
                Object object2 = item.getData();
                if (object2 != null && this.equals(object2, object)) {
                    return item;
                }
                ++n;
            }
            return null;
        }

        private CustomHashtable createRootAccessedMap(TreePath[] treePathArray) {
            CustomHashtable customHashtable = new CustomHashtable(this.getComparer());
            int n = 0;
            while (n < treePathArray.length) {
                TreePath treePath = treePathArray[n];
                Object object = treePath.getFirstSegment();
                if (object != null) {
                    customHashtable.put(object, treePath);
                }
                ++n;
            }
            return customHashtable;
        }
    }
}

