/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.ImportOrganizeInputDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public class ImportOrganizeConfigurationBlock
extends OptionsConfigurationBlock {
    private static final OptionsConfigurationBlock.Key PREF_IMPORTORDER = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.wst.jsdt.ui.importorder");
    private static final OptionsConfigurationBlock.Key PREF_ONDEMANDTHRESHOLD = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.wst.jsdt.ui.ondemandthreshold");
    private static final OptionsConfigurationBlock.Key PREF_IGNORELOWERCASE = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.wst.jsdt.ui.ignorelowercasenames");
    private static final OptionsConfigurationBlock.Key PREF_STATICONDEMANDTHRESHOLD = ImportOrganizeConfigurationBlock.getJDTUIKey("org.eclipse.wst.jsdt.ui.staticondemandthreshold");
    private static final String DIALOGSETTING_LASTLOADPATH = "org.eclipse.wst.jsdt.ui.importorder.loadpath";
    private static final String DIALOGSETTING_LASTSAVEPATH = "org.eclipse.wst.jsdt.ui.importorder.savepath";
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_STATIC = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 3;
    private static final int IDX_UP = 5;
    private static final int IDX_DOWN = 6;
    private ListDialogField fOrderListField;
    private StringDialogField fThresholdField;
    private StringDialogField fStaticThresholdField;
    private SelectionButtonDialogField fIgnoreLowerCaseTypesField;
    private SelectionButtonDialogField fExportButton;
    private SelectionButtonDialogField fImportButton;
    private PixelConverter fPixelConverter;

    private static OptionsConfigurationBlock.Key[] getAllKeys() {
        return new OptionsConfigurationBlock.Key[]{PREF_IMPORTORDER, PREF_ONDEMANDTHRESHOLD, PREF_STATICONDEMANDTHRESHOLD, PREF_IGNORELOWERCASE};
    }

    public ImportOrganizeConfigurationBlock(IStatusChangeListener iStatusChangeListener, IProject iProject, IWorkbenchPreferenceContainer iWorkbenchPreferenceContainer) {
        super(iStatusChangeListener, iProject, ImportOrganizeConfigurationBlock.getAllKeys(), iWorkbenchPreferenceContainer);
        String[] stringArray = new String[7];
        stringArray[0] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_add_button;
        stringArray[1] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_add_static_button;
        stringArray[2] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_edit_button;
        stringArray[3] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_remove_button;
        stringArray[5] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_up_button;
        stringArray[6] = PreferencesMessages.ImportOrganizeConfigurationBlock_order_down_button;
        String[] stringArray2 = stringArray;
        ImportOrganizeAdapter importOrganizeAdapter = new ImportOrganizeAdapter();
        this.fOrderListField = new ListDialogField(importOrganizeAdapter, stringArray2, (ILabelProvider)new ImportOrganizeLabelProvider());
        this.fOrderListField.setDialogFieldListener(importOrganizeAdapter);
        this.fOrderListField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_order_label);
        this.fOrderListField.setUpButtonIndex(5);
        this.fOrderListField.setDownButtonIndex(6);
        this.fOrderListField.setRemoveButtonIndex(3);
        this.fOrderListField.enableButton(2, false);
        this.fImportButton = new SelectionButtonDialogField(8);
        this.fImportButton.setDialogFieldListener(importOrganizeAdapter);
        this.fImportButton.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_order_load_button);
        this.fExportButton = new SelectionButtonDialogField(8);
        this.fExportButton.setDialogFieldListener(importOrganizeAdapter);
        this.fExportButton.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_order_save_button);
        this.fThresholdField = new StringDialogField();
        this.fThresholdField.setDialogFieldListener(importOrganizeAdapter);
        this.fThresholdField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_threshold_label);
        this.fStaticThresholdField = new StringDialogField();
        this.fStaticThresholdField.setDialogFieldListener(importOrganizeAdapter);
        this.fStaticThresholdField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_staticthreshold_label);
        this.fIgnoreLowerCaseTypesField = new SelectionButtonDialogField(32);
        this.fIgnoreLowerCaseTypesField.setDialogFieldListener(importOrganizeAdapter);
        this.fIgnoreLowerCaseTypesField.setLabelText(PreferencesMessages.ImportOrganizeConfigurationBlock_ignoreLowerCase_label);
        this.updateControls();
    }

    protected Control createContents(Composite composite) {
        this.setShell(composite.getShell());
        this.fPixelConverter = new PixelConverter((Control)composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite2.setLayout((Layout)gridLayout);
        this.fOrderListField.doFillIntoGrid(composite2, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fOrderListField.getLabelControl(null), 2);
        LayoutUtil.setWidthHint((Control)this.fOrderListField.getLabelControl(null), this.fPixelConverter.convertWidthInCharsToPixels(60));
        LayoutUtil.setHorizontalGrabbing(this.fOrderListField.getListControl(null));
        Composite composite3 = new Composite(composite2, 0);
        composite3.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite3.setLayout((Layout)gridLayout);
        this.fImportButton.doFillIntoGrid(composite3, 1);
        this.fExportButton.doFillIntoGrid(composite3, 1);
        this.fThresholdField.doFillIntoGrid(composite2, 2);
        ((GridData)this.fThresholdField.getTextControl(null).getLayoutData()).grabExcessHorizontalSpace = false;
        this.fStaticThresholdField.doFillIntoGrid(composite2, 2);
        this.fIgnoreLowerCaseTypesField.doFillIntoGrid(composite2, 2);
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    private boolean doThresholdChanged(String string) {
        StatusInfo statusInfo = new StatusInfo();
        try {
            int n = Integer.parseInt(string);
            if (n < 0) {
                statusInfo.setError(PreferencesMessages.ImportOrganizeConfigurationBlock_error_invalidthreshold);
            }
        }
        catch (NumberFormatException numberFormatException) {
            statusInfo.setError(PreferencesMessages.ImportOrganizeConfigurationBlock_error_invalidthreshold);
        }
        this.updateStatus(statusInfo);
        return statusInfo.isOK();
    }

    private void doButtonPressed(int n) {
        if (n == 0 || n == 1) {
            List list = this.fOrderListField.getElements();
            ImportOrganizeInputDialog importOrganizeInputDialog = new ImportOrganizeInputDialog(this.getShell(), list, n == 1);
            if (importOrganizeInputDialog.open() == 0) {
                List list2 = this.fOrderListField.getSelectedElements();
                if (list2.size() == 1) {
                    int n2 = this.fOrderListField.getIndexOfElement(list2.get(0)) + 1;
                    this.fOrderListField.addElement(importOrganizeInputDialog.getResult(), n2);
                } else {
                    this.fOrderListField.addElement(importOrganizeInputDialog.getResult());
                }
            }
        } else if (n == 2) {
            List list = this.fOrderListField.getSelectedElements();
            if (list.isEmpty()) {
                return;
            }
            ImportOrderEntry importOrderEntry = (ImportOrderEntry)list.get(0);
            List list3 = this.fOrderListField.getElements();
            list3.remove(importOrderEntry);
            ImportOrganizeInputDialog importOrganizeInputDialog = new ImportOrganizeInputDialog(this.getShell(), list3, importOrderEntry.isStatic);
            importOrganizeInputDialog.setInitialSelection(importOrderEntry);
            if (importOrganizeInputDialog.open() == 0) {
                this.fOrderListField.replaceElement(importOrderEntry, importOrganizeInputDialog.getResult());
            }
        }
    }

    private List loadFromProperties(Properties properties) {
        ArrayList<ImportOrderEntry> arrayList = new ArrayList<ImportOrderEntry>();
        int n = properties.size();
        int n2 = 0;
        while (n2 < n) {
            ImportOrderEntry importOrderEntry;
            String string = properties.getProperty(String.valueOf(n2));
            if (string != null) {
                importOrderEntry = ImportOrderEntry.fromSerialized(string);
                if (JavaConventions.validatePackageName((String)importOrderEntry.name, (String)"1.3", (String)"1.5").matches(4)) {
                    return null;
                }
            } else {
                return arrayList;
            }
            arrayList.add(importOrderEntry);
            ++n2;
        }
        return arrayList;
    }

    /*
     * Exception decompiling
     */
    private List loadImportOrder() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 179->182)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void saveImportOrder(List var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 242->246)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateStatus(IStatus iStatus) {
        this.fContext.statusChanged(iStatus);
    }

    protected void validateSettings(OptionsConfigurationBlock.Key key, String string, String string2) {
    }

    protected void updateControls() {
        ImportOrderEntry[] importOrderEntryArray = this.getImportOrderPreference();
        int n = this.getImportNumberThreshold(PREF_ONDEMANDTHRESHOLD);
        int n2 = this.getImportNumberThreshold(PREF_STATICONDEMANDTHRESHOLD);
        boolean bl = Boolean.valueOf(this.getValue(PREF_IGNORELOWERCASE));
        this.fOrderListField.removeAllElements();
        int n3 = 0;
        while (n3 < importOrderEntryArray.length) {
            this.fOrderListField.addElement(importOrderEntryArray[n3]);
            ++n3;
        }
        this.fThresholdField.setText(String.valueOf(n));
        this.fStaticThresholdField.setText(String.valueOf(n2));
        this.fIgnoreLowerCaseTypesField.setSelection(bl);
    }

    protected final void doDialogFieldChanged(DialogField dialogField) {
        if (dialogField == this.fOrderListField) {
            this.setValue(PREF_IMPORTORDER, ImportOrganizeConfigurationBlock.packOrderList(this.fOrderListField.getElements()));
        } else if (dialogField == this.fThresholdField) {
            if (this.doThresholdChanged(this.fThresholdField.getText())) {
                this.setValue(PREF_ONDEMANDTHRESHOLD, this.fThresholdField.getText());
            }
        } else if (dialogField == this.fStaticThresholdField) {
            if (this.doThresholdChanged(this.fStaticThresholdField.getText())) {
                this.setValue(PREF_STATICONDEMANDTHRESHOLD, this.fStaticThresholdField.getText());
            }
        } else if (dialogField == this.fIgnoreLowerCaseTypesField) {
            this.setValue(PREF_IGNORELOWERCASE, this.fIgnoreLowerCaseTypesField.isSelected());
        } else if (dialogField == this.fImportButton) {
            List list = this.loadImportOrder();
            if (list != null) {
                this.fOrderListField.setElements(list);
            }
        } else if (dialogField == this.fExportButton) {
            this.saveImportOrder(this.fOrderListField.getElements());
        }
    }

    protected String[] getFullBuildDialogStrings(boolean bl) {
        return null;
    }

    private static ImportOrderEntry[] unpackOrderList(String string) {
        int n;
        ArrayList<ImportOrderEntry> arrayList = new ArrayList<ImportOrderEntry>();
        int n2 = 0;
        do {
            if ((n = string.indexOf(59, n2)) == -1) {
                n = string.length();
            }
            arrayList.add(ImportOrderEntry.fromSerialized(string.substring(n2, n)));
        } while ((n2 = n + 1) < string.length());
        return arrayList.toArray(new ImportOrderEntry[arrayList.size()]);
    }

    private static String packOrderList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < list.size()) {
            ImportOrderEntry importOrderEntry = (ImportOrderEntry)list.get(n);
            stringBuffer.append(importOrderEntry.serialize());
            stringBuffer.append(';');
            ++n;
        }
        return stringBuffer.toString();
    }

    private ImportOrderEntry[] getImportOrderPreference() {
        String string = this.getValue(PREF_IMPORTORDER);
        if (string != null) {
            return ImportOrganizeConfigurationBlock.unpackOrderList(string);
        }
        return new ImportOrderEntry[0];
    }

    private int getImportNumberThreshold(OptionsConfigurationBlock.Key key) {
        String string = this.getValue(key);
        try {
            int n = Integer.parseInt(string);
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return Integer.MAX_VALUE;
        }
    }

    public static class ImportOrderEntry {
        public final String name;
        public final boolean isStatic;

        public ImportOrderEntry(String string, boolean bl) {
            this.name = string;
            this.isStatic = bl;
        }

        public String serialize() {
            return this.isStatic ? String.valueOf('#') + this.name : this.name;
        }

        public static ImportOrderEntry fromSerialized(String string) {
            if (string.length() > 0 && string.charAt(0) == '#') {
                return new ImportOrderEntry(string.substring(1), true);
            }
            return new ImportOrderEntry(string, false);
        }
    }

    private class ImportOrganizeAdapter
    implements IListAdapter,
    IDialogFieldListener {
        private ImportOrganizeAdapter() {
        }

        private boolean canEdit(ListDialogField listDialogField) {
            List list = listDialogField.getSelectedElements();
            return list.size() == 1;
        }

        public void customButtonPressed(ListDialogField listDialogField, int n) {
            ImportOrganizeConfigurationBlock.this.doButtonPressed(n);
        }

        public void selectionChanged(ListDialogField listDialogField) {
            ImportOrganizeConfigurationBlock.this.fOrderListField.enableButton(2, this.canEdit(listDialogField));
        }

        public void dialogFieldChanged(DialogField dialogField) {
            ImportOrganizeConfigurationBlock.this.doDialogFieldChanged(dialogField);
        }

        public void doubleClicked(ListDialogField listDialogField) {
            if (this.canEdit(listDialogField)) {
                ImportOrganizeConfigurationBlock.this.doButtonPressed(2);
            }
        }
    }

    private static class ImportOrganizeLabelProvider
    extends LabelProvider {
        private final Image PCK_ICON = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.package_obj.gif");
        private final Image STATIC_CLASS_ICON = JavaElementImageProvider.getDecoratedImage(JavaPluginImages.DESC_MISC_PUBLIC, 8, JavaElementImageProvider.SMALL_SIZE);

        public Image getImage(Object object) {
            return ((ImportOrderEntry)object).isStatic ? this.STATIC_CLASS_ICON : this.PCK_ICON;
        }

        public String getText(Object object) {
            ImportOrderEntry importOrderEntry = (ImportOrderEntry)object;
            String string = importOrderEntry.name;
            if (string.length() > 0) {
                return string;
            }
            if (importOrderEntry.isStatic) {
                return PreferencesMessages.ImportOrganizeConfigurationBlock_other_static;
            }
            return PreferencesMessages.ImportOrganizeConfigurationBlock_other_normal;
        }
    }
}

