/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.util.Map;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.text.SimpleJavaSourceViewerConfiguration;
import org.eclipse.wst.jsdt.ui.text.JavaTextTools;

public abstract class JavaPreview {
    protected final SimpleJavaSourceViewerConfiguration fViewerConfiguration;
    protected final Document fPreviewDocument;
    protected final SourceViewer fSourceViewer;
    protected final IPreferenceStore fPreferenceStore;
    protected final MarginPainter fMarginPainter;
    protected Map fWorkingValues;
    private int fTabSize = 0;
    private WhitespaceCharacterPainter fWhitespaceCharacterPainter;

    public JavaPreview(Map map, Composite composite) {
        JavaTextTools javaTextTools = JavaPlugin.getDefault().getJavaTextTools();
        this.fPreviewDocument = new Document();
        this.fWorkingValues = map;
        javaTextTools.setupJavaDocumentPartitioner((IDocument)this.fPreviewDocument, "___java_partitioning");
        PreferenceStore preferenceStore = new PreferenceStore();
        preferenceStore.setValue("org.eclipse.wst.jsdt.core.compiler.source", "1.5");
        preferenceStore.setValue("org.eclipse.wst.jsdt.core.compiler.compliance", "1.5");
        preferenceStore.setValue("org.eclipse.wst.jsdt.core.compiler.codegen.targetPlatform", "1.5");
        preferenceStore.setValue("org.eclipse.wst.jsdt.core.compiler.problem.assertIdentifier", "error");
        IPreferenceStore[] iPreferenceStoreArray = new IPreferenceStore[]{preferenceStore, JavaPlugin.getDefault().getCombinedPreferenceStore()};
        this.fPreferenceStore = new ChainedPreferenceStore(iPreferenceStoreArray);
        this.fSourceViewer = new JavaSourceViewer(composite, null, null, false, 2824, this.fPreferenceStore);
        this.fViewerConfiguration = new SimpleJavaSourceViewerConfiguration(javaTextTools.getColorManager(), this.fPreferenceStore, null, "___java_partitioning", true);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont"));
        this.fMarginPainter = new MarginPainter((ITextViewer)this.fSourceViewer);
        RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"printMarginColor");
        this.fMarginPainter.setMarginRulerColor(javaTextTools.getColorManager().getColor(rGB));
        this.fSourceViewer.addPainter((IPainter)this.fMarginPainter);
        new JavaSourcePreviewerUpdater();
        this.fSourceViewer.setDocument((IDocument)this.fPreviewDocument);
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void update() {
        if (this.fWorkingValues == null) {
            this.fPreviewDocument.set("");
            return;
        }
        String string = (String)this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.lineSplit");
        int n = JavaPreview.getPositiveIntValue(string, 0);
        this.fMarginPainter.setMarginRulerColumn(n);
        int n2 = JavaPreview.getPositiveIntValue((String)this.fWorkingValues.get("org.eclipse.wst.jsdt.core.formatter.tabulation.size"), 0);
        if (n2 != this.fTabSize) {
            this.fSourceViewer.getTextWidget().setTabs(n2);
        }
        this.fTabSize = n2;
        StyledText styledText = (StyledText)this.fSourceViewer.getControl();
        int n3 = styledText.getClientArea().height;
        int n4 = styledText.getTopPixel();
        int n5 = this.getHeightOfAllLines(styledText);
        int n6 = n5 > n3 ? n5 - n3 : 0;
        styledText.setRedraw(false);
        this.doFormatPreview();
        this.fSourceViewer.setSelection(null);
        int n7 = this.getHeightOfAllLines(styledText);
        int n8 = n7 > n3 ? n7 - n3 : 0;
        int n9 = n6 > 0 ? (int)((double)(n8 * n4) / (double)n6) : 0;
        styledText.setTopPixel(n9);
        styledText.setRedraw(true);
    }

    private int getHeightOfAllLines(StyledText styledText) {
        int n = 0;
        int n2 = styledText.getLineCount();
        int n3 = 0;
        while (n3 < n2) {
            n += styledText.getLineHeight(styledText.getOffsetAtLine(n3));
            ++n3;
        }
        return n;
    }

    protected abstract void doFormatPreview();

    private static int getPositiveIntValue(String string, int n) {
        try {
            int n2 = Integer.parseInt(string);
            if (n2 >= 0) {
                return n2;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return n;
    }

    public Map getWorkingValues() {
        return this.fWorkingValues;
    }

    public void setWorkingValues(Map map) {
        this.fWorkingValues = map;
    }

    public void showInvisibleCharacters(boolean bl) {
        if (bl) {
            if (this.fWhitespaceCharacterPainter == null) {
                this.fWhitespaceCharacterPainter = new WhitespaceCharacterPainter((ITextViewer)this.fSourceViewer);
                this.fSourceViewer.addPainter((IPainter)this.fWhitespaceCharacterPainter);
            }
        } else {
            this.fSourceViewer.removePainter((IPainter)this.fWhitespaceCharacterPainter);
            this.fWhitespaceCharacterPainter = null;
        }
        this.update();
    }

    private final class JavaSourcePreviewerUpdater {
        final IPropertyChangeListener fontListener = new IPropertyChangeListener(this){
            final /* synthetic */ JavaSourcePreviewerUpdater this$1;
            {
                this.this$1 = javaSourcePreviewerUpdater;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("org.eclipse.wst.jsdt.ui.editors.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont");
                    JavaSourcePreviewerUpdater.access$0((JavaSourcePreviewerUpdater)this.this$1).fSourceViewer.getTextWidget().setFont(font);
                    if (JavaSourcePreviewerUpdater.access$0((JavaSourcePreviewerUpdater)this.this$1).fMarginPainter != null) {
                        JavaSourcePreviewerUpdater.access$0((JavaSourcePreviewerUpdater)this.this$1).fMarginPainter.initialize();
                    }
                }
            }
        };
        final IPropertyChangeListener propertyListener = new IPropertyChangeListener(this){
            final /* synthetic */ JavaSourcePreviewerUpdater this$1;
            {
                this.this$1 = javaSourcePreviewerUpdater;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (JavaSourcePreviewerUpdater.access$0((JavaSourcePreviewerUpdater)this.this$1).fViewerConfiguration.affectsTextPresentation(propertyChangeEvent)) {
                    JavaSourcePreviewerUpdater.access$0((JavaSourcePreviewerUpdater)this.this$1).fViewerConfiguration.handlePropertyChangeEvent(propertyChangeEvent);
                    JavaSourcePreviewerUpdater.access$0((JavaSourcePreviewerUpdater)this.this$1).fSourceViewer.invalidateTextPresentation();
                }
            }
        };

        public JavaSourcePreviewerUpdater() {
            JFaceResources.getFontRegistry().addListener(this.fontListener);
            JavaPreview.this.fPreferenceStore.addPropertyChangeListener(this.propertyListener);
            JavaPreview.this.fSourceViewer.getTextWidget().addDisposeListener(new DisposeListener(this){
                final /* synthetic */ JavaSourcePreviewerUpdater this$1;
                {
                    this.this$1 = javaSourcePreviewerUpdater;
                }

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    JFaceResources.getFontRegistry().removeListener(this.this$1.fontListener);
                    JavaSourcePreviewerUpdater.access$0((JavaSourcePreviewerUpdater)this.this$1).fPreferenceStore.removePropertyChangeListener(this.this$1.propertyListener);
                }
            });
        }

        static /* synthetic */ JavaPreview access$0(JavaSourcePreviewerUpdater javaSourcePreviewerUpdater) {
            return javaSourcePreviewerUpdater.JavaPreview.this;
        }
    }
}

