/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.AlreadyExistsDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.CreateProfileDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.osgi.service.prefs.BackingStoreException;

public abstract class ProfileConfigurationBlock {
    private Composite fComposite;
    private Combo fProfileCombo;
    private Button fEditButton;
    private Button fDeleteButton;
    private Button fNewButton;
    private Button fLoadButton;
    private PixelConverter fPixConv;
    private final ProfileManager fProfileManager;
    private final IScopeContext fCurrContext;
    private final IScopeContext fInstanceScope;
    private final ProfileStore fProfileStore;
    private final IProfileVersioner fProfileVersioner;
    private final String fLastSaveLoadPathKey;
    private IEclipsePreferences.IPreferenceChangeListener fPreferenceListener;
    private final PreferencesAccess fPreferenceAccess;
    private boolean fPreferenceListenerEnabled;

    public ProfileConfigurationBlock(IProject iProject, PreferencesAccess preferencesAccess, String string) {
        this.fPreferenceAccess = preferencesAccess;
        this.fLastSaveLoadPathKey = string;
        this.fProfileVersioner = this.createProfileVersioner();
        this.fProfileStore = this.createProfileStore(this.fProfileVersioner);
        this.fInstanceScope = preferencesAccess.getInstanceScope();
        this.fCurrContext = iProject != null ? preferencesAccess.getProjectScope(iProject) : this.fInstanceScope;
        List list = null;
        try {
            list = this.fProfileStore.readProfiles(this.fInstanceScope);
        }
        catch (CoreException coreException) {
            JavaPlugin.log(coreException);
        }
        if (list == null) {
            try {
                list = this.fProfileStore.readProfiles((IScopeContext)new DefaultScope());
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }
        if (list == null) {
            list = new ArrayList();
        }
        this.fProfileManager = this.createProfileManager(list, this.fCurrContext, preferencesAccess, this.fProfileVersioner);
        new StoreUpdater();
        this.fPreferenceListenerEnabled = true;
        this.fPreferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
                if (ProfileConfigurationBlock.this.fPreferenceListenerEnabled) {
                    ProfileConfigurationBlock.this.preferenceChanged(preferenceChangeEvent);
                }
            }
        };
        preferencesAccess.getInstanceScope().getNode("org.eclipse.wst.jsdt.ui").addPreferenceChangeListener(this.fPreferenceListener);
    }

    protected void preferenceChanged(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
    }

    protected abstract IProfileVersioner createProfileVersioner();

    protected abstract ProfileStore createProfileStore(IProfileVersioner var1);

    protected abstract ProfileManager createProfileManager(List var1, IScopeContext var2, PreferencesAccess var3, IProfileVersioner var4);

    protected abstract ModifyDialog createModifyDialog(Shell var1, ProfileManager.Profile var2, ProfileManager var3, ProfileStore var4, boolean var5);

    protected abstract void configurePreview(Composite var1, int var2, ProfileManager var3);

    private static Button createButton(Composite composite, String string, int n) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(string);
        GridData gridData = new GridData(n);
        gridData.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gridData);
        return button;
    }

    public Composite createContents(Composite composite) {
        this.fPixConv = new PixelConverter((Control)composite);
        this.fComposite = this.createComposite(composite, 5);
        Label label = new Label(this.fComposite, 0);
        label.setText(PreferencesMessages.CleanUpPreferencePage_Description);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 5;
        label.setLayoutData((Object)gridData);
        this.fProfileCombo = ProfileConfigurationBlock.createProfileCombo(this.fComposite, 3, this.fPixConv.convertWidthInCharsToPixels(20));
        this.fEditButton = ProfileConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_edit_button_desc, 32);
        this.fDeleteButton = ProfileConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_remove_button_desc, 32);
        this.fNewButton = ProfileConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_new_button_desc, 32);
        this.fLoadButton = ProfileConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_load_button_desc, 128);
        ProfileConfigurationBlock.createLabel(this.fComposite, "", 3);
        this.configurePreview(this.fComposite, 5, this.fProfileManager);
        new ButtonController();
        new ProfileComboController();
        return this.fComposite;
    }

    private static Combo createProfileCombo(Composite composite, int n, int n2) {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        gridData.widthHint = n2;
        Combo combo = new Combo(composite, 12);
        combo.setFont(composite.getFont());
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    protected static Label createLabel(Composite composite, String string, int n) {
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = n;
        gridData.widthHint = 0;
        Label label = new Label(composite, 64);
        label.setFont(composite.getFont());
        label.setText(string);
        label.setLayoutData((Object)gridData);
        return label;
    }

    private Composite createComposite(Composite composite, int n) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = new GridLayout(n, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        return composite2;
    }

    public final boolean hasProjectSpecificOptions(IProject iProject) {
        if (iProject != null) {
            return this.fProfileManager.hasProjectSpecificSettings((IScopeContext)new ProjectScope(iProject));
        }
        return false;
    }

    public boolean performOk() {
        return true;
    }

    public void performApply() {
        try {
            this.fCurrContext.getNode("org.eclipse.wst.jsdt.ui").flush();
            this.fCurrContext.getNode("org.eclipse.wst.jsdt.core").flush();
            if (this.fCurrContext != this.fInstanceScope) {
                this.fInstanceScope.getNode("org.eclipse.wst.jsdt.ui").flush();
                this.fInstanceScope.getNode("org.eclipse.wst.jsdt.core").flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            JavaPlugin.log(backingStoreException);
        }
    }

    public void performDefaults() {
        int n;
        ProfileManager.Profile profile = this.fProfileManager.getDefaultProfile();
        if (profile != null && (n = this.fProfileManager.getSortedProfiles().indexOf(profile)) != -1) {
            this.fProfileManager.setSelected(profile);
        }
    }

    public void dispose() {
        if (this.fPreferenceListener != null) {
            this.fPreferenceAccess.getInstanceScope().getNode("org.eclipse.wst.jsdt.ui").removePreferenceChangeListener(this.fPreferenceListener);
            this.fPreferenceListener = null;
        }
    }

    public void enableProjectSpecificSettings(boolean bl) {
        if (bl) {
            this.fProfileManager.commitChanges(this.fCurrContext);
        } else {
            this.fProfileManager.clearAllSettings(this.fCurrContext);
        }
    }

    class ButtonController
    implements Observer,
    SelectionListener {
        public ButtonController() {
            ProfileConfigurationBlock.this.fProfileManager.addObserver(this);
            ProfileConfigurationBlock.this.fNewButton.addSelectionListener((SelectionListener)this);
            ProfileConfigurationBlock.this.fEditButton.addSelectionListener((SelectionListener)this);
            ProfileConfigurationBlock.this.fDeleteButton.addSelectionListener((SelectionListener)this);
            ProfileConfigurationBlock.this.fLoadButton.addSelectionListener((SelectionListener)this);
            this.update(ProfileConfigurationBlock.this.fProfileManager, null);
        }

        public void update(Observable observable, Object object) {
            ProfileManager.Profile profile = ((ProfileManager)observable).getSelected();
            boolean bl = !profile.isBuiltInProfile();
            ProfileConfigurationBlock.this.fDeleteButton.setEnabled(bl);
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            Button button = (Button)selectionEvent.widget;
            if (button == ProfileConfigurationBlock.this.fEditButton) {
                this.modifyButtonPressed();
            } else if (button == ProfileConfigurationBlock.this.fDeleteButton) {
                this.deleteButtonPressed();
            } else if (button == ProfileConfigurationBlock.this.fNewButton) {
                this.newButtonPressed();
            } else if (button == ProfileConfigurationBlock.this.fLoadButton) {
                this.loadButtonPressed();
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        private void modifyButtonPressed() {
            ModifyDialog modifyDialog = ProfileConfigurationBlock.this.createModifyDialog(ProfileConfigurationBlock.this.fComposite.getShell(), ProfileConfigurationBlock.this.fProfileManager.getSelected(), ProfileConfigurationBlock.this.fProfileManager, ProfileConfigurationBlock.this.fProfileStore, false);
            modifyDialog.open();
        }

        private void deleteButtonPressed() {
            if (MessageDialog.openQuestion((Shell)ProfileConfigurationBlock.this.fComposite.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_delete_confirmation_title, (String)Messages.format(FormatterMessages.CodingStyleConfigurationBlock_delete_confirmation_question, ProfileConfigurationBlock.this.fProfileManager.getSelected().getName()))) {
                ProfileConfigurationBlock.this.fProfileManager.deleteSelected();
            }
        }

        private void newButtonPressed() {
            CreateProfileDialog createProfileDialog = new CreateProfileDialog(ProfileConfigurationBlock.this.fComposite.getShell(), ProfileConfigurationBlock.this.fProfileManager, ProfileConfigurationBlock.this.fProfileVersioner);
            if (createProfileDialog.open() != 0) {
                return;
            }
            if (!createProfileDialog.openEditDialog()) {
                return;
            }
            ModifyDialog modifyDialog = ProfileConfigurationBlock.this.createModifyDialog(ProfileConfigurationBlock.this.fComposite.getShell(), createProfileDialog.getCreatedProfile(), ProfileConfigurationBlock.this.fProfileManager, ProfileConfigurationBlock.this.fProfileStore, true);
            modifyDialog.open();
        }

        private void loadButtonPressed() {
            String string;
            Object object;
            String string2;
            FileDialog fileDialog = new FileDialog(ProfileConfigurationBlock.this.fComposite.getShell(), 4096);
            fileDialog.setText(FormatterMessages.CodingStyleConfigurationBlock_load_profile_dialog_title);
            fileDialog.setFilterExtensions(new String[]{"*.xml"});
            String string3 = JavaPlugin.getDefault().getDialogSettings().get(String.valueOf(ProfileConfigurationBlock.this.fLastSaveLoadPathKey) + ".loadpath");
            if (string3 != null) {
                fileDialog.setFilterPath(string3);
            }
            if ((string2 = fileDialog.open()) == null) {
                return;
            }
            JavaPlugin.getDefault().getDialogSettings().put(String.valueOf(ProfileConfigurationBlock.this.fLastSaveLoadPathKey) + ".loadpath", fileDialog.getFilterPath());
            File file = new File(string2);
            List list = null;
            try {
                list = ProfileConfigurationBlock.this.fProfileStore.readProfilesFromFile(file);
            }
            catch (CoreException coreException) {
                object = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_title;
                string = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_message;
                ExceptionHandler.handle(coreException, ProfileConfigurationBlock.this.fComposite.getShell(), object, string);
            }
            if (list == null || list.isEmpty()) {
                return;
            }
            ProfileManager.CustomProfile customProfile = (ProfileManager.CustomProfile)list.iterator().next();
            if (!ProfileConfigurationBlock.this.fProfileVersioner.getProfileKind().equals(customProfile.getKind())) {
                object = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_title;
                string = Messages.format(FormatterMessages.ProfileConfigurationBlock_load_profile_wrong_profile_message, new String[]{ProfileConfigurationBlock.this.fProfileVersioner.getProfileKind(), customProfile.getKind()});
                MessageDialog.openError((Shell)ProfileConfigurationBlock.this.fComposite.getShell(), (String)object, (String)string);
                return;
            }
            if (customProfile.getVersion() > ProfileConfigurationBlock.this.fProfileVersioner.getCurrentVersion()) {
                object = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_too_new_title;
                string = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_too_new_message;
                MessageDialog.openWarning((Shell)ProfileConfigurationBlock.this.fComposite.getShell(), (String)object, (String)string);
            }
            if (ProfileConfigurationBlock.this.fProfileManager.containsName(customProfile.getName()) && (object = new AlreadyExistsDialog(ProfileConfigurationBlock.this.fComposite.getShell(), customProfile, ProfileConfigurationBlock.this.fProfileManager)).open() != 0) {
                return;
            }
            ProfileConfigurationBlock.this.fProfileVersioner.update(customProfile);
            ProfileConfigurationBlock.this.fProfileManager.addProfile(customProfile);
        }
    }

    class ProfileComboController
    implements Observer,
    SelectionListener {
        private final List fSortedProfiles;

        public ProfileComboController() {
            this.fSortedProfiles = ProfileConfigurationBlock.this.fProfileManager.getSortedProfiles();
            ProfileConfigurationBlock.this.fProfileCombo.addSelectionListener((SelectionListener)this);
            ProfileConfigurationBlock.this.fProfileManager.addObserver(this);
            this.updateProfiles();
            this.updateSelection();
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = ProfileConfigurationBlock.this.fProfileCombo.getSelectionIndex();
            ProfileConfigurationBlock.this.fProfileManager.setSelected((ProfileManager.Profile)this.fSortedProfiles.get(n));
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }

        public void update(Observable observable, Object object) {
            if (object == null) {
                return;
            }
            int n = (Integer)object;
            switch (n) {
                case 2: 
                case 3: 
                case 4: {
                    this.updateProfiles();
                    this.updateSelection();
                    break;
                }
                case 1: {
                    this.updateSelection();
                }
            }
        }

        private void updateProfiles() {
            ProfileConfigurationBlock.this.fProfileCombo.setItems(ProfileConfigurationBlock.this.fProfileManager.getSortedDisplayNames());
        }

        private void updateSelection() {
            ProfileConfigurationBlock.this.fProfileCombo.setText(ProfileConfigurationBlock.this.fProfileManager.getSelected().getName());
        }
    }

    private class StoreUpdater
    implements Observer {
        public StoreUpdater() {
            ProfileConfigurationBlock.this.fProfileManager.addObserver(this);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void update(Observable observable, Object object) {
            try {
                ProfileConfigurationBlock.this.fPreferenceListenerEnabled = false;
                int n = (Integer)object;
                switch (n) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        try {
                            ProfileConfigurationBlock.this.fProfileStore.writeProfiles(ProfileConfigurationBlock.this.fProfileManager.getSortedProfiles(), ProfileConfigurationBlock.this.fInstanceScope);
                            ProfileConfigurationBlock.this.fProfileManager.commitChanges(ProfileConfigurationBlock.this.fCurrContext);
                        }
                        catch (CoreException coreException) {
                            JavaPlugin.log(coreException);
                        }
                        break;
                    }
                    case 1: {
                        ProfileConfigurationBlock.this.fProfileManager.commitChanges(ProfileConfigurationBlock.this.fCurrContext);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ProfileConfigurationBlock.this.fPreferenceListenerEnabled = true;
                throw throwable;
            }
            {
                Object var5_7 = null;
            }
            ProfileConfigurationBlock.this.fPreferenceListenerEnabled = true;
        }
    }
}

