/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public final class MoveInstanceMethodAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public MoveInstanceMethodAction(JavaEditor javaEditor) {
        this((IWorkbenchSite)javaEditor.getEditorSite());
        this.fEditor = javaEditor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public MoveInstanceMethodAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(RefactoringMessages.MoveInstanceMethodAction_Move_Method);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.move_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveMethodAvailable(iStructuredSelection));
        }
        catch (JavaModelException javaModelException) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)javaModelException))) {
                JavaPlugin.log(javaModelException);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection javaTextSelection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isMoveMethodAvailable(javaTextSelection));
        }
        catch (CoreException coreException) {
            this.setEnabled(false);
        }
    }

    private static IMethod getSingleSelectedMethod(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty() || iStructuredSelection.size() != 1) {
            return null;
        }
        Object object = iStructuredSelection.getFirstElement();
        if (!(object instanceof IMethod)) {
            return null;
        }
        return (IMethod)object;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isMoveMethodAvailable(iStructuredSelection));
            IMethod iMethod = MoveInstanceMethodAction.getSingleSelectedMethod(iStructuredSelection);
            Assert.isNotNull((Object)iMethod);
            if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iMethod)) {
                return;
            }
            RefactoringExecutionStarter.startMoveMethodRefactoring(iMethod, this.getShell());
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), RefactoringMessages.MoveInstanceMethodAction_dialog_title, RefactoringMessages.MoveInstanceMethodAction_unexpected_exception);
        }
    }

    public void run(ITextSelection iTextSelection) {
        try {
            this.run(iTextSelection, SelectionConverter.getInputAsCompilationUnit(this.fEditor));
        }
        catch (JavaModelException javaModelException) {
            ExceptionHandler.handle((CoreException)((Object)javaModelException), this.getShell(), RefactoringMessages.MoveInstanceMethodAction_dialog_title, RefactoringMessages.MoveInstanceMethodAction_unexpected_exception);
        }
    }

    private void run(ITextSelection iTextSelection, ICompilationUnit iCompilationUnit) throws JavaModelException {
        Assert.isNotNull((Object)iCompilationUnit);
        Assert.isTrue((iTextSelection.getOffset() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((iTextSelection.getLength() >= 0 ? 1 : 0) != 0);
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)iCompilationUnit)) {
            return;
        }
        IMethod iMethod = MoveInstanceMethodAction.getMethod(iCompilationUnit, iTextSelection);
        if (iMethod != null) {
            RefactoringExecutionStarter.startMoveMethodRefactoring(iMethod, this.getShell());
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.MoveInstanceMethodAction_dialog_title, (String)RefactoringMessages.MoveInstanceMethodAction_No_reference_or_declaration);
        }
    }

    private static IMethod getMethod(ICompilationUnit iCompilationUnit, ITextSelection iTextSelection) throws JavaModelException {
        IJavaElement iJavaElement = SelectionConverter.getElementAtOffset((IJavaElement)iCompilationUnit, iTextSelection);
        if (iJavaElement instanceof IMethod) {
            return (IMethod)iJavaElement;
        }
        return null;
    }
}

