/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.CompilationUnitEntry;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchResult;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchResultRequestor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class NLSSearchQuery
implements ISearchQuery {
    private NLSSearchResult fResult;
    private IJavaElement[] fWrapperClass;
    private IFile[] fPropertiesFile;
    private IJavaSearchScope fScope;
    private String fScopeDescription;

    public NLSSearchQuery(IJavaElement[] iJavaElementArray, IFile[] iFileArray, IJavaSearchScope iJavaSearchScope, String string) {
        this.fWrapperClass = iJavaElementArray;
        this.fPropertiesFile = iFileArray;
        this.fScope = iJavaSearchScope;
        this.fScopeDescription = string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus run(IProgressMonitor iProgressMonitor) {
        block17: {
            IStatus iStatus;
            block15: {
                IStatus iStatus2;
                block14: {
                    iProgressMonitor.beginTask("", 5 * this.fWrapperClass.length);
                    try {
                        AbstractTextSearchResult abstractTextSearchResult = (AbstractTextSearchResult)this.getSearchResult();
                        abstractTextSearchResult.removeAll();
                        AppearanceAwareLabelProvider appearanceAwareLabelProvider = new AppearanceAwareLabelProvider(JavaElementLabels.ALL_POST_QUALIFIED, 0);
                        int n = 0;
                        while (n < this.fWrapperClass.length) {
                            IJavaElement iJavaElement = this.fWrapperClass[n];
                            IFile iFile = this.fPropertiesFile[n];
                            if (!iJavaElement.exists()) {
                                iStatus2 = JavaUIStatus.createError(0, Messages.format(NLSSearchMessages.NLSSearchQuery_wrapperNotExists, iJavaElement.getElementName()), null);
                                Object var19_22 = null;
                                break block14;
                            }
                            if (!iJavaElement.exists()) {
                                iStatus = JavaUIStatus.createError(0, Messages.format(NLSSearchMessages.NLSSearchQuery_propertiesNotExists, iFile.getName()), null);
                                break block15;
                            }
                            SearchPattern searchPattern = SearchPattern.createPattern((IJavaElement)iJavaElement, (int)2, (int)24);
                            SearchParticipant[] searchParticipantArray = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                            NLSSearchResultRequestor nLSSearchResultRequestor = new NLSSearchResultRequestor(iFile, this.fResult);
                            try {
                                SearchEngine searchEngine = new SearchEngine();
                                searchEngine.search(searchPattern, searchParticipantArray, this.fScope, (SearchRequestor)nLSSearchResultRequestor, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4));
                                nLSSearchResultRequestor.reportUnusedPropertyNames((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                                ICompilationUnit iCompilationUnit = ((IType)iJavaElement).getCompilationUnit();
                                CompilationUnitEntry compilationUnitEntry = new CompilationUnitEntry(Messages.format(NLSSearchMessages.NLSSearchResultCollector_unusedKeys, appearanceAwareLabelProvider.getText(iCompilationUnit)), iCompilationUnit);
                                boolean bl = false;
                                IField[] iFieldArray = ((IType)iJavaElement).getFields();
                                int n2 = 0;
                                while (true) {
                                    ISourceRange iSourceRange;
                                    if (n2 >= iFieldArray.length) {
                                        if (bl) {
                                            this.fResult.addCompilationUnitGroup(compilationUnitEntry);
                                        }
                                        break;
                                    }
                                    IField iField = iFieldArray[n2];
                                    if (this.isNLSField(iField) && (iSourceRange = iField.getSourceRange()) != null) {
                                        String string = iField.getElementName();
                                        if (!nLSSearchResultRequestor.hasPropertyKey(string)) {
                                            this.fResult.addMatch(new Match((Object)iCompilationUnit, iSourceRange.getOffset(), iSourceRange.getLength()));
                                        }
                                        if (!nLSSearchResultRequestor.isUsedPropertyKey(string)) {
                                            bl = true;
                                            this.fResult.addMatch(new Match((Object)compilationUnitEntry, iSourceRange.getOffset(), iSourceRange.getLength()));
                                        }
                                    }
                                    ++n2;
                                }
                            }
                            catch (CoreException coreException) {
                                JavaPlugin.log(coreException);
                            }
                            ++n;
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var19_24 = null;
                        iProgressMonitor.done();
                        throw throwable;
                    }
                }
                iProgressMonitor.done();
                return iStatus2;
            }
            Object var19_23 = null;
            iProgressMonitor.done();
            return iStatus;
        }
        Object var19_25 = null;
        iProgressMonitor.done();
        return Status.OK_STATUS;
    }

    private boolean isNLSField(IField iField) throws JavaModelException {
        int n = iField.getFlags();
        if (!Flags.isPublic((int)n)) {
            return false;
        }
        if (!Flags.isStatic((int)n)) {
            return false;
        }
        String string = iField.getElementName();
        if ("BUNDLE_NAME".equals(string)) {
            return false;
        }
        return !"RESOURCE_BUNDLE".equals(string);
    }

    public String getLabel() {
        return NLSSearchMessages.NLSSearchQuery_label;
    }

    public String getResultLabel(int n) {
        if (this.fWrapperClass.length == 1) {
            if (n == 1) {
                Object[] objectArray = new String[]{this.fWrapperClass[0].getElementName(), this.fScopeDescription};
                return Messages.format(NLSSearchMessages.SearchOperation_singularLabelPostfix, objectArray);
            }
            Object[] objectArray = new String[]{this.fWrapperClass[0].getElementName(), String.valueOf(n), this.fScopeDescription};
            return Messages.format(NLSSearchMessages.SearchOperation_pluralLabelPatternPostfix, objectArray);
        }
        if (n == 1) {
            return Messages.format(NLSSearchMessages.NLSSearchQuery_oneProblemInScope_description, this.fScopeDescription);
        }
        return Messages.format(NLSSearchMessages.NLSSearchQuery_xProblemsInScope_description, new Object[]{String.valueOf(n), this.fScopeDescription});
    }

    public boolean canRerun() {
        return true;
    }

    public boolean canRunInBackground() {
        return true;
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new NLSSearchResult(this);
        }
        return this.fResult;
    }
}

