/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.IWidgetTokenOwnerExtension;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameLinkedMode;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;

public class RenameInformationPopup
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    private static boolean CARBON = "carbon".equals(SWT.getPlatform());
    private static final int WIDGET_PRIORITY = 1000;
    private static final String DIALOG_SETTINGS_SECTION = "RenameInformationPopup";
    private static final String SNAP_POSITION_KEY = "snap_position";
    private static final int SNAP_POSITION_UNDER_RIGHT_FIELD = 0;
    private static final int SNAP_POSITION_OVER_RIGHT_FIELD = 1;
    private static final int SNAP_POSITION_UNDER_LEFT_FIELD = 2;
    private static final int SNAP_POSITION_OVER_LEFT_FIELD = 3;
    private static final int SNAP_POSITION_LOWER_RIGHT = 4;
    private static final int POPUP_VISIBILITY_DELAY = 300;
    private static final int HAO = 10;
    private static final int HAW = 8;
    private static final int HAH = 10;
    private static final int GAP = 2;
    private final CompilationUnitEditor fEditor;
    private final RenameLinkedMode fRenameLinkedMode;
    private int fSnapPosition;
    private Shell fPopup;
    private GridLayout fPopupLayout;
    private Region fRegion;
    private Image fMenuImage;
    private MenuManager fMenuManager;
    private ToolBar fToolBar;
    private String fOpenDialogBinding = "";
    private boolean fIsMenuUp = false;
    private boolean fDelayJobFinished = false;
    static /* synthetic */ Class class$0;

    public RenameInformationPopup(CompilationUnitEditor compilationUnitEditor, RenameLinkedMode renameLinkedMode) {
        this.fEditor = compilationUnitEditor;
        this.fRenameLinkedMode = renameLinkedMode;
        this.restoreSnapPosition();
    }

    private void restoreSnapPosition() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        try {
            this.fSnapPosition = iDialogSettings.getInt(SNAP_POSITION_KEY);
        }
        catch (NumberFormatException numberFormatException) {
            this.fSnapPosition = 2;
        }
    }

    private IDialogSettings getDialogSettings() {
        return JavaPlugin.getDefault().getDialogSettingsSection(DIALOG_SETTINGS_SECTION);
    }

    public void open() {
        this.fOpenDialogBinding = RenameInformationPopup.getOpenDialogBinding();
        Shell shell = this.fEditor.getSite().getShell();
        final Display display = shell.getDisplay();
        this.fPopup = new Shell(shell, 16396);
        this.fPopupLayout = new GridLayout(2, false);
        this.fPopupLayout.marginWidth = 1;
        this.fPopupLayout.marginHeight = 1;
        this.fPopupLayout.marginLeft = 4;
        this.fPopupLayout.horizontalSpacing = 0;
        this.fPopup.setLayout((Layout)this.fPopupLayout);
        this.createContent((Composite)this.fPopup);
        this.updatePopupLocation(true);
        new PopupVisibilityManager().start();
        this.fPopup.addShellListener((ShellListener)new ShellAdapter(){

            public void shellDeactivated(ShellEvent shellEvent) {
                if (RenameInformationPopup.this.fIsMenuUp) {
                    return;
                }
                Shell shell = RenameInformationPopup.this.fEditor.getSite().getShell();
                display.asyncExec(new Runnable(this, display, shell){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Display val$display;
                    private final /* synthetic */ Shell val$editorShell;
                    {
                        this.this$1 = var1_1;
                        this.val$display = display;
                        this.val$editorShell = shell;
                    }

                    public void run() {
                        Shell shell = this.val$display.getActiveShell();
                        if (shell != this.val$editorShell) {
                            RenameInformationPopup.access$6(2.access$0(this.this$1)).cancel();
                        }
                    }
                });
            }

            static /* synthetic */ RenameInformationPopup access$0(2 var0) {
                return var0.RenameInformationPopup.this;
            }
        });
        if (!CARBON) {
            this.fPopup.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    paintEvent.gc.drawPolygon(RenameInformationPopup.this.getPolygon(true));
                }
            });
        }
        UIJob uIJob = new UIJob(display, ReorgMessages.RenameInformationPopup_delayJobName){

            public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                RenameInformationPopup.this.fDelayJobFinished = true;
                if (RenameInformationPopup.this.fPopup != null && !RenameInformationPopup.this.fPopup.isDisposed()) {
                    RenameInformationPopup.this.updateVisibility();
                }
                return Status.OK_STATUS;
            }
        };
        uIJob.setSystem(true);
        uIJob.setPriority(10);
        uIJob.schedule(300L);
    }

    public void close() {
        if (this.fPopup != null) {
            if (!this.fPopup.isDisposed()) {
                this.fPopup.close();
            }
            this.fPopup = null;
        }
        this.releaseWidgetToken();
        if (this.fRegion != null && !this.fRegion.isDisposed()) {
            this.fRegion.dispose();
        }
    }

    public Shell getShell() {
        return this.fPopup;
    }

    private void updatePopupLocation(boolean bl) {
        if (!bl && this.fSnapPosition == 4) {
            return;
        }
        this.packPopup();
        Point point = this.computePopupLocation(this.fSnapPosition);
        if (point != null) {
            this.fPopup.setLocation(point);
        }
    }

    private void updateVisibility() {
        if (this.fPopup != null && !this.fPopup.isDisposed() && this.fDelayJobFinished) {
            Rectangle rectangle;
            StyledText styledText;
            boolean bl = false;
            if (this.fRenameLinkedMode.isCaretInLinkedPosition()) {
                styledText = this.fEditor.getViewer().getTextWidget();
                rectangle = Geometry.toDisplay((Control)styledText, (Rectangle)styledText.getClientArea());
                Rectangle rectangle2 = this.fPopup.getBounds();
                rectangle2.x -= 2;
                rectangle2.y -= 2;
                rectangle2.width += 4;
                rectangle2.height += 4;
                if (rectangle.intersects(rectangle2)) {
                    bl = true;
                }
            }
            if (bl && !this.fPopup.isVisible()) {
                styledText = this.fEditor.getViewer();
                if (styledText instanceof IWidgetTokenOwnerExtension) {
                    rectangle = (IWidgetTokenOwnerExtension)styledText;
                    rectangle.requestWidgetToken((IWidgetTokenKeeper)this, 1000);
                }
            } else if (!bl && this.fPopup.isVisible()) {
                this.releaseWidgetToken();
            }
            this.fPopup.setVisible(bl);
        }
    }

    private void releaseWidgetToken() {
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        if (iSourceViewer instanceof IWidgetTokenOwner) {
            IWidgetTokenOwner iWidgetTokenOwner = (IWidgetTokenOwner)iSourceViewer;
            iWidgetTokenOwner.releaseWidgetToken((IWidgetTokenKeeper)this);
        }
    }

    private Point computePopupLocation(int n) {
        if (this.fPopup == null || this.fPopup.isDisposed()) {
            return null;
        }
        switch (n) {
            case 4: {
                StyledText styledText = this.fEditor.getViewer().getTextWidget();
                Rectangle rectangle = styledText.getClientArea();
                Point point = styledText.toDisplay(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
                Point point2 = this.getExtent();
                return new Point(point.x - point2.x - 5, point.y - point2.y - 5);
            }
            case 0: 
            case 1: {
                LinkedPosition linkedPosition = this.fRenameLinkedMode.getCurrentLinkedPosition();
                if (linkedPosition == null) {
                    return null;
                }
                ISourceViewer iSourceViewer = this.fEditor.getViewer();
                ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
                int n2 = iTextViewerExtension5.modelOffset2WidgetOffset(linkedPosition.offset + linkedPosition.length);
                StyledText styledText = iSourceViewer.getTextWidget();
                Point point = styledText.getLocationAtOffset(n2);
                Point point3 = this.getExtent();
                point.y = n == 1 ? (point.y -= point3.y + 2) : (point.y += styledText.getLineHeight(n2) + 2);
                point.x += 2;
                Point point4 = styledText.toDisplay(point);
                Rectangle rectangle = styledText.getDisplay().getClientArea();
                Rectangle rectangle2 = Geometry.createRectangle((Point)point4, (Point)point3);
                Geometry.moveInside((Rectangle)rectangle2, (Rectangle)rectangle);
                return new Point(rectangle2.x, rectangle2.y);
            }
        }
        LinkedPosition linkedPosition = this.fRenameLinkedMode.getCurrentLinkedPosition();
        if (linkedPosition == null) {
            return null;
        }
        ISourceViewer iSourceViewer = this.fEditor.getViewer();
        ITextViewerExtension5 iTextViewerExtension5 = (ITextViewerExtension5)iSourceViewer;
        int n3 = iTextViewerExtension5.modelOffset2WidgetOffset(linkedPosition.offset);
        StyledText styledText = iSourceViewer.getTextWidget();
        Point point = styledText.getLocationAtOffset(n3);
        Point point5 = this.getExtent();
        point5.y += 11;
        point.x -= 10;
        point.y = n == 3 ? (point.y -= point5.y) : (point.y += styledText.getLineHeight(n3));
        Point point6 = styledText.toDisplay(point);
        Rectangle rectangle = styledText.getDisplay().getClientArea();
        Rectangle rectangle3 = Geometry.createRectangle((Point)point6, (Point)point5);
        Geometry.moveInside((Rectangle)rectangle3, (Rectangle)rectangle);
        return new Point(rectangle3.x, rectangle3.y);
    }

    private void addMoveSupport(final Shell shell, Control control) {
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button != 1) {
                    return;
                }
                Point point = shell.getLocation();
                StyledText styledText = RenameInformationPopup.this.fEditor.getViewer().getTextWidget();
                Point point2 = RenameInformationPopup.this.getExtent();
                int n = RenameInformationPopup.this.fSnapPosition;
                Tracker tracker = new Tracker((Composite)styledText, 0);
                Point[] pointArray = new Point[]{styledText.toControl(RenameInformationPopup.this.computePopupLocation(0)), styledText.toControl(RenameInformationPopup.this.computePopupLocation(1)), styledText.toControl(RenameInformationPopup.this.computePopupLocation(2)), styledText.toControl(RenameInformationPopup.this.computePopupLocation(3)), styledText.toControl(RenameInformationPopup.this.computePopupLocation(4))};
                Rectangle[] rectangleArray = new Rectangle[]{Geometry.createRectangle((Point)pointArray[0], (Point)point2), Geometry.createRectangle((Point)pointArray[1], (Point)point2), new Rectangle(pointArray[2].x, pointArray[2].y + 10, point2.x, point2.y), Geometry.createRectangle((Point)pointArray[3], (Point)point2), Geometry.createRectangle((Point)pointArray[4], (Point)point2)};
                Rectangle rectangle = new Rectangle(1000000, 0, 0, 0);
                tracker.setRectangles(new Rectangle[]{rectangle, rectangleArray[RenameInformationPopup.this.fSnapPosition]});
                tracker.setStippled(true);
                ControlAdapter controlAdapter = new ControlAdapter(this, tracker, point, rectangle, shell, styledText, rectangleArray, pointArray){
                    final /* synthetic */ 6 this$1;
                    private final /* synthetic */ Tracker val$tracker;
                    private final /* synthetic */ Point val$POPUP_SOURCE;
                    private final /* synthetic */ Rectangle val$MOUSE_MOVE_SOURCE;
                    private final /* synthetic */ Shell val$popupShell;
                    private final /* synthetic */ StyledText val$textWidget;
                    private final /* synthetic */ Rectangle[] val$DROP_TARGETS;
                    private final /* synthetic */ Point[] val$LOCATIONS;
                    {
                        this.this$1 = var1_1;
                        this.val$tracker = tracker;
                        this.val$POPUP_SOURCE = point;
                        this.val$MOUSE_MOVE_SOURCE = rectangle;
                        this.val$popupShell = shell;
                        this.val$textWidget = styledText;
                        this.val$DROP_TARGETS = rectangleArray;
                        this.val$LOCATIONS = pointArray;
                    }

                    public void controlMoved(ControlEvent controlEvent) {
                        Rectangle[] rectangleArray = this.val$tracker.getRectangles();
                        Rectangle rectangle = rectangleArray[0];
                        Point point = new Point(this.val$POPUP_SOURCE.x + rectangle.x - this.val$MOUSE_MOVE_SOURCE.x, this.val$POPUP_SOURCE.y + rectangle.y - this.val$MOUSE_MOVE_SOURCE.y);
                        this.val$popupShell.setLocation(point);
                        Point point2 = this.val$textWidget.toControl(point);
                        int n = Integer.MAX_VALUE;
                        int n2 = 0;
                        while (n2 < this.val$DROP_TARGETS.length) {
                            int n3 = Geometry.distanceSquared((Point)point2, (Point)this.val$LOCATIONS[n2]);
                            if (n3 < n) {
                                n = n3;
                                RenameInformationPopup.access$15(6.access$0(this.this$1), n2);
                                rectangleArray[1] = this.val$DROP_TARGETS[n2];
                            }
                            ++n2;
                        }
                        this.val$tracker.setRectangles(rectangleArray);
                    }
                };
                tracker.addControlListener((ControlListener)controlAdapter);
                boolean bl = tracker.open();
                tracker.close();
                tracker.dispose();
                if (bl) {
                    RenameInformationPopup.this.getDialogSettings().put(RenameInformationPopup.SNAP_POSITION_KEY, RenameInformationPopup.this.fSnapPosition);
                } else {
                    RenameInformationPopup.this.fSnapPosition = n;
                }
                RenameInformationPopup.this.updatePopupLocation(true);
                RenameInformationPopup.this.activateEditor();
            }

            static /* synthetic */ RenameInformationPopup access$0(6 var0) {
                return var0.RenameInformationPopup.this;
            }
        });
    }

    private void packPopup() {
        boolean bl = this.fSnapPosition == 2;
        boolean bl2 = this.fSnapPosition == 3;
        this.fPopupLayout.marginTop = bl ? 10 : 0;
        this.fPopupLayout.marginBottom = bl2 ? 11 : 0;
        this.fPopup.pack();
        Region region = this.fRegion;
        if (bl || bl2) {
            this.fRegion = new Region();
            this.fRegion.add(this.getPolygon(false));
            this.fPopup.setRegion(this.fRegion);
            Rectangle rectangle = this.fRegion.getBounds();
            this.fPopup.setSize(rectangle.width, rectangle.height + 1);
        } else {
            this.fRegion = null;
            this.fPopup.setRegion(null);
        }
        if (region != null) {
            region.dispose();
        }
    }

    private Point getExtent() {
        Point point = this.fPopup.getSize();
        switch (this.fSnapPosition) {
            case 2: {
                point.y -= 10;
                break;
            }
            case 3: {
                point.y -= 11;
            }
        }
        return point;
    }

    private int[] getPolygon(boolean bl) {
        Point point = this.getExtent();
        int n = bl ? 1 : 0;
        switch (this.fSnapPosition) {
            case 3: {
                int[] nArray = new int[16];
                nArray[2] = point.x - n;
                nArray[4] = point.x - n;
                nArray[5] = point.y - n;
                nArray[6] = 18;
                nArray[7] = point.y - n;
                nArray[8] = 14;
                nArray[9] = point.y + 10 - n;
                nArray[10] = 10;
                nArray[11] = point.y - n;
                nArray[13] = point.y - n;
                return nArray;
            }
            case 2: {
                int[] nArray = new int[16];
                nArray[1] = 10;
                nArray[2] = 10 + n;
                nArray[3] = 10;
                nArray[4] = 14;
                nArray[5] = n;
                nArray[6] = 18 - n;
                nArray[7] = 10;
                nArray[8] = point.x - n;
                nArray[9] = 10;
                nArray[10] = point.x - n;
                nArray[11] = point.y + 10 - n;
                nArray[13] = point.y + 10 - n;
                nArray[15] = 10;
                return nArray;
            }
        }
        int[] nArray = new int[10];
        nArray[2] = point.x - n;
        nArray[4] = point.x - n;
        nArray[5] = point.y - n;
        nArray[7] = point.y - n;
        return nArray;
    }

    private void createContent(Composite composite) {
        Display display = composite.getDisplay();
        Color color = display.getSystemColor(28);
        Color color2 = display.getSystemColor(29);
        this.addMoveSupport(this.fPopup, (Control)composite);
        StyledText styledText = new StyledText((Composite)this.fPopup, 12);
        String string = RenameInformationPopup.getEnterBinding();
        String string2 = ReorgMessages.RenameInformationPopup_EnterNewName;
        styledText.setText(Messages.format(string2, string));
        styledText.setForeground(color);
        styledText.setStyleRange(new StyleRange(string2.indexOf("{0}"), string.length(), null, null, 1));
        styledText.setEnabled(false);
        this.addMoveSupport(this.fPopup, (Control)styledText);
        this.addViewMenu(composite);
        RenameInformationPopup.recursiveSetBackgroundColor((Control)composite, color2);
    }

    private ToolBar addViewMenu(Composite composite) {
        this.fToolBar = new ToolBar(composite, 0x800000);
        ToolItem toolItem = new ToolItem(this.fToolBar, 8, 0);
        this.fMenuImage = JavaPluginImages.DESC_ELCL_VIEW_MENU.createImage();
        toolItem.setImage(this.fMenuImage);
        toolItem.setToolTipText(ReorgMessages.RenameInformationPopup_menu);
        this.fToolBar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                RenameInformationPopup.this.showMenu(RenameInformationPopup.this.fToolBar);
            }
        });
        toolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                RenameInformationPopup.this.showMenu(RenameInformationPopup.this.fToolBar);
            }
        });
        this.fToolBar.pack();
        return this.fToolBar;
    }

    private void showMenu(ToolBar toolBar) {
        Menu menu = this.getMenuManager().createContextMenu((Control)toolBar);
        menu.setLocation(toolBar.toDisplay(0, toolBar.getSize().y));
        this.fIsMenuUp = true;
        menu.setVisible(true);
    }

    private MenuManager getMenuManager() {
        if (this.fMenuManager != null) {
            return this.fMenuManager;
        }
        this.fMenuManager = new MenuManager();
        this.fMenuManager.setRemoveAllWhenShown(true);
        this.fMenuManager.addMenuListener((IMenuListener)new IMenuListener2(){

            public void menuAboutToHide(IMenuManager iMenuManager) {
                RenameInformationPopup.this.fIsMenuUp = false;
            }

            public void menuAboutToShow(IMenuManager iMenuManager) {
                Action action = new Action(this, ReorgMessages.RenameInformationPopup_RenameInWorkspace){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RenameInformationPopup.access$17(10.access$0(this.this$1));
                        RenameInformationPopup.access$6(10.access$0(this.this$1)).doRename(false);
                    }
                };
                action.setAccelerator(13);
                iMenuManager.add((IAction)action);
                Action action2 = new Action(this, ReorgMessages.RenameInformationPopup_Preview){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RenameInformationPopup.access$17(10.access$0(this.this$1));
                        RenameInformationPopup.access$6(10.access$0(this.this$1)).doRename(true);
                    }
                };
                action2.setAccelerator(262157);
                iMenuManager.add((IAction)action2);
                Action action3 = new Action(this, String.valueOf(ReorgMessages.RenameInformationPopup_OpenDialog) + '\t' + RenameInformationPopup.this.fOpenDialogBinding){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RenameInformationPopup.access$17(10.access$0(this.this$1));
                        RenameInformationPopup.access$6(10.access$0(this.this$1)).startFullDialog();
                    }
                };
                iMenuManager.add((IAction)action3);
                iMenuManager.add((IContributionItem)new Separator());
                MenuManager menuManager = new MenuManager(ReorgMessages.RenameInformationPopup_SnapTo);
                RenameInformationPopup.this.addMoveMenuItem((IMenuManager)menuManager, 2, ReorgMessages.RenameInformationPopup_snap_under_left);
                RenameInformationPopup.this.addMoveMenuItem((IMenuManager)menuManager, 0, ReorgMessages.RenameInformationPopup_snap_under_right);
                RenameInformationPopup.this.addMoveMenuItem((IMenuManager)menuManager, 3, ReorgMessages.RenameInformationPopup_snap_over_left);
                RenameInformationPopup.this.addMoveMenuItem((IMenuManager)menuManager, 1, ReorgMessages.RenameInformationPopup_snap_over_right);
                RenameInformationPopup.this.addMoveMenuItem((IMenuManager)menuManager, 4, ReorgMessages.RenameInformationPopup_snap_bottom_right);
                iMenuManager.add((IContributionItem)menuManager);
                Action action4 = new Action(this, ReorgMessages.RenameInformationPopup_preferences){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RenameInformationPopup.access$6(10.access$0(this.this$1)).cancel();
                        String string = "org.eclipse.ui.editors.preferencePages.LinkedModePreferencePage";
                        String string2 = "org.eclipse.wst.jsdt.ui.preferences.JavaBasePreferencePage";
                        PreferencesUtil.createPreferenceDialogOn((Shell)RenameInformationPopup.access$0(10.access$0(this.this$1)).getSite().getShell(), (String)string2, (String[])new String[]{string, string2}, null).open();
                    }
                };
                iMenuManager.add((IAction)action4);
            }

            static /* synthetic */ RenameInformationPopup access$0(10 var0) {
                return var0.RenameInformationPopup.this;
            }
        });
        return this.fMenuManager;
    }

    private void addMoveMenuItem(IMenuManager iMenuManager, final int n, String string) {
        Action action = new Action(string, 8){

            public void run() {
                RenameInformationPopup.this.fSnapPosition = n;
                RenameInformationPopup.this.getDialogSettings().put(RenameInformationPopup.SNAP_POSITION_KEY, RenameInformationPopup.this.fSnapPosition);
                RenameInformationPopup.this.updatePopupLocation(true);
                RenameInformationPopup.this.activateEditor();
            }
        };
        action.setChecked(this.fSnapPosition == n);
        iMenuManager.add((IAction)action);
    }

    private static String getEnterBinding() {
        return KeyStroke.getInstance((int)KeyLookupFactory.getDefault().formalKeyLookup("CR")).format();
    }

    private static String getOpenDialogBinding() {
        IBindingService iBindingService;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.keys.IBindingService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iBindingService = (IBindingService)iWorkbench.getAdapter((Class)clazz)) == null) {
            return "";
        }
        String string = iBindingService.getBestActiveBindingFormattedFor("org.eclipse.wst.jsdt.ui.edit.text.java.rename.element");
        return string == null ? "" : string;
    }

    private static void recursiveSetBackgroundColor(Control control, Color color) {
        control.setBackground(color);
        if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = 0;
            while (n < controlArray.length) {
                RenameInformationPopup.recursiveSetBackgroundColor(controlArray[n], color);
                ++n;
            }
        }
    }

    public boolean ownsFocusShell() {
        if (this.fIsMenuUp) {
            return true;
        }
        if (this.fPopup == null || this.fPopup.isDisposed()) {
            return false;
        }
        Shell shell = this.fPopup.getDisplay().getActiveShell();
        return this.fPopup == shell;
    }

    private void activateEditor() {
        this.fEditor.getSite().getShell().setActive();
    }

    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner) {
        return false;
    }

    public boolean requestWidgetToken(IWidgetTokenOwner iWidgetTokenOwner, int n) {
        return false;
    }

    public boolean setFocus(IWidgetTokenOwner iWidgetTokenOwner) {
        if (this.fToolBar != null && !this.fToolBar.isDisposed()) {
            this.showMenu(this.fToolBar);
        }
        return true;
    }

    static /* synthetic */ Image access$2(RenameInformationPopup renameInformationPopup) {
        return renameInformationPopup.fMenuImage;
    }

    static /* synthetic */ void access$3(RenameInformationPopup renameInformationPopup, Image image) {
        renameInformationPopup.fMenuImage = image;
    }

    static /* synthetic */ MenuManager access$4(RenameInformationPopup renameInformationPopup) {
        return renameInformationPopup.fMenuManager;
    }

    static /* synthetic */ void access$5(RenameInformationPopup renameInformationPopup, MenuManager menuManager) {
        renameInformationPopup.fMenuManager = menuManager;
    }

    static /* synthetic */ RenameLinkedMode access$6(RenameInformationPopup renameInformationPopup) {
        return renameInformationPopup.fRenameLinkedMode;
    }

    private class PopupVisibilityManager
    implements IPartListener2,
    ControlListener,
    MouseListener,
    KeyListener,
    ITextListener,
    IViewportListener {
        private PopupVisibilityManager() {
        }

        public void start() {
            RenameInformationPopup.this.fEditor.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
            ISourceViewer iSourceViewer = RenameInformationPopup.this.fEditor.getViewer();
            StyledText styledText = iSourceViewer.getTextWidget();
            styledText.addControlListener((ControlListener)this);
            styledText.addMouseListener((MouseListener)this);
            styledText.addKeyListener((KeyListener)this);
            RenameInformationPopup.this.fEditor.getSite().getShell().addControlListener((ControlListener)this);
            iSourceViewer.addTextListener((ITextListener)this);
            iSourceViewer.addViewportListener((IViewportListener)this);
            RenameInformationPopup.this.fPopup.addDisposeListener(new DisposeListener(this, styledText, iSourceViewer){
                final /* synthetic */ PopupVisibilityManager this$1;
                private final /* synthetic */ StyledText val$textWidget;
                private final /* synthetic */ ISourceViewer val$viewer;
                {
                    this.this$1 = popupVisibilityManager;
                    this.val$textWidget = styledText;
                    this.val$viewer = iSourceViewer;
                }

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    RenameInformationPopup.access$0(PopupVisibilityManager.access$1(this.this$1)).getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this.this$1);
                    if (!this.val$textWidget.isDisposed()) {
                        this.val$textWidget.removeControlListener((ControlListener)this.this$1);
                        this.val$textWidget.removeMouseListener((MouseListener)this.this$1);
                        this.val$textWidget.removeKeyListener((KeyListener)this.this$1);
                    }
                    RenameInformationPopup.access$0(PopupVisibilityManager.access$1(this.this$1)).getSite().getShell().removeControlListener((ControlListener)this.this$1);
                    this.val$viewer.removeTextListener((ITextListener)this.this$1);
                    this.val$viewer.removeViewportListener((IViewportListener)this.this$1);
                    if (RenameInformationPopup.access$2(PopupVisibilityManager.access$1(this.this$1)) != null) {
                        RenameInformationPopup.access$2(PopupVisibilityManager.access$1(this.this$1)).dispose();
                        RenameInformationPopup.access$3(PopupVisibilityManager.access$1(this.this$1), null);
                    }
                    if (RenameInformationPopup.access$4(PopupVisibilityManager.access$1(this.this$1)) != null) {
                        RenameInformationPopup.access$4(PopupVisibilityManager.access$1(this.this$1)).dispose();
                        RenameInformationPopup.access$5(PopupVisibilityManager.access$1(this.this$1), null);
                    }
                    RenameInformationPopup.access$6(PopupVisibilityManager.access$1(this.this$1)).cancel();
                }
            });
        }

        public void partActivated(IWorkbenchPartReference iWorkbenchPartReference) {
            IWorkbenchPart iWorkbenchPart = RenameInformationPopup.this.fEditor.getEditorSite().getPart();
            if (iWorkbenchPartReference.getPart(false) == iWorkbenchPart) {
                RenameInformationPopup.this.updateVisibility();
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partClosed(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partDeactivated(IWorkbenchPartReference iWorkbenchPartReference) {
            IWorkbenchPart iWorkbenchPart = RenameInformationPopup.this.fEditor.getEditorSite().getPart();
            if (RenameInformationPopup.this.fPopup != null && !RenameInformationPopup.this.fPopup.isDisposed() && iWorkbenchPartReference.getPart(false) == iWorkbenchPart) {
                RenameInformationPopup.this.fPopup.setVisible(false);
            }
        }

        public void partHidden(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partInputChanged(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partOpened(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void partVisible(IWorkbenchPartReference iWorkbenchPartReference) {
        }

        public void controlMoved(ControlEvent controlEvent) {
            RenameInformationPopup.this.updatePopupLocation(true);
            RenameInformationPopup.this.updateVisibility();
        }

        public void controlResized(ControlEvent controlEvent) {
            RenameInformationPopup.this.updatePopupLocation(true);
            RenameInformationPopup.this.updateVisibility();
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
        }

        public void mouseUp(MouseEvent mouseEvent) {
            RenameInformationPopup.this.updatePopupLocation(false);
            RenameInformationPopup.this.updateVisibility();
        }

        public void keyPressed(KeyEvent keyEvent) {
            RenameInformationPopup.this.updatePopupLocation(false);
            RenameInformationPopup.this.updateVisibility();
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void textChanged(TextEvent textEvent) {
            RenameInformationPopup.this.updatePopupLocation(false);
            RenameInformationPopup.this.updateVisibility();
        }

        public void viewportChanged(int n) {
            RenameInformationPopup.this.updatePopupLocation(true);
            RenameInformationPopup.this.updateVisibility();
        }

        static /* synthetic */ RenameInformationPopup access$1(PopupVisibilityManager popupVisibilityManager) {
            return popupVisibilityManager.RenameInformationPopup.this;
        }
    }
}

