/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class RenameSelectionState {
    private final Display fDisplay;
    private final Object fElement;
    private final List fParts;
    private final List fSelections;
    static /* synthetic */ Class class$0;

    public RenameSelectionState(Object object) {
        this.fElement = object;
        this.fParts = new ArrayList();
        this.fSelections = new ArrayList();
        IWorkbenchWindow iWorkbenchWindow = JavaPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            this.fDisplay = null;
            return;
        }
        this.fDisplay = iWorkbenchWindow.getShell().getDisplay();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        if (iWorkbenchPage == null) {
            return;
        }
        IViewReference[] iViewReferenceArray = iWorkbenchPage.getViewReferences();
        int n = 0;
        while (n < iViewReferenceArray.length) {
            this.consider(iViewReferenceArray[n].getPart(false));
            ++n;
        }
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n2 = 0;
        while (n2 < iEditorReferenceArray.length) {
            this.consider(iEditorReferenceArray[n2].getPart(false));
            ++n2;
        }
    }

    private void consider(IWorkbenchPart iWorkbenchPart) {
        ISelectionProvider iSelectionProvider;
        if (iWorkbenchPart == null) {
            return;
        }
        ISetSelectionTarget iSetSelectionTarget = null;
        if (!(iWorkbenchPart instanceof ISetSelectionTarget)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iSetSelectionTarget = (ISetSelectionTarget)iWorkbenchPart.getAdapter((Class)clazz)) == null) {
                return;
            }
        } else {
            iSetSelectionTarget = (ISetSelectionTarget)iWorkbenchPart;
        }
        if ((iSelectionProvider = iWorkbenchPart.getSite().getSelectionProvider()) == null) {
            return;
        }
        ISelection iSelection = iSelectionProvider.getSelection();
        if (!(iSelection instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
        if (!iStructuredSelection.toList().contains(this.fElement)) {
            return;
        }
        this.fParts.add(iWorkbenchPart);
        this.fSelections.add(iStructuredSelection);
    }

    public void restore(Object object) {
        if (this.fDisplay == null) {
            return;
        }
        int n = 0;
        while (n < this.fParts.size()) {
            Object[] objectArray;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)this.fSelections.get(n);
            boolean bl = false;
            final ISetSelectionTarget iSetSelectionTarget = (ISetSelectionTarget)this.fParts.get(n);
            final IStructuredSelection[] iStructuredSelectionArray = new IStructuredSelection[]{iStructuredSelection};
            if (iStructuredSelection instanceof TreeSelection) {
                objectArray = (Object[])iStructuredSelection;
                TreePath[] treePathArray = objectArray.getPaths();
                int n2 = 0;
                while (n2 < treePathArray.length) {
                    TreePath treePath = treePathArray[n2];
                    if (treePath.getSegmentCount() > 0 && treePath.getLastSegment().equals(this.fElement)) {
                        treePathArray[n2] = this.createTreePath(treePath, object);
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) {
                    iStructuredSelectionArray[0] = new TreeSelection(treePathArray, objectArray.getElementComparer());
                }
            } else {
                objectArray = iStructuredSelection.toArray();
                int n3 = 0;
                while (n3 < objectArray.length) {
                    if (objectArray[n3].equals(this.fElement)) {
                        objectArray[n3] = object;
                        bl = true;
                    }
                    ++n3;
                }
                if (bl) {
                    iStructuredSelectionArray[0] = new StructuredSelection(objectArray);
                }
            }
            if (bl) {
                this.fDisplay.asyncExec(new Runnable(){

                    public void run() {
                        iSetSelectionTarget.selectReveal((ISelection)iStructuredSelectionArray[0]);
                    }
                });
            }
            ++n;
        }
    }

    private TreePath createTreePath(TreePath treePath, Object object) {
        int n = treePath.getSegmentCount();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n - 1) {
            objectArray[n2] = treePath.getSegment(n2);
            ++n2;
        }
        objectArray[n - 1] = object;
        return new TreePath(objectArray);
    }
}

