/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.wst.jsdt.internal.ui.text.ITypingRunListener;
import org.eclipse.wst.jsdt.internal.ui.text.TypingRun;

public class TypingRunDetector {
    private static final boolean DEBUG = false;
    private final Set fListeners = new HashSet();
    private ITextViewer fViewer;
    private final TextListener fTextListener = new TextListener();
    private SelectionListener fSelectionListener;
    private Change fLastChange;
    private TypingRun fRun;

    public void install(ITextViewer iTextViewer) {
        Assert.isLegal((iTextViewer != null ? 1 : 0) != 0);
        this.fViewer = iTextViewer;
        this.connect();
    }

    private void connect() {
        if (this.fViewer != null) {
            this.fLastChange = new Change(TypingRun.UNKNOWN, -1);
            this.fRun = null;
            this.fSelectionListener = null;
            this.fViewer.addTextListener((ITextListener)this.fTextListener);
        }
    }

    public void uninstall() {
        if (this.fViewer != null) {
            this.fListeners.clear();
            this.disconnect();
            this.fViewer = null;
        }
    }

    private void disconnect() {
        this.fViewer.removeTextListener((ITextListener)this.fTextListener);
        this.ensureSelectionListenerRemoved();
    }

    public void addTypingRunListener(ITypingRunListener iTypingRunListener) {
        Assert.isLegal((iTypingRunListener != null ? 1 : 0) != 0);
        this.fListeners.add(iTypingRunListener);
        if (this.fListeners.size() == 1) {
            this.connect();
        }
    }

    public void removeTypingRunListener(ITypingRunListener iTypingRunListener) {
        this.fListeners.remove(iTypingRunListener);
        if (this.fListeners.size() == 0) {
            this.disconnect();
        }
    }

    void handleTextChanged(TextEvent textEvent) {
        Change change = this.computeChange(textEvent);
        this.handleChange(change);
    }

    private Change computeChange(TextEvent textEvent) {
        DocumentEvent documentEvent = textEvent.getDocumentEvent();
        if (documentEvent == null) {
            return new Change(TypingRun.NO_CHANGE, -1);
        }
        int n = documentEvent.getOffset();
        int n2 = documentEvent.getOffset() + documentEvent.getLength();
        String string = documentEvent.getText();
        if (string == null) {
            string = new String();
        }
        if (n == n2) {
            if (string.length() == 1) {
                return new Change(TypingRun.INSERT, n2 + 1);
            }
        } else if (n == n2 - 1) {
            if (string.length() == 1) {
                return new Change(TypingRun.OVERTYPE, n2);
            }
            if (string.length() == 0) {
                return new Change(TypingRun.DELETE, n);
            }
        }
        return new Change(TypingRun.UNKNOWN, -1);
    }

    void handleSelectionChanged() {
        this.handleChange(new Change(TypingRun.SELECTION, -1));
    }

    private void handleChange(Change change) {
        if (change.getType() == TypingRun.NO_CHANGE) {
            return;
        }
        if (!change.canFollow(this.fLastChange)) {
            this.endIfStarted(change);
        }
        this.fLastChange = change;
        if (change.isModification()) {
            this.startOrContinue();
        }
    }

    private void startOrContinue() {
        if (!this.hasRun()) {
            this.fRun = new TypingRun(this.fLastChange.getType());
            this.ensureSelectionListenerAdded();
            this.fireRunBegun(this.fRun);
        }
    }

    private boolean hasRun() {
        return this.fRun != null;
    }

    private void endIfStarted(Change change) {
        if (this.hasRun()) {
            this.ensureSelectionListenerRemoved();
            this.fireRunEnded(this.fRun, change.getType());
            this.fRun = null;
        }
    }

    private void ensureSelectionListenerAdded() {
        if (this.fSelectionListener == null) {
            this.fSelectionListener = new SelectionListener();
            StyledText styledText = this.fViewer.getTextWidget();
            styledText.addFocusListener((FocusListener)this.fSelectionListener);
            styledText.addKeyListener((KeyListener)this.fSelectionListener);
            styledText.addMouseListener((MouseListener)this.fSelectionListener);
        }
    }

    private void ensureSelectionListenerRemoved() {
        if (this.fSelectionListener != null) {
            StyledText styledText = this.fViewer.getTextWidget();
            styledText.removeFocusListener((FocusListener)this.fSelectionListener);
            styledText.removeKeyListener((KeyListener)this.fSelectionListener);
            styledText.removeMouseListener((MouseListener)this.fSelectionListener);
            this.fSelectionListener = null;
        }
    }

    private void fireRunBegun(TypingRun typingRun) {
        ArrayList arrayList = new ArrayList(this.fListeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ITypingRunListener iTypingRunListener = (ITypingRunListener)iterator.next();
            iTypingRunListener.typingRunStarted(this.fRun);
        }
    }

    private void fireRunEnded(TypingRun typingRun, TypingRun.ChangeType changeType) {
        ArrayList arrayList = new ArrayList(this.fListeners);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            ITypingRunListener iTypingRunListener = (ITypingRunListener)iterator.next();
            iTypingRunListener.typingRunEnded(this.fRun, changeType);
        }
    }

    private static final class Change {
        private TypingRun.ChangeType fType;
        private int fNextOffset;

        public Change(TypingRun.ChangeType changeType, int n) {
            this.fType = changeType;
            this.fNextOffset = n;
        }

        public boolean canFollow(Change change) {
            if (this.fType == TypingRun.NO_CHANGE) {
                return true;
            }
            if (this.fType.equals(TypingRun.UNKNOWN)) {
                return false;
            }
            if (this.fType.equals(change.fType)) {
                if (this.fType == TypingRun.DELETE) {
                    return this.fNextOffset == change.fNextOffset - 1;
                }
                if (this.fType == TypingRun.INSERT) {
                    return this.fNextOffset == change.fNextOffset + 1;
                }
                if (this.fType == TypingRun.OVERTYPE) {
                    return this.fNextOffset == change.fNextOffset + 1;
                }
                if (this.fType == TypingRun.SELECTION) {
                    return true;
                }
            }
            return false;
        }

        public boolean isModification() {
            return this.fType.isModification();
        }

        public String toString() {
            return String.valueOf(this.fType.toString()) + "@" + this.fNextOffset;
        }

        public TypingRun.ChangeType getType() {
            return this.fType;
        }
    }

    private class SelectionListener
    implements MouseListener,
    KeyListener,
    FocusListener {
        private SelectionListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
            TypingRunDetector.this.handleSelectionChanged();
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public void mouseDoubleClick(MouseEvent mouseEvent) {
        }

        public void mouseDown(MouseEvent mouseEvent) {
            if (mouseEvent.button == 1) {
                TypingRunDetector.this.handleSelectionChanged();
            }
        }

        public void mouseUp(MouseEvent mouseEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: 
                case 0x1000005: 
                case 0x1000006: 
                case 0x1000007: 
                case 0x1000008: {
                    TypingRunDetector.this.handleSelectionChanged();
                }
            }
        }
    }

    private class TextListener
    implements ITextListener {
        private TextListener() {
        }

        public void textChanged(TextEvent textEvent) {
            TypingRunDetector.this.handleTextChanged(textEvent);
        }
    }
}

