/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.comment;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class CommentFormattingStrategy
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    private int fLastDocumentHash;
    private int fLastHeaderHash;
    private int fLastMainTokenEnd = -1;
    private int fLastDocumentsHeaderEnd;

    public void format() {
        IDocument iDocument = (IDocument)this.fDocuments.getFirst();
        TextEdit textEdit = this.calculateTextEdit();
        if (textEdit == null) {
            return;
        }
        try {
            textEdit.apply(iDocument);
        }
        catch (MalformedTreeException malformedTreeException) {
            JavaPlugin.log(malformedTreeException);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextEdit calculateTextEdit() {
        boolean bl;
        boolean bl2;
        TextEdit textEdit;
        Map map;
        block16: {
            super.format();
            IDocument iDocument = (IDocument)this.fDocuments.removeFirst();
            TypedPosition typedPosition = (TypedPosition)this.fPartitions.removeFirst();
            if (iDocument == null) return null;
            if (typedPosition == null) {
                return null;
            }
            map = this.getPreferences();
            boolean bl3 = "true".equals(map.get("org.eclipse.wst.jsdt.core.formatter.comment.format_header"));
            int n = this.computeHeaderEnd(iDocument, map);
            textEdit = null;
            if (typedPosition.offset >= n) {
                try {
                    int n2 = iDocument.getLineOffset(iDocument.getLineOfOffset(typedPosition.getOffset()));
                    int n3 = typedPosition.getOffset() - n2;
                    int n4 = n3 + typedPosition.getLength();
                    String string = iDocument.get(n2, n4);
                    CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)map, (int)ToolFactory.M_FORMAT_EXISTING);
                    int n5 = this.inferIndentationLevel(string.substring(0, n3), CommentFormattingStrategy.getTabSize(map), CommentFormattingStrategy.getIndentSize(map));
                    textEdit = codeFormatter.format(CommentFormattingStrategy.getKindForPartitionType(typedPosition.getType()), string, n3, typedPosition.getLength(), n5, TextUtilities.getDefaultLineDelimiter((IDocument)iDocument));
                    if (textEdit == null) return textEdit;
                    textEdit.moveTree(n2);
                    return textEdit;
                }
                catch (BadLocationException badLocationException) {
                    JavaPlugin.log(badLocationException);
                    return textEdit;
                }
            }
            if (!bl3) return textEdit;
            boolean bl4 = "true".equals(map.get("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments"));
            if (!bl4) {
                map.put("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments", "true");
            }
            if (!(bl2 = "true".equals(map.get("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments")))) {
                map.put("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "true");
            }
            if (!(bl = "true".equals(map.get("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments")))) {
                map.put("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments", "true");
            }
            try {
                try {
                    int n6 = iDocument.getLineOffset(iDocument.getLineOfOffset(typedPosition.getOffset()));
                    int n7 = typedPosition.getOffset() - n6;
                    int n8 = n7 + typedPosition.getLength();
                    String string = iDocument.get(n6, n8);
                    CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)map);
                    int n9 = this.inferIndentationLevel(string.substring(0, n7), CommentFormattingStrategy.getTabSize(map), CommentFormattingStrategy.getIndentSize(map));
                    textEdit = codeFormatter.format(CommentFormattingStrategy.getKindForPartitionType(typedPosition.getType()), string, n7, typedPosition.getLength(), n9, TextUtilities.getDefaultLineDelimiter((IDocument)iDocument));
                    if (textEdit != null) {
                        textEdit.moveTree(n6);
                    }
                }
                catch (BadLocationException badLocationException) {
                    JavaPlugin.log(badLocationException);
                }
            }
            catch (Throwable throwable) {
                Object var16_25 = null;
                if (!bl4) {
                    map.put("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments", "false");
                }
                if (!bl2) {
                    map.put("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "false");
                }
                if (bl) throw throwable;
                map.put("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments", "false");
                throw throwable;
            }
            {
                Object var16_26 = null;
                if (bl4) break block16;
                map.put("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments", "false");
            }
        }
        if (!bl2) {
            map.put("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "false");
        }
        if (bl) return textEdit;
        map.put("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments", "false");
        return textEdit;
    }

    public void formatterStarts(IFormattingContext iFormattingContext) {
        super.formatterStarts(iFormattingContext);
        this.fPartitions.addLast(iFormattingContext.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(iFormattingContext.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        this.fPartitions.clear();
        this.fDocuments.clear();
        super.formatterStops();
    }

    private static int getKindForPartitionType(String string) {
        if ("__java_singleline_comment".equals(string)) {
            return 16;
        }
        if ("__java_multiline_comment".equals(string)) {
            return 32;
        }
        if ("__java_javadoc".equals(string)) {
            return 64;
        }
        return 0;
    }

    private int inferIndentationLevel(String string, int n, int n2) {
        StringBuffer stringBuffer = CommentFormattingStrategy.expandTabs(string, n);
        int n3 = stringBuffer.length();
        if (n == 0) {
            return n3;
        }
        int n4 = n3 / n2;
        if (n3 % n2 > 0) {
            ++n4;
        }
        return n4;
    }

    private static StringBuffer expandTabs(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n2 < n3) {
            char c = string.charAt(n2);
            if (c == '\t') {
                while (n4 < n) {
                    stringBuffer.append(' ');
                    ++n4;
                }
                n4 = 0;
            } else {
                stringBuffer.append(c);
                if (++n4 >= n) {
                    n4 = 0;
                }
            }
            ++n2;
        }
        return stringBuffer;
    }

    private static int getTabSize(Map map) {
        String string = "space".equals(map.get("org.eclipse.wst.jsdt.core.formatter.tabulation.char")) ? "org.eclipse.wst.jsdt.core.formatter.indentation.size" : "org.eclipse.wst.jsdt.core.formatter.tabulation.size";
        if (map.containsKey(string)) {
            try {
                return Integer.parseInt((String)map.get(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 4;
    }

    private static int getIndentSize(Map map) {
        String string = "mixed".equals(map.get("org.eclipse.wst.jsdt.core.formatter.tabulation.char")) ? "org.eclipse.wst.jsdt.core.formatter.indentation.size" : "org.eclipse.wst.jsdt.core.formatter.tabulation.size";
        if (map.containsKey(string)) {
            try {
                return Integer.parseInt((String)map.get(string));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 4;
    }

    private int computeHeaderEnd(IDocument iDocument, Map map) {
        if (iDocument == null) {
            return -1;
        }
        try {
            if (this.fLastMainTokenEnd >= 0 && iDocument.hashCode() == this.fLastDocumentHash && this.fLastMainTokenEnd < iDocument.getLength() && iDocument.get(0, this.fLastMainTokenEnd).hashCode() == this.fLastHeaderHash) {
                return this.fLastDocumentsHeaderEnd;
            }
        }
        catch (BadLocationException badLocationException) {}
        IScanner iScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (String)((String)map.get("org.eclipse.wst.jsdt.core.compiler.source")), (String)((String)map.get("org.eclipse.wst.jsdt.core.compiler.compliance")));
        iScanner.setSource(iDocument.get().toCharArray());
        try {
            int n = -1;
            boolean bl = false;
            int n2 = iScanner.getNextToken();
            while (n2 == 1003 || n2 == 1000 || n2 == 1001 || n2 == 1002) {
                if (n2 == 1003) {
                    n = iScanner.getCurrentTokenStartPosition();
                }
                bl = n2 == 1003 || n2 == 1002;
                n2 = iScanner.getNextToken();
            }
            int n3 = iScanner.getCurrentTokenEndPosition();
            if (n2 != 158) {
                ++n3;
                if (n == -1 || bl && (n2 == 191 || n2 == 214)) {
                    n = iScanner.getCurrentTokenStartPosition();
                }
            } else {
                n = -1;
            }
            try {
                this.fLastHeaderHash = iDocument.get(0, n3).hashCode();
            }
            catch (BadLocationException badLocationException) {
                n3 = -1;
            }
            this.fLastDocumentHash = iDocument.hashCode();
            this.fLastMainTokenEnd = n3;
            this.fLastDocumentsHeaderEnd = n;
            return n;
        }
        catch (InvalidInputException invalidInputException) {
            return -1;
        }
    }
}

