/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;

public class AssignToVariableAssistProposal
extends LinkedCorrectionProposal {
    public static final int LOCAL = 1;
    public static final int FIELD = 2;
    private final String KEY_NAME = "name";
    private final String KEY_TYPE = "type";
    private final int fVariableKind;
    private final ASTNode fNodeToAssign;
    private final ITypeBinding fTypeBinding;
    private VariableDeclarationFragment fExistingFragment;

    public AssignToVariableAssistProposal(ICompilationUnit iCompilationUnit, int n, ExpressionStatement expressionStatement, ITypeBinding iTypeBinding, int n2) {
        super("", iCompilationUnit, (ASTRewrite)null, n2, (Image)null);
        this.fVariableKind = n;
        this.fNodeToAssign = expressionStatement;
        if (iTypeBinding.isWildcardType()) {
            iTypeBinding = ASTResolving.normalizeWildcardType(iTypeBinding, true, expressionStatement.getAST());
        }
        this.fTypeBinding = iTypeBinding;
        if (n == 1) {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assigntolocal_description);
            this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.localvariable_obj.gif"));
        } else {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assigntofield_description);
            this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.field_private_obj.gif"));
        }
        this.createImportRewrite((CompilationUnit)expressionStatement.getRoot());
    }

    public AssignToVariableAssistProposal(ICompilationUnit iCompilationUnit, SingleVariableDeclaration singleVariableDeclaration, VariableDeclarationFragment variableDeclarationFragment, ITypeBinding iTypeBinding, int n) {
        super("", iCompilationUnit, (ASTRewrite)null, n, (Image)null);
        this.fVariableKind = 2;
        this.fNodeToAssign = singleVariableDeclaration;
        this.fTypeBinding = iTypeBinding;
        this.fExistingFragment = variableDeclarationFragment;
        if (variableDeclarationFragment == null) {
            this.setDisplayName(CorrectionMessages.AssignToVariableAssistProposal_assignparamtofield_description);
        } else {
            this.setDisplayName(Messages.format(CorrectionMessages.AssignToVariableAssistProposal_assigntoexistingfield_description, variableDeclarationFragment.getName().getIdentifier()));
        }
        this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.field_private_obj.gif"));
    }

    protected ASTRewrite getRewrite() throws CoreException {
        if (this.fVariableKind == 2) {
            return this.doAddField();
        }
        return this.doAddLocal();
    }

    private ASTRewrite doAddLocal() throws CoreException {
        Expression expression = ((ExpressionStatement)this.fNodeToAssign).getExpression();
        AST aST = this.fNodeToAssign.getAST();
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        this.createImportRewrite((CompilationUnit)this.fNodeToAssign.getRoot());
        String[] stringArray = this.suggestLocalVariableNames(this.fTypeBinding, expression);
        int n = 0;
        while (n < stringArray.length) {
            this.addLinkedPositionProposal("name", stringArray[n], null);
            ++n;
        }
        VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(aST.newSimpleName(stringArray[0]));
        variableDeclarationFragment.setInitializer((Expression)aSTRewrite.createCopyTarget((ASTNode)expression));
        VariableDeclarationExpression variableDeclarationExpression = aST.newVariableDeclarationExpression(variableDeclarationFragment);
        Type type = this.evaluateType(aST);
        variableDeclarationExpression.setType(type);
        aSTRewrite.replace((ASTNode)expression, (ASTNode)variableDeclarationExpression, null);
        this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationFragment.getName()), true, "name");
        this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationExpression.getType()), false, "type");
        this.setEndPosition(aSTRewrite.track(this.fNodeToAssign));
        return aSTRewrite;
    }

    private ASTRewrite doAddField() throws CoreException {
        Object object;
        FieldAccess fieldAccess;
        Block block;
        boolean bl = this.fNodeToAssign.getNodeType() == 44;
        ASTNode aSTNode = ASTResolving.findParentType(this.fNodeToAssign);
        if (aSTNode == null) {
            return null;
        }
        SimpleName simpleName = bl ? ((SingleVariableDeclaration)this.fNodeToAssign).getName() : ((ExpressionStatement)this.fNodeToAssign).getExpression();
        AST aST = aSTNode.getAST();
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        this.createImportRewrite((CompilationUnit)this.fNodeToAssign.getRoot());
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(this.fNodeToAssign);
        if (bodyDeclaration instanceof MethodDeclaration) {
            block = ((MethodDeclaration)bodyDeclaration).getBody();
        } else if (bodyDeclaration instanceof Initializer) {
            block = ((Initializer)bodyDeclaration).getBody();
        } else {
            return null;
        }
        boolean bl2 = aSTNode.getNodeType() == 1;
        boolean bl3 = Modifier.isStatic((int)bodyDeclaration.getModifiers()) && !bl2;
        boolean bl4 = bl && this.fNodeToAssign.getParent() instanceof MethodDeclaration && ((MethodDeclaration)this.fNodeToAssign.getParent()).isConstructor();
        int n = 2;
        if (bl3) {
            n |= 8;
        } else if (bl4) {
            n |= 0x10;
        }
        VariableDeclarationFragment variableDeclarationFragment = this.addFieldDeclaration(aSTRewrite, aSTNode, n, (Expression)simpleName);
        String string = variableDeclarationFragment.getName().getIdentifier();
        Assignment assignment = aST.newAssignment();
        assignment.setRightHandSide((Expression)aSTRewrite.createCopyTarget((ASTNode)simpleName));
        boolean bl5 = StubUtility.useThisForFieldAccess(this.getCompilationUnit().getJavaProject());
        if (bl) {
            bl5 |= string.equals(simpleName.getIdentifier());
        }
        SimpleName simpleName2 = aST.newSimpleName(string);
        if (bl5) {
            fieldAccess = aST.newFieldAccess();
            fieldAccess.setName(simpleName2);
            if (bl3) {
                object = ((AbstractTypeDeclaration)aSTNode).getName().getIdentifier();
                fieldAccess.setExpression((Expression)aST.newSimpleName((String)object));
            } else {
                fieldAccess.setExpression((Expression)aST.newThisExpression());
            }
            assignment.setLeftHandSide((Expression)fieldAccess);
        } else {
            assignment.setLeftHandSide((Expression)simpleName2);
        }
        if (bl) {
            object = aST.newExpressionStatement((Expression)assignment);
            int n2 = this.findAssignmentInsertIndex(block.statements());
            aSTRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)object, n2, null);
            fieldAccess = object;
        } else {
            aSTRewrite.replace((ASTNode)simpleName, (ASTNode)assignment, null);
            fieldAccess = this.fNodeToAssign;
        }
        this.addLinkedPosition(aSTRewrite.track((ASTNode)variableDeclarationFragment.getName()), false, "name");
        if (!bl) {
            object = (FieldDeclaration)variableDeclarationFragment.getParent();
            this.addLinkedPosition(aSTRewrite.track((ASTNode)object.getType()), false, "type");
        }
        this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleName2), true, "name");
        this.setEndPosition(aSTRewrite.track((ASTNode)fieldAccess));
        return aSTRewrite;
    }

    private VariableDeclarationFragment addFieldDeclaration(ASTRewrite aSTRewrite, ASTNode aSTNode, int n, Expression expression) throws CoreException {
        if (this.fExistingFragment != null) {
            return this.fExistingFragment;
        }
        ChildListPropertyDescriptor childListPropertyDescriptor = ASTNodes.getBodyDeclarationsProperty(aSTNode);
        List list = (List)aSTNode.getStructuralProperty((StructuralPropertyDescriptor)childListPropertyDescriptor);
        AST aST = aSTNode.getAST();
        String[] stringArray = this.suggestFieldNames(this.fTypeBinding, expression, n);
        int n2 = 0;
        while (n2 < stringArray.length) {
            this.addLinkedPositionProposal("name", stringArray[n2], null);
            ++n2;
        }
        String string = stringArray[0];
        VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(aST.newSimpleName(string));
        FieldDeclaration fieldDeclaration = aST.newFieldDeclaration(variableDeclarationFragment);
        Type type = this.evaluateType(aST);
        fieldDeclaration.setType(type);
        fieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, n));
        ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.getLinkedProposalModel(), aSTRewrite, fieldDeclaration.modifiers(), false);
        int n3 = this.findFieldInsertIndex(list, this.fNodeToAssign.getStartPosition());
        aSTRewrite.getListRewrite(aSTNode, childListPropertyDescriptor).insertAt((ASTNode)fieldDeclaration, n3, null);
        return variableDeclarationFragment;
    }

    private Type evaluateType(AST aST) throws CoreException {
        ITypeBinding[] iTypeBindingArray = ASTResolving.getRelaxingTypes(aST, this.fTypeBinding);
        int n = 0;
        while (n < iTypeBindingArray.length) {
            this.addLinkedPositionProposal("type", iTypeBindingArray[n]);
            ++n;
        }
        return this.getImportRewrite().addImport(this.fTypeBinding, aST);
    }

    private String[] suggestLocalVariableNames(ITypeBinding iTypeBinding, Expression expression) {
        IJavaProject iJavaProject = this.getCompilationUnit().getJavaProject();
        return StubUtility.getVariableNameSuggestions(5, iJavaProject, iTypeBinding, expression, this.getUsedVariableNames());
    }

    private String[] suggestFieldNames(ITypeBinding iTypeBinding, Expression expression, int n) {
        IJavaProject iJavaProject = this.getCompilationUnit().getJavaProject();
        int n2 = Modifier.isStatic((int)n) ? 1 : 2;
        return StubUtility.getVariableNameSuggestions(n2, iJavaProject, iTypeBinding, expression, this.getUsedVariableNames());
    }

    private Collection getUsedVariableNames() {
        return Arrays.asList(ASTResolving.getUsedVariableNames(this.fNodeToAssign));
    }

    private int findAssignmentInsertIndex(List list) {
        SingleVariableDeclaration singleVariableDeclaration;
        HashSet<String> hashSet = new HashSet<String>();
        List list2 = ((MethodDeclaration)this.fNodeToAssign.getParent()).parameters();
        int n = 0;
        while (n < list2.size() && list2.get(n) != this.fNodeToAssign) {
            singleVariableDeclaration = (SingleVariableDeclaration)list2.get(n);
            hashSet.add(singleVariableDeclaration.getName().getIdentifier());
            ++n;
        }
        n = 0;
        n = 0;
        while (n < list.size()) {
            singleVariableDeclaration = (Statement)list.get(n);
            switch (singleVariableDeclaration.getNodeType()) {
                case 17: 
                case 46: {
                    break;
                }
                case 21: {
                    IVariableBinding iVariableBinding;
                    Assignment assignment;
                    Expression expression;
                    Expression expression2 = ((ExpressionStatement)singleVariableDeclaration).getExpression();
                    if (expression2 instanceof Assignment && (expression = (assignment = (Assignment)expression2).getRightHandSide()) instanceof SimpleName && hashSet.contains(((SimpleName)expression).getIdentifier()) && ((iVariableBinding = Bindings.getAssignedVariable(assignment)) == null || iVariableBinding.isField())) break;
                    return n;
                }
                default: {
                    return n;
                }
            }
            ++n;
        }
        return n;
    }

    private int findFieldInsertIndex(List list, int n) {
        int n2 = list.size() - 1;
        while (n2 >= 0) {
            ASTNode aSTNode = (ASTNode)list.get(n2);
            if (aSTNode instanceof FieldDeclaration && n > aSTNode.getStartPosition() + aSTNode.getLength()) {
                return n2 + 1;
            }
            --n2;
        }
        return 0;
    }

    public int getVariableKind() {
        return this.fVariableKind;
    }
}

