/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;

public final class ContributedProcessorDescriptor {
    private final IConfigurationElement fConfigurationElement;
    private Object fProcessorInstance;
    private Boolean fStatus;
    private boolean fLastResult;
    private String fRequiredSourceLevel;
    private final Set fHandledMarkerTypes;
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String REQUIRED_SOURCE_LEVEL = "requiredSourceLevel";
    private static final String HANDLED_MARKER_TYPES = "handledMarkerTypes";
    private static final String MARKER_TYPE = "markerType";

    public ContributedProcessorDescriptor(IConfigurationElement iConfigurationElement, boolean bl) {
        this.fConfigurationElement = iConfigurationElement;
        this.fProcessorInstance = null;
        this.fStatus = null;
        if (this.fConfigurationElement.getChildren("enablement").length == 0) {
            this.fStatus = Boolean.TRUE;
        }
        this.fRequiredSourceLevel = iConfigurationElement.getAttribute(REQUIRED_SOURCE_LEVEL);
        this.fHandledMarkerTypes = bl ? this.getHandledMarkerTypes(iConfigurationElement) : null;
    }

    private Set getHandledMarkerTypes(IConfigurationElement iConfigurationElement) {
        HashSet<String> hashSet = new HashSet<String>(7);
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren(HANDLED_MARKER_TYPES);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray[n].getChildren(MARKER_TYPE);
            int n2 = 0;
            while (n2 < iConfigurationElementArray2.length) {
                String string = iConfigurationElementArray2[n2].getAttribute(ID);
                if (string != null) {
                    hashSet.add(string);
                }
                ++n2;
            }
            ++n;
        }
        if (hashSet.isEmpty()) {
            hashSet.add("org.eclipse.wst.jsdt.core.problem");
            hashSet.add("org.eclipse.wst.jsdt.core.buildpath_problem");
            hashSet.add("org.eclipse.wst.jsdt.core.task");
        }
        return hashSet;
    }

    public IStatus checkSyntax() {
        IConfigurationElement[] iConfigurationElementArray = this.fConfigurationElement.getChildren("enablement");
        if (iConfigurationElementArray.length > 1) {
            String string = this.fConfigurationElement.getAttribute(ID);
            return new StatusInfo(4, "Only one < enablement > element allowed. Disabling " + string);
        }
        return new StatusInfo(0, "Syntactically correct quick assist/fix processor");
    }

    private boolean matches(ICompilationUnit iCompilationUnit) {
        IConfigurationElement[] iConfigurationElementArray;
        if (this.fRequiredSourceLevel != null && JavaModelUtil.isVersionLessThan((String)(iConfigurationElementArray = iCompilationUnit.getJavaProject().getOption("org.eclipse.wst.jsdt.core.compiler.source", true)), this.fRequiredSourceLevel)) {
            return false;
        }
        if (this.fStatus != null) {
            return this.fStatus;
        }
        iConfigurationElementArray = this.fConfigurationElement.getChildren("enablement");
        if (iConfigurationElementArray.length == 1) {
            try {
                ExpressionConverter expressionConverter = ExpressionConverter.getDefault();
                Expression expression = expressionConverter.perform(iConfigurationElementArray[0]);
                EvaluationContext evaluationContext = new EvaluationContext(null, (Object)iCompilationUnit);
                evaluationContext.addVariable("compilationUnit", (Object)iCompilationUnit);
                IJavaProject iJavaProject = iCompilationUnit.getJavaProject();
                String[] stringArray = iJavaProject.getProject().getDescription().getNatureIds();
                evaluationContext.addVariable("projectNatures", Arrays.asList(stringArray));
                evaluationContext.addVariable("sourceLevel", (Object)iJavaProject.getOption("org.eclipse.wst.jsdt.core.compiler.source", true));
                this.fLastResult = expression.evaluate((IEvaluationContext)evaluationContext) == EvaluationResult.TRUE;
                return this.fLastResult;
            }
            catch (CoreException coreException) {
                JavaPlugin.log(coreException);
            }
        }
        this.fStatus = Boolean.FALSE;
        return false;
    }

    public Object getProcessor(ICompilationUnit iCompilationUnit) throws CoreException {
        if (this.matches(iCompilationUnit)) {
            if (this.fProcessorInstance == null) {
                this.fProcessorInstance = this.fConfigurationElement.createExecutableExtension(CLASS);
            }
            return this.fProcessorInstance;
        }
        return null;
    }

    public boolean canHandleMarkerType(String string) {
        return this.fHandledMarkerTypes == null || this.fHandledMarkerTypes.contains(string);
    }
}

