/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CUCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CorrectPackageDeclarationProposal
extends CUCorrectionProposal {
    private IProblemLocation fLocation;

    public CorrectPackageDeclarationProposal(ICompilationUnit iCompilationUnit, IProblemLocation iProblemLocation, int n) {
        super(CorrectionMessages.CorrectPackageDeclarationProposal_name, iCompilationUnit, n, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.packd_obj.gif"));
        this.fLocation = iProblemLocation;
    }

    protected void addEdits(IDocument iDocument, TextEdit textEdit) throws CoreException {
        super.addEdits(iDocument, textEdit);
        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
        IPackageFragment iPackageFragment = (IPackageFragment)iCompilationUnit.getParent();
        IPackageDeclaration[] iPackageDeclarationArray = iCompilationUnit.getPackageDeclarations();
        if (iPackageFragment.isDefaultPackage() && iPackageDeclarationArray.length > 0) {
            int n = 0;
            while (n < iPackageDeclarationArray.length) {
                ISourceRange iSourceRange = iPackageDeclarationArray[n].getSourceRange();
                textEdit.addChild((TextEdit)new DeleteEdit(iSourceRange.getOffset(), iSourceRange.getLength()));
                ++n;
            }
            return;
        }
        if (!iPackageFragment.isDefaultPackage() && iPackageDeclarationArray.length == 0) {
            String string = StubUtility.getLineDelimiterUsed((IJavaElement)iCompilationUnit);
            String string2 = "package " + iPackageFragment.getElementName() + ';' + string + string;
            textEdit.addChild((TextEdit)new InsertEdit(0, string2));
            return;
        }
        textEdit.addChild((TextEdit)new ReplaceEdit(this.fLocation.getOffset(), this.fLocation.getLength(), iPackageFragment.getElementName()));
    }

    public String getDisplayString() {
        ICompilationUnit iCompilationUnit = this.getCompilationUnit();
        IPackageFragment iPackageFragment = (IPackageFragment)iCompilationUnit.getParent();
        try {
            IPackageDeclaration[] iPackageDeclarationArray = iCompilationUnit.getPackageDeclarations();
            if (iPackageFragment.isDefaultPackage() && iPackageDeclarationArray.length > 0) {
                return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_remove_description, iPackageDeclarationArray[0].getElementName());
            }
            if (!iPackageFragment.isDefaultPackage() && iPackageDeclarationArray.length == 0) {
                return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_add_description, iPackageFragment.getElementName());
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return Messages.format(CorrectionMessages.CorrectPackageDeclarationProposal_change_description, iPackageFragment.getElementName());
    }
}

