/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.CleanUpRefactoring;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringExecutionHelper;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.IStatusLineProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.wst.jsdt.ui.JavaElementImageDescriptor;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;

public class FixCorrectionProposal
extends LinkedCorrectionProposal
implements ICompletionProposalExtension2,
IStatusLineProposal {
    private final IFix fFix;
    private final ICleanUp fCleanUp;
    private CompilationUnit fCompilationUnit;

    public FixCorrectionProposal(IFix iFix, ICleanUp iCleanUp, int n, Image image, IInvocationContext iInvocationContext) {
        super(iFix.getDescription(), iFix.getCompilationUnit(), (ASTRewrite)null, n, image);
        this.fFix = iFix;
        this.fCleanUp = iCleanUp;
        this.fCompilationUnit = iInvocationContext.getASTRoot();
    }

    public ICleanUp getCleanUp() {
        return this.fCleanUp;
    }

    public Image getImage() {
        IStatus iStatus = this.fFix.getStatus();
        if (!iStatus.isOK()) {
            ImageImageDescriptor imageImageDescriptor = new ImageImageDescriptor(super.getImage());
            int n = 32;
            if (iStatus.getSeverity() == 4) {
                n = 64;
            }
            JavaElementImageDescriptor javaElementImageDescriptor = new JavaElementImageDescriptor(imageImageDescriptor, n, new Point(imageImageDescriptor.getImageData().width, imageImageDescriptor.getImageData().height));
            return javaElementImageDescriptor.createImage();
        }
        return super.getImage();
    }

    public String getAdditionalProposalInfo() {
        AbstractFix abstractFix;
        String string;
        String string2 = super.getAdditionalProposalInfo();
        IStatus iStatus = this.fFix.getStatus();
        if (!iStatus.isOK()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<b>");
            stringBuffer.append(CorrectionMessages.FixCorrectionProposal_WarningAdditionalProposalInfo);
            stringBuffer.append("</b>");
            stringBuffer.append(iStatus.getMessage());
            stringBuffer.append("<br><br>");
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
        if (this.fFix instanceof AbstractFix && (string = (abstractFix = (AbstractFix)this.fFix).getAdditionalInfo()) != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append("<br>");
            stringBuffer.append(string2);
            return stringBuffer.toString();
        }
        return string2;
    }

    public int getRelevance() {
        IStatus iStatus = this.fFix.getStatus();
        if (iStatus.getSeverity() == 2) {
            return super.getRelevance() - 100;
        }
        return super.getRelevance();
    }

    protected TextChange createTextChange() throws CoreException {
        IFix iFix = this.fFix;
        TextChange textChange = iFix.createChange();
        if (textChange instanceof TextFileChange) {
            ((TextFileChange)textChange).setSaveMode(4);
        }
        if (iFix instanceof LinkedFix) {
            this.setLinkedProposalModel(((LinkedFix)iFix).getLinkedPositions());
        }
        if (textChange == null) {
            return new CompilationUnitChange("", this.getCompilationUnit());
        }
        return textChange;
    }

    public void apply(ITextViewer iTextViewer, char c, int n, int n2) {
        if (n == 262144 && this.fCleanUp != null) {
            CleanUpRefactoring cleanUpRefactoring = new CleanUpRefactoring();
            cleanUpRefactoring.addCompilationUnit(this.getCompilationUnit());
            cleanUpRefactoring.addCleanUp(this.fCleanUp);
            cleanUpRefactoring.setLeaveFilesDirty(true);
            int n3 = RefactoringCore.getConditionCheckingFailedSeverity();
            Shell shell = JavaPlugin.getActiveWorkbenchShell();
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
            RefactoringExecutionHelper refactoringExecutionHelper = new RefactoringExecutionHelper(cleanUpRefactoring, n3, 5, shell, (IRunnableContext)progressMonitorDialog);
            try {
                refactoringExecutionHelper.perform(true, true);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                JavaPlugin.log(invocationTargetException);
            }
            return;
        }
        this.apply(iTextViewer.getDocument());
    }

    public void selected(ITextViewer iTextViewer, boolean bl) {
    }

    public void unselected(ITextViewer iTextViewer) {
    }

    public boolean validate(IDocument iDocument, int n, DocumentEvent documentEvent) {
        return false;
    }

    public String getStatusMessage() {
        if (this.fCleanUp == null) {
            return null;
        }
        int n = this.fCleanUp.maximalNumberOfFixes(this.fCompilationUnit);
        if (n == -1) {
            return CorrectionMessages.FixCorrectionProposal_HitCtrlEnter_description;
        }
        if (n < 2) {
            return "";
        }
        return Messages.format(CorrectionMessages.FixCorrectionProposal_hitCtrlEnter_variable_description, new Integer(n));
    }
}

