/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerHelpRegistry;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AssistContext;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ChangeCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ContributedProcessorDescriptor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.IStatusLineProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionAssistant;
import org.eclipse.wst.jsdt.internal.ui.text.correction.MarkerResolutionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;
import org.eclipse.wst.jsdt.ui.text.java.IQuickFixProcessor;

public class JavaCorrectionProcessor
implements IQuickAssistProcessor {
    private static final String QUICKFIX_PROCESSOR_CONTRIBUTION_ID = "quickFixProcessors";
    private static final String QUICKASSIST_PROCESSOR_CONTRIBUTION_ID = "quickAssistProcessors";
    private static ContributedProcessorDescriptor[] fgContributedAssistProcessors = null;
    private static ContributedProcessorDescriptor[] fgContributedCorrectionProcessors = null;
    private JavaCorrectionAssistant fAssistant;
    private String fErrorMessage;

    private static ContributedProcessorDescriptor[] getProcessorDescriptors(String string, boolean bl) {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.wst.jsdt.ui", string);
        ArrayList<ContributedProcessorDescriptor> arrayList = new ArrayList<ContributedProcessorDescriptor>(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            ContributedProcessorDescriptor contributedProcessorDescriptor = new ContributedProcessorDescriptor(iConfigurationElementArray[n], bl);
            IStatus iStatus = contributedProcessorDescriptor.checkSyntax();
            if (iStatus.isOK()) {
                arrayList.add(contributedProcessorDescriptor);
            } else {
                JavaPlugin.log(iStatus);
            }
            ++n;
        }
        return arrayList.toArray(new ContributedProcessorDescriptor[arrayList.size()]);
    }

    private static ContributedProcessorDescriptor[] getCorrectionProcessors() {
        if (fgContributedCorrectionProcessors == null) {
            fgContributedCorrectionProcessors = JavaCorrectionProcessor.getProcessorDescriptors(QUICKFIX_PROCESSOR_CONTRIBUTION_ID, true);
        }
        return fgContributedCorrectionProcessors;
    }

    private static ContributedProcessorDescriptor[] getAssistProcessors() {
        if (fgContributedAssistProcessors == null) {
            fgContributedAssistProcessors = JavaCorrectionProcessor.getProcessorDescriptors(QUICKASSIST_PROCESSOR_CONTRIBUTION_ID, false);
        }
        return fgContributedAssistProcessors;
    }

    public static boolean hasCorrections(ICompilationUnit iCompilationUnit, int n, String string) {
        ContributedProcessorDescriptor[] contributedProcessorDescriptorArray = JavaCorrectionProcessor.getCorrectionProcessors();
        SafeHasCorrections safeHasCorrections = new SafeHasCorrections(iCompilationUnit, n);
        int n2 = 0;
        while (n2 < contributedProcessorDescriptorArray.length) {
            if (contributedProcessorDescriptorArray[n2].canHandleMarkerType(string)) {
                safeHasCorrections.process(contributedProcessorDescriptorArray[n2]);
                if (safeHasCorrections.hasCorrections()) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean isQuickFixableType(Annotation annotation) {
        return (annotation instanceof IJavaAnnotation || annotation instanceof SimpleMarkerAnnotation) && !annotation.isMarkedDeleted();
    }

    public static boolean hasCorrections(Annotation annotation) {
        ICompilationUnit iCompilationUnit;
        IJavaAnnotation iJavaAnnotation;
        int n;
        if (annotation instanceof IJavaAnnotation && (n = (iJavaAnnotation = (IJavaAnnotation)annotation).getId()) != -1 && (iCompilationUnit = iJavaAnnotation.getCompilationUnit()) != null) {
            return JavaCorrectionProcessor.hasCorrections(iCompilationUnit, n, iJavaAnnotation.getMarkerType());
        }
        if (annotation instanceof SimpleMarkerAnnotation) {
            return JavaCorrectionProcessor.hasCorrections(((SimpleMarkerAnnotation)annotation).getMarker());
        }
        return false;
    }

    private static boolean hasCorrections(IMarker iMarker) {
        if (iMarker == null || !iMarker.exists()) {
            return false;
        }
        IMarkerHelpRegistry iMarkerHelpRegistry = IDE.getMarkerHelpRegistry();
        return iMarkerHelpRegistry != null && iMarkerHelpRegistry.hasResolutions(iMarker);
    }

    public static boolean hasAssists(IInvocationContext iInvocationContext) {
        ContributedProcessorDescriptor[] contributedProcessorDescriptorArray = JavaCorrectionProcessor.getAssistProcessors();
        SafeHasAssist safeHasAssist = new SafeHasAssist(iInvocationContext);
        int n = 0;
        while (n < contributedProcessorDescriptorArray.length) {
            safeHasAssist.process(contributedProcessorDescriptorArray[n]);
            if (safeHasAssist.hasAssists()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public JavaCorrectionProcessor(JavaCorrectionAssistant javaCorrectionAssistant) {
        this.fAssistant = javaCorrectionAssistant;
        this.fAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent contentAssistEvent) {
                JavaCorrectionProcessor.this.fAssistant.setStatusLineVisible(false);
            }

            public void assistSessionStarted(ContentAssistEvent contentAssistEvent) {
                JavaCorrectionProcessor.this.fAssistant.setStatusLineVisible(true);
            }

            public void selectionChanged(ICompletionProposal iCompletionProposal, boolean bl) {
                if (iCompletionProposal instanceof IStatusLineProposal) {
                    IStatusLineProposal iStatusLineProposal = (IStatusLineProposal)iCompletionProposal;
                    String string = iStatusLineProposal.getStatusMessage();
                    if (string != null) {
                        JavaCorrectionProcessor.this.fAssistant.setStatusMessage(string);
                    } else {
                        JavaCorrectionProcessor.this.fAssistant.setStatusMessage("");
                    }
                } else {
                    JavaCorrectionProcessor.this.fAssistant.setStatusMessage("");
                }
            }
        });
    }

    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext iQuickAssistInvocationContext) {
        ISourceViewer iSourceViewer = iQuickAssistInvocationContext.getSourceViewer();
        int n = iQuickAssistInvocationContext.getOffset();
        IEditorPart iEditorPart = this.fAssistant.getEditor();
        ICompilationUnit iCompilationUnit = JavaUI.getWorkingCopyManager().getWorkingCopy(iEditorPart.getEditorInput());
        IAnnotationModel iAnnotationModel = JavaUI.getDocumentProvider().getAnnotationModel((Object)iEditorPart.getEditorInput());
        int n2 = iSourceViewer != null ? iSourceViewer.getSelectedRange().y : 0;
        AssistContext assistContext = new AssistContext(iCompilationUnit, n, n2);
        Annotation[] annotationArray = this.fAssistant.getAnnotationsAtOffset();
        this.fErrorMessage = null;
        ICompletionProposal[] iCompletionProposalArray = null;
        if (iAnnotationModel != null && annotationArray != null) {
            ArrayList arrayList = new ArrayList(10);
            IStatus iStatus = JavaCorrectionProcessor.collectProposals(assistContext, iAnnotationModel, annotationArray, true, !this.fAssistant.isUpdatedOffset(), arrayList);
            iCompletionProposalArray = arrayList.toArray(new ICompletionProposal[arrayList.size()]);
            if (!iStatus.isOK()) {
                this.fErrorMessage = iStatus.getMessage();
                JavaPlugin.log(iStatus);
            }
        }
        if (iCompletionProposalArray == null || iCompletionProposalArray.length == 0) {
            return new ICompletionProposal[]{new ChangeCorrectionProposal(CorrectionMessages.NoCorrectionProposal_description, (Change)new NullChange(""), 0, null)};
        }
        if (iCompletionProposalArray.length > 1) {
            Arrays.sort(iCompletionProposalArray, new CompletionProposalComparator());
        }
        return iCompletionProposalArray;
    }

    public static IStatus collectProposals(IInvocationContext iInvocationContext, IAnnotationModel iAnnotationModel, Annotation[] annotationArray, boolean bl, boolean bl2, Collection collection) {
        ProblemLocation problemLocation;
        IProblemLocation[] iProblemLocationArray;
        ArrayList<ProblemLocation> arrayList = new ArrayList<ProblemLocation>();
        int n = 0;
        while (n < annotationArray.length) {
            iProblemLocationArray = annotationArray[n];
            if (iProblemLocationArray instanceof IJavaAnnotation) {
                problemLocation = JavaCorrectionProcessor.getProblemLocation((IJavaAnnotation)iProblemLocationArray, iAnnotationModel);
                if (problemLocation != null) {
                    arrayList.add(problemLocation);
                }
            } else if (bl && iProblemLocationArray instanceof SimpleMarkerAnnotation) {
                JavaCorrectionProcessor.collectMarkerProposals((SimpleMarkerAnnotation)iProblemLocationArray, collection);
            }
            ++n;
        }
        MultiStatus multiStatus = null;
        iProblemLocationArray = arrayList.toArray(new IProblemLocation[arrayList.size()]);
        if (bl && !(problemLocation = JavaCorrectionProcessor.collectCorrections(iInvocationContext, iProblemLocationArray, collection)).isOK()) {
            multiStatus = new MultiStatus("org.eclipse.wst.jsdt.ui", 4, CorrectionMessages.JavaCorrectionProcessor_error_quickfix_message, null);
            multiStatus.add((IStatus)problemLocation);
        }
        if (bl2 && !(problemLocation = JavaCorrectionProcessor.collectAssists(iInvocationContext, iProblemLocationArray, collection)).isOK()) {
            if (multiStatus == null) {
                multiStatus = new MultiStatus("org.eclipse.wst.jsdt.ui", 4, CorrectionMessages.JavaCorrectionProcessor_error_quickassist_message, null);
            }
            multiStatus.add((IStatus)problemLocation);
        }
        if (multiStatus != null) {
            return multiStatus;
        }
        return Status.OK_STATUS;
    }

    private static ProblemLocation getProblemLocation(IJavaAnnotation iJavaAnnotation, IAnnotationModel iAnnotationModel) {
        Position position;
        int n = iJavaAnnotation.getId();
        if (n != -1 && (position = iAnnotationModel.getPosition((Annotation)iJavaAnnotation)) != null) {
            return new ProblemLocation(position.getOffset(), position.getLength(), iJavaAnnotation);
        }
        return null;
    }

    private static void collectMarkerProposals(SimpleMarkerAnnotation simpleMarkerAnnotation, Collection collection) {
        IMarker iMarker = simpleMarkerAnnotation.getMarker();
        IMarkerResolution[] iMarkerResolutionArray = IDE.getMarkerHelpRegistry().getResolutions(iMarker);
        if (iMarkerResolutionArray.length > 0) {
            int n = 0;
            while (n < iMarkerResolutionArray.length) {
                collection.add(new MarkerResolutionProposal(iMarkerResolutionArray[n], iMarker));
                ++n;
            }
        }
    }

    public static IStatus collectCorrections(IInvocationContext iInvocationContext, IProblemLocation[] iProblemLocationArray, Collection collection) {
        ContributedProcessorDescriptor[] contributedProcessorDescriptorArray = JavaCorrectionProcessor.getCorrectionProcessors();
        SafeCorrectionCollector safeCorrectionCollector = new SafeCorrectionCollector(iInvocationContext, collection);
        int n = 0;
        while (n < contributedProcessorDescriptorArray.length) {
            ContributedProcessorDescriptor contributedProcessorDescriptor = contributedProcessorDescriptorArray[n];
            IProblemLocation[] iProblemLocationArray2 = JavaCorrectionProcessor.getHandledProblems(iProblemLocationArray, contributedProcessorDescriptor);
            if (iProblemLocationArray2 != null) {
                safeCorrectionCollector.setProblemLocations(iProblemLocationArray2);
                safeCorrectionCollector.process(contributedProcessorDescriptor);
            }
            ++n;
        }
        return safeCorrectionCollector.getStatus();
    }

    private static IProblemLocation[] getHandledProblems(IProblemLocation[] iProblemLocationArray, ContributedProcessorDescriptor contributedProcessorDescriptor) {
        boolean bl = true;
        ArrayList<IProblemLocation> arrayList = null;
        int n = 0;
        while (n < iProblemLocationArray.length) {
            IProblemLocation iProblemLocation = iProblemLocationArray[n];
            if (contributedProcessorDescriptor.canHandleMarkerType(iProblemLocation.getMarkerType())) {
                if (!bl) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<IProblemLocation>(iProblemLocationArray.length - n);
                    }
                    arrayList.add(iProblemLocation);
                }
            } else if (bl) {
                if (n > 0) {
                    arrayList = new ArrayList(iProblemLocationArray.length - n);
                    int n2 = 0;
                    while (n2 < n) {
                        arrayList.add(iProblemLocationArray[n2]);
                        ++n2;
                    }
                }
                bl = false;
            }
            ++n;
        }
        if (bl) {
            return iProblemLocationArray;
        }
        if (arrayList == null) {
            return null;
        }
        return arrayList.toArray(new IProblemLocation[arrayList.size()]);
    }

    public static IStatus collectAssists(IInvocationContext iInvocationContext, IProblemLocation[] iProblemLocationArray, Collection collection) {
        ContributedProcessorDescriptor[] contributedProcessorDescriptorArray = JavaCorrectionProcessor.getAssistProcessors();
        SafeAssistCollector safeAssistCollector = new SafeAssistCollector(iInvocationContext, iProblemLocationArray, collection);
        safeAssistCollector.process(contributedProcessorDescriptorArray);
        return safeAssistCollector.getStatus();
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public boolean canFix(Annotation annotation) {
        return JavaCorrectionProcessor.hasCorrections(annotation);
    }

    public boolean canAssist(IQuickAssistInvocationContext iQuickAssistInvocationContext) {
        if (iQuickAssistInvocationContext instanceof IInvocationContext) {
            return JavaCorrectionProcessor.hasAssists((IInvocationContext)iQuickAssistInvocationContext);
        }
        return false;
    }

    private static class SafeAssistCollector
    extends SafeCorrectionProcessorAccess {
        private final IInvocationContext fContext;
        private final IProblemLocation[] fLocations;
        private final Collection fProposals;

        public SafeAssistCollector(IInvocationContext iInvocationContext, IProblemLocation[] iProblemLocationArray, Collection collection) {
            this.fContext = iInvocationContext;
            this.fLocations = iProblemLocationArray;
            this.fProposals = collection;
        }

        public void safeRun(ContributedProcessorDescriptor contributedProcessorDescriptor) throws Exception {
            IJavaCompletionProposal[] iJavaCompletionProposalArray;
            org.eclipse.wst.jsdt.ui.text.java.IQuickAssistProcessor iQuickAssistProcessor = (org.eclipse.wst.jsdt.ui.text.java.IQuickAssistProcessor)contributedProcessorDescriptor.getProcessor(this.fContext.getCompilationUnit());
            if (iQuickAssistProcessor != null && (iJavaCompletionProposalArray = iQuickAssistProcessor.getAssists(this.fContext, this.fLocations)) != null) {
                int n = 0;
                while (n < iJavaCompletionProposalArray.length) {
                    this.fProposals.add(iJavaCompletionProposalArray[n]);
                    ++n;
                }
            }
        }
    }

    private static class SafeCorrectionCollector
    extends SafeCorrectionProcessorAccess {
        private final IInvocationContext fContext;
        private final Collection fProposals;
        private IProblemLocation[] fLocations;

        public SafeCorrectionCollector(IInvocationContext iInvocationContext, Collection collection) {
            this.fContext = iInvocationContext;
            this.fProposals = collection;
        }

        public void setProblemLocations(IProblemLocation[] iProblemLocationArray) {
            this.fLocations = iProblemLocationArray;
        }

        public void safeRun(ContributedProcessorDescriptor contributedProcessorDescriptor) throws Exception {
            IJavaCompletionProposal[] iJavaCompletionProposalArray;
            IQuickFixProcessor iQuickFixProcessor = (IQuickFixProcessor)contributedProcessorDescriptor.getProcessor(this.fContext.getCompilationUnit());
            if (iQuickFixProcessor != null && (iJavaCompletionProposalArray = iQuickFixProcessor.getCorrections(this.fContext, this.fLocations)) != null) {
                int n = 0;
                while (n < iJavaCompletionProposalArray.length) {
                    this.fProposals.add(iJavaCompletionProposalArray[n]);
                    ++n;
                }
            }
        }
    }

    private static abstract class SafeCorrectionProcessorAccess
    implements ISafeRunnable {
        private MultiStatus fMulti = null;
        private ContributedProcessorDescriptor fDescriptor;

        private SafeCorrectionProcessorAccess() {
        }

        public void process(ContributedProcessorDescriptor[] contributedProcessorDescriptorArray) {
            int n = 0;
            while (n < contributedProcessorDescriptorArray.length) {
                this.fDescriptor = contributedProcessorDescriptorArray[n];
                SafeRunner.run((ISafeRunnable)this);
                ++n;
            }
        }

        public void process(ContributedProcessorDescriptor contributedProcessorDescriptor) {
            this.fDescriptor = contributedProcessorDescriptor;
            SafeRunner.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.safeRun(this.fDescriptor);
        }

        protected abstract void safeRun(ContributedProcessorDescriptor var1) throws Exception;

        public void handleException(Throwable throwable) {
            if (this.fMulti == null) {
                this.fMulti = new MultiStatus("org.eclipse.wst.jsdt.ui", 0, CorrectionMessages.JavaCorrectionProcessor_error_status, null);
            }
            this.fMulti.merge((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 4, CorrectionMessages.JavaCorrectionProcessor_error_status, throwable));
        }

        public IStatus getStatus() {
            if (this.fMulti == null) {
                return Status.OK_STATUS;
            }
            return this.fMulti;
        }
    }

    private static class SafeHasAssist
    extends SafeCorrectionProcessorAccess {
        private final IInvocationContext fContext;
        private boolean fHasAssists;

        public SafeHasAssist(IInvocationContext iInvocationContext) {
            this.fContext = iInvocationContext;
            this.fHasAssists = false;
        }

        public boolean hasAssists() {
            return this.fHasAssists;
        }

        public void safeRun(ContributedProcessorDescriptor contributedProcessorDescriptor) throws Exception {
            org.eclipse.wst.jsdt.ui.text.java.IQuickAssistProcessor iQuickAssistProcessor = (org.eclipse.wst.jsdt.ui.text.java.IQuickAssistProcessor)contributedProcessorDescriptor.getProcessor(this.fContext.getCompilationUnit());
            if (iQuickAssistProcessor != null && iQuickAssistProcessor.hasAssists(this.fContext)) {
                this.fHasAssists = true;
            }
        }
    }

    private static class SafeHasCorrections
    extends SafeCorrectionProcessorAccess {
        private final ICompilationUnit fCu;
        private final int fProblemId;
        private boolean fHasCorrections;

        public SafeHasCorrections(ICompilationUnit iCompilationUnit, int n) {
            this.fCu = iCompilationUnit;
            this.fProblemId = n;
            this.fHasCorrections = false;
        }

        public boolean hasCorrections() {
            return this.fHasCorrections;
        }

        public void safeRun(ContributedProcessorDescriptor contributedProcessorDescriptor) throws Exception {
            IQuickFixProcessor iQuickFixProcessor = (IQuickFixProcessor)contributedProcessorDescriptor.getProcessor(this.fCu);
            if (iQuickFixProcessor != null && iQuickFixProcessor.hasCorrections(this.fCu, this.fProblemId)) {
                this.fHasCorrections = true;
            }
        }
    }
}

