/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Annotation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class MissingAnnotationAttributesProposal
extends LinkedCorrectionProposal {
    private Annotation fAnnotation;

    public MissingAnnotationAttributesProposal(ICompilationUnit iCompilationUnit, Annotation annotation, int n) {
        super(CorrectionMessages.MissingAnnotationAttributesProposal_add_missing_attributes_label, iCompilationUnit, (ASTRewrite)null, n, (Image)null);
        this.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
        this.fAnnotation = annotation;
        Assert.isNotNull((Object)this.fAnnotation.resolveTypeBinding());
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ListRewrite listRewrite;
        AST aST = this.fAnnotation.getAST();
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
        this.createImportRewrite((CompilationUnit)this.fAnnotation.getRoot());
        if (this.fAnnotation instanceof NormalAnnotation) {
            listRewrite = aSTRewrite.getListRewrite((ASTNode)this.fAnnotation, NormalAnnotation.VALUES_PROPERTY);
        } else {
            NormalAnnotation normalAnnotation = aST.newNormalAnnotation();
            normalAnnotation.setTypeName((Name)aSTRewrite.createMoveTarget((ASTNode)this.fAnnotation.getTypeName()));
            aSTRewrite.replace((ASTNode)this.fAnnotation, (ASTNode)normalAnnotation, null);
            listRewrite = aSTRewrite.getListRewrite((ASTNode)normalAnnotation, NormalAnnotation.VALUES_PROPERTY);
        }
        this.addMissingAtributes(this.fAnnotation.resolveTypeBinding(), listRewrite);
        return aSTRewrite;
    }

    private void addMissingAtributes(ITypeBinding iTypeBinding, ListRewrite listRewrite) {
        MemberValuePair memberValuePair;
        List list;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.fAnnotation instanceof NormalAnnotation) {
            list = ((NormalAnnotation)this.fAnnotation).values();
            int n = 0;
            while (n < list.size()) {
                memberValuePair = (MemberValuePair)list.get(n);
                hashSet.add(memberValuePair.getName().getIdentifier());
                ++n;
            }
        } else if (this.fAnnotation instanceof SingleMemberAnnotation) {
            hashSet.add("value");
        }
        list = listRewrite.getASTRewrite();
        AST aST = list.getAST();
        memberValuePair = iTypeBinding.getDeclaredMethods();
        int n = 0;
        while (n < ((MemberValuePair)memberValuePair).length) {
            MemberValuePair memberValuePair2 = memberValuePair[n];
            if (!hashSet.contains(memberValuePair2.getName()) && memberValuePair2.getDefaultValue() == null) {
                MemberValuePair memberValuePair3 = aST.newMemberValuePair();
                memberValuePair3.setName(aST.newSimpleName(memberValuePair2.getName()));
                memberValuePair3.setValue(this.newDefaultExpression(aST, memberValuePair2.getReturnType()));
                listRewrite.insertLast((ASTNode)memberValuePair3, null);
                this.addLinkedPosition(list.track((ASTNode)memberValuePair3.getName()), false, "val_name_" + n);
                this.addLinkedPosition(list.track((ASTNode)memberValuePair3.getValue()), false, "val_type_" + n);
            }
            ++n;
        }
    }

    private Expression newDefaultExpression(AST aST, ITypeBinding iTypeBinding) {
        if (iTypeBinding.isPrimitive()) {
            String string = iTypeBinding.getName();
            if ("boolean".equals(string)) {
                return aST.newBooleanLiteral(false);
            }
            return aST.newNumberLiteral("0");
        }
        if (iTypeBinding == aST.resolveWellKnownType("java.lang.String")) {
            return aST.newStringLiteral();
        }
        if (iTypeBinding.isArray()) {
            ArrayInitializer arrayInitializer = aST.newArrayInitializer();
            arrayInitializer.expressions().add(this.newDefaultExpression(aST, iTypeBinding.getElementType()));
            return arrayInitializer;
        }
        if (iTypeBinding.isAnnotation()) {
            MarkerAnnotation markerAnnotation = aST.newMarkerAnnotation();
            markerAnnotation.setTypeName(aST.newName(this.getImportRewrite().addImport(iTypeBinding)));
            return markerAnnotation;
        }
        return aST.newNullLiteral();
    }
}

