/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MemberValuePair;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;

public class NewAnnotationMemberProposal
extends LinkedCorrectionProposal {
    private static final String KEY_NAME = "name";
    private static final String KEY_TYPE = "type";
    private final ASTNode fInvocationNode;
    private final ITypeBinding fSenderBinding;

    public NewAnnotationMemberProposal(String string, ICompilationUnit iCompilationUnit, ASTNode aSTNode, ITypeBinding iTypeBinding, int n, Image image) {
        super(string, iCompilationUnit, (ASTRewrite)null, n, image);
        this.fInvocationNode = aSTNode;
        this.fSenderBinding = iTypeBinding;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        CompilationUnit compilationUnit = ASTResolving.findParentCompilationUnit(this.fInvocationNode);
        ASTNode aSTNode = compilationUnit.findDeclaringNode((IBinding)this.fSenderBinding);
        ASTNode aSTNode2 = null;
        if (aSTNode != null) {
            aSTNode2 = aSTNode;
        } else {
            compilationUnit = ASTResolving.createQuickFixAST(this.getCompilationUnit(), null);
            aSTNode2 = compilationUnit.findDeclaringNode(this.fSenderBinding.getKey());
        }
        this.createImportRewrite(compilationUnit);
        if (aSTNode2 instanceof AnnotationTypeDeclaration) {
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
            AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration = this.getStub(aSTRewrite, (AnnotationTypeDeclaration)aSTNode2);
            ChildListPropertyDescriptor childListPropertyDescriptor = ASTNodes.getBodyDeclarationsProperty(aSTNode2);
            List list = (List)aSTNode2.getStructuralProperty((StructuralPropertyDescriptor)childListPropertyDescriptor);
            int n = list.size();
            ListRewrite listRewrite = aSTRewrite.getListRewrite(aSTNode2, childListPropertyDescriptor);
            listRewrite.insertAt((ASTNode)annotationTypeMemberDeclaration, n, null);
            return aSTRewrite;
        }
        return null;
    }

    private AnnotationTypeMemberDeclaration getStub(ASTRewrite aSTRewrite, AnnotationTypeDeclaration annotationTypeDeclaration) throws CoreException {
        AST aST = annotationTypeDeclaration.getAST();
        AnnotationTypeMemberDeclaration annotationTypeMemberDeclaration = aST.newAnnotationTypeMemberDeclaration();
        SimpleName simpleName = this.getNewName(aSTRewrite);
        annotationTypeMemberDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, this.evaluateModifiers(annotationTypeDeclaration)));
        ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.getLinkedProposalModel(), aSTRewrite, annotationTypeMemberDeclaration.modifiers(), true);
        annotationTypeMemberDeclaration.setName(simpleName);
        Type type = this.getNewType(aSTRewrite);
        annotationTypeMemberDeclaration.setType(type);
        return annotationTypeMemberDeclaration;
    }

    private Type getNewType(ASTRewrite aSTRewrite) {
        AST aST = aSTRewrite.getAST();
        Type type = null;
        ITypeBinding iTypeBinding = null;
        if (this.fInvocationNode.getLocationInParent() == MemberValuePair.NAME_PROPERTY) {
            Expression expression = ((MemberValuePair)this.fInvocationNode.getParent()).getValue();
            iTypeBinding = expression.resolveTypeBinding();
        } else if (this.fInvocationNode instanceof Expression) {
            iTypeBinding = ((Expression)this.fInvocationNode).resolveTypeBinding();
        }
        if (iTypeBinding != null) {
            type = this.getImportRewrite().addImport(iTypeBinding, aST);
        }
        if (type == null) {
            type = aST.newSimpleType((Name)aST.newSimpleName("String"));
        }
        this.addLinkedPosition(aSTRewrite.track((ASTNode)type), false, KEY_TYPE);
        return type;
    }

    private int evaluateModifiers(AnnotationTypeDeclaration annotationTypeDeclaration) {
        List list = annotationTypeDeclaration.bodyDeclarations();
        int n = 0;
        while (n < list.size()) {
            Object e = list.get(n);
            if (e instanceof AnnotationTypeMemberDeclaration) {
                return ((AnnotationTypeMemberDeclaration)e).getModifiers();
            }
            ++n;
        }
        return 0;
    }

    private SimpleName getNewName(ASTRewrite aSTRewrite) {
        String string;
        AST aST = aSTRewrite.getAST();
        if (this.fInvocationNode.getLocationInParent() == MemberValuePair.NAME_PROPERTY) {
            string = ((SimpleName)this.fInvocationNode).getIdentifier();
            if (aST == this.fInvocationNode.getAST()) {
                this.addLinkedPosition(aSTRewrite.track(this.fInvocationNode), true, KEY_NAME);
            }
        } else {
            string = "value";
        }
        SimpleName simpleName = aST.newSimpleName(string);
        this.addLinkedPosition(aSTRewrite.track((ASTNode)simpleName), false, KEY_NAME);
        return simpleName;
    }
}

