/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.TextElement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.MissingReturnTypeCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ReplaceCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.TypeMismatchSubProcessor;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.text.java.IInvocationContext;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class ReturnTypeSubProcessor {
    public static void addMethodWithConstrNameProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) {
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        ASTNode aSTNode = iProblemLocation.getCoveringNode(iInvocationContext.getASTRoot());
        if (aSTNode instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode;
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)methodDeclaration.getAST());
            aSTRewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.TRUE, null);
            String string = CorrectionMessages.ReturnTypeSubProcessor_constrnamemethod_description;
            Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            ASTRewriteCorrectionProposal aSTRewriteCorrectionProposal = new ASTRewriteCorrectionProposal(string, iCompilationUnit, aSTRewrite, 5, image);
            collection.add(aSTRewriteCorrectionProposal);
        }
    }

    public static void addVoidMethodReturnsProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) throws CoreException {
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        CompilationUnit compilationUnit = iInvocationContext.getASTRoot();
        ASTNode aSTNode = iProblemLocation.getCoveringNode(compilationUnit);
        if (aSTNode == null) {
            return;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(aSTNode);
        if (bodyDeclaration instanceof MethodDeclaration && aSTNode.getNodeType() == 41) {
            Object object;
            Image image;
            Object object2;
            AST aST;
            ReturnStatement returnStatement = (ReturnStatement)aSTNode;
            Expression expression = returnStatement.getExpression();
            if (expression != null) {
                aST = compilationUnit.getAST();
                object2 = Bindings.normalizeTypeBinding(expression.resolveTypeBinding());
                if (object2 == null) {
                    object2 = aST.resolveWellKnownType("java.lang.Object");
                }
                if (object2.isWildcardType()) {
                    object2 = ASTResolving.normalizeWildcardType(object2, true, aST);
                }
                image = (MethodDeclaration)bodyDeclaration;
                object = ASTRewrite.create((AST)aST);
                String string = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_voidmethodreturns_description, BindingLabelProvider.getBindingLabel((IBinding)object2, BindingLabelProvider.DEFAULT_TEXTFLAGS));
                Image image2 = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
                LinkedCorrectionProposal linkedCorrectionProposal = new LinkedCorrectionProposal(string, iCompilationUnit, (ASTRewrite)object, 6, image2);
                ImportRewrite importRewrite = linkedCorrectionProposal.createImportRewrite(compilationUnit);
                Type type = importRewrite.addImport(object2, aST);
                if (image.isConstructor()) {
                    object.set((ASTNode)image, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
                    object.set((ASTNode)image, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)type, null);
                } else {
                    object.replace((ASTNode)image.getReturnType2(), (ASTNode)type, null);
                }
                String string2 = "return_type";
                linkedCorrectionProposal.addLinkedPosition(object.track((ASTNode)type), true, string2);
                ITypeBinding[] iTypeBindingArray = ASTResolving.getRelaxingTypes(aST, object2);
                int n = 0;
                while (n < iTypeBindingArray.length) {
                    linkedCorrectionProposal.addLinkedPositionProposal(string2, iTypeBindingArray[n]);
                    ++n;
                }
                Javadoc javadoc = image.getJavadoc();
                if (javadoc != null) {
                    TagElement tagElement = aST.newTagElement();
                    tagElement.setTagName("@return");
                    TextElement textElement = aST.newTextElement();
                    tagElement.fragments().add(textElement);
                    JavadocTagsSubProcessor.insertTag(object.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), tagElement, null);
                    linkedCorrectionProposal.addLinkedPosition(object.track((ASTNode)textElement), false, "comment_start");
                }
                collection.add(linkedCorrectionProposal);
            }
            aST = ASTRewrite.create((AST)bodyDeclaration.getAST());
            aST.remove((ASTNode)returnStatement.getExpression(), null);
            object2 = CorrectionMessages.ReturnTypeSubProcessor_removereturn_description;
            image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            object = new ASTRewriteCorrectionProposal((String)object2, iCompilationUnit, (ASTRewrite)aST, 5, image);
            collection.add(object);
        }
    }

    public static void addMissingReturnTypeProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) throws CoreException {
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        CompilationUnit compilationUnit = iInvocationContext.getASTRoot();
        ASTNode aSTNode = iProblemLocation.getCoveringNode(compilationUnit);
        if (aSTNode == null) {
            return;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(aSTNode);
        if (bodyDeclaration instanceof MethodDeclaration) {
            int n;
            ASTNode aSTNode2;
            String string;
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            ReturnStatementCollector returnStatementCollector = new ReturnStatementCollector();
            bodyDeclaration.accept((ASTVisitor)returnStatementCollector);
            AST aST = compilationUnit.getAST();
            ITypeBinding iTypeBinding = returnStatementCollector.getTypeBinding(bodyDeclaration.getAST());
            iTypeBinding = Bindings.normalizeTypeBinding(iTypeBinding);
            if (iTypeBinding == null) {
                iTypeBinding = aST.resolveWellKnownType("void");
            }
            if (iTypeBinding.isWildcardType()) {
                iTypeBinding = ASTResolving.normalizeWildcardType(iTypeBinding, true, aST);
            }
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            String string2 = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_missingreturntype_description, BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, BindingLabelProvider.DEFAULT_TEXTFLAGS));
            Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
            LinkedCorrectionProposal linkedCorrectionProposal = new LinkedCorrectionProposal(string2, iCompilationUnit, aSTRewrite, 6, image);
            ImportRewrite importRewrite = linkedCorrectionProposal.createImportRewrite(compilationUnit);
            Type type = importRewrite.addImport(iTypeBinding, aST);
            aSTRewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.RETURN_TYPE2_PROPERTY, (Object)type, null);
            aSTRewrite.set((ASTNode)methodDeclaration, (StructuralPropertyDescriptor)MethodDeclaration.CONSTRUCTOR_PROPERTY, (Object)Boolean.FALSE, null);
            Javadoc javadoc = methodDeclaration.getJavadoc();
            if (javadoc != null && iTypeBinding != null) {
                string = aST.newTagElement();
                string.setTagName("@return");
                aSTNode2 = aST.newTextElement();
                string.fragments().add(aSTNode2);
                JavadocTagsSubProcessor.insertTag(aSTRewrite.getListRewrite((ASTNode)javadoc, Javadoc.TAGS_PROPERTY), (TagElement)string, null);
                linkedCorrectionProposal.addLinkedPosition(aSTRewrite.track(aSTNode2), false, "comment_start");
            }
            string = "return_type";
            linkedCorrectionProposal.addLinkedPosition(aSTRewrite.track((ASTNode)type), true, string);
            if (iTypeBinding != null) {
                aSTNode2 = ASTResolving.getRelaxingTypes(aST, iTypeBinding);
                n = 0;
                while (n < ((ASTNode)aSTNode2).length) {
                    linkedCorrectionProposal.addLinkedPositionProposal(string, (ITypeBinding)aSTNode2[n]);
                    ++n;
                }
            }
            collection.add(linkedCorrectionProposal);
            aSTNode2 = ASTResolving.findParentType((ASTNode)bodyDeclaration);
            if (aSTNode2 instanceof AbstractTypeDeclaration) {
                int n2 = n = aSTNode2 instanceof TypeDeclaration && ((TypeDeclaration)aSTNode2).isInterface() ? 1 : 0;
                if (n == 0) {
                    String string3 = ((TypeDeclaration)aSTNode2).getName().getIdentifier();
                    SimpleName simpleName = methodDeclaration.getName();
                    string2 = Messages.format(CorrectionMessages.ReturnTypeSubProcessor_wrongconstructorname_description, string3);
                    collection.add(new ReplaceCorrectionProposal(string2, iCompilationUnit, simpleName.getStartPosition(), simpleName.getLength(), string3, 5));
                }
            }
        }
    }

    public static void addMissingReturnStatementProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) {
        ICompilationUnit iCompilationUnit = iInvocationContext.getCompilationUnit();
        ASTNode aSTNode = iProblemLocation.getCoveringNode(iInvocationContext.getASTRoot());
        if (aSTNode == null) {
            return;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(aSTNode);
        if (bodyDeclaration instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            Block block = methodDeclaration.getBody();
            if (block == null) {
                return;
            }
            ReturnStatement returnStatement = aSTNode instanceof ReturnStatement ? (ReturnStatement)aSTNode : null;
            collection.add(new MissingReturnTypeCorrectionProposal(iCompilationUnit, methodDeclaration, returnStatement, 6));
            Type type = methodDeclaration.getReturnType2();
            if (type != null && !"void".equals(ASTNodes.asString((ASTNode)type))) {
                String string;
                AST aST = methodDeclaration.getAST();
                ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
                aSTRewrite.replace((ASTNode)type, (ASTNode)aST.newPrimitiveType(PrimitiveType.VOID), null);
                Javadoc javadoc = methodDeclaration.getJavadoc();
                if (javadoc != null && (string = JavadocTagsSubProcessor.findTag(javadoc, "@return", null)) != null) {
                    aSTRewrite.remove((ASTNode)string, null);
                }
                string = CorrectionMessages.ReturnTypeSubProcessor_changetovoid_description;
                Image image = JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif");
                ASTRewriteCorrectionProposal aSTRewriteCorrectionProposal = new ASTRewriteCorrectionProposal(string, iCompilationUnit, aSTRewrite, 5, image);
                collection.add(aSTRewriteCorrectionProposal);
            }
        }
    }

    public static void addMethodRetunsVoidProposals(IInvocationContext iInvocationContext, IProblemLocation iProblemLocation, Collection collection) throws JavaModelException {
        CompilationUnit compilationUnit = iInvocationContext.getASTRoot();
        ASTNode aSTNode = iProblemLocation.getCoveringNode(compilationUnit);
        if (!(aSTNode instanceof ReturnStatement)) {
            return;
        }
        ReturnStatement returnStatement = (ReturnStatement)aSTNode;
        Expression expression = returnStatement.getExpression();
        if (expression == null) {
            return;
        }
        BodyDeclaration bodyDeclaration = ASTResolving.findParentBodyDeclaration(aSTNode);
        if (bodyDeclaration instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)bodyDeclaration;
            Type type = methodDeclaration.getReturnType2();
            if (type == null || type.resolveBinding() == null) {
                return;
            }
            TypeMismatchSubProcessor.addChangeSenderTypeProposals(iInvocationContext, expression, type.resolveBinding(), false, 4, collection);
        }
    }

    private static class ReturnStatementCollector
    extends ASTVisitor {
        private ArrayList fResult = new ArrayList();

        private ReturnStatementCollector() {
        }

        public Iterator returnStatements() {
            return this.fResult.iterator();
        }

        public ITypeBinding getTypeBinding(AST aST) {
            boolean bl = false;
            int n = 0;
            while (n < this.fResult.size()) {
                ReturnStatement returnStatement = (ReturnStatement)this.fResult.get(n);
                Expression expression = returnStatement.getExpression();
                if (expression != null) {
                    ITypeBinding iTypeBinding = Bindings.normalizeTypeBinding(expression.resolveTypeBinding());
                    if (iTypeBinding != null) {
                        return iTypeBinding;
                    }
                } else {
                    return aST.resolveWellKnownType("void");
                }
                bl = true;
                ++n;
            }
            if (bl) {
                return aST.resolveWellKnownType("java.lang.Object");
            }
            return aST.resolveWellKnownType("void");
        }

        public boolean visit(ReturnStatement returnStatement) {
            this.fResult.add(returnStatement);
            return false;
        }

        public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
            return false;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            return false;
        }

        public boolean visit(EnumDeclaration enumDeclaration) {
            return false;
        }

        public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
            return false;
        }
    }
}

