/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalInfo;

public class GetterSetterCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private final IField fField;
    private final boolean fIsGetter;

    public static void evaluateProposals(IType iType, String string, int n, int n2, int n3, Set set, Collection collection) throws CoreException {
        if (string.length() == 0) {
            --n3;
        }
        IField[] iFieldArray = iType.getFields();
        IMethod[] iMethodArray = iType.getMethods();
        int n4 = 0;
        while (n4 < iFieldArray.length) {
            IField iField = iFieldArray[n4];
            if (!JdtFlags.isEnum((IMember)iField)) {
                String string2;
                String string3 = GetterSetterUtil.getGetterName(iField, null);
                if (string3.startsWith(string) && !GetterSetterCompletionProposal.hasMethod(iMethodArray, string3) && set.add(string3)) {
                    collection.add(new GetterSetterCompletionProposal(iField, n, n2, true, n3));
                }
                if ((string2 = GetterSetterUtil.getSetterName(iField, null)).startsWith(string) && !GetterSetterCompletionProposal.hasMethod(iMethodArray, string2) && set.add(string2)) {
                    collection.add(new GetterSetterCompletionProposal(iField, n, n2, false, n3));
                }
            }
            ++n4;
        }
    }

    private static boolean hasMethod(IMethod[] iMethodArray, String string) {
        int n = 0;
        while (n < iMethodArray.length) {
            if (iMethodArray[n].getElementName().equals(string)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public GetterSetterCompletionProposal(IField iField, int n, int n2, boolean bl, int n3) throws JavaModelException {
        super("", iField.getCompilationUnit(), n, n2, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.methpub_obj.gif"), GetterSetterCompletionProposal.getDisplayName(iField, bl), n3);
        Assert.isNotNull((Object)iField);
        this.fField = iField;
        this.fIsGetter = bl;
        this.setProposalInfo(new ProposalInfo((IMember)iField));
    }

    private static String getDisplayName(IField iField, boolean bl) throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(GetterSetterUtil.getGetterName(iField, null));
            stringBuffer.append("()  ");
            stringBuffer.append(Signature.toString((String)iField.getTypeSignature()));
            stringBuffer.append(" - ");
            stringBuffer.append(Messages.format(JavaTextMessages.GetterSetterCompletionProposal_getter_label, iField.getElementName()));
        } else {
            stringBuffer.append(GetterSetterUtil.getSetterName(iField, null));
            stringBuffer.append('(').append(Signature.toString((String)iField.getTypeSignature())).append(')');
            stringBuffer.append("  ");
            stringBuffer.append(Signature.toString((String)"V"));
            stringBuffer.append(" - ");
            stringBuffer.append(Messages.format(JavaTextMessages.GetterSetterCompletionProposal_setter_label, iField.getElementName()));
        }
        return stringBuffer.toString();
    }

    protected boolean updateReplacementString(IDocument iDocument, char c, int n, ImportRewrite importRewrite) throws CoreException, BadLocationException {
        String string;
        String string2;
        CodeGenerationSettings codeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fField.getJavaProject());
        boolean bl = codeGenerationSettings.createComments;
        int n2 = 1 | this.fField.getFlags() & 8;
        if (this.fIsGetter) {
            string2 = GetterSetterUtil.getGetterName(this.fField, null);
            string = GetterSetterUtil.getGetterStub(this.fField, string2, bl, n2);
        } else {
            string2 = GetterSetterUtil.getSetterName(this.fField, null);
            string = GetterSetterUtil.getSetterStub(this.fField, string2, bl, n2);
        }
        string2 = TextUtilities.getDefaultLineDelimiter((IDocument)iDocument);
        IRegion iRegion = iDocument.getLineInformationOfOffset(this.getReplacementOffset());
        int n3 = iRegion.getOffset();
        int n4 = Strings.computeIndentUnits(iDocument.get(n3, this.getReplacementOffset() - n3), codeGenerationSettings.tabWidth, codeGenerationSettings.indentWidth);
        String string3 = CodeFormatterUtil.format(4, string, n4, null, string2, this.fField.getJavaProject());
        if (string3.endsWith(string2)) {
            string3 = string3.substring(0, string3.length() - string2.length());
        }
        this.setReplacementString(Strings.trimLeadingTabsAndSpaces(string3));
        return true;
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

