/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.texteditor.ITextEditorExtension3;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.core.dom.WithStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.wst.jsdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.wst.jsdt.internal.ui.text.JavaIndenter;

public class JavaAutoIndentStrategy
extends DefaultIndentLineAutoEditStrategy {
    private static final String LINE_COMMENT = "//";
    private boolean fCloseBrace;
    private boolean fIsSmartMode;
    private String fPartitioning;
    private final IJavaProject fProject;
    private static IScanner fgScanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);

    public JavaAutoIndentStrategy(String string, IJavaProject iJavaProject) {
        this.fPartitioning = string;
        this.fProject = iJavaProject;
    }

    private int getBracketCount(IDocument iDocument, int n, int n2, boolean bl) throws BadLocationException {
        int n3 = 0;
        block7: while (n < n2) {
            char c = iDocument.getChar(n);
            ++n;
            switch (c) {
                case '/': {
                    if (n >= n2) break;
                    char c2 = iDocument.getChar(n);
                    if (c2 == '*') {
                        n = this.getCommentEnd(iDocument, n + 1, n2);
                        break;
                    }
                    if (c2 != '/') break;
                    n = n2;
                    break;
                }
                case '*': {
                    char c2;
                    if (n >= n2 || (c2 = iDocument.getChar(n)) != '/') continue block7;
                    n3 = 0;
                    ++n;
                    break;
                }
                case '{': {
                    ++n3;
                    bl = false;
                    break;
                }
                case '}': {
                    if (bl) break;
                    --n3;
                    break;
                }
                case '\"': 
                case '\'': {
                    n = this.getStringEnd(iDocument, n, n2, c);
                }
            }
        }
        return n3;
    }

    private int getCommentEnd(IDocument iDocument, int n, int n2) throws BadLocationException {
        while (n < n2) {
            char c = iDocument.getChar(n);
            if (c != '*' || ++n >= n2 || iDocument.getChar(n) != '/') continue;
            return n + 1;
        }
        return n2;
    }

    private String getIndentOfLine(IDocument iDocument, int n) throws BadLocationException {
        if (n > -1) {
            int n2 = iDocument.getLineOffset(n);
            int n3 = n2 + iDocument.getLineLength(n) - 1;
            int n4 = this.findEndOfWhiteSpace(iDocument, n2, n3);
            return iDocument.get(n2, n4 - n2);
        }
        return "";
    }

    private int getStringEnd(IDocument iDocument, int n, int n2, char c) throws BadLocationException {
        while (n < n2) {
            char c2 = iDocument.getChar(n);
            ++n;
            if (c2 == '\\') {
                ++n;
                continue;
            }
            if (c2 != c) continue;
            return n;
        }
        return n2;
    }

    private void smartIndentAfterClosingBracket(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset == -1 || iDocument.getLength() == 0) {
            return;
        }
        try {
            int n;
            int n2;
            int n3 = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
            int n4 = iDocument.getLineOfOffset(n3);
            int n5 = iDocument.getLineOffset(n4);
            int n6 = this.findEndOfWhiteSpace(iDocument, n5, documentCommand.offset);
            JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
            JavaIndenter javaIndenter = new JavaIndenter(iDocument, javaHeuristicScanner, this.fProject);
            if (n6 == documentCommand.offset && (n2 = iDocument.getLineOfOffset(n = javaIndenter.findReferencePosition(documentCommand.offset, false, true, false, false))) != -1 && n2 != n4) {
                StringBuffer stringBuffer = new StringBuffer(this.getIndentOfLine(iDocument, n2));
                stringBuffer.append(iDocument.get(n6, documentCommand.offset - n6));
                stringBuffer.append(documentCommand.text);
                documentCommand.length += documentCommand.offset - n5;
                documentCommand.offset = n5;
                documentCommand.text = stringBuffer.toString();
            }
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    private void smartIndentAfterOpeningBracket(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset < 1 || iDocument.getLength() == 0) {
            return;
        }
        JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
        int n = documentCommand.offset == iDocument.getLength() ? documentCommand.offset - 1 : documentCommand.offset;
        try {
            int n2 = iDocument.getLineOfOffset(n);
            int n3 = iDocument.getLineOffset(n2);
            if (iDocument.get(n3, n - n3).trim().length() != 0) {
                return;
            }
            int n4 = javaHeuristicScanner.findNonWhitespaceBackward(n, -2);
            if (n4 == -1) {
                return;
            }
            int n5 = iDocument.getLineOfOffset(n4);
            if (n5 < n2) {
                JavaIndenter javaIndenter = new JavaIndenter(iDocument, javaHeuristicScanner, this.fProject);
                StringBuffer stringBuffer = javaIndenter.computeIndentation(n, true);
                String string = iDocument.get(n3, documentCommand.offset - n3);
                if (stringBuffer != null && !stringBuffer.toString().equals(string)) {
                    documentCommand.text = stringBuffer.append(documentCommand.text).toString();
                    documentCommand.length += documentCommand.offset - n3;
                    documentCommand.offset = n3;
                }
            }
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    private void smartIndentAfterNewLine(IDocument iDocument, DocumentCommand documentCommand) {
        JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
        JavaIndenter javaIndenter = new JavaIndenter(iDocument, javaHeuristicScanner, this.fProject);
        StringBuffer stringBuffer = javaIndenter.computeIndentation(documentCommand.offset);
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer();
        }
        int n = iDocument.getLength();
        if (documentCommand.offset == -1 || n == 0) {
            return;
        }
        try {
            int n2;
            int n3 = documentCommand.offset == n ? documentCommand.offset - 1 : documentCommand.offset;
            int n4 = iDocument.getLineOfOffset(n3);
            StringBuffer stringBuffer2 = new StringBuffer(String.valueOf(documentCommand.text) + stringBuffer);
            IRegion iRegion = iDocument.getLineInformation(n4);
            int n5 = iRegion.getOffset() + iRegion.getLength();
            int n6 = this.findEndOfWhiteSpace(iDocument, documentCommand.offset, n5);
            documentCommand.length = Math.max(n6 - documentCommand.offset, 0);
            int n7 = iRegion.getOffset();
            ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)this.fPartitioning, (int)n7, (boolean)true);
            if ("__java_javadoc".equals(iTypedRegion.getType())) {
                n7 = iDocument.getLineInformationOfOffset(iTypedRegion.getOffset()).getOffset();
            }
            if (this.getBracketCount(iDocument, n7, documentCommand.offset, true) > 0 && this.closeBrace() && !this.isClosed(iDocument, documentCommand.offset, documentCommand.length)) {
                documentCommand.caretOffset = documentCommand.offset + stringBuffer2.length();
                documentCommand.shiftsCaret = false;
                if ((documentCommand.offset == 0 || JavaAutoIndentStrategy.computeAnonymousPosition(iDocument, documentCommand.offset - 1, this.fPartitioning, n5) == -1) && n5 - n6 > 0) {
                    documentCommand.length = n5 - documentCommand.offset;
                    stringBuffer2.append(iDocument.get(n6, n5 - n6).toCharArray());
                }
                stringBuffer2.append(TextUtilities.getDefaultLineDelimiter((IDocument)iDocument));
                StringBuffer stringBuffer3 = null;
                int n8 = this.findEndOfWhiteSpace(iDocument, n7, n5);
                stringBuffer3 = n8 < documentCommand.offset && iDocument.getChar(n8) == '{' ? new StringBuffer(iDocument.get(n7, n8 - n7)) : javaIndenter.getReferenceIndentation(documentCommand.offset);
                if (stringBuffer3 != null) {
                    stringBuffer2.append(stringBuffer3);
                }
                stringBuffer2.append('}');
            } else if (documentCommand.offset > n7 && n6 < n5 && iDocument.getChar(n6) == '}' && (n2 = javaHeuristicScanner.findNonWhitespaceBackward(documentCommand.offset - 1, n7)) != -1 && iDocument.getChar(n2) == '{') {
                documentCommand.caretOffset = documentCommand.offset + stringBuffer2.length();
                documentCommand.shiftsCaret = false;
                StringBuffer stringBuffer4 = null;
                int n9 = this.findEndOfWhiteSpace(iDocument, n7, n5);
                stringBuffer4 = n9 < documentCommand.offset && iDocument.getChar(n9) == '{' ? new StringBuffer(iDocument.get(n7, n9 - n7)) : javaIndenter.getReferenceIndentation(documentCommand.offset);
                stringBuffer2.append(TextUtilities.getDefaultLineDelimiter((IDocument)iDocument));
                if (stringBuffer4 != null) {
                    stringBuffer2.append(stringBuffer4);
                }
            }
            documentCommand.text = stringBuffer2.toString();
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    private static int computeAnonymousPosition(IDocument iDocument, int n, String string, int n2) {
        int n3;
        int n4;
        JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
        int n5 = n;
        int n6 = n2;
        int n7 = javaHeuristicScanner.scanForward(n5, n6, '}');
        if (n7 == -1) {
            n7 = n6;
        }
        int n8 = JavaAutoIndentStrategy.findClosingParenToLeft(javaHeuristicScanner, n5) - 1;
        while ((n8 = javaHeuristicScanner.scanForward(n4 = n8 + 1, n7, ')')) != -1 && (n3 = javaHeuristicScanner.findOpeningPeer(n8 - 1, '(', ')')) >= 1) {
            if (n3 > n5 || !JavaAutoIndentStrategy.looksLikeAnonymousClassDef(iDocument, string, javaHeuristicScanner, n3 - 1)) continue;
            return n8 + 1;
        }
        return -1;
    }

    private static int findClosingParenToLeft(JavaHeuristicScanner javaHeuristicScanner, int n) {
        if (n < 1) {
            return n;
        }
        if (javaHeuristicScanner.previousToken(n - 1, -2) == 6) {
            return javaHeuristicScanner.getPosition() + 1;
        }
        return n;
    }

    private static boolean isNewMatch(IDocument iDocument, int n, int n2, String string) {
        int n3;
        String string2;
        block6: {
            block5: {
                Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
                Assert.isTrue((n >= 0 ? 1 : 0) != 0);
                Assert.isTrue((n + n2 < iDocument.getLength() + 1 ? 1 : 0) != 0);
                try {
                    string2 = iDocument.get(n, n2);
                    n3 = string2.indexOf("new");
                    while (n3 != -1 && !JavaAutoIndentStrategy.isDefaultPartition(iDocument, n3 + n, string)) {
                        n3 = string2.indexOf("new", n3 + 2);
                    }
                    if (n3 >= 0) break block5;
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    return false;
                }
            }
            if (n3 == 0 || !Character.isJavaIdentifierPart(string2.charAt(n3 - 1))) break block6;
            return false;
        }
        return n3 + 3 >= n2 || !Character.isJavaIdentifierPart(string2.charAt(n3 + 3));
    }

    private static boolean looksLikeAnonymousClassDef(IDocument iDocument, String string, JavaHeuristicScanner javaHeuristicScanner, int n) {
        int n2 = javaHeuristicScanner.scanBackward(n - 1, -2, new char[]{',', '(', '='});
        if (n2 == -1 || n < n2 + 5) {
            return false;
        }
        return JavaAutoIndentStrategy.isNewMatch(iDocument, n2 + 1, n - n2 - 2, string);
    }

    private static boolean isDefaultPartition(IDocument iDocument, int n, String string) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n <= iDocument.getLength() ? 1 : 0) != 0);
        try {
            ITypedRegion iTypedRegion = TextUtilities.getPartition((IDocument)iDocument, (String)string, (int)n, (boolean)false);
            return iTypedRegion.getType().equals("__dftl_partition_content_type");
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    private boolean isClosed(IDocument iDocument, int n, int n2) {
        IProblem[] iProblemArray;
        CompilationUnitInfo compilationUnitInfo = JavaAutoIndentStrategy.getCompilationUnitForMethod(iDocument, n, this.fPartitioning);
        if (compilationUnitInfo == null) {
            return false;
        }
        CompilationUnit compilationUnit = null;
        try {
            iProblemArray = ASTParser.newParser((int)3);
            iProblemArray.setSource(compilationUnitInfo.buffer);
            compilationUnit = (CompilationUnit)iProblemArray.createAST(null);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return false;
        }
        iProblemArray = compilationUnit.getProblems();
        int n3 = 0;
        while (n3 != iProblemArray.length) {
            if (iProblemArray[n3].getID() == 1610612956) {
                return true;
            }
            ++n3;
        }
        n3 = n - compilationUnitInfo.delta;
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, n3, n2);
        if (n2 == 0) {
            while (aSTNode != null && (n3 == aSTNode.getStartPosition() || n3 == aSTNode.getStartPosition() + aSTNode.getLength())) {
                aSTNode = aSTNode.getParent();
            }
        }
        if (aSTNode == null) {
            return false;
        }
        switch (aSTNode.getNodeType()) {
            case 8: {
                return JavaAutoIndentStrategy.getBlockBalance(iDocument, n, this.fPartitioning) <= 0;
            }
            case 25: {
                int n4;
                IfStatement ifStatement = (IfStatement)aSTNode;
                Expression expression = ifStatement.getExpression();
                IRegion iRegion = JavaAutoIndentStrategy.createRegion((ASTNode)expression, compilationUnitInfo.delta);
                Statement statement = ifStatement.getThenStatement();
                IRegion iRegion2 = JavaAutoIndentStrategy.createRegion((ASTNode)statement, compilationUnitInfo.delta);
                if (iRegion.getOffset() + iRegion.getLength() <= n && n + n2 <= iRegion2.getOffset()) {
                    return statement != null;
                }
                Statement statement2 = ifStatement.getElseStatement();
                IRegion iRegion3 = JavaAutoIndentStrategy.createRegion((ASTNode)statement2, compilationUnitInfo.delta);
                if (statement2 == null) break;
                int n5 = iRegion2.getOffset() + iRegion2.getLength();
                IRegion iRegion4 = JavaAutoIndentStrategy.getToken(iDocument, (IRegion)new Region(n5, n4 = iRegion3.getOffset() - n5), 213);
                return iRegion4 != null && iRegion4.getOffset() + iRegion4.getLength() <= n && n + n2 < iRegion3.getOffset();
            }
            case 24: 
            case 61: {
                Expression expression = aSTNode.getNodeType() == 61 ? ((WhileStatement)aSTNode).getExpression() : ((ForStatement)aSTNode).getExpression();
                IRegion iRegion = JavaAutoIndentStrategy.createRegion((ASTNode)expression, compilationUnitInfo.delta);
                Statement statement = aSTNode.getNodeType() == 61 ? ((WhileStatement)aSTNode).getBody() : ((ForStatement)aSTNode).getBody();
                IRegion iRegion5 = JavaAutoIndentStrategy.createRegion((ASTNode)statement, compilationUnitInfo.delta);
                if (iRegion.getOffset() + iRegion.getLength() > n || n + n2 > iRegion5.getOffset()) break;
                return statement != null;
            }
            case 83: {
                Expression expression = ((ForInStatement)aSTNode).getCollection();
                IRegion iRegion = JavaAutoIndentStrategy.createRegion((ASTNode)expression, compilationUnitInfo.delta);
                Statement statement = ((ForInStatement)aSTNode).getBody();
                IRegion iRegion6 = JavaAutoIndentStrategy.createRegion((ASTNode)statement, compilationUnitInfo.delta);
                if (iRegion.getOffset() + iRegion.getLength() > n || n + n2 > iRegion6.getOffset()) break;
                return statement != null;
            }
            case 90: {
                Expression expression = ((WithStatement)aSTNode).getExpression();
                IRegion iRegion = JavaAutoIndentStrategy.createRegion((ASTNode)expression, compilationUnitInfo.delta);
                Statement statement = ((WithStatement)aSTNode).getBody();
                IRegion iRegion7 = JavaAutoIndentStrategy.createRegion((ASTNode)statement, compilationUnitInfo.delta);
                if (iRegion.getOffset() + iRegion.getLength() > n || n + n2 > iRegion7.getOffset()) break;
                return statement != null;
            }
            case 19: {
                DoStatement doStatement = (DoStatement)aSTNode;
                IRegion iRegion = JavaAutoIndentStrategy.createRegion((ASTNode)doStatement, compilationUnitInfo.delta);
                Statement statement = doStatement.getBody();
                IRegion iRegion8 = JavaAutoIndentStrategy.createRegion((ASTNode)statement, compilationUnitInfo.delta);
                if (iRegion.getOffset() + iRegion.getLength() > n || n + n2 > iRegion8.getOffset()) break;
                return statement != null;
            }
        }
        return true;
    }

    private static void installJavaStuff(Document document) {
        String[] stringArray = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character", "__dftl_partition_content_type"};
        FastPartitioner fastPartitioner = new FastPartitioner((IPartitionTokenScanner)new FastJavaPartitionScanner(), stringArray);
        fastPartitioner.connect((IDocument)document);
        document.setDocumentPartitioner("___java_partitioning", (IDocumentPartitioner)fastPartitioner);
    }

    private static void removeJavaStuff(Document document) {
        document.setDocumentPartitioner("___java_partitioning", null);
    }

    private void smartPaste(IDocument iDocument, DocumentCommand documentCommand) {
        int n = documentCommand.offset;
        int n2 = documentCommand.length;
        String string = documentCommand.text;
        try {
            JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
            JavaIndenter javaIndenter = new JavaIndenter(iDocument, javaHeuristicScanner, this.fProject);
            int n3 = n;
            int n4 = javaIndenter.findReferencePosition(n3);
            if (n4 == -1) {
                return;
            }
            int n5 = this.getPeerPosition(iDocument, documentCommand);
            n5 = javaIndenter.findReferencePosition(n5);
            n4 = Math.min(n4, n5);
            int n6 = 1;
            IRegion iRegion = iDocument.getLineInformationOfOffset(n3);
            String string2 = iDocument.get(iRegion.getOffset(), n3 - iRegion.getOffset());
            if (string2.trim().length() == 0) {
                n2 += string2.length();
                n = iRegion.getOffset();
                n6 = 0;
            }
            IRegion iRegion2 = iDocument.getLineInformationOfOffset(n4);
            String string3 = iDocument.get(iRegion2.getOffset(), n - iRegion2.getOffset());
            Document document = new Document(String.valueOf(string3) + string);
            DocumentRewriteSession documentRewriteSession = document.startRewriteSession(DocumentRewriteSessionType.STRICTLY_SEQUENTIAL);
            javaHeuristicScanner = new JavaHeuristicScanner((IDocument)document);
            javaIndenter = new JavaIndenter((IDocument)document, javaHeuristicScanner, this.fProject);
            JavaAutoIndentStrategy.installJavaStuff(document);
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n7 = 0;
            int n8 = iDocument.computeNumberOfLines(string3) + n6;
            int n9 = document.getNumberOfLines();
            int n10 = this.getVisualTabLengthPreference();
            boolean bl2 = false;
            int n11 = n8;
            while (n11 < n9) {
                IRegion iRegion3 = document.getLineInformation(n11);
                int n12 = iRegion3.getOffset();
                int n13 = iRegion3.getLength();
                if (n13 != 0) {
                    if (!bl) {
                        String string4 = JavaAutoIndentStrategy.getCurrentIndent(document, n11);
                        StringBuffer stringBuffer2 = javaIndenter.computeIndentation(n12);
                        if (stringBuffer2 == null) {
                            return;
                        }
                        n7 = this.subtractIndent(stringBuffer2, string4, stringBuffer, n10);
                        if (n11 != n8 && document.get(n12, n13).trim().length() != 0) {
                            bl = true;
                            if (n7 == 0) {
                                if (n6 == 0) {
                                    documentCommand.offset = n;
                                    documentCommand.length = n2;
                                    if (bl2) break;
                                }
                                return;
                            }
                            JavaAutoIndentStrategy.removeJavaStuff(document);
                        } else {
                            boolean bl3 = bl2 = n7 != 0;
                        }
                    }
                    if (n7 > 0) {
                        this.addIndent(document, n11, stringBuffer, n10);
                    } else if (n7 < 0) {
                        this.cutIndent(document, n11, -n7, n10);
                    }
                }
                ++n11;
            }
            document.stopRewriteSession(documentRewriteSession);
            string = document.get(string3.length(), document.getLength() - string3.length());
            documentCommand.offset = n;
            documentCommand.length = n2;
            documentCommand.text = string;
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    private static String getCurrentIndent(Document document, int n) throws BadLocationException {
        String string;
        IRegion iRegion = document.getLineInformation(n);
        int n2 = iRegion.getOffset();
        int n3 = iRegion.getOffset() + iRegion.getLength();
        int n4 = n2;
        while (n4 < n3 - 2 && document.get(n4, 2).equals(LINE_COMMENT)) {
            n4 += 2;
        }
        while (n4 < n3) {
            char c = document.getChar(n4);
            if (!Character.isWhitespace(c)) break;
            ++n4;
        }
        if (n4 > n2 && n4 < n3 - 1 && document.get(n4 - 1, 2).equals(" *") && ((string = TextUtilities.getContentType((IDocument)document, (String)"___java_partitioning", (int)n4, (boolean)true)).equals("__java_javadoc") || string.equals("__java_multiline_comment"))) {
            --n4;
        }
        return document.get(n2, n4 - n2);
    }

    private int subtractIndent(CharSequence charSequence, CharSequence charSequence2, StringBuffer stringBuffer, int n) {
        int n2;
        int n3 = this.computeVisualLength(charSequence, n);
        int n4 = n3 - (n2 = this.computeVisualLength(charSequence2, n));
        if (n4 <= 0) {
            return n4;
        }
        stringBuffer.setLength(0);
        int n5 = 0;
        int n6 = 0;
        while (n5 < n4) {
            char c = charSequence.charAt(n6++);
            stringBuffer.append(c);
            n5 += this.computeVisualLength(c, n);
        }
        return n4;
    }

    private void addIndent(Document document, int n, CharSequence charSequence, int n2) throws BadLocationException {
        IRegion iRegion = document.getLineInformation(n);
        int n3 = iRegion.getOffset();
        int n4 = iRegion.getOffset() + iRegion.getLength();
        int n5 = n3;
        while (n5 < n4 - 2 && document.get(n5, 2).equals(LINE_COMMENT)) {
            n5 += 2;
        }
        if (n5 > n3) {
            int n6 = 0;
            int n7 = n5;
            while (n7 < n4 - 1) {
                char c = document.get(n7, 1).charAt(0);
                if (!Character.isWhitespace(c)) break;
                n6 += this.computeVisualLength(c, n2);
                ++n7;
            }
            if (n6 != 0 && n6 >= CodeFormatterUtil.getIndentWidth(this.fProject)) {
                n3 = n5;
            }
        }
        document.replace(n3, 0, charSequence.toString());
    }

    private void cutIndent(Document document, int n, int n2, int n3) throws BadLocationException {
        IRegion iRegion = document.getLineInformation(n);
        int n4 = iRegion.getOffset();
        int n5 = iRegion.getOffset() + iRegion.getLength();
        while (n4 < n5 - 2 && document.get(n4, 2).equals(LINE_COMMENT)) {
            n4 += 2;
        }
        int n6 = n4;
        while (n2 > 0 && n6 < n5) {
            char c = document.getChar(n6);
            if (!Character.isWhitespace(c) || (n2 -= this.computeVisualLength(c, n3)) < 0) break;
            ++n6;
        }
        document.replace(n4, n6 - n4, "");
    }

    private int computeVisualLength(CharSequence charSequence, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < charSequence.length()) {
            char c = charSequence.charAt(n3);
            if (c == '\t') {
                if (n != 0) {
                    n2 += n - n2 % n;
                }
            } else {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    private int computeVisualLength(char c, int n) {
        if (c == '\t') {
            return n;
        }
        return 1;
    }

    private int getVisualTabLengthPreference() {
        return CodeFormatterUtil.getTabWidth(this.fProject);
    }

    private int getPeerPosition(IDocument iDocument, DocumentCommand documentCommand) {
        if (iDocument.getLength() == 0) {
            return 0;
        }
        Document document = new Document(documentCommand.text);
        JavaAutoIndentStrategy.installJavaStuff(document);
        int n = documentCommand.offset;
        JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner((IDocument)document);
        JavaHeuristicScanner javaHeuristicScanner2 = new JavaHeuristicScanner(iDocument);
        int n2 = javaHeuristicScanner2.nextToken(documentCommand.offset + documentCommand.length, -2);
        try {
            switch (n2) {
                case 2: {
                    document.replace(document.getLength(), 0, "}");
                    break;
                }
                case 6: {
                    document.replace(document.getLength(), 0, ")");
                    break;
                }
                case 4: {
                    document.replace(document.getLength(), 0, "]");
                }
            }
        }
        catch (BadLocationException badLocationException) {
            Assert.isTrue((boolean)false);
        }
        int n3 = 0;
        int n4 = Math.max(0, documentCommand.offset - 1);
        block15: while (true) {
            int n5 = javaHeuristicScanner.nextToken(n3, -2);
            n3 = javaHeuristicScanner.getPosition();
            switch (n5) {
                case 1: 
                case 3: 
                case 5: {
                    if ((n3 = JavaAutoIndentStrategy.skipScope(javaHeuristicScanner, n3, n5)) != -1) continue block15;
                    return n;
                }
                case 2: {
                    int n6 = javaHeuristicScanner2.findOpeningPeer(n4, '{', '}');
                    n4 = n6 - 1;
                    if (n6 == -1) {
                        return n;
                    }
                    n = n6;
                    continue block15;
                }
                case 4: {
                    int n6 = javaHeuristicScanner2.findOpeningPeer(n4, '[', ']');
                    n4 = n6 - 1;
                    if (n6 == -1) {
                        return n;
                    }
                    n = n6;
                    continue block15;
                }
                case 6: {
                    int n6 = javaHeuristicScanner2.findOpeningPeer(n4, '(', ')');
                    n4 = n6 - 1;
                    if (n6 == -1) {
                        return n;
                    }
                    n = n6;
                    continue block15;
                }
                case 1013: 
                case 1024: {
                    JavaIndenter javaIndenter = new JavaIndenter(iDocument, javaHeuristicScanner2, this.fProject);
                    int n6 = javaIndenter.findReferencePosition(n4, false, false, false, true);
                    if (n6 == -1) {
                        return n;
                    }
                    n = n6;
                    continue block15;
                }
                case -1: {
                    return n;
                }
            }
        }
    }

    private static int skipScope(JavaHeuristicScanner javaHeuristicScanner, int n, int n2) {
        int n3;
        int n4 = n2;
        switch (n2) {
            case 5: {
                n3 = 6;
                break;
            }
            case 3: {
                n3 = 4;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
            default: {
                Assert.isTrue((boolean)false);
                return -1;
            }
        }
        int n5 = 1;
        int n6 = n;
        while (true) {
            int n7 = javaHeuristicScanner.nextToken(n6, -2);
            n6 = javaHeuristicScanner.getPosition();
            if (n7 == n4) {
                ++n5;
                continue;
            }
            if (n7 == n3) {
                if (--n5 != 0) continue;
                return n6 + 1;
            }
            if (n7 == -1) break;
        }
        return -1;
    }

    private boolean isLineDelimiter(IDocument iDocument, String string) {
        String[] stringArray = iDocument.getLegalLineDelimiters();
        if (stringArray != null) {
            return TextUtilities.equals((String[])stringArray, (String)string) > -1;
        }
        return false;
    }

    private void smartIndentOnKeypress(IDocument iDocument, DocumentCommand documentCommand) {
        switch (documentCommand.text.charAt(0)) {
            case '}': {
                this.smartIndentAfterClosingBracket(iDocument, documentCommand);
                break;
            }
            case '{': {
                this.smartIndentAfterOpeningBracket(iDocument, documentCommand);
                break;
            }
            case 'e': {
                this.smartIndentUponE(iDocument, documentCommand);
            }
        }
    }

    private void smartIndentUponE(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.offset < 4 || iDocument.getLength() == 0) {
            return;
        }
        try {
            String string = iDocument.get(documentCommand.offset - 3, 3);
            if (string.equals("els")) {
                JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
                int n = documentCommand.offset - 3;
                int n2 = iDocument.getLineOfOffset(n);
                int n3 = iDocument.getLineOffset(n2);
                if (iDocument.get(n3, n - n3).trim().length() != 0) {
                    return;
                }
                int n4 = javaHeuristicScanner.findNonWhitespaceBackward(n - 1, -2);
                if (n4 == -1) {
                    return;
                }
                int n5 = iDocument.getLineOfOffset(n4);
                if (n5 < n2) {
                    JavaIndenter javaIndenter = new JavaIndenter(iDocument, javaHeuristicScanner, this.fProject);
                    int n6 = javaIndenter.findReferencePosition(n, true, false, false, false);
                    if (n6 == -1) {
                        return;
                    }
                    int n7 = iDocument.getLineOfOffset(n6);
                    String string2 = this.getIndentOfLine(iDocument, n7);
                    if (string2 != null) {
                        documentCommand.text = String.valueOf(string2.toString()) + "else";
                        documentCommand.length += documentCommand.offset - n3;
                        documentCommand.offset = n3;
                    }
                }
                return;
            }
            if (string.equals("cas")) {
                JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
                int n = documentCommand.offset - 3;
                int n8 = iDocument.getLineOfOffset(n);
                int n9 = iDocument.getLineOffset(n8);
                if (iDocument.get(n9, n - n9).trim().length() != 0) {
                    return;
                }
                int n10 = javaHeuristicScanner.findNonWhitespaceBackward(n - 1, -2);
                if (n10 == -1) {
                    return;
                }
                int n11 = iDocument.getLineOfOffset(n10);
                if (n11 < n8) {
                    JavaIndenter javaIndenter = new JavaIndenter(iDocument, javaHeuristicScanner, this.fProject);
                    int n12 = javaIndenter.findReferencePosition(n, false, false, false, true);
                    if (n12 == -1) {
                        return;
                    }
                    int n13 = iDocument.getLineOfOffset(n12);
                    int n14 = javaHeuristicScanner.nextToken(n12, -2);
                    String string3 = n14 == 1013 || n14 == 1024 ? this.getIndentOfLine(iDocument, n13) : javaIndenter.computeIndentation(n).toString();
                    if (string3 != null) {
                        documentCommand.text = String.valueOf(string3.toString()) + "case";
                        documentCommand.length += documentCommand.offset - n9;
                        documentCommand.offset = n9;
                    }
                }
                return;
            }
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (!documentCommand.doit) {
            return;
        }
        this.clearCachedValues();
        if (!this.isSmartMode()) {
            super.customizeDocumentCommand(iDocument, documentCommand);
            return;
        }
        if (documentCommand.length == 0 && documentCommand.text != null && this.isLineDelimiter(iDocument, documentCommand.text)) {
            this.smartIndentAfterNewLine(iDocument, documentCommand);
        } else if (documentCommand.text.length() == 1) {
            this.smartIndentOnKeypress(iDocument, documentCommand);
        } else if (documentCommand.text.length() > 1 && JavaAutoIndentStrategy.getPreferenceStore().getBoolean("smartPaste")) {
            this.smartPaste(iDocument, documentCommand);
        }
    }

    private static IPreferenceStore getPreferenceStore() {
        return JavaPlugin.getDefault().getCombinedPreferenceStore();
    }

    private boolean closeBrace() {
        return this.fCloseBrace;
    }

    private boolean isSmartMode() {
        return this.fIsSmartMode;
    }

    private void clearCachedValues() {
        IPreferenceStore iPreferenceStore = JavaAutoIndentStrategy.getPreferenceStore();
        this.fCloseBrace = iPreferenceStore.getBoolean("closeBraces");
        this.fIsSmartMode = this.computeSmartMode();
    }

    private boolean computeSmartMode() {
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = JavaPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) instanceof ITextEditorExtension3) {
            ITextEditorExtension3 iTextEditorExtension3 = (ITextEditorExtension3)iEditorPart;
            return iTextEditorExtension3.getInsertMode() == ITextEditorExtension3.SMART_INSERT;
        }
        return false;
    }

    private static CompilationUnitInfo getCompilationUnitForMethod(IDocument iDocument, int n, String string) {
        IRegion iRegion;
        block3: {
            try {
                JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
                iRegion = javaHeuristicScanner.findSurroundingBlock(n);
                if (iRegion != null) break block3;
                return null;
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
                return null;
            }
        }
        String string2 = iDocument.get(iRegion.getOffset(), iRegion.getLength());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("class ____C{void ____m()");
        int n2 = stringBuffer.length();
        stringBuffer.append(string2);
        stringBuffer.append('}');
        char[] cArray = stringBuffer.toString().toCharArray();
        return new CompilationUnitInfo(cArray, iRegion.getOffset() - n2);
    }

    private static int getBlockBalance(IDocument iDocument, int n, String string) {
        if (n < 1) {
            return -1;
        }
        if (n >= iDocument.getLength()) {
            return 1;
        }
        int n2 = n;
        int n3 = n - 1;
        JavaHeuristicScanner javaHeuristicScanner = new JavaHeuristicScanner(iDocument);
        do {
            n2 = javaHeuristicScanner.findOpeningPeer(n2 - 1, '{', '}');
            n3 = javaHeuristicScanner.findClosingPeer(n3 + 1, '{', '}');
            if (n2 == -1 && n3 == -1) {
                return 0;
            }
            if (n2 != -1) continue;
            return -1;
        } while (n3 != -1);
        return 1;
    }

    private static IRegion createRegion(ASTNode aSTNode, int n) {
        return aSTNode == null ? null : new Region(aSTNode.getStartPosition() + n, aSTNode.getLength());
    }

    private static IRegion getToken(IDocument iDocument, IRegion iRegion, int n) {
        block5: {
            String string = iDocument.get(iRegion.getOffset(), iRegion.getLength());
            fgScanner.setSource(string.toCharArray());
            int n2 = fgScanner.getNextToken();
            while (n2 != 158 && n2 != n) {
                n2 = fgScanner.getNextToken();
            }
            if (n2 != 158) break block5;
            return null;
        }
        try {
            int n3 = fgScanner.getCurrentTokenStartPosition();
            int n4 = fgScanner.getCurrentTokenEndPosition() + 1 - n3;
            return new Region(n3 + iRegion.getOffset(), n4);
        }
        catch (InvalidInputException invalidInputException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private static class CompilationUnitInfo {
        char[] buffer;
        int delta;

        CompilationUnitInfo(char[] cArray, int n) {
            this.buffer = cArray;
            this.delta = n;
        }
    }
}

