/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class JavaMethodCompletionProposal
extends LazyJavaCompletionProposal {
    protected static final char[] METHOD_TRIGGERS = new char[]{';', ',', '.', '\t', '['};
    protected static final char[] METHOD_WITH_ARGUMENTS_TRIGGERS = new char[]{'(', '-', ' '};
    protected static final char[] METHOD_NAME_TRIGGERS = new char[]{';'};
    private boolean fHasParameters;
    private boolean fHasParametersComputed = false;
    private LazyJavaCompletionProposal.FormatterPrefs fFormatterPrefs;

    public JavaMethodCompletionProposal(CompletionProposal completionProposal, JavaContentAssistInvocationContext javaContentAssistInvocationContext) {
        super(completionProposal, javaContentAssistInvocationContext);
    }

    public void apply(IDocument iDocument, char c, int n) {
        if (c == ' ' || c == '(') {
            c = '\u0000';
        }
        super.apply(iDocument, c, n);
        if (this.needsLinkedMode()) {
            this.setUpLinkedMode(iDocument, ')');
        }
    }

    protected boolean needsLinkedMode() {
        return this.hasArgumentList() && this.hasParameters();
    }

    public CharSequence getPrefixCompletionText(IDocument iDocument, int n) {
        if (this.hasArgumentList()) {
            String string = String.valueOf(this.fProposal.getName());
            if (this.isCamelCaseMatching()) {
                String string2 = this.getPrefix(iDocument, n);
                return this.getCamelCaseCompound(string2, string);
            }
            return string;
        }
        return super.getPrefixCompletionText(iDocument, n);
    }

    protected IContextInformation computeContextInformation() {
        if (this.fProposal.getKind() == 6 && this.hasParameters() && (this.getReplacementString().endsWith(")") || this.getReplacementString().length() == 0)) {
            ProposalContextInformation proposalContextInformation = new ProposalContextInformation(this.fProposal);
            if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length == 0) {
                proposalContextInformation.setContextInformationPosition(this.fContextInformationPosition);
            }
            return proposalContextInformation;
        }
        return super.computeContextInformation();
    }

    protected char[] computeTriggerCharacters() {
        if (this.fProposal.getKind() == 12) {
            return METHOD_NAME_TRIGGERS;
        }
        if (this.hasParameters()) {
            return METHOD_WITH_ARGUMENTS_TRIGGERS;
        }
        return METHOD_TRIGGERS;
    }

    protected final boolean hasParameters() {
        if (!this.fHasParametersComputed) {
            this.fHasParametersComputed = true;
            this.fHasParameters = this.computeHasParameters();
        }
        return this.fHasParameters;
    }

    private boolean computeHasParameters() throws IllegalArgumentException {
        return Signature.getParameterCount((char[])this.fProposal.getSignature()) > 0;
    }

    protected boolean hasArgumentList() {
        if (12 == this.fProposal.getKind()) {
            return false;
        }
        IPreferenceStore iPreferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        boolean bl = iPreferenceStore.getBoolean("content_assist_insert_completion") ^ this.isToggleEating();
        char[] cArray = this.fProposal.getCompletion();
        return !this.isInJavadoc() && cArray.length > 0 && (bl || cArray[cArray.length - 1] == ')');
    }

    protected final LazyJavaCompletionProposal.FormatterPrefs getFormatterPrefs() {
        if (this.fFormatterPrefs == null) {
            this.fFormatterPrefs = new LazyJavaCompletionProposal.FormatterPrefs(this.fInvocationContext.getProject());
        }
        return this.fFormatterPrefs;
    }

    protected String computeReplacementString() {
        if (!this.hasArgumentList()) {
            return super.computeReplacementString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.fProposal.getName());
        LazyJavaCompletionProposal.FormatterPrefs formatterPrefs = this.getFormatterPrefs();
        if (formatterPrefs.beforeOpeningParen) {
            stringBuffer.append(" ");
        }
        stringBuffer.append("(");
        if (this.hasParameters()) {
            this.setCursorPosition(stringBuffer.length());
            if (formatterPrefs.afterOpeningParen) {
                stringBuffer.append(" ");
            }
        } else if (formatterPrefs.inEmptyList) {
            stringBuffer.append(" ");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    protected ProposalInfo computeProposalInfo() {
        IJavaProject iJavaProject = this.fInvocationContext.getProject();
        if (iJavaProject != null) {
            return new MethodProposalInfo(iJavaProject, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    protected String computeSortString() {
        char[] cArray = this.fProposal.getName();
        char[] cArray2 = Signature.toCharArray((char[])this.fProposal.getSignature(), null, null, (boolean)false, (boolean)false);
        int n = Signature.getParameterCount((char[])this.fProposal.getSignature()) % 10;
        StringBuffer stringBuffer = new StringBuffer(cArray.length + 2 + cArray2.length);
        stringBuffer.append(cArray);
        stringBuffer.append('\u0000');
        stringBuffer.append(n);
        stringBuffer.append(cArray2);
        return stringBuffer.toString();
    }

    protected boolean isValidPrefix(String string) {
        if (super.isValidPrefix(string)) {
            return true;
        }
        String string2 = this.getDisplayString();
        if (this.isInJavadoc()) {
            int n = string2.indexOf("{@link ");
            if (n == 0) {
                string2 = string2.substring(7);
            } else {
                n = string2.indexOf("{@value ");
                if (n == 0) {
                    string2 = string2.substring(8);
                }
            }
        }
        return this.isPrefix(string, string2);
    }
}

